/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.devtools.impl.model.DfaFunctionsModel;
import com.intellij.rml.dfa.devtools.impl.model.DfaStructuredTuplesModel;
import com.intellij.rml.dfa.devtools.impl.picasso.DfaCfgPictureGenerator;
import com.intellij.rml.dfa.devtools.impl.picasso.IrCfg2DotKt;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotCLI;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotGraph;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.DfaCallGraphGenerator;
import com.intellij.rml.dfa.impl.relations.DfaRelationInfo;
import com.intellij.rml.dfa.impl.rml.profiler.DummyProfileManager;
import com.intellij.rml.dfa.impl.translator.IrTranslationUtilsKt;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.testFramework.BinaryLightVirtualFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "showAllFunctionsCFG", "", "project", "Lcom/intellij/openapi/project/Project;", "showCallGraph", "attachNodesToFiles", "", "showFunctionCfg", "function", "Lcom/intellij/rml/dfa/attributes/Attribute;", "showFunctionIR", "producer", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionDecl;", "intellij.rml.dfa.devtools.impl"})
public final class DfaGraphActionsKt {
    @NotNull
    private static final Logger LOG;

    public static final void showAllFunctionsCFG(@NotNull Project project) {
        RMLAnalysisDescription description;
        DfaFunctionsModel functionsModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DfaFunctionsModel dfaFunctionsModel = functionsModel = DfaFunctionsModel.Companion.getInstance(project);
        RMLAnalysisDescription rMLAnalysisDescription = description = dfaFunctionsModel != null ? dfaFunctionsModel.getAnalysisDescription() : null;
        if (description != null) {
            DfaCfgPictureGenerator graphGenerator = new DfaCfgPictureGenerator(description, project);
            for (Attribute function2 : functionsModel.getAllFunctions()) {
                DfaStructuredTuplesModel dfaStructuredTuplesModel = DfaStructuredTuplesModel.Companion.getInstance(project);
                Map<String, DfaRelationInfo> functionInfo = dfaStructuredTuplesModel != null ? dfaStructuredTuplesModel.getFunctionInfo(function2) : null;
                if (functionInfo == null) continue;
                String string = function2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                graphGenerator.addTuples(functionInfo, string);
            }
            byte[] svgFile = graphGenerator.generateFile();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("cfg.svg", svgFile), true);
        } else {
            Messages.showInfoMessage((String)"DFA debug info was not built or is outdated", (String)"DFA debug tools");
        }
    }

    public static final void showFunctionCfg(@NotNull Attribute function2, @NotNull Project project) {
        RMLAnalysisDescription description;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DfaFunctionsModel dfaFunctionsModel = DfaFunctionsModel.Companion.getInstance(project);
        RMLAnalysisDescription rMLAnalysisDescription = description = dfaFunctionsModel != null ? dfaFunctionsModel.getAnalysisDescription() : null;
        if (description != null) {
            Object object = DfaStructuredTuplesModel.Companion.getInstance(project);
            if (object == null || (object = ((DfaStructuredTuplesModel)object).getFunctionInfo(function2)) == null) {
                return;
            }
            Object functionInfo = object;
            DfaCfgPictureGenerator dfaCfgPictureGenerator = new DfaCfgPictureGenerator(description, project);
            String string = function2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            byte[] svgFile = dfaCfgPictureGenerator.addTuples((Map<String, DfaRelationInfo>)functionInfo, string).generateFile();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("cfg.svg", svgFile), true);
        } else {
            Messages.showInfoMessage((String)"DFA debug info was not built or is outdated", (String)"DFA debug tools");
        }
    }

    public static final void showCallGraph(boolean attachNodesToFiles, @NotNull Project project) {
        Graph<Attribute> callGraph2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DfaFunctionsModel dfaFunctionsModel = DfaFunctionsModel.Companion.getInstance(project);
        Graph<Attribute> graph2 = callGraph2 = dfaFunctionsModel != null ? dfaFunctionsModel.getCallGraph() : null;
        if (callGraph2 != null) {
            DfaCallGraphGenerator generator = new DfaCallGraphGenerator(attachNodesToFiles, callGraph2, project);
            generator.addCalls();
            byte[] svgFile = generator.generateFile();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("call-graph.svg", svgFile), true);
        } else {
            Messages.showInfoMessage((String)"DFA debug info was not built or is outdated", (String)"DFA debug tools");
        }
    }

    private static final void showFunctionIR(IrFunctionDecl producer, Project project) {
        IrTopLevelDecl decl = IrTranslationUtilsKt.performTransformStages(producer, new DummyProfileManager(), AnalysisOptions.INSTANCE.getDefaultOptions());
        if (!(decl instanceof IrFunctionDecl)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String dot2 = DotGraph.build$default(IrCfg2DotKt.convert2dot(((IrFunctionDecl)decl).getBody()), 0, 1, null);
        byte[] svg = DotCLI.Companion.run(dot2, "svg");
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("cfg.svg", svg), true);
    }

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    public static final /* synthetic */ void access$showFunctionIR(IrFunctionDecl producer, Project project) {
        DfaGraphActionsKt.showFunctionIR(producer, project);
    }

    static {
        Logger logger = Logger.getInstance(DfaCallGraphGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

