/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.rml.dfa.DfaSessionProvider;
import com.intellij.rml.dfa.DfaSummarySession;
import com.intellij.rml.dfa.InterproceduralAnalysisDescription;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.devtools.DfaDebugProvider;
import com.intellij.rml.dfa.devtools.DfaSessionDebugRegistrar;
import com.intellij.rml.dfa.devtools.UtilsKt;
import com.intellij.rml.dfa.devtools.actions.DfaAction;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.test.IrProtoLanguageParser;
import com.intellij.rml.dfa.test.IrTestProvider;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/rml/dfa/devtools/actions/RunDfaOnProtoLanguageAction;", "Lcom/intellij/rml/dfa/devtools/actions/DfaAction;", "Lcom/intellij/rml/dfa/test/IrTestProvider;", "()V", "analysisDescription", "Lcom/intellij/rml/dfa/RMLAnalysisDescription;", "getAnalysisDescription", "()Lcom/intellij/rml/dfa/RMLAnalysisDescription;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "getOptions", "()Lcom/intellij/rml/dfa/utils/RMLOptions;", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "runDFA", "intellij.rml.dfa.devtools"})
public class RunDfaOnProtoLanguageAction
extends DfaAction
implements IrTestProvider {
    @NotNull
    private final RMLOptions options = new RMLOptions(null, 1, null);

    @Override
    @NotNull
    public RMLAnalysisDescription getAnalysisDescription() {
        return new InterproceduralAnalysisDescription(null, null, null, null, null, null, null, 127, null);
    }

    @Override
    @NotNull
    public RMLOptions getOptions() {
        return this.options;
    }

    @NotNull
    public String getText() {
        return "Run DFA";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!DfaDebugProvider.Companion.getInstance().getDevMode()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".dfa", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        new Task.Backgroundable(project, this, file){
            final /* synthetic */ RunDfaOnProtoLanguageAction this$0;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super($project, "Running DFA");
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RunDfaOnProtoLanguageAction.access$runDFA(this.this$0, this.$file);
            }
        }.queue();
    }

    private final void runDFA(PsiFile file) {
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UtilsKt.catchDFAExceptions(project, () -> RunDfaOnProtoLanguageAction.runDFA$lambda$0(this, file));
    }

    private static final void runDFA$lambda$0(RunDfaOnProtoLanguageAction this$0, PsiFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        DfaSummarySession session = DfaSessionProvider.Companion.getInstance().createSummarySession(this$0.getAnalysisDescription(), this$0.getOptions());
        String string = $file.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = $file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        IrProtoLanguageParser parser = this$0.getParser(string, string2);
        List<IrTopLevelDecl> input2 = parser.parse();
        DfaSessionDebugRegistrar dfaSessionDebugRegistrar = DfaSessionDebugRegistrar.Companion.getInstance();
        Project project = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        dfaSessionDebugRegistrar.registerSession(session, project);
        session.runDfaForFile(input2);
    }

    public static final /* synthetic */ void access$runDFA(RunDfaOnProtoLanguageAction $this, PsiFile file) {
        $this.runDFA(file);
    }
}

