/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.attributes;

import com.intellij.rml.dfa.attributes.Attribute;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/rml/dfa/attributes/IntAttribute;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "value", "", "(I)V", "", "(J)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "key", "", "(Ljava/math/BigInteger;Ljava/lang/String;)V", "getValue", "()Ljava/math/BigInteger;", "Companion", "intellij.rml.dfa"})
public final class IntAttribute
extends Attribute {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger value;
    @NotNull
    private static final IntAttribute positiveInf;
    @NotNull
    private static final IntAttribute negativeInf;

    private IntAttribute(BigInteger value, String key) {
        super(key);
        this.value = value;
    }

    @NotNull
    public final BigInteger getValue() {
        return this.value;
    }

    public IntAttribute(int value) {
        BigInteger bigInteger = BigInteger.valueOf(value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger, String.valueOf(value));
    }

    public IntAttribute(long value) {
        BigInteger bigInteger = BigInteger.valueOf(value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger, String.valueOf(value));
    }

    public IntAttribute(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this(value, string);
    }

    static {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        positiveInf = new IntAttribute(bigInteger, "+inf");
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        negativeInf = new IntAttribute(bigInteger2, "-inf");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/attributes/IntAttribute$Companion;", "", "()V", "negativeInf", "Lcom/intellij/rml/dfa/attributes/IntAttribute;", "getNegativeInf", "()Lcom/intellij/rml/dfa/attributes/IntAttribute;", "positiveInf", "getPositiveInf", "intellij.rml.dfa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntAttribute getPositiveInf() {
            return positiveInf;
        }

        @NotNull
        public final IntAttribute getNegativeInf() {
            return negativeInf;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

