/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa;

import com.intellij.rml.dfa.AnalysisMode;
import com.intellij.rml.dfa.BaseRelationKind;
import com.intellij.rml.dfa.TraceReconstructionInfo;
import com.intellij.rml.dfa.analyzes.input.DomainTypesDescriptor;
import com.intellij.rml.dfa.rml.dsl.DfaAnalysisExtension;
import com.intellij.rml.dfa.rml.dsl.DfaAnalysisSpecification;
import com.intellij.rml.dfa.rml.dsl.DfaRoutineSpecification;
import com.intellij.rml.dfa.rml.dsl.DfaRoutineSpecificationInterface;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00070\u0005\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u00a2\u0006\u0002\u0010\u0011R#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/rml/dfa/RMLAnalysisDescription;", "", "typesDescriptor", "Lcom/intellij/rml/dfa/analyzes/input/DomainTypesDescriptor;", "baseRelations", "", "Lcom/intellij/rml/dfa/BaseRelationKind;", "", "Lcom/intellij/rml/dfa/rml/dsl/lang/RmlRelation;", "outputRelations", "traceReconstructionInfo", "Lcom/intellij/rml/dfa/TraceReconstructionInfo;", "analyses", "Lcom/intellij/rml/dfa/AnalysisMode;", "Lcom/intellij/rml/dfa/rml/dsl/DfaAnalysisSpecification;", "extensions", "Lcom/intellij/rml/dfa/rml/dsl/DfaAnalysisExtension;", "(Lcom/intellij/rml/dfa/analyzes/input/DomainTypesDescriptor;Ljava/util/Map;Ljava/util/List;Lcom/intellij/rml/dfa/TraceReconstructionInfo;Ljava/util/Map;Ljava/util/List;)V", "getAnalyses", "()Ljava/util/Map;", "getBaseRelations", "getExtensions", "()Ljava/util/List;", "getOutputRelations", "getTraceReconstructionInfo", "()Lcom/intellij/rml/dfa/TraceReconstructionInfo;", "getTypesDescriptor", "()Lcom/intellij/rml/dfa/analyzes/input/DomainTypesDescriptor;", "intellij.rml.dfa"})
public abstract class RMLAnalysisDescription {
    @NotNull
    private final DomainTypesDescriptor typesDescriptor;
    @NotNull
    private final Map<BaseRelationKind, List<RmlRelation>> baseRelations;
    @NotNull
    private final List<RmlRelation> outputRelations;
    @NotNull
    private final TraceReconstructionInfo traceReconstructionInfo;
    @NotNull
    private final Map<AnalysisMode, List<DfaAnalysisSpecification>> analyses;
    @NotNull
    private final List<DfaAnalysisExtension> extensions;

    public RMLAnalysisDescription(@NotNull DomainTypesDescriptor typesDescriptor, @NotNull Map<BaseRelationKind, ? extends List<? extends RmlRelation>> baseRelations, @NotNull List<? extends RmlRelation> outputRelations, @NotNull TraceReconstructionInfo traceReconstructionInfo, @NotNull Map<AnalysisMode, ? extends List<? extends DfaAnalysisSpecification>> analyses, @NotNull List<? extends DfaAnalysisExtension> extensions) {
        Intrinsics.checkNotNullParameter((Object)typesDescriptor, (String)"typesDescriptor");
        Intrinsics.checkNotNullParameter(baseRelations, (String)"baseRelations");
        Intrinsics.checkNotNullParameter(outputRelations, (String)"outputRelations");
        Intrinsics.checkNotNullParameter((Object)traceReconstructionInfo, (String)"traceReconstructionInfo");
        Intrinsics.checkNotNullParameter(analyses, (String)"analyses");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.typesDescriptor = typesDescriptor;
        this.baseRelations = baseRelations;
        this.outputRelations = outputRelations;
        this.traceReconstructionInfo = traceReconstructionInfo;
        this.analyses = analyses;
        this.extensions = extensions;
        MultiMap extensionsMap = new MultiMap();
        for (DfaAnalysisExtension extension : this.extensions) {
            extensionsMap.putValue(extension.getBaseAnalysis(), (Object)extension);
        }
        for (AnalysisMode mode : AnalysisMode.getEntries()) {
            List list = this.analyses.get((Object)mode);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (DfaRoutineSpecificationInterface routine : CollectionsKt.plus((Collection)list, (Iterable)this.extensions)) {
                Intrinsics.checkNotNull((Object)routine, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.rml.dsl.DfaRoutineSpecification");
                DfaRoutineSpecification dfaRoutineSpecification = (DfaRoutineSpecification)routine;
                Collection collection = extensionsMap.get((Object)JvmClassMappingKt.getKotlinClass(routine.getClass()));
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                dfaRoutineSpecification.setExtensions(CollectionsKt.toList((Iterable)collection));
            }
        }
    }

    @NotNull
    public final DomainTypesDescriptor getTypesDescriptor() {
        return this.typesDescriptor;
    }

    @NotNull
    public final Map<BaseRelationKind, List<RmlRelation>> getBaseRelations() {
        return this.baseRelations;
    }

    @NotNull
    public final List<RmlRelation> getOutputRelations() {
        return this.outputRelations;
    }

    @NotNull
    public final TraceReconstructionInfo getTraceReconstructionInfo() {
        return this.traceReconstructionInfo;
    }

    @NotNull
    public final Map<AnalysisMode, List<DfaAnalysisSpecification>> getAnalyses() {
        return this.analyses;
    }

    @NotNull
    public final List<DfaAnalysisExtension> getExtensions() {
        return this.extensions;
    }
}

