/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.wizard;

import com.goide.GoIcons;
import com.goide.i18n.GoBundle;
import com.goide.project.GoModuleBuilderBase;
import com.goide.project.GoProjectLibrariesService;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.configuration.VgoSettings;
import com.goide.vgo.mod.psi.impl.VgoElementFactory;
import com.goide.vgo.mod.quickfix.VgoAddModuleToWorkspaceFix;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.wizard.VgoNewProjectSettings;
import com.goide.vgo.wizard.VgoProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoModuleBuilder
extends GoModuleBuilderBase<VgoNewProjectSettings> {
    public VgoModuleBuilder() {
        super(new VgoProjectGeneratorPeer(false));
    }

    public VgoModuleBuilder(@NotNull VgoProjectGeneratorPeer peer, boolean isCreatingNewProject) {
        if (peer == null) {
            VgoModuleBuilder.$$$reportNull$$$0(0);
        }
        super(peer, isCreatingNewProject);
    }

    public String getPresentableName() {
        return GoBundle.message((String)"go.modules.wizard.name", (Object[])new Object[0]);
    }

    public Icon getNodeIcon() {
        return GoIcons.ICON;
    }

    public boolean isAvailable() {
        return false;
    }

    public int getWeight() {
        return 1100;
    }

    @Override
    protected void moduleCreated(@NotNull Module module, boolean isCreatingNewProject) {
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(1);
        }
        if (isCreatingNewProject) {
            GoProjectLibrariesService.getInstance(module.getProject()).setIndexEntireGopath(false);
        }
        VgoModuleBuilder.vgoModuleCreated(module, (VgoNewProjectSettings)this.getSettings(), isCreatingNewProject, this.getContentEntryPath());
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        return GoBundle.message((String)"go.modules.wizard.description", (Object[])new Object[0]);
    }

    public static void vgoModuleCreated(@NotNull Module module, @NotNull VgoNewProjectSettings settings, boolean isCreatingNewProject, @Nullable String contentRoot) {
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            VgoModuleBuilder.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmpty((String)contentRoot)) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
                try {
                    VirtualFile directory = VfsUtil.createDirectoryIfMissing((String)contentRoot);
                    if (directory != null) {
                        VgoModuleBuilder.createGoModFile(module, directory);
                        if (settings.generateHelloWorld) {
                            VgoModuleBuilder.createHelloWorldFile(module, directory);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
        }
        if (isCreatingNewProject || !VgoProjectSettings.getInstance(module.getProject()).isIntegrationEnabled()) {
            VgoProjectSettings vgoProjectSettings = VgoProjectSettings.getInstance(module.getProject());
            vgoProjectSettings.setIntegrationEnabled(true);
            vgoProjectSettings.setAutoVendoringMode(settings.vendoringMode);
            vgoProjectSettings.setEnvironment(settings.environment);
            VgoSettings.getInstance().addEnvironmentVars(settings.environment);
        }
    }

    @NotNull
    public static VirtualFile createGoModFile(@NotNull Module module, @NotNull VirtualFile contentRootVirtualFileDirectory) throws IOException {
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(4);
        }
        if (contentRootVirtualFileDirectory == null) {
            VgoModuleBuilder.$$$reportNull$$$0(5);
        }
        PsiDirectory contentRootPsiDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(contentRootVirtualFileDirectory);
        return VgoModuleBuilder.createGoModFile(module, contentRootVirtualFileDirectory, contentRootPsiDirectory);
    }

    @NotNull
    public static VirtualFile createGoModFile(@NotNull Module module, @NotNull VirtualFile contentRootVirtualFileDirectory, @Nullable PsiDirectory contentRootPsiDirectory) throws IOException {
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(6);
        }
        if (contentRootVirtualFileDirectory == null) {
            VgoModuleBuilder.$$$reportNull$$$0(7);
        }
        VirtualFile goModFile = contentRootVirtualFileDirectory.createChildData((Object)module, "go.mod");
        String moduleName = contentRootPsiDirectory != null ? GoPackage.in(contentRootPsiDirectory, "").getImportPath(GoVendoringUtil.isVendoringEnabled(module)) : null;
        StringBuilder content2 = new StringBuilder();
        String name = (String)ObjectUtils.notNull((Object)moduleName, (Object)contentRootVirtualFileDirectory.getName());
        content2.append("module ").append(name.replace(' ', '_')).append('\n');
        VgoModuleBuilder.addGoSdkVersion(module, content2, "\n");
        goModFile.setBinaryContent(content2.toString().getBytes(StandardCharsets.UTF_8));
        VirtualFile virtualFile = goModFile;
        if (virtualFile == null) {
            VgoModuleBuilder.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public static VirtualFile createGoWorkFile(@NotNull Module module, @NotNull VirtualFile workspaceDirectory, @Nullable Collection<String> includedModulesPaths) throws IOException {
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(9);
        }
        if (workspaceDirectory == null) {
            VgoModuleBuilder.$$$reportNull$$$0(10);
        }
        if (includedModulesPaths == null) {
            Collection<VgoModule> modules = VgoModulesRegistry.getInstance(module.getProject()).getModules(module);
            includedModulesPaths = ContainerUtil.mapNotNull(modules, mod -> VgoAddModuleToWorkspaceFix.calcPathToModule(mod.getRoot(), workspaceDirectory));
        }
        VirtualFile goModFile = workspaceDirectory.createChildData((Object)module, "go.work");
        StringBuilder content2 = new StringBuilder();
        VgoModuleBuilder.addGoSdkVersion(module, content2, "");
        VgoModuleBuilder.addUseDirectives(content2, includedModulesPaths);
        goModFile.setBinaryContent(content2.toString().getBytes(StandardCharsets.UTF_8));
        return goModFile;
    }

    private static void addGoSdkVersion(@NotNull Module module, @NotNull StringBuilder content2, @NotNull String prefix) {
        GoSdk sdk;
        GoSdkVersion sdkVersion;
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(11);
        }
        if (content2 == null) {
            VgoModuleBuilder.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            VgoModuleBuilder.$$$reportNull$$$0(13);
        }
        if ((sdkVersion = (sdk = GoSdkService.getInstance(module.getProject()).getSdk(module)).getMajorVersion()) != GoSdkVersion.UNKNOWN && sdkVersion != GoSdkVersion.GO_DEVEL) {
            content2.append(prefix).append("go ").append((Object)sdkVersion).append('\n');
        }
    }

    private static void addUseDirectives(@NotNull StringBuilder content2, @NotNull Collection<String> includedModulesPaths) {
        if (content2 == null) {
            VgoModuleBuilder.$$$reportNull$$$0(14);
        }
        if (includedModulesPaths == null) {
            VgoModuleBuilder.$$$reportNull$$$0(15);
        }
        content2.append('\n');
        content2.append(VgoElementFactory.createUseDirective(includedModulesPaths));
    }

    private static void createHelloWorldFile(@NotNull Module module, VirtualFile directory) throws IOException {
        if (module == null) {
            VgoModuleBuilder.$$$reportNull$$$0(16);
        }
        String helloWorld = "package main\n\nimport \"fmt\"\n\nfunc main() {\n\tfmt.Println(\"Hello, World!\")\n}";
        VgoModuleBuilder.createFile("main.go", helloWorld, directory, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peer";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootVirtualFileDirectory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/wizard/VgoModuleBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceDirectory";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedModulesPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/wizard/VgoModuleBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoModFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moduleCreated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "vgoModuleCreated";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGoModFile";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createGoWorkFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addGoSdkVersion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addUseDirectives";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHelloWorldFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

