/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.sdk;

import com.goide.playground.GoPlaygroundRunOption;
import com.goide.playground.ui.GoPlaygroundFileEditorWithPreview;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/goide/vgo/sdk/VgoTargetSdkVersionProvider;", "Lcom/goide/sdk/GoTargetSdkVersionProvider;", "()V", "getTargetSdkVersion", "", "file", "Lcom/intellij/psi/PsiFile;", "isApplicable", "", "intellij.go.impl"})
public final class VgoTargetSdkVersionProvider
implements GoTargetSdkVersionProvider {
    @Override
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!VgoProjectSettings.getInstance(file.getProject()).isIntegrationEnabled()) {
            return false;
        }
        if (ScratchUtil.isScratch((VirtualFile)file.getVirtualFile())) {
            GoPlaygroundFileEditorWithPreview editor;
            FileEditorManager manager = FileEditorManager.getInstance((Project)file.getProject());
            FileEditor fileEditor = manager.getSelectedEditor();
            GoPlaygroundFileEditorWithPreview goPlaygroundFileEditorWithPreview = editor = fileEditor instanceof GoPlaygroundFileEditorWithPreview ? (GoPlaygroundFileEditorWithPreview)fileEditor : null;
            return (goPlaygroundFileEditorWithPreview != null ? goPlaygroundFileEditorWithPreview.getRunLocation() : null) == GoPlaygroundRunOption.LocalSDK;
        }
        return true;
    }

    @Override
    @Nullable
    public String getTargetSdkVersion(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Pair.NonNull<VgoModule, VgoDependency> nonNull = VgoUtil.findModuleAndDependencyOfFile(project2, virtualFile2);
        VgoModule vgoModule = nonNull != null ? (VgoModule)nonNull.first : null;
        if (vgoModule == null) {
            return null;
        }
        VgoModule vgoModule2 = vgoModule;
        VirtualFile virtualFile3 = vgoModule2.getRoot().findChild("go.mod");
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile goModVirtualFile = virtualFile3;
        Object object = PsiManager.getInstance((Project)project2).findFile(goModVirtualFile);
        VgoFile vgoFile = object instanceof VgoFile ? (VgoFile)((Object)object) : null;
        if (vgoFile == null) {
            return null;
        }
        VgoFile goMod = vgoFile;
        String version2 = goMod.getGoVersion();
        object = version2;
        if (!(object == null || object.length() == 0)) {
            return version2;
        }
        GoSdkVersion goSdkVersion = GoSdkService.getInstance(project2).getSdk(GoUtil.module((PsiElement)file)).getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goSdkVersion), (String)"getMajorVersion(...)");
        GoSdkVersion sdkVersion = goSdkVersion;
        return sdkVersion.isAtLeast(GoSdkVersion.GO_1_17) ? "1.16" : sdkVersion.toString();
    }
}

