/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VgoModule
implements VgoDependency,
VgoModuleOrWorkspace {
    @NotNull
    private final VirtualFile myRoot;
    @NlsSafe
    private final String myImportPath;
    private final String myGoVersion;

    protected VgoModule(@NotNull VirtualFile root, @NotNull String importPath, @Nullable String goVersion) {
        if (root == null) {
            VgoModule.$$$reportNull$$$0(0);
        }
        if (importPath == null) {
            VgoModule.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myImportPath = importPath;
        this.myGoVersion = goVersion;
    }

    static Map<String, VgoDependency> makeDependenciesMap(@NotNull Collection<VgoDependency> dependencies) {
        if (dependencies == null) {
            VgoModule.$$$reportNull$$$0(2);
        }
        HashMap<String, VgoDependency> dependenciesMap = new HashMap<String, VgoDependency>();
        for (VgoDependency dependency : dependencies) {
            String path = (String)ObjectUtils.doIfCast((Object)dependency, VgoDependencyImpl.class, VgoDependencyImpl::getDirPath);
            if (dependency instanceof VgoModule) {
                path = ((VgoModule)dependency).getRoot().getPath();
            }
            if (path == null) continue;
            dependenciesMap.put(FileUtil.toCanonicalPath((String)path), dependency);
        }
        return dependenciesMap;
    }

    @Override
    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            VgoModule.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getImportPath() {
        String string = this.myImportPath;
        if (string == null) {
            VgoModule.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public String getVersion() {
        return null;
    }

    @Override
    @Nullable
    public String getGoVersion() {
        return this.myGoVersion;
    }

    @Override
    @NotNull
    public abstract Collection<VgoDependency> getDependencies();

    @Nullable
    public abstract VgoDependency findDependencyAt(@NotNull String var1);

    public abstract boolean dependenciesAreUnknown();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VgoModule vgoModule = (VgoModule)o;
        return this.myRoot.equals(vgoModule.myRoot) && Objects.equals(this.myImportPath, vgoModule.myImportPath) && Objects.equals(this.myGoVersion, vgoModule.myGoVersion);
    }

    public int hashCode() {
        return Objects.hash(this.myRoot, this.myImportPath, this.myGoVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/project/VgoModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/project/VgoModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeDependenciesMap";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

