/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.GoFileType;
import com.goide.i18n.GoBundle;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.inspections.golist.VgoDependencyVersion;
import com.goide.vgo.mod.psi.impl.VgoElementFactory;
import com.goide.vgo.mod.quickfix.VgoSyncDependencyFix;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\f0\u0007\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0012\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J)\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoUpdateReplaceTargetVersionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "moduleVersion", "Lcom/intellij/psi/PsiElement;", "currentVersion", "Lcom/goide/vgo/mod/inspections/golist/VgoDependencyVersion;", "newVersion", "", "(Lcom/intellij/psi/PsiElement;Lcom/goide/vgo/mod/inspections/golist/VgoDependencyVersion;Ljava/lang/String;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "startInWriteAction", "", "intellij.go.impl"})
public final class VgoUpdateReplaceTargetVersionQuickFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final VgoDependencyVersion currentVersion;
    @NotNull
    private final String newVersion;

    public VgoUpdateReplaceTargetVersionQuickFix(@NotNull PsiElement moduleVersion, @NotNull VgoDependencyVersion currentVersion, @NotNull String newVersion) {
        Intrinsics.checkNotNullParameter((Object)moduleVersion, (String)"moduleVersion");
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        super(moduleVersion);
        this.currentVersion = currentVersion;
        this.newVersion = newVersion;
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"vgo.fix.dependency-update.family-name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.currentVersion.getImportPath(), this.currentVersion.getVersion(), this.newVersion};
        String string = GoBundle.message((String)"vgo.fix.dependency-update.single.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!startElement.isValid()) {
            return;
        }
        Module module = GoUtil.module((PsiElement)file);
        if (module == null) {
            return;
        }
        Module module2 = module;
        PsiElement psiElement = VgoElementFactory.createIdentifier(project, this.newVersion);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createIdentifier(...)");
        PsiElement newVersionIdentifier = psiElement;
        WriteAction.run(() -> VgoUpdateReplaceTargetVersionQuickFix.invoke$lambda$0(startElement, newVersionIdentifier));
        VgoModuleOrWorkspace vgoModuleOrWorkspace = VgoModulesRegistry.getInstance(project).findVgoModuleOrWorkspace(module2, file.getVirtualFile());
        if (vgoModuleOrWorkspace == null) {
            return;
        }
        VgoModuleOrWorkspace moduleOrWorkspace = vgoModuleOrWorkspace;
        VgoSyncDependencyFix.applyFix(project, module2, moduleOrWorkspace, GoBundle.message((String)"go.settings.modules.sync.dependencies.fix.family.name", (Object[])new Object[0]), VgoSyncDependencyFix.Action.SYNC);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        PsiElement psiElement = previewDescriptor.getPsiElement();
        if (psiElement == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        PsiElement element = psiElement;
        PsiFile originalFile = element.getContainingFile();
        PsiElement psiElement2 = originalFile.copy();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        PsiFile copyFile = (PsiFile)psiElement2;
        PsiElement copyElement = PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)copyFile);
        PsiElement psiElement3 = VgoElementFactory.createIdentifier(project, this.newVersion);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"createIdentifier(...)");
        PsiElement newVersionIdentifier = psiElement3;
        copyElement.replace(newVersionIdentifier);
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)GoFileType.INSTANCE, originalFile.getName(), originalFile.getText(), copyFile.getText());
    }

    private static final void invoke$lambda$0(PsiElement $startElement, PsiElement $newVersionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$startElement, (String)"$startElement");
        Intrinsics.checkNotNullParameter((Object)$newVersionIdentifier, (String)"$newVersionIdentifier");
        $startElement.replace($newVersionIdentifier);
    }
}

