/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0003H\u0016J%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u0013\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoRunWhyCommandIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "moduleName", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Ljava/lang/String;)V", "PRESENTABLE_NAME_PREFIX", "commandKey", "moduleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "runWhyCommand", "module", "Lcom/intellij/openapi/module/Module;", "AlwaysShowOutputProcessListener", "intellij.go.impl"})
public final class VgoRunWhyCommandIntention
extends BaseIntentionAction {
    @NotNull
    private final String moduleName;
    @NotNull
    private final String PRESENTABLE_NAME_PREFIX;

    public VgoRunWhyCommandIntention(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.moduleName = moduleName;
        this.PRESENTABLE_NAME_PREFIX = "go mod why -m ";
        this.setText(this.PRESENTABLE_NAME_PREFIX + this.moduleName);
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"vgo.intention.run.why.command.fix.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        return (psiFile != null ? psiFile.getVirtualFile() : null) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        Object object = psiFile != null ? psiFile.getVirtualFile() : null;
        if (object == null) {
            return;
        }
        VirtualFile virtualFile = object;
        this.runWhyCommand(project, GoUtil.module((PsiElement)file), virtualFile);
    }

    private final void runWhyCommand(Project project, Module module, VirtualFile file) {
        GoSdk goSdk = GoSdkService.getInstance(project).getSdk(module);
        Intrinsics.checkNotNullExpressionValue((Object)goSdk, (String)"getSdk(...)");
        GoSdk sdk = goSdk;
        if (!sdk.isValid()) {
            return;
        }
        Pair.NonNull<VgoModule, VgoDependency> nonNull = VgoUtil.findModuleAndDependencyOfFile(project, module, file);
        VgoModule vgoModule = nonNull != null ? (VgoModule)nonNull.first : null;
        if (vgoModule == null) {
            return;
        }
        VgoModule vgoModule2 = vgoModule;
        String[] stringArray = new String[]{"mod", "why", "-m", this.moduleName};
        GoExecutor goExecutor = GoExecutor.in(project, module).disablePty().withPresentableName(this.getText()).withParameters(stringArray).withWorkDirectory(vgoModule2.getRoot().getPath()).withPrintingOutputAsStatus().showNotifications(false, false);
        Intrinsics.checkNotNullExpressionValue((Object)goExecutor, (String)"showNotifications(...)");
        GoExecutor executor = goExecutor;
        GoHistoryProcessListener goHistoryProcessListener = new AlwaysShowOutputProcessListener();
        VirtualFile virtualFile = vgoModule2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        executor.executeWithProgress(true, true, goHistoryProcessListener, this.commandKey(virtualFile), (Consumer<? super GoExecutor.ExecutionResult>)EmptyConsumer.getInstance());
    }

    private final String commandKey(VirtualFile moduleRoot) {
        return "vgo.mod.why.command.executor.key." + this.moduleName + "." + moduleRoot.getPath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoRunWhyCommandIntention$AlwaysShowOutputProcessListener;", "Lcom/goide/util/GoHistoryProcessListener;", "()V", "shouldShowOutput", "", "isFinishedSuccessfully", "intellij.go.impl"})
    private static final class AlwaysShowOutputProcessListener
    extends GoHistoryProcessListener {
        @Override
        public boolean shouldShowOutput(boolean isFinishedSuccessfully) {
            return true;
        }
    }
}

