/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.psi.impl;

import com.goide.vgo.mod.VgoLanguage;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoGoVersionDirective;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoUseDirective;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoElementFactory {
    private VgoElementFactory() {
    }

    @Nullable
    public static VgoModuleSpec createModuleSpec(@NotNull Project project, @NonNls @NotNull String dependencyText) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(0);
        }
        if (dependencyText == null) {
            VgoElementFactory.$$$reportNull$$$0(1);
        }
        VgoFile file = VgoElementFactory.createFileFromText(project, "module name\nreplace (\n" + dependencyText + "\n)");
        return (VgoModuleSpec)PsiTreeUtil.findChildOfType((PsiElement)file, VgoModuleSpec.class);
    }

    @Nullable
    public static VgoModuleDirective createModuleDirective(@NotNull Project project, @NonNls @NotNull String moduleName) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            VgoElementFactory.$$$reportNull$$$0(3);
        }
        VgoFile file = VgoElementFactory.createFileFromText(project, "module " + moduleName);
        return (VgoModuleDirective)PsiTreeUtil.findChildOfType((PsiElement)file, VgoModuleDirective.class);
    }

    @NotNull
    public static VgoGoVersionDirective createGoVersionDirective(@NotNull Project project, @NotNull String goVersion) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(4);
        }
        if (goVersion == null) {
            VgoElementFactory.$$$reportNull$$$0(5);
        }
        VgoFile file = VgoElementFactory.createFileFromText(project, "module name\ngo " + goVersion);
        VgoGoVersionDirective vgoGoVersionDirective = Objects.requireNonNull((VgoGoVersionDirective)PsiTreeUtil.findChildOfType((PsiElement)file, VgoGoVersionDirective.class));
        if (vgoGoVersionDirective == null) {
            VgoElementFactory.$$$reportNull$$$0(6);
        }
        return vgoGoVersionDirective;
    }

    @NotNull
    public static VgoUseDirective createUseDirective(@NotNull Project project, @NotNull Collection<String> moduleSpecs) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(7);
        }
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(8);
        }
        String directiveText = VgoElementFactory.createUseDirective(moduleSpecs);
        VgoFile file = VgoElementFactory.createFileFromText(project, directiveText);
        VgoUseDirective vgoUseDirective = Objects.requireNonNull((VgoUseDirective)PsiTreeUtil.findChildOfType((PsiElement)file, VgoUseDirective.class));
        if (vgoUseDirective == null) {
            VgoElementFactory.$$$reportNull$$$0(9);
        }
        return vgoUseDirective;
    }

    @NotNull
    public static String createUseDirective(@NotNull Collection<String> moduleSpecs) {
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(10);
        }
        StringBuilder sb = new StringBuilder();
        if (moduleSpecs.size() == 1) {
            sb.append("use ").append((String)ContainerUtil.getOnlyItem(moduleSpecs));
        } else {
            sb.append("use (\n");
            for (String spec : moduleSpecs) {
                sb.append('\t').append(spec).append('\n');
            }
            sb.append(')');
        }
        String string = sb.toString();
        if (string == null) {
            VgoElementFactory.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static PsiElement createIdentifier(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(12);
        }
        if (text == null) {
            VgoElementFactory.$$$reportNull$$$0(13);
        }
        PsiElement psiElement = Objects.requireNonNull(VgoElementFactory.createFileFromText(project, "module %s".formatted(text)).getLastChild().getLastChild());
        if (psiElement == null) {
            VgoElementFactory.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @NotNull
    public static String quoteModuleSpecIfNeeded(@NotNull String moduleSpec) {
        if (moduleSpec == null) {
            VgoElementFactory.$$$reportNull$$$0(15);
        }
        if (moduleSpec.startsWith("\"")) {
            String string = moduleSpec;
            if (string == null) {
                VgoElementFactory.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = StringUtil.containsAnyChar((String)moduleSpec, (String)" ,[]\t\n\r") ? StringUtil.wrapWithDoubleQuote((String)moduleSpec) : moduleSpec;
        if (string == null) {
            VgoElementFactory.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static VgoFile createFileFromText(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(18);
        }
        if (text == null) {
            VgoElementFactory.$$$reportNull$$$0(19);
        }
        VgoFile vgoFile = (VgoFile)PsiFileFactory.getInstance((Project)project).createFileFromText("go.mod", (Language)VgoLanguage.INSTANCE, (CharSequence)text);
        if (vgoFile == null) {
            VgoElementFactory.$$$reportNull$$$0(20);
        }
        return vgoFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 11, 14, 16, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goVersion";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/psi/impl/VgoElementFactory";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpecs";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/psi/impl/VgoElementFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoVersionDirective";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseDirective";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteModuleSpecIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSpec";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDirective";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGoVersionDirective";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUseDirective";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "quoteModuleSpecIfNeeded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 11, 14, 16, 17, 20 -> new IllegalStateException(string);
        };
    }
}

