/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.documentation;

import com.goide.documentation.GoDocumentationPackageVersionProvider;
import com.goide.psi.impl.GoPackage;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoPackageVersionProvider
implements GoDocumentationPackageVersionProvider {
    @Override
    public boolean isApplicable(@NotNull GoPackage goPackage) {
        if (goPackage == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(0);
        }
        return VgoProjectSettings.getInstance(goPackage.getProject()).isIntegrationEnabled();
    }

    @Override
    @Nullable
    public String getVersion(@NotNull GoPackage goPackage) {
        if (goPackage == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(1);
        }
        Set<VirtualFile> directories = goPackage.getDirectories();
        for (VirtualFile directory : directories) {
            Pair.NonNull<VgoModule, VgoDependency> moduleAndDependency = VgoUtil.findModuleAndDependencyOfFile(goPackage.getProject(), directory);
            if (moduleAndDependency == null) continue;
            return VgoPackageVersionProvider.getVersion(goPackage, directory, moduleAndDependency);
        }
        return null;
    }

    @Nullable
    private static String getVersion(@NotNull GoPackage goPackage, @NotNull VirtualFile directory, @NotNull Pair.NonNull<VgoModule, VgoDependency> moduleAndDependency) {
        Module module;
        if (goPackage == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(3);
        }
        if (moduleAndDependency == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(4);
        }
        if (moduleAndDependency.second instanceof VgoModule && (module = GoUtil.module(goPackage.getProject(), directory)) != null && GoVendoringUtil.isVendoredFile(directory, module)) {
            VgoDependency vendoredDependency = VgoPackageVersionProvider.findDependency((VgoModule)moduleAndDependency.second, goPackage);
            return vendoredDependency != null ? vendoredDependency.getVersion() : null;
        }
        return ((VgoDependency)moduleAndDependency.second).getVersion();
    }

    @Nullable
    private static VgoDependency findDependency(@NotNull VgoModule vgoModule, @NotNull GoPackage goPackage) {
        String importPath;
        if (vgoModule == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(5);
        }
        if (goPackage == null) {
            VgoPackageVersionProvider.$$$reportNull$$$0(6);
        }
        return (importPath = goPackage.getImportPath(true)) == null ? null : (VgoDependency)vgoModule.getDependencies().stream().filter(d -> importPath.startsWith(d.getImportPath())).max(Comparator.comparingInt(d -> d.getImportPath().length())).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndDependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModule";
                break;
            }
        }
        objectArray2[1] = "com/goide/vgo/documentation/VgoPackageVersionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

