/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.configuration;

import com.goide.GoLibrariesUtil;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VgoProject", storages={@Storage(value="$WORKSPACE_FILE$")})
public class VgoProjectSettings
implements PersistentStateComponent<VgoProjectSettingsState> {
    private final VgoProjectSettingsState myState;
    private final Project myProject;
    public static final Topic<IntegrationListener> VGO_INTEGRATION_TOPIC = Topic.create((String)"vgo integration toggled", IntegrationListener.class);

    public VgoProjectSettings(@NotNull Project project) {
        if (project == null) {
            VgoProjectSettings.$$$reportNull$$$0(0);
        }
        this.myState = new VgoProjectSettingsState();
        this.myProject = project;
    }

    @NotNull
    public static VgoProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            VgoProjectSettings.$$$reportNull$$$0(1);
        }
        VgoProjectSettings vgoProjectSettings = (VgoProjectSettings)project.getService(VgoProjectSettings.class);
        if (vgoProjectSettings == null) {
            VgoProjectSettings.$$$reportNull$$$0(2);
        }
        return vgoProjectSettings;
    }

    public void setIntegrationEnabled(boolean enabled) {
        if (this.myState.integrationEnabled != enabled) {
            GoLibrariesUtil.updateLibraries(this.myProject, RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, () -> {
                this.myState.integrationEnabled = enabled;
            }, () -> ((IntegrationListener)this.myProject.getMessageBus().syncPublisher(VGO_INTEGRATION_TOPIC)).changed());
        }
    }

    public boolean isIntegrationEnabled() {
        return this.myState.integrationEnabled;
    }

    public void setAutoVendoringMode(boolean enabled) {
        if (this.myState.autoVendoringMode != enabled) {
            GoLibrariesUtil.updateLibraries(this.myProject, RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, () -> {
                this.myState.autoVendoringMode = enabled;
            }, () -> ((IntegrationListener)this.myProject.getMessageBus().syncPublisher(VGO_INTEGRATION_TOPIC)).changed());
        }
    }

    public boolean isAutoVendoringMode() {
        return this.myState.autoVendoringMode;
    }

    public void setEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            VgoProjectSettings.$$$reportNull$$$0(3);
        }
        if (!environment.equals(this.myState.environment)) {
            HashMap<String, String> environmentCopy = new HashMap<String, String>(environment);
            GoLibrariesUtil.updateLibraries(this.myProject, RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, () -> {
                this.myState.environment = environmentCopy;
            }, () -> ((IntegrationListener)this.myProject.getMessageBus().syncPublisher(VGO_INTEGRATION_TOPIC)).changed());
        }
    }

    @NotNull
    public Map<String, String> getRawEnvironment() {
        Map map = ContainerUtil.unmodifiableOrEmptyMap(this.myState.environment);
        if (map == null) {
            VgoProjectSettings.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>(this.myState.environment);
        Optional.ofNullable(this.getGoModCache()).ifPresent(value -> env.put(VgoEnvironmentVariable.GOMODCACHE.getName(), (String)value));
        HashMap<String, String> hashMap = env;
        if (hashMap == null) {
            VgoProjectSettings.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @Nullable
    public String getGoModCache() {
        Map<String, String> env = this.getRawEnvironment();
        String value = env.get(VgoEnvironmentVariable.GOMODCACHE.getName());
        return value != null ? FileUtil.expandUserHome((String)value) : null;
    }

    public boolean isSettingsMigrated() {
        return this.myState.settingsMigrated;
    }

    public void setSettingsMigrated(boolean settingsMigrated) {
        this.myState.settingsMigrated = settingsMigrated;
    }

    @Nullable
    public Boolean isAutomaticDependenciesDownloadEnabled() {
        return this.myState.automaticDependenciesDownloadEnabled;
    }

    public void setAutomaticDependenciesDownloadEnabled(@Nullable Boolean enabled) {
        this.myState.automaticDependenciesDownloadEnabled = enabled;
    }

    @Nullable
    public VgoProjectSettingsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull VgoProjectSettingsState state) {
        if (state == null) {
            VgoProjectSettings.$$$reportNull$$$0(6);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/configuration/VgoProjectSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/configuration/VgoProjectSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnvironment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    static class VgoProjectSettingsState {
        @Tag(value="integration-enabled")
        public boolean integrationEnabled = true;
        @Tag(value="auto-vendoring-mode")
        public boolean autoVendoringMode = true;
        @Tag(value="environment")
        public Map<String, String> environment = new HashMap<String, String>();
        @Tag(value="automatic-dependencies-download-enabled")
        public Boolean automaticDependenciesDownloadEnabled = null;
        @Tag(value="settings-migrated")
        public boolean settingsMigrated;

        VgoProjectSettingsState() {
        }
    }

    public static interface IntegrationListener {
        public void changed();
    }
}

