/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoUtil;
import com.goide.vgo.GoListOutputParser;
import com.goide.vgo.VgoModuleInfoProvider;
import com.goide.vgo.VgoProgressScopeKt;
import com.goide.vgo.VgoRootToModule;
import com.goide.vgo.VgoStatusTracker;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoStandaloneModule;
import com.goide.vgo.project.VgoWorkspace;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.google.gson.JsonParseException;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class VgoModuleInfoProviderImpl
implements VgoModuleInfoProvider {
    private static final Logger LOG = Logger.getInstance(VgoModuleInfoProviderImpl.class);
    private static final IJTracer TRACER = TelemetryManager.getInstance().getTracer(VgoProgressScopeKt.VgoProgressScope);

    public @NotNull Function<@Nullable String, @Nullable String> getGoListDirMapper(@NotNull VirtualFile goModuleRoot) {
        WSLDistribution wsl;
        if (goModuleRoot == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(0);
        }
        if ((wsl = WslPath.getDistributionByWindowsUncPath((String)goModuleRoot.getPath())) != null) {
            Function<String, String> function = dir -> dir != null ? wsl.getWindowsPath(dir) : null;
            if (function == null) {
                VgoModuleInfoProviderImpl.$$$reportNull$$$0(1);
            }
            return function;
        }
        Function<String, String> function = Function.identity();
        if (function == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(2);
        }
        return function;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public @NotNull Promise<Collection<@NotNull VgoRootToModule>> getInfos(final @NotNull @NotNull Collection<@NotNull VirtualFile> goModuleSettingsFiles, final @NotNull Module module, final @Nullable ProgressIndicatorEx progressIndicator) {
        if (goModuleSettingsFiles == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(3);
        }
        if (module == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(4);
        }
        VgoStatusTracker.LOG.debug("go list: " + goModuleSettingsFiles);
        final @NotNull AsyncPromise promise = new AsyncPromise();
        Task.Backgroundable task2 = new Task.Backgroundable(module.getProject(), GoBundle.message((String)"go.modules.background.task.updating.dependencies.title", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            private Task myCurrentTask;
            private Collection<VirtualFile> goModuleSettingsMerged;
            {
                super(arg0, arg1, arg2, arg3);
                this.myCurrentTask = null;
                this.goModuleSettingsMerged = Set.of();
            }

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.goModuleSettingsMerged = this.getModuleSettingsMerged();
                indicator.setIndeterminate(false);
                indicator.setText(GoBundle.message((String)"go.modules.background.task.updating.dependencies.text", (Object[])new Object[]{this.goModuleSettingsMerged.size()}));
                if (progressIndicator != null) {
                    new ProgressIndicatorListener(){

                        public void cancelled() {
                            indicator.cancel();
                        }
                    }.installToProgress(progressIndicator);
                }
                int i = 0;
                ArrayList<VgoRootToModule> vgoModules = new ArrayList<VgoRootToModule>();
                for (VirtualFile goModuleSettingsFile : this.goModuleSettingsMerged) {
                    indicator.checkCanceled();
                    VirtualFile moduleRoot = goModuleSettingsFile.getParent();
                    if (moduleRoot == null || !moduleRoot.isValid()) {
                        LOG.debug("Skipped invalid module root " + (moduleRoot != null ? moduleRoot.getPath() : goModuleSettingsFile.getPath()));
                        continue;
                    }
                    SmartList buildListContainer = new SmartList();
                    this.myCurrentTask = VgoModuleInfoProviderImpl.this.createTask(module, (ProgressIndicatorEx)ObjectUtils.tryCast((Object)indicator, ProgressIndicatorEx.class), (Collection<GoListOutputParser.BuildList>)buildListContainer, moduleRoot, goModuleSettingsFile);
                    if (this.myCurrentTask != null) {
                        Span.current().setAttribute("goland.modulesCount", (long)i);
                        indicator.setFraction((double)i++ / (double)this.goModuleSettingsMerged.size());
                        indicator.setText2(this.myCurrentTask.getTitle() + " (" + CodeInsightBundle.message((String)"n.of.m", (Object[])new Object[]{i, this.goModuleSettingsMerged.size()}) + ")");
                        SpanBuilder spanBuilder = TRACER.spanBuilder("Subtask: go list -m -json", TracerLevel.DEFAULT).setAttribute("goland.moduleRoot", moduleRoot.getPath());
                        TraceKt.use((SpanBuilder)spanBuilder, __ -> {
                            this.myCurrentTask.run((ProgressIndicator)new EmptyProgressIndicator());
                            ApplicationManager.getApplication().invokeAndWait(() -> ((Task)this.myCurrentTask).onFinished());
                            return null;
                        });
                        GoListOutputParser.BuildList buildList = (GoListOutputParser.BuildList)ContainerUtil.getFirstItem((List)buildListContainer);
                        VgoModuleInfoProviderImpl.calculateVgoModules(vgoModules, moduleRoot, goModuleSettingsFile, buildList);
                        continue;
                    }
                    vgoModules.add(new VgoRootToModule(moduleRoot, null));
                }
                promise.setResult(vgoModules);
                VgoStatusTracker.LOG.debug("go list result: " + vgoModules);
            }

            @NotNull
            private Collection<VirtualFile> getModuleSettingsMerged() {
                if (!GoSdkService.getInstance(module.getProject()).getSdk(module).supportsWorkspaceMode()) {
                    Collection collection = goModuleSettingsFiles;
                    if (collection == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return collection;
                }
                Set set = ContainerUtil.map2Set((Collection)goModuleSettingsFiles, f -> {
                    if (f.getName().equals("go.mod")) {
                        return (VirtualFile)ObjectUtils.notNull((Object)VgoModuleInfoProviderImpl.findWorkspaceFile(f), (Object)f);
                    }
                    return f;
                });
                if (set == null) {
                    1.$$$reportNull$$$0(2);
                }
                return set;
            }

            public void onFinished() {
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])ContainerUtil.union(this.goModuleSettingsMerged, (Collection)goModuleSettingsFiles).toArray(VirtualFile.EMPTY_ARRAY));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (this.myCurrentTask != null) {
                    this.myCurrentTask.onThrowable(error);
                }
                promise.setError(error);
            }

            public void onCancel() {
                if (this.myCurrentTask != null) {
                    this.myCurrentTask.onCancel();
                }
                promise.cancel();
            }

            public boolean isHeadless() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/vgo/VgoModuleInfoProviderImpl$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/vgo/VgoModuleInfoProviderImpl$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModuleSettingsMerged";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "onThrowable";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread() && ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            task2.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            task2.queue();
        }
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    @Nullable
    private Task.Backgroundable createTask(@NotNull Module module, @Nullable ProgressIndicatorEx progressIndicator, @NotNull Collection<GoListOutputParser.BuildList> buildListContainer, @NotNull VirtualFile moduleRoot, @NotNull VirtualFile goModuleSettingsFile) {
        String tmpModuleRootPath;
        if (module == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(6);
        }
        if (buildListContainer == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(7);
        }
        if (moduleRoot == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(8);
        }
        if (goModuleSettingsFile == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(9);
        }
        final String moduleRootPath = moduleRoot.getPath();
        OutputListener outputListener = new OutputListener();
        @NlsSafe String presentableName = "go list -m -json all (" + moduleRoot.getName() + ")";
        GoExecutor executor = GoExecutor.in(module).withPresentableName(presentableName).withParameters("list").withWorkDirectory(moduleRootPath).withProcessListener((ProcessListener)outputListener).disablePty().showNotifications(false, false);
        boolean workspaceMode = goModuleSettingsFile.getName().equals("go.work");
        String string = tmpModuleRootPath = workspaceMode ? null : VgoModuleInfoProviderImpl.copyGoModFile(module, moduleRoot);
        if (tmpModuleRootPath != null) {
            GoCommandLineParameter.PathParameter goModPath = GoCommandLineParameter.path(tmpModuleRootPath + "/go.mod");
            executor.withParameters(GoCommandLineParameter.map(goModPath, (com.intellij.util.Function<? super String, String>)((com.intellij.util.Function)it -> "-modfile=" + it)));
        }
        executor.withParameters("-m", "-json").withParameters(VgoModuleInfoProviderImpl.calcModParameterValue(module, workspaceMode)).withParameters("all");
        VgoHistoryProcessListener historyProcessListener = new VgoHistoryProcessListener(){

            @Override
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (tmpModuleRootPath != null) {
                    ProcessEvent newEvent = new ProcessEvent(event.getProcessHandler(), event.getText().replace(tmpModuleRootPath, moduleRootPath));
                    super.onTextAvailable(newEvent, outputType);
                } else {
                    super.onTextAvailable(event, outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/goide/vgo/VgoModuleInfoProviderImpl$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Function<String, String> goListDirMapper = this.getGoListDirMapper(moduleRoot);
        GoListOutputParser parser = new GoListOutputParser(goListDirMapper);
        return executor.createTask(true, true, historyProcessListener, VgoModuleInfoProviderImpl.commandKey(moduleRoot), progressIndicator, (Consumer<? super GoExecutor.ExecutionResult>)((Consumer)result -> {
            if (ApplicationManager.getApplication().isHeadlessEnvironment() && result.status != GoExecutor.ExecutionResult.Status.SUCCEEDED) {
                LOG.warn("Couldn't run go list: " + result.message + "; output: " + outputListener.getOutput().getStdout());
            }
            if (!moduleRoot.isValid()) {
                LOG.debug("Skipped invalid module root " + moduleRoot.getPath());
                return;
            }
            try {
                GoListOutputParser.BuildList buildList = parser.readDependencies(outputListener.getOutput().getStdout());
                buildListContainer.add(buildList);
            }
            catch (JsonParseException e) {
                LOG.debug("Failed to parse `go list` output: " + e.getMessage());
            }
            finally {
                if (tmpModuleRootPath != null) {
                    FileUtil.asyncDelete((File)new File(tmpModuleRootPath));
                }
            }
        }));
    }

    private static void calculateVgoModules(@NotNull @NotNull Collection<@NotNull VgoRootToModule> vgoModules, @NotNull VirtualFile moduleRoot, @NotNull VirtualFile goModuleSettingsFile, @Nullable GoListOutputParser.BuildList buildList) {
        if (vgoModules == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(10);
        }
        if (moduleRoot == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(11);
        }
        if (goModuleSettingsFile == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(12);
        }
        boolean workspaceMode = goModuleSettingsFile.getName().equals("go.work");
        VgoModule vgoModule = null;
        if (workspaceMode && buildList != null) {
            VgoWorkspace workspace = new VgoWorkspace(buildList, goModuleSettingsFile);
            for (VgoDependency mainModule : buildList.getMainModules()) {
                VirtualFile mainModuleRoot = mainModule.getRoot();
                if (mainModuleRoot == null) continue;
                vgoModule = new VgoWorkspaceModule(mainModuleRoot, mainModule.getImportPath(), mainModule.getGoVersion(), workspace);
                vgoModules.add(new VgoRootToModule(mainModuleRoot, vgoModule));
            }
        } else if (buildList != null && buildList.getMainModules().size() == 1) {
            VgoDependency mainModule = (VgoDependency)ContainerUtil.getOnlyItem(buildList.getMainModules());
            vgoModule = new VgoStandaloneModule(moduleRoot, mainModule.getImportPath(), mainModule.getGoVersion(), buildList.getDependencies());
            vgoModules.add(new VgoRootToModule(moduleRoot, vgoModule));
        } else {
            String moduleName = GoUtil.getModuleName(goModuleSettingsFile);
            if (moduleName != null) {
                vgoModule = new VgoStandaloneModule(moduleRoot, moduleName);
                vgoModules.add(new VgoRootToModule(moduleRoot, vgoModule));
                LOG.debug("Module " + moduleName + " was created with unknown set of dependencies");
            }
        }
        if (vgoModule == null) {
            LOG.debug("No modules were extracted from `go list` output");
        }
    }

    private static String copyGoModFile(@NotNull Module module, @NotNull VirtualFile moduleRoot) {
        if (module == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(13);
        }
        if (moduleRoot == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(14);
        }
        if (Registry.is((String)"go.modules.run.go.list.on.file.copy") && GoSdkService.getInstance(module.getProject()).getSdk(module).supportsTempGoModFile()) {
            File moduleIoRoot = VfsUtilCore.virtualToIoFile((VirtualFile)moduleRoot);
            try {
                File tmpModuleRoot = FileUtil.createTempDirectory((String)moduleRoot.getName(), (String)"goland");
                FileUtil.copy((File)new File(moduleIoRoot, "go.mod"), (File)new File(tmpModuleRoot, "go.mod"));
                try {
                    File goSum = new File(moduleIoRoot, "go.sum");
                    if (goSum.exists()) {
                        FileUtil.copy((File)goSum, (File)new File(tmpModuleRoot, "go.sum"));
                    }
                }
                catch (IOException e) {
                    LOG.debug("Couldn't copy go.mod file", (Throwable)e);
                }
                return tmpModuleRoot.getAbsolutePath();
            }
            catch (IOException e) {
                LOG.info("Couldn't copy go.sum file", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findWorkspaceFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(15);
        }
        VirtualFile virtualFile = parent = file.isDirectory() ? file : file.getParent();
        while (parent != null) {
            VirtualFile goWork = parent.findChild("go.work");
            if (goWork != null) {
                return goWork;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @NotNull
    private static String calcModParameterValue(@NotNull Module module, boolean workspaceMode) {
        if (module == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(16);
        }
        if (workspaceMode) {
            return "-mod=readonly";
        }
        if (GoSdkService.getInstance(module.getProject()).getSdk(module).supportsModulesWithVendorByDefault()) {
            return "-mod=mod";
        }
        return "-mod=";
    }

    @NotNull
    private static String commandKey(@NotNull VirtualFile moduleRoot) {
        if (moduleRoot == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(17);
        }
        String string = "vgo.command.executor.key." + moduleRoot.getPath();
        if (string == null) {
            VgoModuleInfoProviderImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModuleRoot";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/VgoModuleInfoProviderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModuleSettingsFiles";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildListContainer";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModuleSettingsFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModules";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/VgoModuleInfoProviderImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoListDirMapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "commandKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGoListDirMapper";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInfos";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateVgoModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyGoModFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcModParameterValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "commandKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 18 -> new IllegalStateException(string);
        };
    }

    private static class VgoHistoryProcessListener
    extends GoHistoryProcessListener {
        private VgoHistoryProcessListener() {
        }

        @Override
        public boolean shouldShowOutput(boolean isFinishedSuccessfully) {
            return !isFinishedSuccessfully;
        }
    }
}

