/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.project.GoModuleSettings;
import com.goide.project.GoProjectLifecycle;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.vgo.VgoModFileIsAbsentNotificationManager;
import com.goide.vgo.VgoStatusTracker;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.project.workspaceModel.VgoWorkspaceModelAsyncChangeListener;
import com.goide.vgo.project.workspaceModel.VgoWorkspaceModelUpdater;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoIntegrationManager
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    private volatile VgoIntegrationState myState;
    private static final String VGO_DISABLE_STATUS_TRACKING = "go.vgo.disable.status.tracking";
    public static final Key<Boolean> DISABLE_TRACKERS = Key.create((String)"VgoIntegrationManager.DISABLE_TRACKERS");

    public VgoIntegrationManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            VgoIntegrationManager.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            VgoIntegrationManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myCoroutineScope = coroutineScope;
    }

    @NotNull
    public static VgoIntegrationManager getInstance(@NotNull Project project) {
        if (project == null) {
            VgoIntegrationManager.$$$reportNull$$$0(2);
        }
        VgoIntegrationManager vgoIntegrationManager = (VgoIntegrationManager)project.getService(VgoIntegrationManager.class);
        if (vgoIntegrationManager == null) {
            VgoIntegrationManager.$$$reportNull$$$0(3);
        }
        return vgoIntegrationManager;
    }

    @Nullable
    public VgoStatusTracker getTracker(@Nullable Module module) {
        VgoIntegrationState state = this.myState;
        return state != null ? state.getStatusTracker(module) : null;
    }

    public void untrackModule(@NotNull Module module) {
        VgoIntegrationState state;
        if (module == null) {
            VgoIntegrationManager.$$$reportNull$$$0(4);
        }
        if ((state = this.myState) != null) {
            state.untrackModule(module);
        }
    }

    private void projectOpened() {
        if (Registry.is((String)"go.restore.modules.registry")) {
            new VgoWorkspaceModelUpdater(this.myProject).restoreModulesRegistry();
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(this::switchIntegrationState, this.myProject.getDisposed()));
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VgoProjectSettings.VGO_INTEGRATION_TOPIC, () -> this.switchIntegrationState());
    }

    @RequiresEdt
    private void switchIntegrationState() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (VgoProjectSettings.getInstance(this.myProject).isIntegrationEnabled()) {
            if (this.myState == null) {
                this.myState = new VgoIntegrationState(this.myProject, this.myCoroutineScope, this);
            }
        } else {
            if (this.myState != null) {
                Disposer.dispose((Disposable)this.myState);
            }
            this.myState = null;
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/VgoIntegrationManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/VgoIntegrationManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "untrackModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class VgoIntegrationState
    implements Disposable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final CoroutineScope myCoroutineScope;
        private final Map<Module, VgoStatusTracker> myVgoModules;
        private volatile boolean disposed;

        private VgoIntegrationState(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable) {
            if (project == null) {
                VgoIntegrationState.$$$reportNull$$$0(0);
            }
            if (coroutineScope == null) {
                VgoIntegrationState.$$$reportNull$$$0(1);
            }
            if (parentDisposable == null) {
                VgoIntegrationState.$$$reportNull$$$0(2);
            }
            this.myVgoModules = new HashMap<Module, VgoStatusTracker>();
            this.disposed = false;
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            this.myProject = project;
            this.myCoroutineScope = coroutineScope;
            this.enableVgoIntegration();
        }

        private synchronized void enableVgoIntegration() {
            if (this.disposed || Boolean.getBoolean(VgoIntegrationManager.VGO_DISABLE_STATUS_TRACKING) || TestModeFlags.is(DISABLE_TRACKERS)) {
                return;
            }
            ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)this.myProject, (String)"VgoIntegrationState.enableVgoIntegration");
            if (this.alreadyEnabled()) {
                if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
                    this.updateTrackedModules();
                } else {
                    NonUrgentExecutor.getInstance().execute(this::updateTrackedModules);
                }
                activityTracker.activityFinished();
                return;
            }
            GoProjectLifecycle.runWhenProjectSetupFinished(this.myProject, () -> new VgoModFileIsAbsentNotificationManager(this.myProject, this));
            Collection<Module> modules = GoSdkUtil.getGoModules(this.myProject);
            for (Module module2 : modules) {
                this.trackModule(module2);
            }
            MessageBusConnection modulesTrackingConnection = this.myProject.getMessageBus().connect((Disposable)this);
            modulesTrackingConnection.subscribe(GoModuleSettings.GO_SUPPORT_TOPIC, (module, __) -> {
                if (GoSdkService.getInstance(module.getProject()).isGoModule(module)) {
                    this.trackModule(module);
                } else {
                    this.untrackModule(module);
                }
            });
            modulesTrackingConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.isCausedByWorkspaceModelChangesOnly()) {
                        return;
                    }
                    if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
                        this.updateTrackedModules();
                    } else {
                        NonUrgentExecutor.getInstance().execute(this::updateTrackedModules);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/vgo/VgoIntegrationManager$VgoIntegrationState$1", "rootsChanged"));
                }
            });
            new VgoWorkspaceModelAsyncChangeListener(this.myProject, this.myCoroutineScope).subscribe();
            activityTracker.activityFinished();
        }

        @Nullable
        private synchronized VgoStatusTracker getStatusTracker(@Nullable Module module) {
            return !this.disposed ? this.myVgoModules.get(module) : null;
        }

        private synchronized void disableVgoIntegration() {
            if (!this.alreadyEnabled()) {
                return;
            }
            ArrayList<VgoStatusTracker> trackers = new ArrayList<VgoStatusTracker>(this.myVgoModules.values());
            this.myVgoModules.clear();
            trackers.forEach(Disposer::dispose);
        }

        private synchronized boolean alreadyEnabled() {
            return !this.myVgoModules.isEmpty();
        }

        private synchronized void updateTrackedModules() {
            if (this.disposed) {
                return;
            }
            HashSet<Module> currentModules = new HashSet<Module>(GoSdkUtil.getGoModules(this.myProject));
            Map removedModules = ContainerUtil.filter(this.myVgoModules, m -> !currentModules.contains(m));
            removedModules.keySet().forEach(this.myVgoModules::remove);
            removedModules.values().forEach(Disposer::dispose);
            currentModules.forEach(this::trackModule);
        }

        private synchronized void trackModule(@NotNull Module module) {
            if (module == null) {
                VgoIntegrationState.$$$reportNull$$$0(3);
            }
            if (this.disposed) {
                return;
            }
            ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)this.myProject, (String)"VgoIntegrationManager.VgoIntegrationState.trackModule");
            VgoStatusTracker tracker = this.myVgoModules.computeIfAbsent(module, __ -> new VgoStatusTracker(module, this));
            tracker.scheduleUpdatingDependenciesOfAllModules();
            activityTracker.activityFinished();
        }

        private synchronized void untrackModule(@NotNull Module module) {
            if (module == null) {
                VgoIntegrationState.$$$reportNull$$$0(4);
            }
            if (this.disposed) {
                return;
            }
            VgoStatusTracker tracker = this.myVgoModules.remove(module);
            if (tracker != null) {
                Disposer.dispose((Disposable)tracker);
            }
        }

        public void dispose() {
            this.disposed = true;
            if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
                this.disableVgoIntegration();
            } else {
                NonUrgentExecutor.getInstance().execute(this::disableVgoIntegration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coroutineScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/VgoIntegrationManager$VgoIntegrationState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trackModule";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "untrackModule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class VgoIntegrationProjectManagerListener
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                VgoIntegrationProjectManagerListener.$$$reportNull$$$0(0);
            }
            VgoIntegrationManager.getInstance(project).projectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/goide/vgo/VgoIntegrationManager$VgoIntegrationProjectManagerListener", "runActivity"));
        }
    }
}

