/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vendor;

import com.goide.GoPluginDisposable;
import com.goide.project.GoActivityKey;
import com.goide.sdk.GoSdkUtil;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vendor.workspaceModel.GoVendorWorkspaceModelUpdater;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.Alarm;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class GoVendorDirectoriesCollector {
    private static final Logger LOG = Logger.getInstance(GoVendorDirectoriesCollector.class);
    private static final Key<Boolean> VENDOR_COLLECTOR_DISABLED_IN_TEST = Key.create((String)"GO_VENDOR_COLLECTOR_DISABLED_IN_TESTS");
    private final SingleAlarm myAlarm;
    private final ConcurrentMap<Module, Set<VirtualFile>> myVendorDirectoriesMap;
    private volatile boolean myIsMapInitialized;
    private final Project myProject;

    public GoVendorDirectoriesCollector(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(1);
        }
        this.myVendorDirectoriesMap = new ConcurrentHashMap<Module, Set<VirtualFile>>();
        this.myIsMapInitialized = false;
        this.myProject = project;
        if (!GoVendorDirectoriesCollector.isEnabled()) {
            this.myAlarm = null;
            return;
        }
        Alarm.ThreadToUse threadToUse = CoreProgressManager.shouldKeepTasksAsynchronous() ? Alarm.ThreadToUse.POOLED_THREAD : Alarm.ThreadToUse.SWING_THREAD;
        this.myAlarm = new SingleAlarm(this::recalculateVendorDirectories, 300, threadToUse, GoPluginDisposable.getInstance(project));
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> GoVendorDirectoriesCollector.this.myVendorDirectoriesMap.remove(module));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "com/goide/vendor/GoVendorDirectoriesCollector$1";
                objectArray[2] = "beforeModuleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event.isCausedByWorkspaceModelChangesOnly()) {
                    return;
                }
                GoVendorDirectoriesCollector.this.requestVendorDirectoriesRecalculation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/vendor/GoVendorDirectoriesCollector$2", "rootsChanged"));
            }
        });
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            if (project.isDisposed()) {
                return null;
            }
            for (VFileEvent event : events) {
                ProgressManager.checkCanceled();
                VirtualFile file = event.getFile();
                if ((!(event instanceof VFileCreateEvent) || !((VFileCreateEvent)event).isDirectory()) && (file == null || !file.isDirectory())) continue;
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        GoVendorDirectoriesCollector.this.requestVendorDirectoriesRecalculation();
                    }
                };
            }
            return null;
        }, GoPluginDisposable.getInstance(project));
        GoVendorWorkspaceModelUpdater updater = new GoVendorWorkspaceModelUpdater(project);
        updater.restore(coroutineScope, restoredMap -> {
            if (!this.myIsMapInitialized) {
                this.updateVendorDirectoriesIfNeeded((Map<Module, Set<VirtualFile>>)restoredMap);
            }
        });
        updater.subscribe(coroutineScope);
    }

    @TestOnly
    public void disableInTest(@NotNull Disposable disposable) {
        if (disposable == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(2);
        }
        TestModeFlags.set(VENDOR_COLLECTOR_DISABLED_IN_TEST, (Object)true, (Disposable)disposable);
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            this.updateVendorDirectoriesIfNeeded(Collections.emptyMap());
        }
        Disposer.register((Disposable)disposable, () -> {
            TestModeFlags.reset(VENDOR_COLLECTOR_DISABLED_IN_TEST);
            this.requestVendorDirectoriesRecalculation();
        });
    }

    private static boolean isEnabled() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return !TestModeFlags.is(VENDOR_COLLECTOR_DISABLED_IN_TEST);
        }
        return SystemProperties.getBooleanProperty((String)"go.mark.vendor.as.library", (boolean)true);
    }

    public static GoVendorDirectoriesCollector getInstance(@NotNull Project project) {
        if (project == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(3);
        }
        return (GoVendorDirectoriesCollector)project.getService(GoVendorDirectoriesCollector.class);
    }

    public void requestVendorDirectoriesRecalculation() {
        if (this.myAlarm == null || !GoVendorDirectoriesCollector.isEnabled() || this.myProject.isDisposed() || !this.myProject.isInitialized()) {
            return;
        }
        TrackingUtil.trackActivity((Project)this.myProject, (ActivityKey)GoActivityKey.INSTANCE, () -> this.myAlarm.cancelAndRequest(!CoreProgressManager.shouldKeepTasksAsynchronous()));
    }

    @VisibleForTesting
    public void recalculateVendorDirectories() {
        ReadTask readTask = new ReadTask(){

            public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                return !GoVendorDirectoriesCollector.this.myProject.isDisposed() ? (ReadTask.Continuation)DumbService.getInstance((Project)GoVendorDirectoriesCollector.this.myProject).runReadActionInSmartMode(() -> this.performInReadAction(indicator)) : null;
            }

            @NotNull
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    4.$$$reportNull$$$0(1);
                }
                Map<Module, Set<VirtualFile>> vendorDirectories = GoVendorDirectoriesCollector.this.gatherVendorDirectories(indicator);
                return new ReadTask.Continuation(() -> GoVendorDirectoriesCollector.this.updateVendorDirectoriesIfNeeded(vendorDirectories));
            }

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(2);
                }
                Objects.requireNonNull(GoVendorDirectoriesCollector.this.myAlarm).cancelAndRequest();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "indicator";
                objectArray2[1] = "com/goide/vendor/GoVendorDirectoriesCollector$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runBackgroundProcess";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performInReadAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCanceled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (CoreProgressManager.shouldKeepTasksAsynchronous()) {
            ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)readTask);
        } else {
            ReadAction.run(() -> readTask.performInReadAction((ProgressIndicator)new EmptyProgressIndicator()).getAction().run());
        }
    }

    private Map<Module, Set<VirtualFile>> gatherVendorDirectories(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return Collections.emptyMap();
        }
        Set<Module> modules = this.getGoModulesWithVendoring();
        if (modules.isEmpty()) {
            return Collections.emptyMap();
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        HashMap<Module, Set<VirtualFile>> result = new HashMap<Module, Set<VirtualFile>>();
        FilenameIndex.processFilesByName((String)"vendor", (boolean)true, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject), f -> {
            VirtualFile vendor;
            indicator.checkCanceled();
            Object object = vendor = f.isDirectory() ? f : null;
            if (vendor == null || vendor.is(VFileProperty.SYMLINK)) {
                return true;
            }
            Module module = GoVendorDirectoriesCollector.findModuleForVendorDirectory(fileIndex, vendor);
            if (modules.contains(module)) {
                result.computeIfAbsent(module, m -> new HashSet()).add(vendor);
            }
            return true;
        });
        return result;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static Module findModuleForVendorDirectory(@NotNull ProjectFileIndex fileIndex, @Nullable VirtualFile vendor) {
        if (fileIndex == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(5);
        }
        VirtualFile parent = vendor != null ? vendor.getParent() : null;
        return vendor != null && parent != null ? fileIndex.getModuleForFile(parent, true) : null;
    }

    @NotNull
    private Set<Module> getGoModulesWithVendoring() {
        Set<Module> set = GoSdkUtil.getGoModules(this.myProject).stream().filter(GoVendoringUtil::isVendoringEnabled).collect(Collectors.toSet());
        if (set == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void updateVendorDirectoriesIfNeeded(@NotNull Map<Module, Set<VirtualFile>> newMap) {
        if (newMap == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myIsMapInitialized = true;
        Runnable runnable2 = () -> {
            ThreadingAssertions.assertEventDispatchThread();
            this.myVendorDirectoriesMap.clear();
            this.myVendorDirectoriesMap.putAll(newMap);
        };
        if (!newMap.equals(this.myVendorDirectoriesMap)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Vendor directories set changed from " + this.myVendorDirectoriesMap + " to " + newMap);
            }
            runnable2.run();
            new GoVendorWorkspaceModelUpdater(this.myProject).update(newMap);
        }
    }

    @NotNull
    public Set<VirtualFile> getVendorDirectories(@NotNull Module module) {
        if (module == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(8);
        }
        Set<VirtualFile> set = this.myVendorDirectoriesMap.getOrDefault(module, Collections.emptySet());
        if (set == null) {
            GoVendorDirectoriesCollector.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vendor/GoVendorDirectoriesCollector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vendor/GoVendorDirectoriesCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoModulesWithVendoring";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendorDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disableInTest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "gatherVendorDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForVendorDirectory";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateVendorDirectoriesIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVendorDirectories";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

