/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vendor;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoredFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoEditingVendoredFileNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    GoEditingVendoredFileNotificationProvider() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(1);
        }
        if (!GoVendoredFileChangeTracker.getInstance(project).isEditedVendoredFile(file)) {
            return null;
        }
        Module module = GoUtil.module(project, file);
        List allPackages = module != null ? GoEditingVendoredFileNotificationProvider.gatherAllPackages(file, project) : List.of();
        return fileEditor -> GoEditingVendoredFileNotificationProvider.createNotificationPanel(fileEditor, module, allPackages);
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createNotificationPanel(@NotNull FileEditor fileEditor, @Nullable Module module, @NotNull List<AddPackageData> directoriesToAdd) {
        if (fileEditor == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(2);
        }
        if (directoriesToAdd == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        MyEditorNotificationPanel panel2 = new MyEditorNotificationPanel(fileEditor);
        panel2.setText(GoBundle.message((String)"go.notification.code.insight.disabled.for.vendored.files.text", (Object[])new Object[0]));
        if (!directoriesToAdd.isEmpty()) {
            panel2.createLabel(Objects.requireNonNull(module), directoriesToAdd);
        }
        MyEditorNotificationPanel myEditorNotificationPanel = panel2;
        if (myEditorNotificationPanel == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(4);
        }
        return myEditorNotificationPanel;
    }

    @NotNull
    private static List<AddPackageData> gatherAllPackages(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GoEditingVendoredFileNotificationProvider.$$$reportNull$$$0(6);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        LinkedHashSet<AddPackageData> allPackages = new LinkedHashSet<AddPackageData>();
        for (VirtualFile parent = file.getParent(); parent != null && !"vendor".equals(parent.getName()); parent = parent.getParent()) {
            String grandImportPath = GoPackageUtil.findFirstImportPath(psiManager.findDirectory(parent), true);
            if (grandImportPath == null) continue;
            allPackages.add(new AddPackageData(parent, grandImportPath));
        }
        return new ArrayList<AddPackageData>(allPackages);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoriesToAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vendor/GoEditingVendoredFileNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vendor/GoEditingVendoredFileNotificationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "gatherAllPackages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        private MyEditorNotificationPanel(@NotNull FileEditor fileEditor) {
            if (fileEditor == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(0);
            }
            super(fileEditor, EditorNotificationPanel.Status.Warning);
        }

        public void createLabel(@NotNull Module module, @NotNull List<AddPackageData> directoriesToAdd) {
            AddPackageData firstItem;
            if (module == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(1);
            }
            if (directoriesToAdd == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(2);
            }
            if ((firstItem = (AddPackageData)ContainerUtil.getFirstItem(directoriesToAdd)) == null) {
                return;
            }
            if (directoriesToAdd.size() == 1) {
                this.createActionLabel(firstItem.toString(), () -> MyEditorNotificationPanel.addContentRoot(module, firstItem));
            } else {
                this.myLinksPanel.add((Component)new DropDownLink((Object)firstItem, directoriesToAdd, selected -> MyEditorNotificationPanel.addContentRoot(module, selected), true));
            }
        }

        private static void addContentRoot(@NotNull Module module, @NotNull AddPackageData selected) {
            if (module == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(3);
            }
            if (selected == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(4);
            }
            if (!module.isDisposed() && selected.file.isValid()) {
                ModuleRootModificationUtil.addContentRoot((Module)module, (VirtualFile)selected.file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoriesToAdd";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vendor/GoEditingVendoredFileNotificationProvider$MyEditorNotificationPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLabel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addContentRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AddPackageData {
        public final VirtualFile file;
        public final String importPath;

        private AddPackageData(@NotNull VirtualFile file, @NotNull String importPath) {
            if (file == null) {
                AddPackageData.$$$reportNull$$$0(0);
            }
            if (importPath == null) {
                AddPackageData.$$$reportNull$$$0(1);
            }
            this.file = file;
            this.importPath = importPath;
        }

        @Nls
        public String toString() {
            return GoBundle.message((String)"go.notification.add.vendored.package.to.project.action.text", (Object[])new Object[]{this.importPath});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importPath";
                    break;
                }
            }
            objectArray[1] = "com/goide/vendor/GoEditingVendoredFileNotificationProvider$AddPackageData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

