/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoFileType;
import com.goide.util.GoPathScopeBase;
import com.goide.util.GoPathScopeHelper;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPathResolveScope
extends GoPathScopeBase {
    @Nullable
    private final VirtualFile myReferenceFile;
    @NotNull
    private final GoPathScopeHelper myScopeHelper;

    @NotNull
    public static GlobalSearchScope create(@NotNull Project project, @Nullable Module module, @Nullable PsiElement context) {
        if (project == null) {
            GoPathResolveScope.$$$reportNull$$$0(0);
        }
        VirtualFile referenceFile = context != null ? context.getContainingFile().getVirtualFile() : null;
        GoPathScopeHelper helper = GoPathScopeHelper.fromReferenceFile(project, module, referenceFile);
        GlobalSearchScope globalSearchScope = new GoPathResolveScope(project, referenceFile, helper).intersectWith(GlobalSearchScope.allScope((Project)project));
        if (globalSearchScope == null) {
            GoPathResolveScope.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    private GoPathResolveScope(@NotNull Project project, @Nullable VirtualFile referenceFile, @NotNull GoPathScopeHelper scopeHelper) {
        if (project == null) {
            GoPathResolveScope.$$$reportNull$$$0(2);
        }
        if (scopeHelper == null) {
            GoPathResolveScope.$$$reportNull$$$0(3);
        }
        super(project);
        this.myScopeHelper = scopeHelper;
        this.myReferenceFile = referenceFile;
    }

    public boolean contains(@NotNull VirtualFile declarationFile) {
        VirtualFile declarationDirectory;
        if (declarationFile == null) {
            GoPathResolveScope.$$$reportNull$$$0(4);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(declarationFile, (FileType)GoFileType.INSTANCE)) {
            return false;
        }
        VirtualFile virtualFile = declarationDirectory = declarationFile.isDirectory() ? declarationFile : declarationFile.getParent();
        if (declarationDirectory == null) {
            return false;
        }
        if (this.myReferenceFile != null && declarationDirectory.equals(this.myReferenceFile.getParent())) {
            return true;
        }
        return this.myScopeHelper.couldBeReferenced(declarationFile, this.myReferenceFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoPathResolveScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoPathResolveScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

