/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Complex
implements Comparable<Complex> {
    private final double re;
    private final double im;

    public Complex(double real, double imag) {
        this.re = real;
        this.im = imag;
    }

    @Nullable
    public static Complex of(@Nullable Object o) {
        if (o instanceof Complex) {
            return (Complex)o;
        }
        return o instanceof Number ? new Complex(((Number)o).doubleValue(), 0.0) : null;
    }

    @Nullable
    public static Complex of(@Nullable Double re, @Nullable Double im) {
        if (re == null || im == null) {
            return null;
        }
        return new Complex(re, im);
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if (this.re == 0.0) {
            return this.im + "i";
        }
        if (this.im < 0.0) {
            return this.re + " - " + -this.im + "i";
        }
        return this.re + " + " + this.im + "i";
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    @NotNull
    public Complex plus(@NotNull Complex b) {
        if (b == null) {
            Complex.$$$reportNull$$$0(0);
        }
        Complex a = this;
        double real = a.re + b.re;
        double imag = a.im + b.im;
        return new Complex(real, imag);
    }

    @NotNull
    public Complex minus(@NotNull Complex b) {
        if (b == null) {
            Complex.$$$reportNull$$$0(1);
        }
        Complex a = this;
        double real = a.re - b.re;
        double imag = a.im - b.im;
        return new Complex(real, imag);
    }

    @NotNull
    public Complex times(@NotNull Complex b) {
        if (b == null) {
            Complex.$$$reportNull$$$0(2);
        }
        Complex a = this;
        double real = a.re * b.re - a.im * b.im;
        double imag = a.re * b.im + a.im * b.re;
        return new Complex(real, imag);
    }

    @NotNull
    public Complex times(double alpha) {
        return new Complex(alpha * this.re, alpha * this.im);
    }

    @NotNull
    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    @NotNull
    public Complex reciprocal() {
        double scale = this.re * this.re + this.im * this.im;
        return new Complex(this.re / scale, -this.im / scale);
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    @NotNull
    public Complex divides(@NotNull Complex b) {
        if (b == null) {
            Complex.$$$reportNull$$$0(3);
        }
        Complex a = this;
        Complex complex = a.times(b.reciprocal());
        if (complex == null) {
            Complex.$$$reportNull$$$0(4);
        }
        return complex;
    }

    @NotNull
    public Complex exp() {
        return new Complex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    @NotNull
    public Complex sin() {
        return new Complex(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
    }

    @NotNull
    public Complex cos() {
        return new Complex(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
    }

    @NotNull
    public Complex tan() {
        Complex complex = this.sin().divides(this.cos());
        if (complex == null) {
            Complex.$$$reportNull$$$0(5);
        }
        return complex;
    }

    @NotNull
    public static Complex plus(@NotNull Complex a, @NotNull Complex b) {
        if (a == null) {
            Complex.$$$reportNull$$$0(6);
        }
        if (b == null) {
            Complex.$$$reportNull$$$0(7);
        }
        double real = a.re + b.re;
        double imag = a.im + b.im;
        return new Complex(real, imag);
    }

    public static boolean equals(@Nullable Complex l, @Nullable Complex r) {
        if (l == null || r == null) {
            return false;
        }
        if (l == r) {
            return true;
        }
        return l.re == r.re && l.im == r.im;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Complex)) {
            return false;
        }
        return Complex.equals(this, (Complex)o);
    }

    @Override
    public int compareTo(@NotNull Complex o) {
        if (o == null) {
            Complex.$$$reportNull$$$0(8);
        }
        return Complex.equals(this, o) ? 0 : 1;
    }

    public int hashCode() {
        return 31 * Double.hashCode(this.re) + Double.hashCode(this.im);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/Complex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/Complex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "divides";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "times";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "divides";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

