/*
 * Decompiled with CFR 0.152.
 */
package com.goide.usages;

import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.impl.rules.UsageGroupingRulesDefaultRanks;
import com.intellij.usages.rules.PsiElementUsage;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0014J%\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/goide/usages/GoPackageGroupingRule;", "Lcom/intellij/usages/impl/rules/DirectoryGroupingRule;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "computeExternalPackageImportPath", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getExternalImportPath", "getGroupForFile", "Lcom/intellij/usages/UsageGroup;", "getParentGroupFor", "usage", "Lcom/intellij/usages/Usage;", "targets", "", "Lcom/intellij/usages/UsageTarget;", "(Lcom/intellij/usages/Usage;[Lcom/intellij/usages/UsageTarget;)Lcom/intellij/usages/UsageGroup;", "getRank", "", "GoPackageGroup", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoPackageGroupingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoPackageGroupingRule.kt\ncom/goide/usages/GoPackageGroupingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class GoPackageGroupingRule
extends DirectoryGroupingRule {
    public GoPackageGroupingRule(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        PsiFile psiFile;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        PsiElement psiElement2 = psiElement = usage instanceof PsiElementUsage ? ((PsiElementUsage)usage).getElement() : null;
        if (psiElement != null && (psiFile = psiElement.getContainingFile()) instanceof GoFile) {
            VirtualFile virtualFile = psiFile.getVirtualFile().getParent();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile dir = virtualFile;
            return this.getGroupForFile(dir);
        }
        return null;
    }

    @NotNull
    protected UsageGroup getGroupForFile(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return (UsageGroup)new GoPackageGroup(this.getExternalImportPath(dir), dir);
    }

    @NlsContexts.ListItem
    private final String getExternalImportPath(VirtualFile dir) {
        String sdkOrVgoPath;
        boolean isInProject = ModuleUtilCore.projectContainsFile((Project)this.myProject, (VirtualFile)dir, (boolean)false);
        if (!isInProject && (sdkOrVgoPath = this.computeExternalPackageImportPath(dir)) != null) {
            return sdkOrVgoPath;
        }
        return null;
    }

    @NlsContexts.ListItem
    private final String computeExternalPackageImportPath(VirtualFile dir) {
        String importPath;
        GoPackage goPackage;
        Collection<GoPackage> collection;
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(dir);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        Collection<GoPackage> it = collection = GoPackage.in(psiDirectory2);
        boolean bl = false;
        Collection<GoPackage> collection2 = it.size() == 1 ? collection : null;
        GoPackage goPackage2 = goPackage = collection2 != null ? (GoPackage)CollectionsKt.firstOrNull((Iterable)collection2) : null;
        String string = importPath = goPackage2 != null ? goPackage2.getImportPath(true) : null;
        if (Intrinsics.areEqual((Object)importPath, (Object)"builtin") && GoSdkUtil.isInSdk(this.myProject, GoUtil.module(this.myProject, dir), dir)) {
            return "";
        }
        return importPath;
    }

    public int getRank() {
        return UsageGroupingRulesDefaultRanks.AFTER_FILE_STRUCTURE.getAbsoluteRank();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\n\b\u0001\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/goide/usages/GoPackageGroupingRule$GoPackageGroup;", "Lcom/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup;", "Lcom/intellij/usages/impl/rules/DirectoryGroupingRule;", "externalImportPath", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/goide/usages/GoPackageGroupingRule;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getIcon", "Ljavax/swing/Icon;", "getPresentableGroupText", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "isSelected", "", "intellij.go.impl"})
    private final class GoPackageGroup
    extends DirectoryGroupingRule.DirectoryGroup {
        @Nullable
        private final String externalImportPath;

        public GoPackageGroup(@NotNull String externalImportPath, VirtualFile dir) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            super((DirectoryGroupingRule)GoPackageGroupingRule.this, dir);
            this.externalImportPath = externalImportPath;
        }

        @NotNull
        public String getPresentableGroupText() {
            if (this.externalImportPath != null) {
                return this.externalImportPath;
            }
            String string = super.getPresentableGroupText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableGroupText(...)");
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        public SimpleTextAttributes getTextAttributes(boolean isSelected) {
            SimpleTextAttributes simpleTextAttributes;
            if (isSelected) {
                SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNull((Object)simpleTextAttributes2);
                simpleTextAttributes = simpleTextAttributes2;
            } else {
                SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAY_ATTRIBUTES;
                Intrinsics.checkNotNull((Object)simpleTextAttributes3);
                simpleTextAttributes = simpleTextAttributes3;
            }
            return simpleTextAttributes;
        }
    }
}

