/*
 * Decompiled with CFR 0.152.
 */
package com.goide.training.learn.lesson.debugging;

import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.training.GoIFTDisposable;
import com.goide.training.GoLessonsBundle;
import com.goide.training.learn.lesson.GoLesson;
import com.goide.training.learn.lesson.debugging.GoDebugFunctionCallsLesson;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import java.awt.Component;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0017\u001a\u00020\t*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\t*\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R%\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/goide/training/learn/lesson/debugging/GoDebugFunctionCallsLesson;", "Lcom/goide/training/learn/lesson/GoLesson;", "()V", "DEMO_CONFIG_NAME", "", "DEMO_FILE_NAME", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "sample", "Ltraining/dsl/LessonSample;", "sampleFilePath", "getSampleFilePath", "()Ljava/lang/String;", "checkWordInTextField", "", "Ltraining/dsl/TaskRuntimeContext;", "expected", "debuggerSupportsFunctionCalls", "evaluateExpression", "Ltraining/dsl/TaskContext;", "hitBreakpoint", "intellij.go.featuresTrainer"})
public final class GoDebugFunctionCallsLesson
extends GoLesson {
    @NotNull
    private final String DEMO_CONFIG_NAME;
    @NotNull
    private final String DEMO_FILE_NAME;
    @NotNull
    private final String sampleFilePath;
    @Language(value="go")
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public GoDebugFunctionCallsLesson() {
        super("Go.Debug.Function.Calls", GoLessonsBundle.INSTANCE.message("go.debug.function.calls.lesson.name", new Object[0]));
        this.DEMO_CONFIG_NAME = "main";
        this.DEMO_FILE_NAME = this.DEMO_CONFIG_NAME + ".go";
        this.sampleFilePath = "main.go";
        this.sample = LessonSampleKt.parseLessonSample((String)"package main\n\nimport \"runtime\"\n\nfunc main() {\n\t_ = Factorial(10, false)\n\truntime.Breakpoint()\n\tprintln(\"ok\")\n}\n\nfunc Factorial(n int, withBreak bool) int {\n\tif withBreak {\n\t\truntime.Breakpoint()\n\t}\n\tif n == 0 {\n\t\treturn 1\n\t} else {\n\t\treturn n * Factorial(n-1, withBreak)\n\t}\n}");
        this.lessonContent = (Function1)new Function1<LessonContext, Unit>(this){
            final /* synthetic */ GoDebugFunctionCallsLesson this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull LessonContext $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                LessonContext.prepareSample$default((LessonContext)$this$null, (LessonSample)GoDebugFunctionCallsLesson.access$getSample$p(this.this$0), (boolean)false, (int)2, null);
                $this$null.task("ToggleLineBreakpoint", (Function2)new Function2<TaskContext, String, Unit>(this.this$0){
                    final /* synthetic */ GoDebugFunctionCallsLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        $this$task.caret(6, 5);
                        Ref.BooleanRef debuggerSupportsFunctionCalls = new Ref.BooleanRef();
                        $this$task.before((Function1)new Function1<TaskRuntimeContext, Unit>(debuggerSupportsFunctionCalls, this.this$0){
                            final /* synthetic */ Ref.BooleanRef $debuggerSupportsFunctionCalls;
                            final /* synthetic */ GoDebugFunctionCallsLesson this$0;
                            {
                                this.$debuggerSupportsFunctionCalls = $debuggerSupportsFunctionCalls;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskRuntimeContext $this$before) {
                                Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
                                this.$debuggerSupportsFunctionCalls.element = GoDebugFunctionCallsLesson.access$debuggerSupportsFunctionCalls(this.this$0, $this$before);
                            }
                        });
                        String versionWarning = debuggerSupportsFunctionCalls.element ? "" : GoLessonsBundle.INSTANCE.message("go.debug.function.calls.version.warning", new Object[0]) + "\n";
                        String link = "https://www.jetbrains.com/help/go/examining-suspended-program.html#evaluating-expressions";
                        Object[] objectArray = new Object[]{link, versionWarning, $this$task.action(it)};
                        TaskContext.text$default((TaskContext)$this$task, (String)GoLessonsBundle.INSTANCE.message("go.debug.function.calls.toggle.breakpoint", objectArray), null, (int)2, null);
                        $this$task.trigger("ToggleLineBreakpoint");
                    }
                });
                String string = XDebuggerBundle.message((String)"debugger.runner.start.action.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String debugText = LessonUtilKt.dropMnemonic((String)string);
                String debugItem = debugText + " 'go build " + GoDebugFunctionCallsLesson.access$getDEMO_FILE_NAME$p(this.this$0) + "'";
                String debugItemPart = debugText + " 'go build";
                String debugItemMainContext = debugText + " 'go build learn-go-pr...'";
                $this$null.task((Function1)new Function1<TaskContext, Unit>(debugItemMainContext, debugItem, this.this$0, debugItemPart){
                    final /* synthetic */ String $debugItemMainContext;
                    final /* synthetic */ String $debugItem;
                    final /* synthetic */ GoDebugFunctionCallsLesson this$0;
                    final /* synthetic */ String $debugItemPart;
                    {
                        this.$debugItemMainContext = $debugItemMainContext;
                        this.$debugItem = $debugItem;
                        this.this$0 = $receiver;
                        this.$debugItemPart = $debugItemPart;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull TaskContext $this$task) {
                        void this_$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        HighlightingTriggerMethods highlightingTriggerMethods = new Object[4];
                        String string = XDebuggerBundle.message((String)"debugger.runner.start.action.text", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        highlightingTriggerMethods[0] = $this$task.strong(LessonUtilKt.dropMnemonic((String)string));
                        highlightingTriggerMethods[1] = $this$task.strong(this.$debugItemMainContext);
                        highlightingTriggerMethods[2] = $this$task.code("main");
                        highlightingTriggerMethods[3] = $this$task.strong(this.$debugItem);
                        TaskContext.text$default((TaskContext)$this$task, (String)GoLessonsBundle.INSTANCE.message("go.debug.function.context.menu", (Object[])highlightingTriggerMethods), null, (int)2, null);
                        highlightingTriggerMethods = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
                        String string2 = this.$debugItemPart;
                        String string3 = this.$debugItemMainContext;
                        String string4 = this.$debugItem;
                        boolean $i$f$component = false;
                        this_$iv.explicitComponentDetection(ActionMenuItem.class, null, (Function2)new Function2<TaskRuntimeContext, ActionMenuItem, Boolean>(string2, string3, string4){
                            final /* synthetic */ String $debugItemPart$inlined;
                            final /* synthetic */ String $debugItemMainContext$inlined;
                            final /* synthetic */ String $debugItem$inlined;
                            {
                                this.$debugItemPart$inlined = string;
                                this.$debugItemMainContext$inlined = string2;
                                this.$debugItem$inlined = string3;
                                super(2);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$explicitComponentDetection, @NotNull Component it) {
                                void ui;
                                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ActionMenuItem actionMenuItem = (ActionMenuItem)it;
                                TaskRuntimeContext $this$invoke_u24lambda_u240 = $this$explicitComponentDetection;
                                boolean bl = false;
                                return Intrinsics.areEqual((Object)ui.getText(), (Object)this.$debugItemPart$inlined) || Intrinsics.areEqual((Object)ui.getText(), (Object)this.$debugItemMainContext$inlined) || Intrinsics.areEqual((Object)ui.getText(), (Object)this.$debugItem$inlined);
                            }
                        });
                        LessonUtilKt.checkToolWindowState((TaskContext)$this$task, (String)"Debug", (boolean)true);
                        GoDebugFunctionCallsLesson.access$hitBreakpoint(this.this$0, $this$task);
                    }
                });
                $this$null.task((Function1)lessonContent.3.INSTANCE);
                $this$null.task("RunToCursor", (Function2)lessonContent.4.INSTANCE);
                $this$null.task("StepOver", (Function2)lessonContent.5.INSTANCE);
                $this$null.task("EvaluateExpression", (Function2)lessonContent.6.INSTANCE);
                $this$null.task("EditorChooseLookupItem", (Function2)lessonContent.7.INSTANCE);
                $this$null.task("Factorial(6, true)", (Function2)new Function2<TaskContext, String, Unit>(this.this$0){
                    final /* synthetic */ GoDebugFunctionCallsLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object[] objectArray = new Object[]{$this$task.code("6,true"), $this$task.code(it)};
                        TaskContext.text$default((TaskContext)$this$task, (String)GoLessonsBundle.INSTANCE.message("go.debug.function.calls.add.arguments.for.evaluation", objectArray), null, (int)2, null);
                        $this$task.stateCheck((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0, it){
                            final /* synthetic */ GoDebugFunctionCallsLesson this$0;
                            final /* synthetic */ String $it;
                            {
                                this.this$0 = $receiver;
                                this.$it = $it;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                                return GoDebugFunctionCallsLesson.access$checkWordInTextField(this.this$0, $this$stateCheck, this.$it);
                            }
                        });
                    }
                });
                $this$null.task("Evaluate", (Function2)new Function2<TaskContext, String, Unit>(this.this$0){
                    final /* synthetic */ GoDebugFunctionCallsLesson this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object[] objectArray = new Object[2];
                        String string = XDebuggerBundle.message((String)"xdebugger.button.evaluate", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        objectArray[0] = $this$task.strong(LessonUtilKt.dropMnemonic((String)string));
                        objectArray[1] = $this$task.action("EditorEnter");
                        TaskContext.text$default((TaskContext)$this$task, (String)GoLessonsBundle.INSTANCE.message("go.debug.function.calls.click.evaluate", objectArray), null, (int)2, null);
                        GoDebugFunctionCallsLesson.access$evaluateExpression(this.this$0, $this$task);
                    }
                });
                $this$null.task("Stop", (Function2)lessonContent.10.INSTANCE);
            }
        };
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final boolean debuggerSupportsFunctionCalls(TaskRuntimeContext $this$debuggerSupportsFunctionCalls) {
        return GoSdkService.getInstance($this$debuggerSupportsFunctionCalls.getProject()).getSdk(null).getMajorVersion().isAtLeast(GoSdkVersion.GO_1_11);
    }

    private final boolean checkWordInTextField(TaskRuntimeContext $this$checkWordInTextField, String expected) {
        String string;
        Serializable serializable = $this$checkWordInTextField.getFocusOwner();
        Object object = serializable instanceof JTextComponent ? (JTextComponent)serializable : null;
        if (object != null && (object = ((JTextComponent)object).getText()) != null && (object = StringsKt.replace$default((String)object, (String)" ", (String)"", (boolean)false, (int)4, null)) != null) {
            Object object2 = object;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = ((String)object2).toLowerCase(locale);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string3 = expected;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        serializable = locale;
        String string4 = string3.toLowerCase((Locale)serializable);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        return Intrinsics.areEqual((Object)string, (Object)StringsKt.replace$default((String)string4, (String)" ", (String)"", (boolean)false, (int)4, null));
    }

    private final void hitBreakpoint(TaskContext $this$hitBreakpoint) {
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        Disposable disposable = Disposer.newDisposable((String)"Go IFT debug process started listener");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        $this$hitBreakpoint.before((Function1)new Function1<TaskRuntimeContext, Unit>(disposable2, future2){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$disposable = $disposable;
                this.$future = $future;
                super(1);
            }

            public final void invoke(@NotNull TaskRuntimeContext $this$before) {
                Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
                ComponentManager $this$service$iv = (ComponentManager)$this$before.getProject();
                boolean $i$f$service = false;
                Class<GoIFTDisposable> serviceClass$iv = GoIFTDisposable.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Disposer.register((Disposable)((Disposable)object), (Disposable)this.$disposable);
                MessageBusConnection messageBusConnection = $this$before.getProject().getMessageBus().connect(this.$disposable);
                Topic topic = XDebuggerManager.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(this.$disposable, this.$future){
                    final /* synthetic */ Disposable $disposable;
                    final /* synthetic */ CompletableFuture<Boolean> $future;
                    {
                        this.$disposable = $disposable;
                        this.$future = $future;
                    }

                    public void processStarted(@NotNull XDebugProcess debugProcess) {
                        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                        debugProcess.getSession().addSessionListener(new XDebugSessionListener(this.$future){
                            final /* synthetic */ CompletableFuture<Boolean> $future;
                            {
                                this.$future = $future;
                            }

                            public void sessionPaused() {
                                ApplicationManager.getApplication().invokeLater(() -> hitBreakpoint.processStarted.1.sessionPaused$lambda$0(this.$future));
                            }

                            private static final void sessionPaused$lambda$0(CompletableFuture $future) {
                                Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
                                if (!$future.isDone() && !$future.isCancelled()) {
                                    $future.complete(true);
                                }
                            }
                        });
                        Disposer.dispose((Disposable)this.$disposable);
                    }
                });
            }
        });
        $this$hitBreakpoint.addStep(future2);
    }

    private final void evaluateExpression(TaskContext $this$evaluateExpression) {
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        $this$evaluateExpression.before((Function1)new Function1<TaskRuntimeContext, Unit>(future2){
            final /* synthetic */ CompletableFuture<Boolean> $future;
            {
                this.$future = $future;
                super(1);
            }

            public final void invoke(@NotNull TaskRuntimeContext $this$before) {
                Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
                XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)$this$before.getProject()).getCurrentSession();
                Intrinsics.checkNotNull((Object)xDebugSession);
                xDebugSession.addSessionListener(new XDebugSessionListener(this.$future){
                    final /* synthetic */ CompletableFuture<Boolean> $future;
                    {
                        this.$future = $future;
                    }

                    public void settingsChanged() {
                        ApplicationManager.getApplication().invokeLater(() -> evaluateExpression.1.settingsChanged$lambda$0(this.$future));
                    }

                    private static final void settingsChanged$lambda$0(CompletableFuture $future) {
                        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
                        if (!$future.isDone() && !$future.isCancelled()) {
                            $future.complete(true);
                        }
                    }
                });
            }
        });
        $this$evaluateExpression.addStep(future2);
    }

    public static final /* synthetic */ LessonSample access$getSample$p(GoDebugFunctionCallsLesson $this) {
        return $this.sample;
    }

    public static final /* synthetic */ boolean access$debuggerSupportsFunctionCalls(GoDebugFunctionCallsLesson $this, TaskRuntimeContext $receiver) {
        return $this.debuggerSupportsFunctionCalls($receiver);
    }

    public static final /* synthetic */ String access$getDEMO_FILE_NAME$p(GoDebugFunctionCallsLesson $this) {
        return $this.DEMO_FILE_NAME;
    }

    public static final /* synthetic */ void access$hitBreakpoint(GoDebugFunctionCallsLesson $this, TaskContext $receiver) {
        $this.hitBreakpoint($receiver);
    }

    public static final /* synthetic */ boolean access$checkWordInTextField(GoDebugFunctionCallsLesson $this, TaskRuntimeContext $receiver, String expected) {
        return $this.checkWordInTextField($receiver, expected);
    }

    public static final /* synthetic */ void access$evaluateExpression(GoDebugFunctionCallsLesson $this, TaskContext $receiver) {
        $this.evaluateExpression($receiver);
    }
}

