/*
 * Decompiled with CFR 0.152.
 */
package com.goide.testing;

import com.goide.testing.GoTestEvent;
import com.goide.testing.GoTestEventProcessor;
import com.goide.testing.OutputType;
import com.goide.testing.ServiceMessageBuilder;
import com.goide.utils.GoStringUtil;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestJsonEventsProcessor {
    private static final String NOT_EQUAL_PATTERN = "Error:\\s+Not equal:.*\n";
    private static final String WINDOWS_PTY_PREFIX = "\u001b[0m";
    private static final String CTRL_C_PREFIX = "^C";
    private static final String JSON_START = "{\"Time\":";
    @NotNull
    private final GoTestEventProcessor myProcessor;
    private final Set<String> myEmptySuites;
    private final Set<String> myStartedPackages;
    private final Set<String> myStartedTests;
    private final Set<String> myTestsWithIgnoredChildren;
    private final Map<String, ComparisonFailures> myComparisonFailures;
    private final String myDefaultImportPath;
    private final Object myFailTestSync;
    private volatile String myCurrentFailedImportPath;
    private final StringBuilder myPendingInvalidJson;
    private final boolean myHandleSplitLines;
    private final boolean myRestoreTrimmedSpaces;
    private Double myTotalTimeSeconds;

    public GoTestJsonEventsProcessor(@NotNull GoTestEventProcessor processor2) {
        if (processor2 == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(0);
        }
        this("", processor2, false, false);
    }

    public GoTestJsonEventsProcessor(@NotNull String defaultImportPath, @NotNull GoTestEventProcessor processor2, boolean handleSplitLines, boolean restoreTrimmedSpaces) {
        if (defaultImportPath == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(2);
        }
        this.myEmptySuites = new HashSet<String>();
        this.myStartedPackages = new HashSet<String>();
        this.myStartedTests = new HashSet<String>();
        this.myTestsWithIgnoredChildren = new HashSet<String>();
        this.myComparisonFailures = new HashMap<String, ComparisonFailures>();
        this.myFailTestSync = new Object();
        this.myPendingInvalidJson = new StringBuilder();
        this.myProcessor = processor2;
        this.myDefaultImportPath = defaultImportPath;
        this.myHandleSplitLines = handleSplitLines;
        this.myRestoreTrimmedSpaces = restoreTrimmedSpaces;
    }

    public void clearState() {
        this.myEmptySuites.clear();
        this.myStartedPackages.clear();
        this.myStartedTests.clear();
        this.myTestsWithIgnoredChildren.clear();
        this.myComparisonFailures.clear();
        this.myCurrentFailedImportPath = null;
        this.myPendingInvalidJson.setLength(0);
    }

    public boolean processLine(@NotNull String text, @NotNull OutputType outputType, ServiceMessageVisitor visitor2) {
        GoTestEvent event;
        if (text == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(4);
        }
        Gson gson = new Gson();
        String textWithoutWindowsPrefix = text;
        if (this.myPendingInvalidJson.length() > 0) {
            this.appendPendingInvalidJson(text);
            try {
                event = (GoTestEvent)gson.fromJson(this.myPendingInvalidJson.toString(), GoTestEvent.class);
            }
            catch (RuntimeException e) {
                return true;
            }
            this.myPendingInvalidJson.setLength(0);
        } else {
            if (text.startsWith("\u001b[0m{\"Time\":")) {
                textWithoutWindowsPrefix = text.substring(WINDOWS_PTY_PREFIX.length());
            }
            if (textWithoutWindowsPrefix.startsWith("^C{\"Time\":")) {
                textWithoutWindowsPrefix = text.substring(CTRL_C_PREFIX.length());
            }
            try {
                event = (GoTestEvent)gson.fromJson(textWithoutWindowsPrefix, GoTestEvent.class);
            }
            catch (RuntimeException e) {
                if (this.myHandleSplitLines && GoTestJsonEventsProcessor.looksLikeJson(textWithoutWindowsPrefix)) {
                    this.appendPendingInvalidJson(textWithoutWindowsPrefix);
                    return true;
                }
                event = null;
            }
        }
        if (event == null) {
            return this.handleNonJsonOutput(text, outputType, visitor2);
        }
        this.finishNonJsonOutputIfNeeded(visitor2);
        Action action = event.getAction();
        NameAndParentTestName nameAndParentTestName = this.getNames(event.testName, event.importPath);
        String name = nameAndParentTestName.testName;
        if (action == Action.OUTPUT) {
            if (name != null) {
                if (event.isPackage() && this.myStartedPackages.add(event.importPath)) {
                    if (!this.startPackage(event, visitor2)) {
                        return false;
                    }
                } else if (this.myStartedTests.add(event.getNodeId())) {
                    this.startTest(event, visitor2);
                }
                this.processComparisonFailure(event.getNodeId(), event.output);
                return this.output(name, event.getNodeId(), event.output, outputType, visitor2);
            }
            ServiceMessageBuilder message = new ServiceMessageBuilder("message").attribute("text", GoStringUtil.notNullize(event.output)).attribute("status", outputType == OutputType.STDERR ? "ERROR" : "NORMAL");
            return this.myProcessor.processEvent(message.build(), outputType, visitor2);
        }
        if (name == null) {
            if (action == Action.PASS || action == Action.FAIL) {
                this.myTotalTimeSeconds = event.elapsed;
            }
            return true;
        }
        if (action == Action.CONT || action == Action.PAUSE) {
            return true;
        }
        if (action == Action.RUN && event.isTest()) {
            if (event.importPath != null && this.myStartedPackages.add(event.importPath) && !this.startPackage(event, visitor2)) {
                return false;
            }
            return this.startTest(event, visitor2);
        }
        if (action == Action.PASS || action == Action.FAIL || action == Action.SKIP) {
            boolean suite;
            if (event.isPackage() && this.myStartedPackages.add(event.importPath) && !this.startPackage(event, visitor2)) {
                return false;
            }
            boolean bl = suite = event.isPackage() && this.myStartedPackages.remove(event.importPath);
            if (action == Action.FAIL && (!suite || this.myEmptySuites.contains(event.getNodeId()))) {
                ServiceMessageBuilder failTest = ServiceMessageBuilder.testFailed(name).attribute("nodeId", event.getNodeId()).attribute("message", GoStringUtil.notNullize(event.output));
                ComparisonFailures comparisonFailure = this.myComparisonFailures.remove(event.getNodeId());
                if (comparisonFailure != null) {
                    failTest.attribute("type", "comparisonFailure");
                    failTest.attribute("expected", GoTestJsonEventsProcessor.decodeComparisonValue(comparisonFailure.expected));
                    failTest.attribute("actual", GoTestJsonEventsProcessor.decodeComparisonValue(comparisonFailure.actual));
                }
                if (!this.myProcessor.processEvent(failTest.build(), OutputType.SYSTEM, visitor2)) {
                    return false;
                }
            }
            if (!suite && (action == Action.SKIP || action == Action.PASS && this.myTestsWithIgnoredChildren.remove(event.getNodeId()))) {
                ServiceMessageBuilder skipTest = ServiceMessageBuilder.testIgnored(name).attribute("nodeId", event.getNodeId()).attribute("message", GoStringUtil.notNullize(event.output));
                String parentNodeId = event.getParentNodeId(nameAndParentTestName.parentTestName);
                if (parentNodeId != null) {
                    this.myTestsWithIgnoredChildren.add(parentNodeId);
                }
                if (!this.myProcessor.processEvent(skipTest.build(), OutputType.SYSTEM, visitor2)) {
                    return false;
                }
            }
            return this.finishTest(event, name, suite, visitor2);
        }
        return false;
    }

    private void appendPendingInvalidJson(@NotNull String text) {
        int trimmedSpaces;
        if (text == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(5);
        }
        String trimmed = text.endsWith("\r\n") ? text.substring(0, text.length() - 2) : (text.length() > 0 && text.charAt(text.length() - 1) == '\n' ? text.substring(0, text.length() - 1) : text);
        if (this.myRestoreTrimmedSpaces && (trimmedSpaces = 80 - trimmed.length()) > 0) {
            trimmed = trimmed + GoStringUtil.repeat(" ", trimmedSpaces);
        }
        this.myPendingInvalidJson.append(trimmed);
    }

    private static boolean looksLikeJson(@NotNull String text) {
        if (text == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(6);
        }
        return text.startsWith(JSON_START);
    }

    @NotNull
    private static String decodeComparisonValue(@Nullable String value) {
        String literalText = GoStringUtil.unescapeStringLiteralText(value);
        String string = literalText != null ? literalText : GoStringUtil.notNullize(value);
        if (string == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void processComparisonFailure(@Nullable String nodeId, @Nullable String output2) {
        if (GoStringUtil.isNotEmpty(nodeId) && GoStringUtil.isNotEmpty(output2)) {
            String trimmedOutput = GoStringUtil.trimLeading(output2);
            ComparisonFailures comparisonFailures = this.myComparisonFailures.get(nodeId);
            if (comparisonFailures != null) {
                if (trimmedOutput.startsWith("expected:")) {
                    comparisonFailures.expected = GoStringUtil.trimStart(trimmedOutput, "expected:").trim();
                } else if (trimmedOutput.startsWith("actual  :")) {
                    comparisonFailures.actual = GoStringUtil.trimStart(trimmedOutput, "actual  :").trim();
                }
            } else if (Pattern.compile(NOT_EQUAL_PATTERN).matcher(trimmedOutput).matches()) {
                this.myComparisonFailures.put(nodeId, new ComparisonFailures());
            }
        }
    }

    private boolean startPackage(@NotNull GoTestEvent event, ServiceMessageVisitor visitor2) {
        if (event == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(8);
        }
        assert (event.importPath != null);
        this.myEmptySuites.add(event.getNodeId());
        return this.startTest(event, event.importPath, event.importPath, null, event.getPackageLocationString(this.myDefaultImportPath), true, visitor2);
    }

    private boolean startTest(@NotNull GoTestEvent event, ServiceMessageVisitor visitor2) {
        if (event == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(9);
        }
        NameAndParentTestName names = this.getNames(event.testName, event.importPath);
        assert (names.testName != null);
        String parentNodeId = event.getParentNodeId(names.parentTestName);
        return this.startTest(event, names.testName, event.getNodeId(), parentNodeId, event.getTestLocationString(this.myDefaultImportPath), false, visitor2);
    }

    private boolean output(@NotNull String testName, @Nullable String nodeId, @Nullable String output2, @NotNull OutputType outputType, ServiceMessageVisitor visitor2) {
        if (testName == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(10);
        }
        if (outputType == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(11);
        }
        ServiceMessageBuilder message = outputType == OutputType.STDERR ? ServiceMessageBuilder.testStdErr(testName) : ServiceMessageBuilder.testStdOut(testName);
        message.attribute("nodeId", nodeId).attribute("out", output2);
        return this.myProcessor.processEvent(message.build(), outputType, visitor2);
    }

    private boolean startTest(@NotNull GoTestEvent event, @NotNull String testName, @Nullable String nodeId, @Nullable String parentNodeId, @NotNull String locationString, boolean suite, ServiceMessageVisitor visitor2) {
        if (event == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(12);
        }
        if (testName == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(13);
        }
        if (locationString == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(14);
        }
        this.myStartedTests.add(nodeId);
        this.myEmptySuites.remove(parentNodeId);
        ServiceMessageBuilder startTest = suite ? ServiceMessageBuilder.testSuiteStarted(testName) : ServiceMessageBuilder.testStarted(testName);
        startTest.attribute("nodeId", nodeId).attribute("parentNodeId", GoStringUtil.notNullize(parentNodeId, "0")).attribute("locationHint", locationString).attribute("message", GoStringUtil.notNullize(event.output));
        return this.myProcessor.processEvent(startTest.build(), OutputType.SYSTEM, visitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishNonJsonOutputIfNeeded(ServiceMessageVisitor visitor2) {
        Object object = this.myFailTestSync;
        synchronized (object) {
            if (this.myCurrentFailedImportPath != null) {
                String nodeId = this.myCurrentFailedImportPath;
                this.myCurrentFailedImportPath = null;
                ServiceMessageBuilder failTest = ServiceMessageBuilder.testFailed(nodeId).attribute("nodeId", nodeId).attribute("message", "");
                this.myProcessor.processEvent(failTest.build(), OutputType.SYSTEM, visitor2);
                ServiceMessageBuilder finishTest = ServiceMessageBuilder.testSuiteFinished(nodeId).attribute("nodeId", nodeId);
                this.myProcessor.processEvent(finishTest.build(), OutputType.SYSTEM, visitor2);
            }
        }
    }

    private boolean finishTest(@NotNull GoTestEvent event, @NotNull String testName, boolean suite, ServiceMessageVisitor visitor2) {
        if (event == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(15);
        }
        if (testName == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(16);
        }
        ServiceMessageBuilder finishTest = suite ? ServiceMessageBuilder.testSuiteFinished(GoStringUtil.notNullize(event.importPath)) : ServiceMessageBuilder.testFinished(testName);
        finishTest.attribute("nodeId", event.getNodeId()).attribute("duration", event.getElapsedTime());
        return this.myProcessor.processEvent(finishTest.build(), OutputType.SYSTEM, visitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleNonJsonOutput(@NotNull String text, @NotNull OutputType type2, ServiceMessageVisitor visitor2) {
        if (text == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(17);
        }
        if (type2 == null) {
            GoTestJsonEventsProcessor.$$$reportNull$$$0(18);
        }
        Object object = this.myFailTestSync;
        synchronized (object) {
            if (text.startsWith("# ")) {
                this.myCurrentFailedImportPath = GoStringUtil.trimStart(text, "# ");
                ServiceMessageBuilder messageBuilder = ServiceMessageBuilder.testSuiteStarted(this.myCurrentFailedImportPath).attribute("nodeId", this.myCurrentFailedImportPath).attribute("parentNodeId", "0");
                if (!this.myProcessor.processEvent(messageBuilder.build(), type2, visitor2)) {
                    return false;
                }
            }
            if (this.myCurrentFailedImportPath != null) {
                return this.output(this.myCurrentFailedImportPath, this.myCurrentFailedImportPath, text, type2, visitor2);
            }
            return false;
        }
    }

    private NameAndParentTestName getNames(@Nullable String testName, @Nullable String importPath) {
        String parentTestName = "";
        if (testName != null) {
            String notNullImportPath = GoStringUtil.notNullize(importPath);
            int lastSlash = testName.lastIndexOf(47);
            while (lastSlash > -1) {
                String beforeSlash = testName.substring(0, lastSlash);
                if (lastSlash < testName.length() - 1 && this.myStartedTests.contains(notNullImportPath + "#" + beforeSlash)) {
                    testName = testName.substring(lastSlash + 1);
                    parentTestName = beforeSlash;
                    break;
                }
                lastSlash = testName.lastIndexOf(47, lastSlash - 1);
            }
        }
        return new NameAndParentTestName(testName != null ? testName : importPath, parentTestName);
    }

    @Nullable
    public Double getTotalTimeSeconds() {
        return this.myTotalTimeSeconds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/testing/GoTestJsonEventsProcessor";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationString";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/testing/GoTestJsonEventsProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeComparisonValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendPendingInvalidJson";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeJson";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startPackage";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startTest";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "output";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "finishTest";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleNonJsonOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum Action {
        RUN,
        PASS,
        SKIP,
        FAIL,
        OUTPUT,
        CONT,
        PAUSE;

    }

    private static final class NameAndParentTestName {
        public final String testName;
        public final String parentTestName;

        private NameAndParentTestName(@Nullable String testName, @Nullable String parentTestName) {
            this.testName = testName;
            this.parentTestName = parentTestName;
        }
    }

    private static class ComparisonFailures {
        public String expected;
        public String actual;

        private ComparisonFailures() {
        }
    }
}

