/*
 * Decompiled with CFR 0.152.
 */
package com.goide.template.integration;

import com.goide.codeInsight.imports.GoImport;
import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoLookupElementOptions;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.stubs.index.GoTypesIndex;
import com.goide.template.integration.GoTemplateDotTypeHint;
import com.goide.template.integration.GoTemplateUtil;
import com.goide.template.psi.GoTemplateEmptyStatement;
import com.goide.template.psi.GoTemplateFile;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTemplateTypeHintCompletionContributor
extends CompletionContributor {
    private static final PsiElementPattern.Capture<PsiComment> GO_TEMPLATE_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)StandardPatterns.instanceOf(GoTemplateFile.class))).withParent((ElementPattern)PlatformPatterns.psiElement(GoTemplateEmptyStatement.class));
    private static final InsertHandler<LookupElement> HANDLER = (context, item) -> {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        PsiElement position = context.getFile().findElementAt(context.getStartOffset());
        GoImport goImport = (GoImport)((Object)((Object)item.getUserData(GoCompletionUtil.GO_IMPORT_KEY)));
        GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)item.getPsiElement(), GoTypeSpec.class);
        if (GO_TEMPLATE_COMMENT.accepts((Object)position) && goImport != null && typeSpec != null) {
            assert (position != null);
            Document document = context.getDocument();
            String newHint = goImport.getImportPath() + "." + typeSpec.getName();
            document.replaceString(context.getStartOffset(), context.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET), (CharSequence)newHint);
            context.getEditor().getCaretModel().moveToOffset(context.getStartOffset() + newHint.length());
        }
    };

    public GoTemplateTypeHintCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(GoTemplateFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement position;
                String importPath;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((importPath = GoTemplateTypeHintCompletionContributor.getImportPath(position = parameters.getPosition(), parameters.getOffset())) != null) {
                    boolean vendoringEnabled = GoVendoringUtil.isVendoringEnabled((PsiElement)parameters.getOriginalFile());
                    Project project = position.getProject();
                    Collection types = StubIndex.getInstance().getAllKeys(GoTypesIndex.KEY, project);
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
                    result = GoTemplateTypeHintCompletionContributor.adjustMatcher(parameters, result, position);
                    for (String type2 : types) {
                        Collection<GoTypeSpec> specs = GoTypesIndex.find(type2, project, scope, null);
                        for (GoTypeSpec spec : specs) {
                            String path = spec.getContainingFile().getImportPath(vendoringEnabled);
                            if (path == null || !path.startsWith(importPath)) continue;
                            String packageName = GoPsiImplUtil.sanitizePackageName(path);
                            String lookupString = StringUtil.isEmpty((String)packageName) ? type2 : packageName + "." + type2;
                            GoImport goImport = new GoImport(path);
                            GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(lookupString).setOtherLookupStrings(Collections.singleton(path + "." + type2)).setInsertHandler(HANDLER).setImport(goImport);
                            result.addElement(GoCompletionUtil.createTypeLookupElement(spec, options));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/goide/template/integration/GoTemplateTypeHintCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(0);
        }
        super.beforeCompletion(context);
        PsiElement at = context.getFile().findElementAt(context.getStartOffset());
        if (GO_TEMPLATE_COMMENT.accepts((Object)at)) {
            assert (at != null);
            context.setReplacementOffset(at.getTextRange().getStartOffset() + ElementManipulators.getValueTextRange((PsiElement)at).getEndOffset());
        }
    }

    @NotNull
    private static CompletionResultSet adjustMatcher(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element) {
        String text;
        int hintIndex;
        if (parameters == null) {
            GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((hintIndex = (text = element.getText()).indexOf("gotype:")) == -1) {
            CompletionResultSet completionResultSet = result;
            if (completionResultSet == null) {
                GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(4);
            }
            return completionResultSet;
        }
        int hintEnd = hintIndex + "gotype:".length();
        int startOffset = element.getTextRange().getStartOffset() + hintEnd + StringUtil.findFirst((CharSequence)text.subSequence(hintEnd, text.length()), c -> !Character.isWhitespace(c));
        String newPrefix = parameters.getEditor().getDocument().getText(TextRange.create((int)startOffset, (int)parameters.getOffset()));
        CompletionResultSet completionResultSet = result.withPrefixMatcher(GoCompletionUtil.createPrefixMatcher(newPrefix));
        if (completionResultSet == null) {
            GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(5);
        }
        return completionResultSet;
    }

    @Nullable
    private static String getImportPath(@NotNull PsiElement position, int offset) {
        if (position == null) {
            GoTemplateTypeHintCompletionContributor.$$$reportNull$$$0(6);
        }
        if (!GO_TEMPLATE_COMMENT.accepts((Object)position)) {
            return null;
        }
        String text = position.getText();
        text = text.substring(0, offset - position.getTextOffset());
        GoTemplateDotTypeHint hint = GoTemplateUtil.parseTypeHint(text = GoTemplateUtil.trimTypeHintCommentPrefix(text));
        return hint != null ? hint.getImportPath() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/template/integration/GoTemplateTypeHintCompletionContributor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/template/integration/GoTemplateTypeHintCompletionContributor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustMatcher";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

