/*
 * Decompiled with CFR 0.152.
 */
package com.goide.statistics;

import com.goide.editor.GoFoldingSettings;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GoFoldingSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    private static final String GROUP_ID = "go.settings.folding";
    private static final int VERSION = 5;
    private static final EventLogGroup GROUP = new EventLogGroup("go.settings.folding", 5);
    private static final VarargEventId ONE_LINE_RETURNS = GROUP.registerVarargEvent("oneLineReturns", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ONE_LINE_PANICS = GROUP.registerVarargEvent("oneLinePanics", new EventField[]{EventFields.Enabled});
    private static final VarargEventId FMT_STRINGS = GROUP.registerVarargEvent("fmtStrings", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ONE_LINE_RETURN_FUNCTIONS = GROUP.registerVarargEvent("oneLineReturnFunctions", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ONE_LINE_ERROR_HANDLING_BLOCKS = GROUP.registerVarargEvent("oneLineErrorHandlingBlocks", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ONE_LINE_CASE_CLAUSES = GROUP.registerVarargEvent("oneLineCaseClauses", new EventField[]{EventFields.Enabled});
    private static final VarargEventId EMPTY_FUNCTIONS = GROUP.registerVarargEvent("emptyFunctions", new EventField[]{EventFields.Enabled});
    private static final VarargEventId EMPTY_STRUCT_OR_INTERFACE_TYPE_DEFS = GROUP.registerVarargEvent("emptyStructOrInterfaceTypeDefs", new EventField[]{EventFields.Enabled});
    private static final EnumEventField<GoFoldingSettings.FoldedReturnSyntax> RETURN_SYNTAX_VALUE = EventFields.Enum((String)"ReturnSyntax", GoFoldingSettings.FoldedReturnSyntax.class);
    private static final VarargEventId RETURN_SYNTAX = GROUP.registerVarargEvent("returnSyntax", new EventField[]{RETURN_SYNTAX_VALUE});
    private static final EnumEventField<GoFoldingSettings.FoldedPanicSyntax> PANIC_SYNTAX_VALUE = EventFields.Enum((String)"PanicSyntax", GoFoldingSettings.FoldedPanicSyntax.class);
    private static final VarargEventId PANIC_SYNTAX = GROUP.registerVarargEvent("panicSyntax", new EventField[]{PANIC_SYNTAX_VALUE});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        GoFoldingSettings settings = GoFoldingSettings.getInstance();
        GoFoldingSettings defaultSettings = new GoFoldingSettings();
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isOneLineReturns, (VarargEventId)ONE_LINE_RETURNS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isOneLinePanics, (VarargEventId)ONE_LINE_PANICS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isFmtStrings, (VarargEventId)FMT_STRINGS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isOneLineReturnFunctions, (VarargEventId)ONE_LINE_RETURN_FUNCTIONS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isOneLineErrorHandlingBlocks, (VarargEventId)ONE_LINE_ERROR_HANDLING_BLOCKS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isOneLineCaseClauses, (VarargEventId)ONE_LINE_CASE_CLAUSES);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isEmptyFunctions, (VarargEventId)EMPTY_FUNCTIONS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.isEmptyStructOrInterfaceTypeDefs, (VarargEventId)EMPTY_STRUCT_OR_INTERFACE_TYPE_DEFS);
        MetricEventUtilKt.addIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.returnSyntax, (VarargEventId)RETURN_SYNTAX, RETURN_SYNTAX_VALUE);
        MetricEventUtilKt.addIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.panicSyntax, (VarargEventId)PANIC_SYNTAX, PANIC_SYNTAX_VALUE);
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            GoFoldingSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/statistics/GoFoldingSettingsStatisticsCollector", "getMetrics"));
    }
}

