/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.GoNotifications;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdkAccessor;
import com.goide.sdk.download.GoBasedDownloadingSdk;
import com.goide.sdk.download.GoDownloadUnpackSdkStrings;
import com.goide.util.GoUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoSdkDownloader<Sdk extends GoBasedSdk, DownloadingSdk extends GoBasedDownloadingSdk<Sdk>> {
    private static final Logger LOG = Logger.getInstance(GoSdkDownloader.class);
    protected final Set<DownloadingSdk> myDownloadingSdks;
    private final Map<Trinity<String, String, String>, Path> myDownloadedArchives;
    @NotNull
    private final Function<? super Project, ? extends GoSdkAccessor<Sdk>> mySdkAccessor;
    @NotNull
    private final Sdk myNullSdk;
    @NotNull
    private final GoDownloadUnpackSdkStrings myStrings;

    protected GoSdkDownloader(@NotNull Function<? super Project, ? extends GoSdkAccessor<Sdk>> sdkAccessor, @NotNull Sdk nullSdk, @NotNull GoDownloadUnpackSdkStrings strings) {
        if (sdkAccessor == null) {
            GoSdkDownloader.$$$reportNull$$$0(0);
        }
        if (nullSdk == null) {
            GoSdkDownloader.$$$reportNull$$$0(1);
        }
        if (strings == null) {
            GoSdkDownloader.$$$reportNull$$$0(2);
        }
        this.myDownloadingSdks = new HashSet<DownloadingSdk>();
        this.myDownloadedArchives = new ConcurrentHashMap<Trinity<String, String, String>, Path>();
        this.mySdkAccessor = sdkAccessor;
        this.myNullSdk = nullSdk;
        this.myStrings = strings;
    }

    public void downloadSdk(@NotNull DownloadingSdk sdk) {
        if (sdk == null) {
            GoSdkDownloader.$$$reportNull$$$0(3);
        }
        if (this.myDownloadingSdks.add(sdk)) {
            this.startDownloading(sdk);
        } else if (sdk.isDownloaded()) {
            this.replaceDownloadedSdkWithLocal(sdk, sdk.toLocalSdk());
        }
    }

    private void startDownloading(@NotNull DownloadingSdk sdk) {
        WSLDistribution wsl;
        if (sdk == null) {
            GoSdkDownloader.$$$reportNull$$$0(4);
        }
        String os = (wsl = GoWslUtil.getWsl(VfsUtilCore.urlToPath((String)sdk.getHomeUrl()))) != null ? "linux" : GoUtil.systemOS();
        String arch = GoUtil.systemArch();
        Task.Backgroundable downloadTask = new Task.Backgroundable(null, GoBundle.message((String)"go.settings.sdk.download.progress.downloading.status", (Object[])new Object[]{this.myStrings.getSdkName(), sdk.getVersion()}), true, (GoBasedDownloadingSdk)sdk, os, arch, wsl){
            private volatile Sdk downloadedSdk;
            final /* synthetic */ GoBasedDownloadingSdk val$sdk;
            final /* synthetic */ String val$os;
            final /* synthetic */ String val$arch;
            final /* synthetic */ WSLDistribution val$wsl;
            {
                this.val$sdk = goBasedDownloadingSdk;
                this.val$os = string;
                this.val$arch = string2;
                this.val$wsl = wSLDistribution;
                super(arg0, arg1, arg2);
                this.downloadedSdk = GoSdkDownloader.this.myNullSdk;
            }

            public void onFinished() {
                GoSdkDownloader.this.myDownloadingSdks.remove(this.val$sdk);
                Object localSdk = this.downloadedSdk;
                if (localSdk == GoSdkDownloader.this.myNullSdk) {
                    GoSdkDownloader.this.error(this.val$sdk, GoBundle.message((String)"go.settings.sdk.download.unpacked.sdk.is.corrupted.error", (Object[])new Object[0]), null, "Home url: " + this.val$sdk.getHomeUrl());
                    return;
                }
                this.val$sdk.setDownloaded(true);
                GoSdkDownloader.this.registerDownloadedSdk(localSdk);
                GoSdkDownloader.this.replaceDownloadedSdkWithLocal(this.val$sdk, localSdk);
                GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"go.settings.sdk.download.installed.notification.title", (Object[])new Object[]{GoSdkDownloader.this.myStrings.getSdkName(), localSdk.getVersion()}), NotificationType.INFORMATION).notify(null);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    indicator.setIndeterminate(false);
                    Trinity archiveKey = Trinity.create((Object)this.val$os, (Object)this.val$arch, (Object)this.val$sdk.getVersion());
                    Path downloadedArchive = GoSdkDownloader.this.myDownloadedArchives.get(archiveKey);
                    String fileName = GoSdkDownloader.this.myStrings.getFileName(this.val$sdk.getVersion(), this.val$os, this.val$arch);
                    if (downloadedArchive == null || !GoSdkDownloader.this.verifyChecksum(this.val$sdk, indicator, GoSdkDownloader.this.myStrings.getChecksumUrl(fileName), downloadedArchive, true)) {
                        downloadedArchive = Files.createTempFile("for-actual-downloading-", GoSdkDownloader.this.myStrings.getFileExtension(this.val$os), new FileAttribute[0]);
                        DownloadUtil.downloadContentToFile((ProgressIndicator)indicator, (String)GoSdkDownloader.this.myStrings.getDownloadUrl(fileName), (File)downloadedArchive.toFile());
                        indicator.setText2("");
                        if (!GoSdkDownloader.this.verifyChecksum(this.val$sdk, indicator, GoSdkDownloader.this.myStrings.getChecksumUrl(fileName), downloadedArchive, false)) {
                            return;
                        }
                        GoSdkDownloader.this.myDownloadedArchives.put((Trinity<String, String, String>)archiveKey, downloadedArchive);
                    }
                    this.unpackSdk(indicator, downloadedArchive, VfsUtilCore.urlToPath((String)this.val$sdk.getHomeUrl()));
                    this.downloadedSdk = this.val$sdk.toLocalSdk();
                }
                catch (IOException e) {
                    GoSdkDownloader.this.error(this.val$sdk, e.getMessage(), e, null);
                }
            }

            private void unpackSdk(@NotNull ProgressIndicator indicator, @NotNull Path archive, @NonNls @NotNull String targetPath) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (archive == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (targetPath == null) {
                    1.$$$reportNull$$$0(3);
                }
                indicator.setIndeterminate(true);
                indicator.setText(GoBundle.message((String)"go.settings.sdk.download.progress.unpacking.status", (Object[])new Object[0]));
                try {
                    if (this.val$wsl != null) {
                        WSLCommandLineOptions options = new WSLCommandLineOptions();
                        Path targetDir = Path.of(targetPath, new String[0]);
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                        options.setRemoteWorkingDirectory(this.val$wsl.getWslPath(targetDir.getParent()));
                        List<String> cmd = Arrays.asList("tar", "xzf", this.val$wsl.getWslPath(archive), "--one-top-level=" + targetDir.getFileName(), "--strip-components", "1");
                        ProcessOutput output2 = this.val$wsl.executeOnWsl(cmd, options, 300000, null);
                        if (output2.getExitCode() != 0) {
                            String message = "Unpack command '" + StringUtil.join(cmd, (String)" ") + "' failed\nexit code: " + output2.getExitCode() + "\nstdout: " + output2.getStdout() + "\nstderr: " + output2.getStderr();
                            LOG.warn(message);
                            throw new IOException(GoBundle.message((String)"go.wsl.sdk.unpack.error", (Object[])new Object[]{output2.getExitCode()}));
                        }
                        LocalFileSystem.getInstance().refreshNioFiles((Iterable)targetDir);
                        WriteAction.runAndWait(() -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)targetPath)));
                        return;
                    }
                    Path tempDirectory = Files.createTempDirectory("downloaded-sdk-", new FileAttribute[0]);
                    if ("zip".equals(PathUtil.getFileExtension((String)archive.getFileName().toString()))) {
                        ZipUtil.unzip((ProgressIndicator)indicator, (File)tempDirectory.toFile(), (File)archive.toFile(), null, null, (boolean)false);
                    } else {
                        new Decompressor.Tar(archive).extract(tempDirectory);
                    }
                    Path unpacked = tempDirectory.resolve(GoSdkDownloader.this.myStrings.unpackedDirectoryName());
                    if (!Files.exists(unpacked, new LinkOption[0]) || !Files.isDirectory(unpacked, new LinkOption[0])) {
                        GoSdkDownloader.this.error(this.val$sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.find.go.directory.in.downloaded.file.error", (Object[])new Object[0]), null, null);
                        return;
                    }
                    Path targetDir = Files.createDirectories(Paths.get(targetPath, new String[0]), new FileAttribute[0]);
                    this.copyDir(unpacked, targetDir, indicator);
                    LocalFileSystem.getInstance().refreshNioFiles(Collections.singleton(targetDir));
                    FileUtil.asyncDelete((File)unpacked.toFile());
                }
                catch (ExecutionException | IOException e) {
                    GoSdkDownloader.this.error(this.val$sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.unpack.downloaded.file.error", (Object[])new Object[0]), (Exception)e, null);
                }
            }

            private void copyDir(Path from, Path to, ProgressIndicator indicator) throws IOException {
                indicator.setIndeterminate(true);
                indicator.setText(GoBundle.message((String)"go.settings.sdk.download.progress.copying.status", (Object[])new Object[0]));
                try (Stream<Path> filesStream = Files.walk(from, new FileVisitOption[0]);){
                    filesStream.forEach(f -> {
                        try {
                            indicator.checkCanceled();
                            Path relativePath = from.relativize((Path)f);
                            indicator.setText2(GoBundle.message((String)"go.settings.sdk.download.progress.copying.detailed.status", (Object[])new Object[]{relativePath.toString()}));
                            Path targetPath = to.resolve(relativePath);
                            Files.copy(f, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e.getMessage(), e);
                        }
                    });
                }
                catch (UncheckedIOException e) {
                    GoSdkDownloader.this.error(this.val$sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.copy.unpacked.sdk.error", (Object[])new Object[0]), e, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "archive";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetPath";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/sdk/download/GoSdkDownloader$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "unpackSdk";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(downloadTask, (ProgressIndicator)new BackgroundableProcessIndicator(downloadTask));
    }

    private void replaceDownloadedSdkWithLocal(@NotNull DownloadingSdk sdk, @NotNull Sdk localSdk) {
        if (sdk == null) {
            GoSdkDownloader.$$$reportNull$$$0(5);
        }
        if (localSdk == null) {
            GoSdkDownloader.$$$reportNull$$$0(6);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!sdk.equals(((GoSdkAccessor)this.mySdkAccessor.fun((Object)project)).getSdk(null))) continue;
            ((GoSdkAccessor)this.mySdkAccessor.fun((Object)project)).setSdk(localSdk);
        }
    }

    protected abstract boolean verifyChecksum(@NotNull DownloadingSdk var1, @NotNull ProgressIndicator var2, @NotNull String var3, @NotNull Path var4, boolean var5);

    protected void error(@NotNull DownloadingSdk sdk, @NotNull @Nls String message, @Nullable Exception e, @Nullable String details) {
        if (sdk == null) {
            GoSdkDownloader.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GoSdkDownloader.$$$reportNull$$$0(8);
        }
        GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"go.settings.sdk.download.failed.to.download.notification.title", (Object[])new Object[0]), message, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimpleExpiring((String)RefactoringBundle.message((String)"retry.command"), () -> {
            if (!sdk.isDownloaded()) {
                this.downloadSdk(sdk);
            }
        })).notify(null);
        LOG.info(message + ". " + StringUtil.notNullize((String)details), (Throwable)e);
    }

    protected abstract void registerDownloadedSdk(Sdk var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAccessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullSdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/goide/sdk/download/GoSdkDownloader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startDownloading";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceDownloadedSdkWithLocal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

