/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.combobox.GoSdkList;
import com.goide.sdk.download.GoDownloadUnpackSdkStrings;
import com.goide.sdk.download.GoDownloadingSdk;
import com.goide.sdk.download.GoSdkDownloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class GoDownloadSdkService
extends GoSdkDownloader<GoSdk, GoDownloadingSdk> {
    private GoDownloadSdkService() {
        super(GoSdkService::getInstance, GoSdk.NULL, new MyDownloadUnpackSdkStrings());
    }

    @Override
    protected boolean verifyChecksum(@NotNull GoDownloadingSdk sdk, @NotNull ProgressIndicator indicator, @NotNull String checksumUrl, @NotNull Path downloadedFile, boolean silent) {
        if (sdk == null) {
            GoDownloadSdkService.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            GoDownloadSdkService.$$$reportNull$$$0(1);
        }
        if (checksumUrl == null) {
            GoDownloadSdkService.$$$reportNull$$$0(2);
        }
        if (downloadedFile == null) {
            GoDownloadSdkService.$$$reportNull$$$0(3);
        }
        indicator.setText(GoBundle.message((String)"go.settings.sdk.download.progress.verifying.status", (Object[])new Object[0]));
        indicator.setIndeterminate(true);
        try {
            String expectedChecksum = HttpRequests.request((String)checksumUrl).readString(indicator);
            String actualChecksum = DigestUtilKt.sha256Hex((Path)downloadedFile);
            if (!expectedChecksum.equals(actualChecksum)) {
                if (!silent) {
                    this.error(sdk, GoBundle.message((String)"go.settings.sdk.download.checksum.of.downloaded.file.mismatched.error", (Object[])new Object[0]), null, String.format("Expected: %s. Actual: %s", expectedChecksum, actualChecksum));
                }
                return false;
            }
        }
        catch (IOException e) {
            if (!silent) {
                this.error(sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.get.checksum.error", (Object[])new Object[]{checksumUrl}), e, null);
            }
            return false;
        }
        return true;
    }

    @Override
    protected void registerDownloadedSdk(GoSdk downloadedSdk) {
        GoSdkList.getInstance().addSdk(downloadedSdk);
    }

    public static GoDownloadSdkService getInstance() {
        return (GoDownloadSdkService)ApplicationManager.getApplication().getService(GoDownloadSdkService.class);
    }

    @NotNull
    public Set<GoDownloadingSdk> getDownloadingSdks() {
        Set<GoDownloadingSdk> set = Collections.unmodifiableSet(this.myDownloadingSdks);
        if (set == null) {
            GoDownloadSdkService.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksumUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/download/GoDownloadSdkService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/download/GoDownloadSdkService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadingSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "verifyChecksum";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyDownloadUnpackSdkStrings
    implements GoDownloadUnpackSdkStrings {
        private MyDownloadUnpackSdkStrings() {
        }

        @Override
        public String getSdkName() {
            return "Go";
        }

        @Override
        public String unpackedDirectoryName() {
            return "go";
        }

        @Override
        @NotNull
        public String getFileExtension(String os) {
            return "windows".equals(os) ? ".zip" : ".tar.gz";
        }

        @Override
        @NotNull
        public String getFileName(String version2, String os, String arch) {
            String string = String.format("go%s.%s-%s%s", version2, os, arch, this.getFileExtension(os));
            if (string == null) {
                MyDownloadUnpackSdkStrings.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDownloadUrl(String fileName) {
            String string = "https://storage.googleapis.com/golang/" + fileName;
            if (string == null) {
                MyDownloadUnpackSdkStrings.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public String getChecksumUrl(String fileName) {
            return "https://storage.googleapis.com/golang/" + fileName + ".sha256";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/goide/sdk/download/GoDownloadSdkService$MyDownloadUnpackSdkStrings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDownloadUrl";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

