/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.combobox.GoSdkChooserCombo;
import com.goide.sdk.download.GoDownloadSdkAction;
import com.goide.sdk.download.GoDownloadingSdk;
import com.goide.sdk.download.GoSdkDownloaderDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;

public final class GoDownloadSdkActionFactory {
    private static final AtomicReference<Cache> ourVersionCache = new AtomicReference<Cache>(new Cache("", "", Collections.emptySet()));

    private GoDownloadSdkActionFactory() {
    }

    public static GoDownloadSdkAction<GoSdk> createGoSdkDownloadAction(@NotNull Supplier<String> projectPathSupplier, GoSdkChooserCombo combo) {
        if (projectPathSupplier == null) {
            GoDownloadSdkActionFactory.$$$reportNull$$$0(0);
        }
        return new GoDownloadSdkAction<GoSdk>(projectPathSupplier, combo, new GoDownloadDialog(), VersionComparatorUtil.COMPARATOR.reversed());
    }

    private static void initFromCache(@NotNull Set<String> versions, @NotNull Consumer<Collection<String>> versionsConsumer) {
        if (versions == null) {
            GoDownloadSdkActionFactory.$$$reportNull$$$0(1);
        }
        if (versionsConsumer == null) {
            GoDownloadSdkActionFactory.$$$reportNull$$$0(2);
        }
        if (!versions.isEmpty()) {
            versionsConsumer.accept(versions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPathSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsConsumer";
                break;
            }
        }
        objectArray2[1] = "com/goide/sdk/download/GoDownloadSdkActionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createGoSdkDownloadAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initFromCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class GoDownloadDialog
    implements GoSdkDownloaderDialog<GoSdk> {
        private static final Logger LOG = Logger.getInstance(GoDownloadDialog.class);

        private GoDownloadDialog() {
        }

        @Override
        public GoSdk createDownloadingSdk(@NotNull String version2, @NotNull String path) {
            if (version2 == null) {
                GoDownloadDialog.$$$reportNull$$$0(0);
            }
            if (path == null) {
                GoDownloadDialog.$$$reportNull$$$0(1);
            }
            return new GoDownloadingSdk(version2, path);
        }

        @Override
        @NlsContexts.DialogTitle
        @NlsSafe
        public String getTitle() {
            return GoBundle.message((String)"go.settings.sdk.download.dialog.title", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public String getProgressIconName() {
            String string = GoBundle.message((String)"go.settings.sdk.download.dialog.progress.versions.status", (Object[])new Object[0]);
            if (string == null) {
                GoDownloadDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean discoverVersions(@NotNull String os, @NotNull String arch, @NotNull ProgressIndicator progressIndicator, @NotNull Consumer<Collection<String>> versionsConsumer) {
            if (os == null) {
                GoDownloadDialog.$$$reportNull$$$0(3);
            }
            if (arch == null) {
                GoDownloadDialog.$$$reportNull$$$0(4);
            }
            if (progressIndicator == null) {
                GoDownloadDialog.$$$reportNull$$$0(5);
            }
            if (versionsConsumer == null) {
                GoDownloadDialog.$$$reportNull$$$0(6);
            }
            String suffix = "." + os + "-" + arch + "." + ("windows".equals(os) ? "zip" : "tar.gz");
            Cache cache = ourVersionCache.get();
            HashSet<String> versions = new HashSet<String>(cache.versions);
            if (cache.os.equals(os) && cache.arch.equals(arch)) {
                GoDownloadSdkActionFactory.initFromCache(versions, versionsConsumer);
            }
            try {
                String nextMarker = "";
                while (nextMarker != null) {
                    Namespace namespace = Namespace.getNamespace((String)"http://doc.s3.amazonaws.com/2006-03-01");
                    RequestBuilder request = HttpRequests.request((String)("https://storage.googleapis.com/golang/?prefix=go&marker=" + nextMarker));
                    Element response = JDOMUtil.load((CharSequence)request.readString(progressIndicator));
                    HashSet<String> recentlyDiscoveredVersions = new HashSet<String>();
                    for (Element contents : response.getChildren("Contents", namespace)) {
                        String version2;
                        progressIndicator.checkCanceled();
                        String key = contents.getChildText("Key", namespace);
                        if (!StringUtil.endsWith((CharSequence)key, (CharSequence)suffix) || !versions.add(version2 = StringUtil.trimEnd((String)key, (String)suffix))) continue;
                        recentlyDiscoveredVersions.add(version2);
                    }
                    versionsConsumer.accept(recentlyDiscoveredVersions);
                    nextMarker = response.getChildText("NextMarker", namespace);
                }
            }
            catch (IOException | JDOMException ex) {
                LOG.info(ex);
                return false;
            }
            ourVersionCache.set(new Cache(os, arch, versions));
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/sdk/download/GoDownloadSdkActionFactory$GoDownloadDialog";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arch";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionsConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/sdk/download/GoDownloadSdkActionFactory$GoDownloadDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProgressIconName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDownloadingSdk";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "discoverVersions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class Cache {
        private final String os;
        private final String arch;
        private final Set<String> versions;

        private Cache(@NotNull String os, @NotNull String arch, @NotNull Set<String> versions) {
            if (os == null) {
                Cache.$$$reportNull$$$0(0);
            }
            if (arch == null) {
                Cache.$$$reportNull$$$0(1);
            }
            if (versions == null) {
                Cache.$$$reportNull$$$0(2);
            }
            this.os = os;
            this.arch = arch;
            this.versions = Collections.unmodifiableSet(versions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "os";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "arch";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "versions";
                    break;
                }
            }
            objectArray[1] = "com/goide/sdk/download/GoDownloadSdkActionFactory$Cache";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

