/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.configuration.ColoredListCellRendererWithProgressIcon;
import com.goide.configuration.GoUIUtil;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoBasedSdkChooserCombo;
import com.goide.sdk.download.GoSdkDownloaderDialog;
import com.goide.util.GoUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDownloadSdkAction<Sdk extends GoBasedSdk>
extends DumbAwareAction {
    private static final String DOWNLOAD_SDK_LAST_TARGET_PATH_KEY = "go.download.sdk.last.target.path";
    @NotNull
    private final Supplier<String> myProjectPathSupplier;
    @NotNull
    private final GoBasedSdkChooserCombo<Sdk> myCombo;
    @NotNull
    private final GoSdkDownloaderDialog<? extends Sdk> myDownloader;
    @NotNull
    private final Comparator<String> myVersionComparator;

    public GoDownloadSdkAction(@NotNull Supplier<String> projectPathSupplier, @NotNull GoBasedSdkChooserCombo<Sdk> combo, @NotNull GoSdkDownloaderDialog<? extends Sdk> downloaderDialog, @NotNull Comparator<String> versionsComparator) {
        if (projectPathSupplier == null) {
            GoDownloadSdkAction.$$$reportNull$$$0(0);
        }
        if (combo == null) {
            GoDownloadSdkAction.$$$reportNull$$$0(1);
        }
        if (downloaderDialog == null) {
            GoDownloadSdkAction.$$$reportNull$$$0(2);
        }
        if (versionsComparator == null) {
            GoDownloadSdkAction.$$$reportNull$$$0(3);
        }
        super(() -> GoBundle.message((String)"go.settings.sdk.download.action.name", (Object[])new Object[0]));
        this.myProjectPathSupplier = projectPathSupplier;
        this.myCombo = combo;
        this.myDownloader = downloaderDialog;
        this.myVersionComparator = versionsComparator;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GoDownloadSdkDialog dialog;
        if (e == null) {
            GoDownloadSdkAction.$$$reportNull$$$0(4);
        }
        if ((dialog = new GoDownloadSdkDialog(e.getProject())).showAndGet()) {
            String targetPath = dialog.myTargetDirectoryTextField.getText();
            PropertiesComponent.getInstance().setValue(DOWNLOAD_SDK_LAST_TARGET_PATH_KEY, targetPath);
            Sdk downloadingSdk = this.myDownloader.createDownloadingSdk(String.valueOf(dialog.myVersionsCombo.getSelectedItem()), targetPath);
            this.myCombo.addSdk(downloadingSdk, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPathSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaderDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsComparator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/goide/sdk/download/GoDownloadSdkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class GoDownloadSdkDialog
    extends DialogWrapper {
        private final ProgressIndicator myProgressIndicator;
        private final AsyncProcessIcon myAsyncProcessIcon;
        private final ComboBox<String> myVersionsCombo;
        private volatile boolean myFailedToLoadVersions;
        private final TextFieldWithBrowseButton myTargetDirectoryTextField;

        private GoDownloadSdkDialog(Project project) {
            super(project, GoDownloadSdkAction.this.myCombo, false, DialogWrapper.IdeModalityType.IDE);
            this.myFailedToLoadVersions = false;
            this.setTitle(GoDownloadSdkAction.this.myDownloader.getTitle());
            this.myVersionsCombo = new ComboBox();
            this.myAsyncProcessIcon = GoUIUtil.createProcessIcon(GoDownloadSdkAction.this.myDownloader.getProgressIconName(), this.getDisposable(), () -> this.myVersionsCombo.repaint());
            this.myProgressIndicator = new EmptyProgressIndicator();
            Disposer.register((Disposable)this.getDisposable(), () -> this.myProgressIndicator.cancel());
            this.myTargetDirectoryTextField = new TextFieldWithBrowseButton(null, this.getDisposable());
            this.myTargetDirectoryTextField.setText(this.getDefaultTargetPath());
            GoRunUtil.installDirectoryChooser(null, this.myTargetDirectoryTextField);
            this.init();
        }

        private String getDefaultTargetPath() {
            WSLDistribution lastTargetWsl;
            WSLDistribution projectWsl = GoWslUtil.getWsl(GoDownloadSdkAction.this.myProjectPathSupplier.get());
            String lastTarget = PropertiesComponent.getInstance().getValue(GoDownloadSdkAction.DOWNLOAD_SDK_LAST_TARGET_PATH_KEY);
            if (lastTarget != null && Objects.equals(projectWsl, lastTargetWsl = GoWslUtil.getWsl(lastTarget))) {
                return lastTarget;
            }
            String wslHome = GoWslUtil.computeWslUserHomeWithProgress(projectWsl);
            if (wslHome != null) {
                return projectWsl.getWindowsPath(wslHome + "/sdk");
            }
            Collection<VirtualFile> roots = GoSdkUtil.getGoPathRoots(null, null);
            VirtualFile firstItem = (VirtualFile)ContainerUtil.getFirstItem(roots);
            if (firstItem != null) {
                return firstItem.getPresentableUrl();
            }
            return FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), "sdk"});
        }

        protected JComponent createCenterPanel() {
            ComboboxSpeedSearch.installOn(this.myVersionsCombo);
            this.myVersionsCombo.setRenderer((ListCellRenderer)((Object)new VersionsRenderer(this.myAsyncProcessIcon)));
            SortedComboBoxModel versionsModel = new SortedComboBoxModel(GoDownloadSdkAction.this.myVersionComparator);
            this.myVersionsCombo.setModel((ComboBoxModel)versionsModel);
            new ComponentValidator(this.getDisposable()).withHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "#reload.versions".equals(e.getDescription())) {
                    this.discoverSdkVersions((SortedComboBoxModel<String>)versionsModel);
                }
            }).installOn(this.myVersionsCombo);
            this.discoverSdkVersions((SortedComboBoxModel<String>)versionsModel);
            JPanel panel2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel(this.myVersionsCombo).withLabel(GoBundle.message((String)"go.settings.sdk.download.dialog.version.label", (Object[])new Object[0]))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myTargetDirectoryTextField).withLabel(GoBundle.message((String)"go.settings.sdk.download.dialog.location.label", (Object[])new Object[0]))).createPanel();
            panel2.setPreferredSize((Dimension)JBUI.size((int)450, (int)-1));
            return panel2;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myVersionsCombo;
        }

        @NotNull
        protected String getHelpId() {
            return "go.download.sdk";
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            if (this.myFailedToLoadVersions) {
                String reloadLink = "<a href=\"#reload.versions\">" + GoBundle.message((String)"go.settings.sdk.download.dialog.reload.versions.action.name", (Object[])new Object[0]) + "</a>";
                ValidationInfo validationInfo = new ValidationInfo(GoBundle.message((String)"go.settings.sdk.download.dialog.cannot.load.go.versions.validation.message", (Object[])new Object[]{reloadLink}), this.myVersionsCombo);
                if (this.myVersionsCombo.getModel().getSize() > 0) {
                    validationInfo.asWarning();
                }
                List<ValidationInfo> list = Collections.singletonList(validationInfo);
                if (list == null) {
                    GoDownloadSdkDialog.$$$reportNull$$$0(0);
                }
                return list;
            }
            SmartList result = new SmartList();
            if (this.myVersionsCombo.getSelectedIndex() == -1) {
                result.add(new ValidationInfo(GoBundle.message((String)"go.settings.sdk.download.dialog.version.is.not.specified.validation.message", (Object[])new Object[0]), this.myVersionsCombo));
            } else {
                String selectedVersion = String.valueOf(this.myVersionsCombo.getSelectedItem());
                Object downloadingSdk = GoDownloadSdkAction.this.myDownloader.createDownloadingSdk(selectedVersion, "");
                ValidationResult validationResult = GoDownloadSdkAction.this.myCombo.getValidator().validate(downloadingSdk);
                if (!validationResult.isOk()) {
                    result.add(new ValidationInfo(validationResult.getErrorMessage()));
                }
            }
            String text = this.myTargetDirectoryTextField.getText();
            if (StringUtil.isEmpty((String)text)) {
                result.add(new ValidationInfo(GoBundle.message((String)"go.settings.sdk.download.dialog.location.is.not.specified.validation.message", (Object[])new Object[0]), (JComponent)this.myTargetDirectoryTextField.getTextField()));
            } else {
                File file = new File(text);
                while (file != null && !file.exists()) {
                    file = FileUtil.getParentFile((File)file);
                }
                if (file == null || !file.isDirectory() || !file.canWrite()) {
                    result.add(new ValidationInfo(GoBundle.message((String)"go.settings.sdk.download.dialog.cannot.create.directory.validation.message", (Object[])new Object[0]), (JComponent)this.myTargetDirectoryTextField.getTextField()));
                }
            }
            SmartList smartList = result;
            if (smartList == null) {
                GoDownloadSdkDialog.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private void discoverSdkVersions(@NotNull SortedComboBoxModel<String> versions) {
            if (versions == null) {
                GoDownloadSdkDialog.$$$reportNull$$$0(2);
            }
            this.myFailedToLoadVersions = false;
            this.myAsyncProcessIcon.resume();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String arch;
                WSLDistribution wsl = GoWslUtil.getWsl(GoDownloadSdkAction.this.myProjectPathSupplier.get());
                String os = wsl != null ? "linux" : GoUtil.systemOS();
                boolean successfullyDiscovered = GoDownloadSdkAction.this.myDownloader.discoverVersions(os, arch = GoUtil.systemArch(), this.myProgressIndicator, discoveredVersions -> {
                    versions.addAll(discoveredVersions);
                    ApplicationManager.getApplication().invokeLater(() -> this.myVersionsCombo.repaint(), ModalityState.any());
                });
                if (successfullyDiscovered) {
                    if (this.myVersionsCombo.getSelectedIndex() == -1 && this.myVersionsCombo.getItemCount() > 0) {
                        this.myVersionsCombo.setSelectedIndex(0);
                    }
                    Disposer.dispose((Disposable)this.myAsyncProcessIcon);
                } else {
                    this.myFailedToLoadVersions = true;
                    this.startTrackingValidation();
                }
                this.myAsyncProcessIcon.suspend();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/sdk/download/GoDownloadSdkAction$GoDownloadSdkDialog";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidateAll";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/sdk/download/GoDownloadSdkAction$GoDownloadSdkDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "discoverSdkVersions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class VersionsRenderer
    extends ColoredListCellRendererWithProgressIcon<String> {
        VersionsRenderer(@NotNull AsyncProcessIcon icon) {
            if (icon == null) {
                VersionsRenderer.$$$reportNull$$$0(0);
            }
            super(icon);
        }

        @Override
        protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NlsSafe String value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                VersionsRenderer.$$$reportNull$$$0(1);
            }
            this.append(StringUtil.notNullize((String)value), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/goide/sdk/download/GoDownloadSdkAction$VersionsRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

