/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.formatter.GoFormattingRules;
import com.goide.i18n.GoBundle;
import com.goide.inspections.buildTag.GoBuildDirectiveOptions;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdkImpl;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GoSdk
extends GoBasedSdk {
    public static final GoSdkVersion DIGIT_SEPARATOR_VERSION = GoSdkVersion.GO_1_13;
    public static final GoSdkVersion BINARY_DIGITS_VERSION = GoSdkVersion.GO_1_13;
    public static final GoSdkVersion OCTAL_PREFIX_VERSION = GoSdkVersion.GO_1_13;
    public static final GoSdkVersion HEX_FLOATS_VERSION = GoSdkVersion.GO_1_13;
    public static final GoSdkVersion ERROR_WRAPPERS_VERSION = GoSdkVersion.GO_1_13;
    public static final GoSdkVersion DARWIN_ARM64_VERSION = GoSdkVersion.GO_1_16;
    public static final GoSdkVersion RETRACT_DIRECTIVE_VERSION = GoSdkVersion.GO_1_16;
    public static final GoSdkVersion MULTI_ERRORS_VERSION = GoSdkVersion.GO_1_20;
    public static final GoSdkVersion TOOLCHAINS_VERSION = GoSdkVersion.GO_1_21;
    public static final GoSdk NULL = new GoSdk(){

        @Override
        @Nullable
        public String getVersion() {
            return null;
        }

        @Override
        @NotNull
        public GoSdkVersion getMajorVersion() {
            GoSdkVersion goSdkVersion = GoSdkVersion.UNKNOWN;
            if (goSdkVersion == null) {
                1.$$$reportNull$$$0(0);
            }
            return goSdkVersion;
        }

        @Override
        @Nullable
        public String getVersionFilePath() {
            return null;
        }

        @Override
        @NotNull
        public String getHomeUrl() {
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getSdkRoot() {
            return null;
        }

        @Override
        @Nullable
        public VirtualFile getSrcDir() {
            return null;
        }

        @Override
        @Nullable
        public VirtualFile getExecutable() {
            return null;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRootsToAttach() {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/goide/sdk/GoSdk$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMajorVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToAttach";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    @NotNull
    public static GoSdk fromHomePath(@Nullable String homePath) {
        return GoSdk.fromHomePath(homePath, false);
    }

    @NotNull
    public static GoSdk fromHomePath(@Nullable String homePath, boolean refresh) {
        if (homePath == null) {
            GoSdk goSdk = NULL;
            if (goSdk == null) {
                GoSdk.$$$reportNull$$$0(0);
            }
            return goSdk;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile homeDir = refresh ? localFileSystem.refreshAndFindFileByPath(homePath) : localFileSystem.findFileByPath(homePath);
        return GoSdk.fromDirectory(homeDir, refresh);
    }

    @NotNull
    public static GoSdk fromUrl(@Nullable String homeUrl) {
        return GoSdk.fromUrl(homeUrl, false);
    }

    @NotNull
    public static GoSdk fromUrl(@Nullable String homeUrl, boolean refresh) {
        if (homeUrl == null) {
            GoSdk goSdk = NULL;
            if (goSdk == null) {
                GoSdk.$$$reportNull$$$0(1);
            }
            return goSdk;
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile homeDir = refresh ? virtualFileManager.refreshAndFindFileByUrl(homeUrl) : virtualFileManager.findFileByUrl(homeUrl);
        return GoSdk.fromDirectory(homeDir, refresh);
    }

    @NotNull
    private static GoSdk fromDirectory(@Nullable VirtualFile homeDir, boolean refresh) {
        if (homeDir == null) {
            GoSdk goSdk = NULL;
            if (goSdk == null) {
                GoSdk.$$$reportNull$$$0(2);
            }
            return goSdk;
        }
        VirtualFile sdkRoot = GoSdkUtil.adjustSdkDir(homeDir);
        VirtualFile versionFile = GoSdkUtil.findVersionFile(sdkRoot, refresh);
        if (versionFile == null) {
            GoSdk goSdk = NULL;
            if (goSdk == null) {
                GoSdk.$$$reportNull$$$0(3);
            }
            return goSdk;
        }
        String version2 = GoSdkUtil.retrieveGoVersion(versionFile);
        return new GoSdkImpl(sdkRoot.getUrl(), version2, versionFile.getPath());
    }

    @NotNull
    public GoSdkVersion getMajorVersion();

    @Nullable
    public String getVersionFilePath();

    @Deprecated
    @NotNull
    @NlsSafe
    default public String getHomePath() {
        String string = VfsUtilCore.urlToPath((String)this.getHomeUrl());
        if (string == null) {
            GoSdk.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public VirtualFile getSdkRoot();

    @NotNull
    public Collection<VirtualFile> getRootsToAttach();

    default public GoFormattingRules getFormattingRules() {
        return new GoFormattingRules(this.getMajorVersion());
    }

    @Override
    @Nls
    default public String getName() {
        @NlsSafe String version2 = this.getVersion();
        return "Go " + StringUtil.notNullize((String)version2, (String)GoBundle.message((String)"go.sdk.no.version.text", (Object[])new Object[0]));
    }

    default public boolean supportsAppEngine() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_11);
    }

    default public boolean supportsVendoringByDefault() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_6);
    }

    default public boolean supportsInternalPackages() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_5);
    }

    default public boolean supportsSdkInternalPackages() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_4);
    }

    default public boolean supportsCanonicalPaths() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_4);
    }

    default public boolean supportsDefaultGoPath() {
        return Registry.is((String)"go.default.go.path.supported") && this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_8);
    }

    default public boolean supportsComparingTagsInStructures() {
        return this.getMajorVersion().isLessThan(GoSdkVersion.GO_1_8);
    }

    default public boolean supportsSubTests() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_7);
    }

    default public boolean supportsMultiPackageCoverage() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_10);
    }

    default public boolean supportsJsonTestsOutput() {
        return Registry.is((String)"go.testing.json.mode") && this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_10);
    }

    default public boolean requiredTransitivePackagesRebuildOnDebug() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_9);
    }

    default public boolean supportsCompilerCache() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_10);
    }

    default public boolean supportsPatternBasedCachingStrategy() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_10);
    }

    default public boolean requiresLdFlagsOnDebug() {
        return this.getMajorVersion().isLessThan(GoSdkVersion.GO_1_9);
    }

    default public boolean supportsTypeAliases() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_9);
    }

    default public boolean supportsAtSignInImportPath() {
        return this.getMajorVersion().isLessThan(GoSdkVersion.GO_1_11);
    }

    default public boolean supportsModules() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_11);
    }

    default public boolean supportsToolVet() {
        return this.getMajorVersion().isLessThan(GoSdkVersion.GO_1_12);
    }

    default public boolean supportsAnyTypeForMethodExprReceiver() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_10);
    }

    default public boolean supportsDigitSeparator() {
        return this.getMajorVersion().supportsDigitSeparator();
    }

    default public boolean supportsBinaryDigits() {
        return this.getMajorVersion().supportsBinaryDigits();
    }

    default public boolean supportsOctalPrefix() {
        return this.getMajorVersion().supportsOctalPrefix();
    }

    default public boolean supportsHexFloats() {
        return this.getMajorVersion().supportsHexFloats();
    }

    default public boolean supportsSignedShift() {
        return this.getMajorVersion().supportsSignedShift();
    }

    default public boolean supportsOverlappingEmbeddedInterfaces() {
        return this.getMajorVersion().supportsOverlappingEmbeddedInterfaces();
    }

    default public boolean supportsModulesWithVendorByDefault() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_14);
    }

    default public boolean supportsTempGoModFile() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_14);
    }

    default public boolean supportsGoModCacheEnvironmentVariable() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_15);
    }

    default public boolean supportsDarwinArm64() {
        return this.getMajorVersion().isAtLeast(DARWIN_ARM64_VERSION);
    }

    default public boolean supportsPanicOnExit0() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_16);
    }

    default public boolean supportsRetractDirective() {
        return this.getMajorVersion().isAtLeast(RETRACT_DIRECTIVE_VERSION);
    }

    default public boolean hasModuleAwareModeByDefault() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_16);
    }

    default public boolean supportsGoEmbedDirective() {
        return this.getMajorVersion().supportsGoEmbedDirective();
    }

    default public boolean supportsSliceToArrayPointerConversion() {
        return this.getMajorVersion().supportsSliceToArrayPointerConversion();
    }

    default public boolean supportsFuzzing() {
        return this.getMajorVersion().supportsFuzzing();
    }

    default public boolean prefersInstallOverGet() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_17);
    }

    default public boolean supportsGenerics() {
        return this.getMajorVersion().supportsGenerics();
    }

    default public boolean doesModTidyDuringModVendor() {
        return this.getMajorVersion().isLessThan(GoSdkVersion.GO_1_18);
    }

    default public boolean supportsWorkspaceMode() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_18);
    }

    default public boolean supportsUnixBuildConstraint() {
        return this.getMajorVersion().supportsUnixBuildConstraint();
    }

    default public boolean supportsSliceToArrayConversion() {
        return this.getMajorVersion().supportsSliceToArrayConversion();
    }

    default public boolean supportsToolchains() {
        return this.getMajorVersion().isAtLeast(TOOLCHAINS_VERSION);
    }

    default public boolean supportsModDownloadVerboseOutput() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_14);
    }

    default public boolean supportsApplicationCoverage() {
        return this.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_20);
    }

    @NotNull
    default public GoBuildDirectiveOptions getGoBuildDirectiveOptions() {
        GoBuildDirectiveOptions goBuildDirectiveOptions = GoBuildDirectiveOptions.getGoBuildDirectiveOptions(this.getMajorVersion());
        if (goBuildDirectiveOptions == null) {
            GoSdk.$$$reportNull$$$0(5);
        }
        return goBuildDirectiveOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/goide/sdk/GoSdk";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromHomePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUrl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoBuildDirectiveOptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

