/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.GoEnvironmentUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class GoEnvironmentGoPathModificationTracker
implements Disposable {
    private final Set<String> pathsToTrack = new LinkedHashSet<String>();
    private final Collection<VirtualFile> goPathRoots = new LinkedHashSet<VirtualFile>();

    public GoEnvironmentGoPathModificationTracker() {
        String goPath = GoEnvironmentUtil.retrieveGoPathFromEnvironment();
        if (goPath != null) {
            String home = SystemProperties.getUserHome();
            for (String s : StringUtil.split((String)goPath, (String)File.pathSeparator)) {
                if (s.contains("$HOME")) {
                    s = s.replaceAll("\\$HOME", home);
                }
                this.pathsToTrack.add(s);
            }
        }
        this.recalculateFiles();
    }

    public static Collection<VirtualFile> getGoEnvironmentGoPathRoots() {
        return GoEnvironmentGoPathModificationTracker.getInstance().getGoPathRoots();
    }

    private void recalculateFiles() {
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        for (String path : this.pathsToTrack) {
            ContainerUtil.addIfNotNull(result, (Object)LocalFileSystem.getInstance().findFileByPath(path));
        }
        this.updateGoPathRoots(result);
    }

    private synchronized void updateGoPathRoots(Collection<VirtualFile> newRoots) {
        this.goPathRoots.clear();
        this.goPathRoots.addAll(newRoots);
    }

    private synchronized Collection<VirtualFile> getGoPathRoots() {
        return this.goPathRoots;
    }

    public void dispose() {
        this.goPathRoots.clear();
        this.pathsToTrack.clear();
    }

    private static GoEnvironmentGoPathModificationTracker getInstance() {
        return (GoEnvironmentGoPathModificationTracker)ApplicationManager.getApplication().getService(GoEnvironmentGoPathModificationTracker.class);
    }

    static class MyFileListener
    implements BulkFileListener {
        MyFileListener() {
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyFileListener.$$$reportNull$$$0(0);
            }
            GoEnvironmentGoPathModificationTracker tracker = GoEnvironmentGoPathModificationTracker.getInstance();
            for (VFileEvent vFileEvent : events) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null || !tracker.pathsToTrack.contains(file.getPath())) continue;
                NonUrgentExecutor.getInstance().execute(() -> tracker.recalculateFiles());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/goide/sdk/GoEnvironmentGoPathModificationTracker$MyFileListener", "after"));
        }
    }
}

