/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.util;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.GoFormatterUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GoCommentsHolder<T extends PsiElement> {
    private final List<PsiComment> myUpperComments;
    private final T myElement;
    private final List<PsiComment> myAfterComments;

    private GoCommentsHolder(@NotNull List<PsiComment> upperComments, @NotNull T element, @NotNull List<PsiComment> afterComments2) {
        if (upperComments == null) {
            GoCommentsHolder.$$$reportNull$$$0(0);
        }
        if (element == null) {
            GoCommentsHolder.$$$reportNull$$$0(1);
        }
        if (afterComments2 == null) {
            GoCommentsHolder.$$$reportNull$$$0(2);
        }
        this.myUpperComments = upperComments;
        this.myElement = element;
        this.myAfterComments = afterComments2;
    }

    @NotNull
    public static <T extends PsiElement> GoCommentsHolder<T> create(@NotNull T element) {
        if (element == null) {
            GoCommentsHolder.$$$reportNull$$$0(3);
        }
        return GoCommentsHolder.create(element, element);
    }

    @NotNull
    public static <T extends PsiElement> GoCommentsHolder<T> create(@NotNull T element, @NotNull PsiElement commentsHolder) {
        if (element == null) {
            GoCommentsHolder.$$$reportNull$$$0(4);
        }
        if (commentsHolder == null) {
            GoCommentsHolder.$$$reportNull$$$0(5);
        }
        return new GoCommentsHolder<T>(GoDocumentationProvider.getUpperComments(commentsHolder), element, GoDocumentationProvider.getAfterComments(commentsHolder));
    }

    @NotNull
    public static <T extends PsiElement> GoCommentsHolder<T> withUpperComments(@NotNull List<PsiComment> upperComments, @NotNull T element) {
        if (upperComments == null) {
            GoCommentsHolder.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoCommentsHolder.$$$reportNull$$$0(7);
        }
        return new GoCommentsHolder<T>(upperComments, element, Collections.emptyList());
    }

    @NotNull
    public static <T extends PsiElement> GoCommentsHolder<T> withComments(@NotNull List<PsiComment> upperComments, @NotNull T element, @NotNull List<PsiComment> afterComments2) {
        if (upperComments == null) {
            GoCommentsHolder.$$$reportNull$$$0(8);
        }
        if (element == null) {
            GoCommentsHolder.$$$reportNull$$$0(9);
        }
        if (afterComments2 == null) {
            GoCommentsHolder.$$$reportNull$$$0(10);
        }
        return new GoCommentsHolder<T>(upperComments, element, afterComments2);
    }

    @NotNull
    public static <T extends PsiElement> GoCommentsHolder<T> elementOnly(@NotNull T element) {
        if (element == null) {
            GoCommentsHolder.$$$reportNull$$$0(11);
        }
        return new GoCommentsHolder<T>(Collections.emptyList(), element, Collections.emptyList());
    }

    @NotNull
    public List<PsiComment> getUpperComments() {
        List<PsiComment> list = this.myUpperComments;
        if (list == null) {
            GoCommentsHolder.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public T getElement() {
        T t = this.myElement;
        if (t == null) {
            GoCommentsHolder.$$$reportNull$$$0(13);
        }
        return t;
    }

    @NotNull
    public List<PsiComment> getAfterComments() {
        List<PsiComment> list = this.myAfterComments;
        if (list == null) {
            GoCommentsHolder.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> addBefore(@NotNull PsiElement anchor) {
        if (anchor == null) {
            GoCommentsHolder.$$$reportNull$$$0(15);
        }
        PsiElement parent = anchor.getParent();
        SmartList newElements = new SmartList();
        this.myUpperComments.forEach(arg_0 -> GoCommentsHolder.lambda$addBefore$0((List)newElements, parent, anchor, arg_0));
        PsiElement added = parent.addBefore(this.myElement, anchor);
        newElements.add(added);
        ContainerUtil.reverse(this.myAfterComments).forEach(arg_0 -> GoCommentsHolder.lambda$addBefore$1((List)newElements, parent, added, arg_0));
        SmartList smartList = newElements;
        if (smartList == null) {
            GoCommentsHolder.$$$reportNull$$$0(16);
        }
        return smartList;
    }

    @NotNull
    public List<PsiElement> replace(@NotNull GoCommentsHolder<? extends PsiElement> other) {
        PsiElement parent;
        if (other == null) {
            GoCommentsHolder.$$$reportNull$$$0(17);
        }
        if ((parent = this.myElement.getParent()) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoCommentsHolder.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<PsiElement> added = other.addBefore(this.startElement());
        this.deleteAsChildRange();
        GoFormatterUtil.reformat(parent.getContainingFile(), added);
        List<PsiElement> list = added;
        if (list == null) {
            GoCommentsHolder.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public PsiElement startElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getFirstItem(this.myUpperComments)), this.myElement);
        if (psiElement == null) {
            GoCommentsHolder.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement endElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getLastItem(this.myAfterComments)), this.myElement);
        if (psiElement == null) {
            GoCommentsHolder.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    public void deleteAsChildRange() {
        PsiElement parent;
        if (this.myUpperComments.isEmpty() && this.myAfterComments.isEmpty()) {
            this.myElement.delete();
        }
        if ((parent = this.myElement.getParent()) == null) {
            throw new UnsupportedOperationException("Cannot delete elements without parent");
        }
        PsiElement first = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getFirstItem(this.myUpperComments)), this.myElement);
        PsiElement last = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getLastItem(this.myAfterComments)), this.myElement);
        parent.deleteChildRange(first, last);
    }

    public static <T extends PsiElement> void deleteAsChildRange(@NotNull GoCommentsHolder<T> first, @NotNull GoCommentsHolder<T> last) {
        if (first == null) {
            GoCommentsHolder.$$$reportNull$$$0(22);
        }
        if (last == null) {
            GoCommentsHolder.$$$reportNull$$$0(23);
        }
        PsiElement start = first.startElement();
        PsiElement end = last.endElement();
        start.getParent().deleteChildRange(start, end);
    }

    private static /* synthetic */ void lambda$addBefore$1(List newElements, PsiElement parent, PsiElement added, PsiComment c) {
        newElements.add(parent.addAfter((PsiElement)c, added));
    }

    private static /* synthetic */ void lambda$addBefore$0(List newElements, PsiElement parent, PsiElement anchor, PsiComment c) {
        newElements.add(parent.addBefore((PsiElement)c, anchor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 16, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperComments";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterComments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsHolder";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/util/GoCommentsHolder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/util/GoCommentsHolder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperComments";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterComments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addBefore";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "startElement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withUpperComments";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withComments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "elementOnly";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteAsChildRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 16, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

