/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.rename.GoRenamePsiElementProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRenameTypeParameterProcessor
extends GoRenamePsiElementProcessor {
    static final Key<Boolean> TEST_RENAME_ALL = Key.create((String)"GoRenameTypeParameterProcessor.TEST_RENAME_ALL");
    private boolean myRenameCurrentTypeParameterOnly;

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(2);
        }
        if (this.myRenameCurrentTypeParameterOnly) {
            return;
        }
        GoTypeSpec typeSpec = GoRenameTypeParameterProcessor.getTypeSpec(element);
        if (typeSpec == null) {
            return;
        }
        GoCompositeElement typeArgsOrParams = (GoCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoTypeArguments.class, GoTypeParameters.class});
        List<GoTypeParamDefinition> typeParamDefinitions = GoRenameTypeParameterProcessor.findTypeParamDefinitions(typeArgsOrParams);
        if (typeParamDefinitions == null) {
            return;
        }
        int typeParamIndex = ContainerUtil.indexOfIdentity(typeParamDefinitions, (Object)element);
        if (typeParamIndex < 0) {
            return;
        }
        Project project = (Project)ReadAction.compute(() -> ((PsiElement)element).getProject());
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> GoRenameTypeParameterProcessor.findTypeParameterDefinitionsInReceivers(newName, allRenames, typeSpec, typeParamIndex)), GoBundle.message((String)"go.refactoring.rename.looking.for.method.usages.progress.title", (Object[])new Object[0]), true, project);
    }

    @Nullable
    @Contract(value="null -> null")
    private static List<GoTypeParamDefinition> findTypeParamDefinitions(@Nullable GoCompositeElement typeArgsOrParams) {
        if (typeArgsOrParams instanceof GoTypeArguments) {
            GoTypeArguments typeArguments = (GoTypeArguments)typeArgsOrParams;
            return ContainerUtil.map(typeArguments.getTypes(), type2 -> (GoTypeParamDefinition)PsiTreeUtil.getStubChildOfType((PsiElement)type2, GoTypeParamDefinition.class));
        }
        if (typeArgsOrParams instanceof GoTypeParameters) {
            GoTypeParameters typeParameters = (GoTypeParameters)typeArgsOrParams;
            return GoRenameTypeParameterProcessor.getAllTypeParamDefinitions(typeParameters);
        }
        return null;
    }

    @NotNull
    private static List<GoTypeParamDefinition> getAllTypeParamDefinitions(GoTypeParameters typeParameters) {
        List list = StreamEx.of(typeParameters.getTypeParameterDeclarationList()).flatCollection(typeParamDecl -> typeParamDecl.getTypeParamDefinitionList()).toList();
        if (list == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void findTypeParameterDefinitionsInReceivers(@NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull GoTypeSpec typeSpec, int typeParamIndex) {
        if (newName == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(4);
        }
        if (allRenames == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(5);
        }
        if (typeSpec == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(6);
        }
        List<GoMethodDeclaration> methods = typeSpec.getMethods();
        for (GoMethodDeclaration decl : methods) {
            GoTypeParamDefinition typeParamDef;
            GoType typeToRename;
            List<GoType> types;
            GoTypeArguments arguments;
            GoType type2;
            GoReceiver methodReceiver = decl.getReceiver();
            if (methodReceiver == null || (type2 = GoTypeUtil.unwrapPointerAndParTypes(methodReceiver.getType())) == null || (arguments = type2.getTypeArguments()) == null || (types = arguments.getTypes()).size() <= typeParamIndex || (typeToRename = types.get(typeParamIndex)) == null || (typeParamDef = (GoTypeParamDefinition)PsiTreeUtil.getStubChildOfType((PsiElement)typeToRename, GoTypeParamDefinition.class)) == null) continue;
            allRenames.put(typeParamDef, newName);
        }
        GoTypeParameters typeParameters = typeSpec.getSpecType().getTypeParameters();
        if (typeParameters == null) {
            return;
        }
        List<GoTypeParamDefinition> typeParamDefinitionsOnTypeSpec = GoRenameTypeParameterProcessor.getAllTypeParamDefinitions(typeParameters);
        if (typeParamDefinitionsOnTypeSpec.size() <= typeParamIndex) {
            return;
        }
        GoTypeParamDefinition definition = typeParamDefinitionsOnTypeSpec.get(typeParamIndex);
        allRenames.put(definition, newName);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        GoTypeSpec typeSpec;
        if (element == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(8);
        }
        if (renameCallback == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(9);
        }
        if ((typeSpec = GoRenameTypeParameterProcessor.getTypeSpec(element)) == null || typeSpec.getMethods().isEmpty()) {
            this.myRenameCurrentTypeParameterOnly = true;
            renameCallback.accept((Object)element);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myRenameCurrentTypeParameterOnly = !TestModeFlags.is(TEST_RENAME_ALL);
            renameCallback.accept((Object)element);
            return;
        }
        if (StartMarkAction.canStart((Editor)editor) != null) {
            renameCallback.accept((Object)element);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(GoRenameTypeParameterProcessor.getRenameAllTypeParametersMessage(), GoRenameTypeParameterProcessor.getRenameCurrentTypeParameterOnlyMessage())).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value -> {
            this.myRenameCurrentTypeParameterOnly = GoRenameTypeParameterProcessor.getRenameCurrentTypeParameterOnlyMessage().equals(value);
            renameCallback.accept((Object)element);
        }).createPopup().showInBestPositionFor(editor);
    }

    @Nullable
    private static GoTypeSpec getTypeSpec(@NotNull PsiElement element) {
        GoTypeSpec typeSpec;
        if (element == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(10);
        }
        return (typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class)) != null ? typeSpec : GoPsiImplUtil.getTypeSpecFromReceiver((GoTypeOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoReceiver.class));
    }

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(11);
        }
        return element instanceof GoTypeParamDefinition;
    }

    @NotNull
    public static String getRenameCurrentTypeParameterOnlyMessage() {
        String string = GoBundle.message((String)"go.refactoring.rename.type.parameter.option.current.only", (Object[])new Object[0]);
        if (string == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getRenameAllTypeParametersMessage() {
        String string = GoBundle.message((String)"go.refactoring.rename.type.parameter.option.all", (Object[])new Object[0]);
        if (string == null) {
            GoRenameTypeParameterProcessor.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/rename/GoRenameTypeParameterProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/rename/GoRenameTypeParameterProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypeParamDefinitions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameCurrentTypeParameterOnlyMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameAllTypeParametersMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTypeParameterDefinitionsInReceivers";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSpec";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 13 -> new IllegalStateException(string);
        };
    }
}

