/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.comments.GoCommentReference;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.usages.GoUsageView;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GoNamedElement;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts2) {
        GoNamedElement namedElement;
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        if (conflicts2 == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(3);
        }
        if ((namedElement = (GoNamedElement)ObjectUtils.tryCast((Object)element, GoNamedElement.class)) == null) {
            return;
        }
        GoRefactoringUtil.findDuplicateConflicts(namedElement, newName, conflicts2);
        GoRenamePsiElementProcessor.findVisibilityConflicts(namedElement, newName, conflicts2);
    }

    private static void findVisibilityConflicts(@NotNull GoNamedElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts2) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        if (conflicts2 == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        if (StringUtil.isCapitalized((String)newName) || !element.isPublic()) {
            return;
        }
        GlobalSearchScope scope = (GlobalSearchScope)ObjectUtils.tryCast((Object)element.getUseScope(), GlobalSearchScope.class);
        if (scope == null) {
            return;
        }
        GlobalSearchScope packageScope = GoPackageUtil.packageScope(element.getContainingFile());
        GlobalSearchScope scopeWithoutCurrentPackage = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)packageScope));
        GoReferencesSearch.search(element, (SearchScope)scopeWithoutCurrentPackage).forEach(reference -> {
            PsiElement usage = reference.getElement();
            conflicts2.putValue((Object)usage, (Object)GoRefactoringUtil.getUnexportedMessage(element, usage));
        });
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        if (element instanceof GoFunctionOrMethodDeclaration || element instanceof GoMethodSpec) {
            return GoCodeInsightSettings.getInstance().isRenameSearchInCommentsForFunction();
        }
        if (element instanceof GoTypeSpec || element instanceof GoTypeDeclaration) {
            return GoCodeInsightSettings.getInstance().isRenameSearchInCommentsForType();
        }
        if (element instanceof GoNamedElement) {
            return GoCodeInsightSettings.getInstance().isRenameSearchInCommentsForVariable();
        }
        return super.isToSearchInComments(element);
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        if (element instanceof GoFunctionOrMethodDeclaration || element instanceof GoMethodSpec) {
            GoCodeInsightSettings.getInstance().setRenameSearchInCommentsForFunction(enabled);
        } else if (element instanceof GoTypeSpec || element instanceof GoTypeDeclaration) {
            GoCodeInsightSettings.getInstance().setRenameSearchInCommentsForType(enabled);
        } else if (element instanceof GoNamedElement) {
            GoCodeInsightSettings.getInstance().setRenameSearchInCommentsForVariable(enabled);
        } else {
            super.setToSearchInComments(element, enabled);
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        if (element instanceof GoFunctionOrMethodDeclaration || element instanceof GoMethodSpec) {
            return GoCodeInsightSettings.getInstance().isRenameSearchNonCodeForFunction();
        }
        if (element instanceof GoTypeSpec || element instanceof GoTypeDeclaration) {
            return GoCodeInsightSettings.getInstance().isRenameSearchNonCodeForType();
        }
        if (element instanceof GoNamedElement) {
            return GoCodeInsightSettings.getInstance().isRenameSearchNonCodeForVariable();
        }
        return super.isToSearchForTextOccurrences(element);
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        if (element instanceof GoFunctionOrMethodDeclaration || element instanceof GoMethodSpec) {
            GoCodeInsightSettings.getInstance().setRenameSearchNonCodeForFunction(enabled);
        } else if (element instanceof GoTypeSpec || element instanceof GoTypeDeclaration) {
            GoCodeInsightSettings.getInstance().setRenameSearchNonCodeForType(enabled);
        } else if (element instanceof GoNamedElement) {
            GoCodeInsightSettings.getInstance().setRenameSearchNonCodeForVariable(enabled);
        } else {
            super.setToSearchForTextOccurrences(element, enabled);
        }
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        if (ref == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(12);
        }
        if (referenceElement == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(13);
        }
        if (ref instanceof GoCommentReference) {
            return new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, true);
        }
        UsageInfo usageInfo = super.createUsageInfo(element, ref, referenceElement);
        if (usageInfo == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(14);
        }
        return usageInfo;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(15);
        }
        if (element == null) {
            GoRenamePsiElementProcessor.$$$reportNull$$$0(16);
        }
        return new RenameDialog(project, element, nameSuggestionContext, editor){

            protected RenameProcessor createRenameProcessor(@NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
                        if (viewDescriptor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (usageView == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.customizeUsagesView(viewDescriptor, usageView);
                        GoUsageView.markAsRefactoring(usageView);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "viewDescriptor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "usageView";
                                break;
                            }
                        }
                        objectArray[1] = "com/goide/refactor/rename/GoRenamePsiElementProcessor$1$1";
                        objectArray[2] = "customizeUsagesView";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/goide/refactor/rename/GoRenamePsiElementProcessor$1", "createRenameProcessor"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/rename/GoRenamePsiElementProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/rename/GoRenamePsiElementProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVisibilityConflicts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

