/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRenameFileProcessor
extends RenamePsiFileProcessor {
    static final Key<Boolean> TESTING_RENAME_CORRESPONDING_FILE = Key.create((String)"GoRenameFileProcessor.TESTING_RENAME_CORRESPONDING_FILE");

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GoFile;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(4);
        }
        if (element instanceof GoFile) {
            String testFileName;
            VirtualFile testFile;
            GoFile fileToRename;
            VirtualFile file = ((GoFile)element).getVirtualFile();
            if (GoTestFinder.isTestFile((PsiFile)((GoFile)element))) {
                String productionFileName;
                VirtualFile productionFile;
                GoFile fileToRename2;
                if (newName.endsWith("_test.go") && (fileToRename2 = GoRenameFileProcessor.findGoFile(productionFile = file.findFileByRelativePath("../" + (productionFileName = StringUtil.trimEnd((String)file.getName(), (String)"_test.go") + ".go")), element.getManager())) != null && GoRenameFileProcessor.shouldAddFileToRename(fileToRename2, file, GoBundle.message((String)"go.refactoring.rename.production.file.title", (Object[])new Object[]{fileToRename2.getName()}))) {
                    allRenames.put((PsiElement)fileToRename2, StringUtil.trimEnd((String)newName, (String)"_test.go") + ".go");
                }
            } else if (!newName.endsWith("_test.go") && (fileToRename = GoRenameFileProcessor.findGoFile(testFile = file.findFileByRelativePath("../" + (testFileName = file.getNameWithoutExtension() + "_test.go")), element.getManager())) != null && GoRenameFileProcessor.shouldAddFileToRename(fileToRename, file, GoBundle.message((String)"go.refactoring.rename.test.file.title", (Object[])new Object[]{fileToRename.getName()}))) {
                allRenames.put((PsiElement)fileToRename, StringUtil.trimEnd((String)newName, (String)".go") + "_test.go");
            }
        }
    }

    @Nullable
    private static GoFile findGoFile(@Nullable VirtualFile file, @NotNull PsiManager psiManager) {
        if (psiManager == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(5);
        }
        return file != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)psiManager.findFile(file), GoFile.class)) : null;
    }

    private static boolean shouldAddFileToRename(@NotNull GoFile file, @NotNull VirtualFile related, @NotNull @NlsContexts.DialogMessage String message) {
        if (file == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(6);
        }
        if (related == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GoRenameFileProcessor.$$$reportNull$$$0(8);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (GoRenameFileProcessor.isChildInProjectView(virtualFile, related, project) || GoRenameFileProcessor.isChildInProjectView(related, virtualFile, project)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TestModeFlags.is(TESTING_RENAME_CORRESPONDING_FILE);
        }
        ThreeState renameCorrespondingFileOption = GoCodeInsightSettings.getInstance().getRenameCorrespondingTestOrProductionFile();
        if (renameCorrespondingFileOption != ThreeState.UNSURE) {
            return renameCorrespondingFileOption.toBoolean();
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)message).doNotAsk((DoNotAskOption)new RenameFileDoNotAskOption())).icon(Messages.getQuestionIcon())).ask(project);
    }

    private static boolean isChildInProjectView(VirtualFile parent, VirtualFile child, Project project) {
        return NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView((Project)project, (VirtualFile)parent).stream().map(info -> info.file()).anyMatch(child::equals);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "related";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/goide/refactor/rename/GoRenameFileProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findGoFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAddFileToRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RenameFileDoNotAskOption
    extends DoNotAskOption.Adapter {
        private RenameFileDoNotAskOption() {
        }

        public void rememberChoice(boolean isSelected, int exitCode) {
            if (isSelected) {
                GoCodeInsightSettings.getInstance().setRenameCorrespondingTestOrProductionFile(ThreeState.fromBoolean((exitCode == 0 ? 1 : 0) != 0));
            }
        }
    }
}

