/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.inline.function;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.highlighting.errors.GoExpressionStatementSpecChecker;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoTypeParametersAwareReference;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.inline.function.GoInlineFunctionProcessor;
import com.goide.refactor.inline.function.GoInlineFunctionProcessorKt;
import com.goide.refactor.introduce.GoIntroduceVariableOrConstBase;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.refactor.util.GoReferenceConverter;
import com.goide.util.GoZeroValue;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0002yzB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001d\u0010\u0015\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J&\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020\u0011H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020\u0011H\u0002J\u001d\u00103\u001a\u0002042\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020706H\u0014\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020\r2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020 0\u0014H\u0002J\u0017\u0010;\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b<2\u0006\u0010=\u001a\u00020\u0011H\u0002J$\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u0002072\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020B0AH\u0002J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020 0\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0013\u0010D\u001a\b\u0012\u0004\u0012\u00020706H\u0014\u00a2\u0006\u0002\u0010EJ%\u0010F\u001a\u00020B2\u000b\u0010G\u001a\u00070B\u00a2\u0006\u0002\bH2\u0006\u0010!\u001a\u00020\"2\u0006\u0010I\u001a\u00020\tH\u0002J\u001e\u0010J\u001a\b\u0012\u0004\u0012\u0002010\u00142\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020$H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010$2\u0006\u0010L\u001a\u000207H\u0002J\u0012\u0010M\u001a\f0B\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\bNH\u0014J\u0017\u0010O\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b<2\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010Q\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020$H\u0002J\u0017\u0010R\u001a\t\u0018\u00010S\u00a2\u0006\u0002\b<2\u0006\u0010\u000e\u001a\u00020$H\u0002J\u0015\u0010T\u001a\u00070,\u00a2\u0006\u0002\b\u00162\u0006\u0010U\u001a\u00020VH\u0002J\u0015\u0010W\u001a\u00070B\u00a2\u0006\u0002\b<2\u0006\u0010X\u001a\u00020VH\u0002J\u0010\u0010Y\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0010\u0010Z\u001a\u00020\r2\u0006\u0010L\u001a\u000207H\u0002J\u0018\u0010[\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\\\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020V2\u0006\u0010]\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010^\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u00100\u001a\u0002012\u0006\u0010!\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J(\u0010_\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010`\u001a\u00020,2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010a\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020B2\u0006\u0010b\u001a\u00020,2\u0006\u0010c\u001a\u00020B2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010d\u001a\u00020\t2\u0006\u0010b\u001a\u00020,H\u0002J\u0010\u0010e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020$2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020 0\u0014H\u0002J\u001d\u0010g\u001a\u00020\r2\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020706H\u0014\u00a2\u0006\u0002\u0010hJ\u001c\u0010i\u001a\u00020\t2\u0012\u0010j\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000207060kH\u0014J\u0010\u0010l\u001a\u00020\r2\u0006\u0010m\u001a\u00020*H\u0002J\u0018\u0010n\u001a\u00020\r2\u0006\u0010=\u001a\u00020o2\u0006\u0010!\u001a\u00020\"H\u0002J\u001f\u0010p\u001a\u0004\u0018\u00010\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010qJ\u0018\u0010r\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J \u0010s\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010t\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020$H\u0002J\u0010\u0010u\u001a\u00020\t2\u0006\u00100\u001a\u000201H\u0002J \u0010v\u001a\u00020\t2\u0006\u0010w\u001a\u00020,2\u0006\u0010x\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lcom/goide/refactor/inline/function/GoInlineFunctionProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "originalDeclaration", "Lcom/goide/psi/GoFunctionOrMethodDeclaration;", "reference", "Lcom/goide/psi/impl/GoTypeParametersAwareReference;", "isInlineThisOnly", "", "isDeleteDeclaration", "(Lcom/intellij/openapi/project/Project;Lcom/goide/psi/GoFunctionOrMethodDeclaration;Lcom/goide/psi/impl/GoTypeParametersAwareReference;ZZ)V", "addAsStatementBefore", "", "callExpr", "Lcom/goide/psi/GoExpression;", "anchor", "Lcom/intellij/psi/PsiElement;", "addExpressionsBefore", "exprs", "", "addParenthesesIfNeeded", "Lorg/jetbrains/annotations/NotNull;", "host", "expr", "addVarDeclarationsForNamedReturnValues", "signature", "Lcom/goide/psi/GoSignature;", "block", "Lcom/goide/psi/GoBlock;", "addVarDeclarationsForReturnValues", "returnStatement", "Lcom/goide/psi/GoReturnStatement;", "existingNames", "Lcom/goide/refactor/inline/function/GoInlineFunctionProcessor$ExistingNames;", "canIntroduceLocalVariable", "Lcom/goide/psi/GoCallExpr;", "copyAndUpdateReferences", "declaration", "targetFile", "Lcom/goide/psi/GoFile;", "createSlice", "Lcom/goide/psi/GoCompositeLit;", "sliceType", "Lcom/goide/psi/GoType;", "expressions", "context", "createSliceForVararg", "callArgument", "Lcom/goide/refactor/inline/function/GoInlineFunctionProcessor$CallArgument;", "createSliceLiteralIfNeeded", "createUsageViewDescriptor", "Lcom/intellij/refactoring/ui/UsageViewDescriptorAdapter;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/ui/UsageViewDescriptorAdapter;", "dropReturns", "returnStatements", "findAnchor", "Lorg/jetbrains/annotations/Nullable;", "element", "findProblems", "usageInfo", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "", "findReturnStatements", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "generateUniqueName", "name", "Lcom/intellij/openapi/util/NlsSafe;", "isLocallyUnique", "getCallArguments", "getCallExpr", "usage", "getCommandName", "Lorg/jetbrains/annotations/Nls;", "getLocalAnchor", "getNakedReturnExpressions", "getNamesInContext", "getPackageAnchor", "Lcom/goide/psi/GoVarDeclaration;", "getSliceType", "paramDefinition", "Lcom/goide/psi/GoParamDefinition;", "getZeroValue", "returnParameter", "hasDefers", "inline", "insertBefore", "introduceParamVariable", "paramExpr", "introduceParamVariableIfNeeded", "introduceReturnVariableIfNeeded", "returnType", "introduceVariable", "type", "valueText", "isEmptyInterface", "isNakedReturn", "isResultIgnored", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "removeRedundantLiteralTypes", "newSliceElement", "renameIfNeeded", "Lcom/goide/psi/GoNamedElement;", "renameNamedReturnParameters", "(Lcom/goide/psi/GoFunctionOrMethodDeclaration;Lcom/goide/refactor/inline/function/GoInlineFunctionProcessor$ExistingNames;)Lkotlin/Unit;", "renameVariablesAndConstants", "replaceParameters", "replaceReceiverReferences", "shouldCreateSliceForVararg", "shouldExplicitlyConvertType", "inputType", "outputType", "CallArgument", "ExistingNames", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoInlineFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoInlineFunctionProcessor.kt\ncom/goide/refactor/inline/function/GoInlineFunctionProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,504:1\n1#2:505\n26#3:506\n1855#4,2:507\n1855#4,2:509\n1855#4,2:511\n1855#4,2:513\n1855#4,2:515\n*S KotlinDebug\n*F\n+ 1 GoInlineFunctionProcessor.kt\ncom/goide/refactor/inline/function/GoInlineFunctionProcessor\n*L\n48#1:506\n214#1:507,2\n232#1:509,2\n243#1:511,2\n352#1:513,2\n452#1:515,2\n*E\n"})
public final class GoInlineFunctionProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final GoFunctionOrMethodDeclaration originalDeclaration;
    @Nullable
    private final GoTypeParametersAwareReference reference;
    private final boolean isInlineThisOnly;
    private final boolean isDeleteDeclaration;

    public GoInlineFunctionProcessor(@NotNull Project project, @NotNull GoFunctionOrMethodDeclaration originalDeclaration, @Nullable GoTypeParametersAwareReference reference, boolean isInlineThisOnly, boolean isDeleteDeclaration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        super(project);
        this.originalDeclaration = originalDeclaration;
        this.reference = reference;
        this.isInlineThisOnly = isInlineThisOnly;
        this.isDeleteDeclaration = isDeleteDeclaration;
    }

    @NotNull
    protected String getCommandName() {
        String string = GoBundle.message((String)"go.refactoring.inline.command.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected UsageViewDescriptorAdapter createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptorAdapter(this){
            final /* synthetic */ GoInlineFunctionProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public GoFunctionOrMethodDeclaration[] getElements() {
                GoFunctionOrMethodDeclaration[] goFunctionOrMethodDeclarationArray = new GoFunctionOrMethodDeclaration[]{GoInlineFunctionProcessor.access$getOriginalDeclaration$p(this.this$0)};
                return goFunctionOrMethodDeclarationArray;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                String string = RefactoringBundle.message((String)"all.invocations.in.project");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.isInlineThisOnly) {
            UsageInfo[] usageInfoArray;
            GoTypeParametersAwareReference goTypeParametersAwareReference = this.reference;
            if (goTypeParametersAwareReference != null) {
                GoTypeParametersAwareReference it = goTypeParametersAwareReference;
                boolean bl = false;
                UsageInfo[] usageInfoArray2 = new UsageInfo[]{new UsageInfo((PsiReference)it)};
                usageInfoArray = usageInfoArray2;
            } else {
                boolean $i$f$emptyArray = false;
                usageInfoArray = new UsageInfo[]{};
            }
            return usageInfoArray;
        }
        Object[] objectArray = GoReferencesSearch.search(this.originalDeclaration).mapping(arg_0 -> GoInlineFunctionProcessor.findUsages$lambda$1(findUsages.2.INSTANCE, arg_0)).toArray((Object[])UsageInfo.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        return (UsageInfo[])objectArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        boolean cancelled;
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        MultiMap conflicts2 = new MultiMap();
        boolean bl = cancelled = !ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GoInlineFunctionProcessor.preprocessUsages$lambda$3(this, conflicts2, refUsages), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject);
        if (cancelled) {
            return false;
        }
        return this.showConflicts(conflicts2, (UsageInfo[])refUsages.get());
    }

    private final void findProblems(UsageInfo usageInfo, MultiMap<PsiElement, String> conflicts2) {
        String error;
        GoCallExpr goCallExpr = this.getCallExpr(usageInfo);
        if (goCallExpr == null) {
            return;
        }
        GoCallExpr callExpr = goCallExpr;
        String string = GoInlineFunctionProcessorKt.isUnableToInsertCodeBlock(callExpr, this.originalDeclaration) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.in.loop.condition", (Object[])new Object[0]) : (GoInlineFunctionProcessorKt.isCallFromDefer(callExpr) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.call.from.defer", (Object[])new Object[0]) : (error = GoInlineFunctionProcessorKt.isCallFromGo(callExpr) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.call.from.go", (Object[])new Object[0]) : null));
        if (error != null) {
            conflicts2.putValue((Object)callExpr, (Object)error);
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        for (UsageInfo usage : usages) {
            this.inline(usage);
        }
        if (this.isDeleteDeclaration) {
            this.originalDeclaration.delete();
        }
    }

    private final void inline(UsageInfo usage) {
        GoCallExpr goCallExpr = this.getCallExpr(usage);
        if (goCallExpr == null) {
            return;
        }
        GoCallExpr callExpr = goCallExpr;
        GoBlock parentBlock = (GoBlock)PsiTreeUtil.getParentOfType((PsiElement)callExpr, GoBlock.class);
        PsiElement psiElement = this.findAnchor(callExpr);
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        PsiFile psiFile = callExpr.getContainingFile();
        GoFile goFile = psiFile instanceof GoFile ? (GoFile)psiFile : null;
        if (goFile == null) {
            return;
        }
        GoFile targetFile = goFile;
        GoFunctionOrMethodDeclaration declaration = this.copyAndUpdateReferences(this.originalDeclaration, targetFile);
        GoBlock goBlock = declaration.getBlock();
        if (goBlock == null) {
            return;
        }
        GoBlock block = goBlock;
        GoSignature goSignature = declaration.getSignature();
        if (goSignature == null) {
            return;
        }
        GoSignature signature = goSignature;
        ExistingNames existingNames = this.getNamesInContext(callExpr);
        this.renameVariablesAndConstants(declaration, existingNames);
        this.renameNamedReturnParameters(declaration, existingNames);
        this.replaceReceiverReferences(declaration, callExpr);
        this.replaceParameters(declaration, callExpr, existingNames);
        List returnStatements = this.findReturnStatements(block);
        if (this.isResultIgnored(callExpr, returnStatements)) {
            this.dropReturns(returnStatements);
            returnStatements = CollectionsKt.emptyList();
        }
        switch (returnStatements.size()) {
            case 0: {
                this.insertBefore(block, anchor);
                callExpr.delete();
                break;
            }
            case 1: {
                this.addVarDeclarationsForNamedReturnValues(signature, block);
                GoReturnStatement returnStatement = (GoReturnStatement)returnStatements.get(0);
                if (this.isNakedReturn(returnStatement)) {
                    this.addExpressionsBefore(this.getNakedReturnExpressions(signature), callExpr);
                } else {
                    List<GoExpression> exprs = this.addVarDeclarationsForReturnValues(signature, returnStatement, existingNames);
                    this.addExpressionsBefore(exprs, callExpr);
                }
                returnStatement.delete();
                this.insertBefore(block, anchor);
                callExpr.delete();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Many returns case is not supported yet");
            }
        }
        if (parentBlock != null) {
            GoFormatterUtil.reformat(parentBlock);
        }
    }

    private final List<GoExpression> addVarDeclarationsForReturnValues(GoSignature signature, GoReturnStatement returnStatement, ExistingNames existingNames) {
        SmartList result = new SmartList();
        GoType goType = signature.getResultType();
        Intrinsics.checkNotNullExpressionValue((Object)goType, (String)"getResultType(...)");
        GoType resultType = goType;
        List<GoExpression> list = returnStatement.getExpressionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
        List<GoExpression> exprs = list;
        PsiElement psiElement = this.findAnchor(returnStatement);
        if (psiElement == null) {
            return exprs;
        }
        PsiElement anchor = psiElement;
        List<GoType> list2 = GoTypeUtil.getListOfTypesFromTypeList(resultType);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getListOfTypesFromTypeList(...)");
        List<GoType> listOfTypes = list2;
        Iterator<GoType> iterator = listOfTypes.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GoExpression expr;
            int index = n++;
            GoType returnType = iterator.next();
            if ((GoExpression)CollectionsKt.getOrNull(exprs, (int)index) == null) continue;
            Collection collection = (Collection)result;
            Intrinsics.checkNotNull((Object)returnType);
            collection.add(this.introduceReturnVariableIfNeeded(expr, returnType, existingNames, anchor));
        }
        return (List)result;
    }

    private final GoExpression introduceReturnVariableIfNeeded(GoExpression expr, GoType returnType, ExistingNames existingNames, PsiElement anchor) {
        GoType goType = expr.getGoType(null);
        if (goType == null) {
            return expr;
        }
        GoType exprType = goType;
        if (this.shouldExplicitlyConvertType(exprType, returnType, expr)) {
            String uniqueName = this.generateUniqueName("r", existingNames, false);
            String string = expr.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this.introduceVariable(uniqueName, returnType, string, anchor);
        }
        return expr;
    }

    private final GoExpression introduceVariable(String name, GoType type2, String valueText, PsiElement anchor) {
        String typeText = type2.getText();
        GoVarDeclaration goVarDeclaration = GoElementFactory.createVarDeclaration(this.myProject, name + " " + typeText + " = " + valueText);
        Intrinsics.checkNotNullExpressionValue((Object)goVarDeclaration, (String)"createVarDeclaration(...)");
        GoVarDeclaration varDeclaration = goVarDeclaration;
        PsiElement psiElement = GoElementFactory.createNewLine(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createNewLine(...)");
        PsiElement newLine = psiElement;
        PsiElement parent = anchor.getParent();
        parent.addBefore((PsiElement)varDeclaration, anchor);
        parent.addBefore(newLine, anchor);
        GoReferenceExpression goReferenceExpression = GoElementFactory.createReferenceExpression(this.myProject, name);
        Intrinsics.checkNotNullExpressionValue((Object)goReferenceExpression, (String)"createReferenceExpression(...)");
        return goReferenceExpression;
    }

    private final void addVarDeclarationsForNamedReturnValues(GoSignature signature, GoBlock block) {
        Object object = signature.getResult();
        if (object == null || (object = object.getParameters()) == null || (object = object.getDefinitionList()) == null) {
            return;
        }
        Object paramDefinitions = object;
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)block.getLbrace());
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        Iterator iterator = paramDefinitions.iterator();
        while (iterator.hasNext()) {
            PsiElement newLine;
            GoVarDeclaration newElement;
            GoParamDefinition paramDefinition = (GoParamDefinition)iterator.next();
            String name = paramDefinition.getName();
            if (Intrinsics.areEqual((Object)"_", (Object)name)) continue;
            GoType goType = paramDefinition.getGoType(null);
            String string = goType != null ? goType.getText() : null;
            if (string == null) {
                string = "";
            }
            String type2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)GoElementFactory.createVarDeclaration(this.myProject, name + " " + type2), (String)"createVarDeclaration(...)");
            Intrinsics.checkNotNullExpressionValue((Object)GoElementFactory.createNewLine(this.myProject), (String)"createNewLine(...)");
            block.addBefore(newElement, anchor);
            block.addBefore(newLine, anchor);
        }
    }

    private final boolean isNakedReturn(GoReturnStatement returnStatement) {
        return returnStatement.getExpressionList().isEmpty();
    }

    private final Unit renameNamedReturnParameters(GoFunctionOrMethodDeclaration declaration, ExistingNames existingNames) {
        Unit unit;
        Object object = declaration.getResult();
        if (object != null && (object = object.getParameters()) != null && (object = object.getDefinitionList()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GoParamDefinition it = (GoParamDefinition)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.renameIfNeeded(it, existingNames);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final ExistingNames getNamesInContext(GoCallExpr callExpr) {
        GoBlock goBlock = this.originalDeclaration.getBlock();
        PsiElement firstChild = goBlock != null ? goBlock.getFirstChild() : null;
        LinkedHashSet<String> linkedHashSet = GoNameSuggestionProvider.getNamesInContext(firstChild);
        Intrinsics.checkNotNullExpressionValue(linkedHashSet, (String)"getNamesInContext(...)");
        LinkedHashSet<String> declarationSiteNames = linkedHashSet;
        LinkedHashSet<String> linkedHashSet2 = GoNameSuggestionProvider.getNamesInContext(callExpr);
        Intrinsics.checkNotNullExpressionValue(linkedHashSet2, (String)"getNamesInContext(...)");
        LinkedHashSet<String> callSiteNames = linkedHashSet2;
        return new ExistingNames((Set<String>)declarationSiteNames, (Set<String>)callSiteNames);
    }

    private final GoFunctionOrMethodDeclaration copyAndUpdateReferences(GoFunctionOrMethodDeclaration declaration, GoFile targetFile) {
        String string = GoReferenceConverter.on(declaration, targetFile).withElementsToSkip(CollectionsKt.listOf((Object)declaration)).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        GoFunctionOrMethodDeclaration goFunctionOrMethodDeclaration = GoElementFactory.createFunctionOrMethodDeclaration(this.myProject, text, (PsiElement)targetFile);
        Intrinsics.checkNotNullExpressionValue((Object)goFunctionOrMethodDeclaration, (String)"createFunctionOrMethodDeclaration(...)");
        return goFunctionOrMethodDeclaration;
    }

    private final void replaceReceiverReferences(GoFunctionOrMethodDeclaration declaration, GoCallExpr callExpr) {
        if (declaration instanceof GoMethodDeclaration) {
            GoReceiver goReceiver = ((GoMethodDeclaration)declaration).getReceiver();
            if (goReceiver == null) {
                return;
            }
            GoReceiver receiver = goReceiver;
            GoExpression goExpression = callExpr.getExpression();
            GoExpression goExpression2 = goExpression instanceof GoReferenceExpression ? (GoReferenceExpression)goExpression : null;
            if (goExpression2 == null || (goExpression2 = goExpression2.getExpressionQualifier()) == null) {
                return;
            }
            GoExpression receiverExpr = goExpression2;
            Collection collection = GoReferencesSearch.search(receiver, (SearchScope)new LocalSearchScope((PsiElement)declaration)).findAll();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiReference it = (PsiReference)element$iv;
                boolean bl = false;
                it.getElement().replace((PsiElement)receiverExpr);
            }
        }
    }

    private final void renameVariablesAndConstants(GoFunctionOrMethodDeclaration declaration, ExistingNames existingNames) {
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)declaration)).forceIgnore(arg_0 -> ((KClass)Reflection.getOrCreateKotlinClass(GoFunctionLit.class)).isInstance(arg_0))).filter(GoVarOrConstDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoVarOrConstDefinition it = (GoVarOrConstDefinition)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.renameIfNeeded(it, existingNames);
        }
    }

    private final void renameIfNeeded(GoNamedElement element, ExistingNames existingNames) {
        String string = element.getName();
        if (string == null) {
            return;
        }
        String name = string;
        if (!Intrinsics.areEqual((Object)"_", (Object)name) && existingNames.getCallSiteNames().contains(name)) {
            String newName = this.generateUniqueName(name, existingNames, true);
            GoRefactoringUtil.renameInPsiTree(element, newName);
        }
    }

    private final void insertBefore(GoBlock block, PsiElement anchor) {
        if (block.getChildren().length < 3) {
            return;
        }
        PsiElement psiElement = anchor.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement parent = psiElement;
        PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)block.getLbrace());
        if (psiElement2 == null) {
            return;
        }
        PsiElement first = psiElement2;
        PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)block.getRbrace());
        if (psiElement3 == null) {
            return;
        }
        PsiElement last = psiElement3;
        if (!Intrinsics.areEqual((Object)first.getNode().getElementType(), (Object)GoTypes.RBRACE) && !Intrinsics.areEqual((Object)last.getNode().getElementType(), (Object)GoTypes.LBRACE)) {
            PsiElement psiElement4 = GoElementFactory.createNewLine(this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"createNewLine(...)");
            PsiElement newLine = psiElement4;
            parent.addRangeBefore(first, last, anchor);
            parent.addBefore(newLine, anchor);
        }
    }

    private final boolean isResultIgnored(GoCallExpr callExpr, List<? extends GoReturnStatement> returnStatements) {
        return !((Collection)returnStatements).isEmpty() && callExpr.getParent() instanceof GoLeftHandExprList;
    }

    private final void dropReturns(List<? extends GoReturnStatement> returnStatements) {
        for (GoReturnStatement goReturnStatement : returnStatements) {
            for (GoExpression expr : goReturnStatement.getExpressionList()) {
                expr.accept(new GoVisitor(this, goReturnStatement){
                    final /* synthetic */ GoInlineFunctionProcessor this$0;
                    final /* synthetic */ GoReturnStatement $returnStatement;
                    {
                        this.this$0 = $receiver;
                        this.$returnStatement = $returnStatement;
                    }

                    public void visitCallExpr(@NotNull GoCallExpr funcCall) {
                        Intrinsics.checkNotNullParameter((Object)funcCall, (String)"funcCall");
                        super.visitCallExpr(funcCall);
                        GoInlineFunctionProcessor.access$addAsStatementBefore(this.this$0, funcCall, this.$returnStatement);
                    }

                    public void visitBuiltinCallExpr(@NotNull GoBuiltinCallExpr funcCall) {
                        Intrinsics.checkNotNullParameter((Object)funcCall, (String)"funcCall");
                        super.visitBuiltinCallExpr(funcCall);
                        GoInlineFunctionProcessor.access$addAsStatementBefore(this.this$0, funcCall, this.$returnStatement);
                    }
                });
            }
            goReturnStatement.delete();
        }
    }

    private final void addAsStatementBefore(GoExpression callExpr, PsiElement anchor) {
        PsiElement psiElement = anchor.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement parent = psiElement;
        if (GoExpressionStatementSpecChecker.isPermittedAsStatement(callExpr)) {
            parent.addBefore((PsiElement)callExpr, anchor);
        }
    }

    private final List<GoExpression> getNakedReturnExpressions(GoSignature signature) {
        Object object = signature.getResult();
        if (object == null || (object = object.getParameters()) == null || (object = object.getDefinitionList()) == null) {
            return CollectionsKt.emptyList();
        }
        Object returnParameters = object;
        ArrayList result = new ArrayList();
        Iterator iterator = returnParameters.iterator();
        while (iterator.hasNext()) {
            String name;
            GoParamDefinition returnParameter = (GoParamDefinition)iterator.next();
            if (returnParameter.getName() == null) continue;
            if (Intrinsics.areEqual((Object)"_", (Object)name)) {
                Collection collection = result;
                Intrinsics.checkNotNull((Object)returnParameter);
                collection.add(GoElementFactory.createExpression(this.myProject, this.getZeroValue(returnParameter)));
                continue;
            }
            ((Collection)result).add(GoElementFactory.createReferenceExpression(this.myProject, name));
        }
        return result;
    }

    private final String getZeroValue(GoParamDefinition returnParameter) {
        Object object = GoZeroValue.of(returnParameter.getGoType(null));
        if (object == null || (object = object.getText()) == null) {
            object = "0";
        }
        return object;
    }

    private final void addExpressionsBefore(List<? extends GoExpression> exprs, PsiElement anchor) {
        PsiElement psiElement = anchor.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement parent = psiElement;
        if (exprs.size() == 1) {
            GoExpression expr = this.addParenthesesIfNeeded(anchor, exprs.get(0));
            parent.addBefore((PsiElement)expr, anchor);
        } else {
            PsiElement psiElement2 = GoElementFactory.createComma(this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createComma(...)");
            PsiElement comma = psiElement2;
            boolean first = true;
            for (GoExpression goExpression : exprs) {
                if (!first) {
                    parent.addBefore(comma, anchor);
                }
                parent.addBefore((PsiElement)goExpression, anchor);
                first = false;
            }
        }
    }

    private final List<GoReturnStatement> findReturnStatements(GoBlock block) {
        List list = ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)block)).forceIgnore(arg_0 -> ((KClass)Reflection.getOrCreateKotlinClass(GoFunctionLit.class)).isInstance(arg_0))).filter(GoReturnStatement.class).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    private final void replaceParameters(GoFunctionOrMethodDeclaration declaration, GoCallExpr callExpr, ExistingNames existingNames) {
        List<CallArgument> callArguments = this.getCallArguments(declaration, callExpr);
        PsiElement anchor = this.canIntroduceLocalVariable(callExpr) ? this.getLocalAnchor(declaration) : (PsiElement)this.getPackageAnchor(callExpr);
        for (CallArgument callArgument : callArguments) {
            GoExpression expr;
            if (this.createSliceLiteralIfNeeded(callArgument, callExpr) == null) continue;
            GoExpression finalExpr = this.introduceParamVariableIfNeeded(expr, callArgument, existingNames, anchor);
            Iterable $this$forEach$iv = callArgument.getReferences();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiReference it = (PsiReference)element$iv;
                boolean bl = false;
                PsiElement psiElement = it.getElement();
                PsiElement psiElement2 = it.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
                psiElement.replace((PsiElement)this.addParenthesesIfNeeded(psiElement2, finalExpr));
            }
        }
    }

    private final GoExpression introduceParamVariableIfNeeded(GoExpression expr, CallArgument callArgument, ExistingNames existingNames, PsiElement anchor) {
        if (callArgument.getReferences().size() > 1 && !(expr instanceof GoReferenceExpression)) {
            return this.introduceParamVariable(callArgument.getParamDefinition(), expr, existingNames, anchor);
        }
        GoType goType = expr.getGoType(null);
        if (goType == null) {
            return expr;
        }
        GoType argType = goType;
        GoType goType2 = callArgument.getParamDefinition().getGoType(null);
        if (goType2 == null) {
            return expr;
        }
        GoType paramType = goType2;
        if (this.shouldExplicitlyConvertType(argType, paramType, expr)) {
            return this.introduceParamVariable(callArgument.getParamDefinition(), expr, existingNames, anchor);
        }
        return expr;
    }

    private final boolean shouldExplicitlyConvertType(GoType inputType, GoType outputType, PsiElement context) {
        GoType goType = inputType.getUnderlyingType(context);
        Intrinsics.checkNotNullExpressionValue((Object)goType, (String)"getUnderlyingType(...)");
        GoType inputUnderlyingType = goType;
        GoType goType2 = outputType.getUnderlyingType(context);
        Intrinsics.checkNotNullExpressionValue((Object)goType2, (String)"getUnderlyingType(...)");
        GoType outputUnderlyingType = goType2;
        return outputUnderlyingType instanceof GoInterfaceType && !(inputUnderlyingType instanceof GoInterfaceType) || this.isEmptyInterface(outputUnderlyingType) && !this.isEmptyInterface(inputUnderlyingType);
    }

    private final boolean isEmptyInterface(GoType type2) {
        return type2 instanceof GoInterfaceType && GoTypeUtil.isEmptyInterface((GoInterfaceType)type2);
    }

    private final GoExpression createSliceLiteralIfNeeded(CallArgument callArgument, PsiElement context) {
        return this.shouldCreateSliceForVararg(callArgument) ? (GoExpression)this.createSliceForVararg(callArgument, context) : (GoExpression)CollectionsKt.firstOrNull(callArgument.getExpressions());
    }

    private final boolean canIntroduceLocalVariable(GoCallExpr callExpr) {
        return GoInlineFunctionProcessorKt.access$findStatementsHolder(callExpr) != null;
    }

    private final PsiElement getLocalAnchor(GoFunctionOrMethodDeclaration declaration) {
        GoBlock goBlock = declaration.getBlock();
        return PsiTreeUtil.skipWhitespacesForward((PsiElement)(goBlock != null ? goBlock.getLbrace() : null));
    }

    private final GoVarDeclaration getPackageAnchor(GoCallExpr callExpr) {
        return (GoVarDeclaration)PsiTreeUtil.getParentOfType((PsiElement)callExpr, GoVarDeclaration.class);
    }

    private final GoExpression introduceParamVariable(GoParamDefinition paramDefinition, GoExpression paramExpr, ExistingNames existingNames, PsiElement anchor) {
        if (anchor == null) {
            return paramExpr;
        }
        String string = paramDefinition.getName();
        if (string == null) {
            return paramExpr;
        }
        String name = string;
        GoType goType = paramDefinition.getGoType(null);
        if (goType == null) {
            return paramExpr;
        }
        GoType type2 = goType;
        String string2 = paramExpr.getText();
        if (string2 == null) {
            return paramExpr;
        }
        String value = string2;
        String uniqueName = this.generateUniqueName(name, existingNames, true);
        return this.introduceVariable(uniqueName, type2, value, anchor);
    }

    private final String generateUniqueName(String name, ExistingNames existingNames, boolean isLocallyUnique) {
        String string;
        if (isLocallyUnique) {
            ((Collection)existingNames.getDeclarationSiteNames()).remove(name);
        }
        String string2 = UniqueNameGenerator.generateUniqueName((String)name, arg_0 -> GoInlineFunctionProcessor.generateUniqueName$lambda$8((Function1)new Function1<String, Boolean>(existingNames){
            final /* synthetic */ ExistingNames $existingNames;
            {
                this.$existingNames = $existingNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return !this.$existingNames.getCallSiteNames().contains(it) && !this.$existingNames.getDeclarationSiteNames().contains(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateUniqueName(...)");
        String it = string = string2;
        boolean bl = false;
        existingNames.plusAssign(it);
        return string;
    }

    private final GoExpression addParenthesesIfNeeded(PsiElement host, GoExpression expr) {
        GoExpression goExpression = GoExpressionUtil.needParentheses(host, expr) ? GoElementFactory.createExpression(this.myProject, "(" + expr.getText() + ")", expr) : expr;
        Intrinsics.checkNotNull((Object)goExpression);
        return goExpression;
    }

    private final GoCompositeLit createSliceForVararg(CallArgument callArgument, PsiElement context) {
        GoType sliceType = this.getSliceType(callArgument.getParamDefinition());
        GoCompositeLit newSliceElement = this.createSlice(sliceType, callArgument.getExpressions(), context);
        this.removeRedundantLiteralTypes(newSliceElement);
        return newSliceElement;
    }

    private final GoType getSliceType(GoParamDefinition paramDefinition) {
        GoType goType = paramDefinition.getGoType(null);
        Intrinsics.checkNotNull((Object)goType, (String)"null cannot be cast to non-null type com.goide.psi.impl.GoLightType.LightSliceType");
        GoType goType2 = ((GoLightType.LightSliceType)goType).getType();
        Intrinsics.checkNotNullExpressionValue((Object)goType2, (String)"getType(...)");
        return goType2;
    }

    private final GoCompositeLit createSlice(GoType sliceType, List<? extends GoExpression> expressions, PsiElement context) {
        Object object;
        if (expressions.isEmpty()) {
            object = "[]" + sliceType.getText() + "{}";
        } else {
            String string = new GoIntroduceVariableOrConstBase.GoFakeVariadicExpression((GoExpression)CollectionsKt.first(expressions), sliceType).getText();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        }
        String sliceLiteralText = object;
        GoCompositeLit goCompositeLit = GoElementFactory.createElement(this.myProject, "package a; var b = " + sliceLiteralText, GoCompositeLit.class, context);
        Intrinsics.checkNotNull((Object)goCompositeLit);
        return goCompositeLit;
    }

    private final void removeRedundantLiteralTypes(GoCompositeLit newSliceElement) {
        block1: {
            Object object = newSliceElement.getLiteralValue();
            if (object == null || (object = object.getElementList()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GoElement it = (GoElement)element$iv;
                boolean bl = false;
                GoValue goValue = it.getValue();
                GoExpression goExpression = goValue != null ? goValue.getExpression() : null;
                GoCompositeElement goCompositeElement = goExpression instanceof GoCompositeLit ? (GoCompositeLit)goExpression : null;
                if (goCompositeElement == null || (goCompositeElement = goCompositeElement.getTypeReferenceExpression()) == null) continue;
                goCompositeElement.delete();
            }
        }
    }

    private final List<CallArgument> getCallArguments(GoFunctionOrMethodDeclaration declaration, GoCallExpr callExpr) {
        GoSignature goSignature = declaration.getSignature();
        Intrinsics.checkNotNull((Object)goSignature);
        List<GoParamDefinition> list = goSignature.getParameters().getDefinitionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDefinitionList(...)");
        List<GoParamDefinition> paramDefinitions = list;
        List<GoExpression> list2 = callExpr.getArgumentList().getExpressionList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExpressionList(...)");
        List<GoExpression> argumentExpressions = list2;
        ArrayList result = new ArrayList();
        Iterator<GoParamDefinition> iterator = paramDefinitions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Collection references;
            int index = n++;
            GoParamDefinition paramDefinition = iterator.next();
            String paramName = paramDefinition.getName();
            if (paramName == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)GoReferencesSearch.search(paramDefinition, (SearchScope)new LocalSearchScope((PsiElement)declaration)).findAll(), (String)"findAll(...)");
            List<GoExpression> expressions = paramDefinition.isVariadic() ? argumentExpressions.subList(index, argumentExpressions.size()) : CollectionsKt.listOfNotNull((Object)CollectionsKt.getOrNull(argumentExpressions, (int)index));
            Collection collection = result;
            Intrinsics.checkNotNull((Object)paramDefinition);
            collection.add(new CallArgument(paramDefinition, expressions, references));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCreateSliceForVararg(CallArgument callArgument) {
        if (!callArgument.getParamDefinition().isVariadic()) return false;
        if (callArgument.getExpressions().isEmpty()) return true;
        PsiElement psiElement = callArgument.getExpressions().get(0).getNextSibling();
        if (Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)GoTypes.TRIPLE_DOT)) return false;
        return true;
    }

    private final PsiElement findAnchor(PsiElement element) {
        return GoRefactoringUtil.findLocalAnchor(CollectionsKt.listOf((Object)element));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final GoCallExpr getCallExpr(UsageInfo usage) {
        v0 /* !! */  = usage.getElement();
        if (v0 /* !! */  == null) ** GOTO lbl-1000
        it = var3_2 = v0 /* !! */ ;
        $i$a$-takeIf-GoInlineFunctionProcessor$getCallExpr$1 = false;
        v0 /* !! */  = it.isValid() != false ? var3_2 : null;
        if (v0 /* !! */  != null) {
            v1 = v0 /* !! */ .getParent();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        var2_5 = v1;
        return var2_5 instanceof GoCallExpr != false ? (GoCallExpr)var2_5 : null;
    }

    private final boolean hasDefers(GoFunctionOrMethodDeclaration declaration) {
        return PsiTreeUtil.findChildOfType((PsiElement)declaration, GoDeferStatement.class) != null;
    }

    private static final UsageInfo findUsages$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UsageInfo)$tmp0.invoke(p0);
    }

    private static final void preprocessUsages$lambda$3$lambda$2(GoInlineFunctionProcessor this$0, MultiMap $conflicts, Ref $refUsages) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conflicts, (String)"$conflicts");
        Intrinsics.checkNotNullParameter((Object)$refUsages, (String)"$refUsages");
        if (this$0.hasDefers(this$0.originalDeclaration)) {
            $conflicts.putValue((Object)this$0.originalDeclaration, (Object)GoBundle.message((String)"go.refactoring.inline.defer.statements", (Object[])new Object[0]));
        }
        Object object = $refUsages.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        for (UsageInfo usageInfo : (UsageInfo[])object) {
            ProgressManager.checkCanceled();
            this$0.findProblems(usageInfo, (MultiMap<PsiElement, String>)$conflicts);
        }
    }

    private static final void preprocessUsages$lambda$3(GoInlineFunctionProcessor this$0, MultiMap $conflicts, Ref $refUsages) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conflicts, (String)"$conflicts");
        Intrinsics.checkNotNullParameter((Object)$refUsages, (String)"$refUsages");
        ReadAction.run(() -> GoInlineFunctionProcessor.preprocessUsages$lambda$3$lambda$2(this$0, $conflicts, $refUsages));
    }

    private static final boolean generateUniqueName$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ GoFunctionOrMethodDeclaration access$getOriginalDeclaration$p(GoInlineFunctionProcessor $this) {
        return $this.originalDeclaration;
    }

    public static final /* synthetic */ void access$addAsStatementBefore(GoInlineFunctionProcessor $this, GoExpression callExpr, PsiElement anchor) {
        $this.addAsStatementBefore(callExpr, anchor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/goide/refactor/inline/function/GoInlineFunctionProcessor$CallArgument;", "", "paramDefinition", "Lcom/goide/psi/GoParamDefinition;", "expressions", "", "Lcom/goide/psi/GoExpression;", "references", "", "Lcom/intellij/psi/PsiReference;", "(Lcom/goide/psi/GoParamDefinition;Ljava/util/List;Ljava/util/Collection;)V", "getExpressions", "()Ljava/util/List;", "getParamDefinition", "()Lcom/goide/psi/GoParamDefinition;", "getReferences", "()Ljava/util/Collection;", "intellij.go.impl"})
    private static final class CallArgument {
        @NotNull
        private final GoParamDefinition paramDefinition;
        @NotNull
        private final List<GoExpression> expressions;
        @NotNull
        private final Collection<PsiReference> references;

        public CallArgument(@NotNull GoParamDefinition paramDefinition, @NotNull List<? extends GoExpression> expressions, @NotNull Collection<? extends PsiReference> references) {
            Intrinsics.checkNotNullParameter((Object)paramDefinition, (String)"paramDefinition");
            Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
            Intrinsics.checkNotNullParameter(references, (String)"references");
            this.paramDefinition = paramDefinition;
            this.expressions = expressions;
            this.references = references;
        }

        @NotNull
        public final GoParamDefinition getParamDefinition() {
            return this.paramDefinition;
        }

        @NotNull
        public final List<GoExpression> getExpressions() {
            return this.expressions;
        }

        @NotNull
        public final Collection<PsiReference> getReferences() {
            return this.references;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\rH\u0086\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/goide/refactor/inline/function/GoInlineFunctionProcessor$ExistingNames;", "", "declarationSiteNames", "", "", "callSiteNames", "(Ljava/util/Set;Ljava/util/Set;)V", "getCallSiteNames", "()Ljava/util/Set;", "getDeclarationSiteNames", "plusAssign", "", "it", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.go.impl"})
    private static final class ExistingNames {
        @NotNull
        private final Set<String> declarationSiteNames;
        @NotNull
        private final Set<String> callSiteNames;

        public ExistingNames(@NotNull Set<String> declarationSiteNames, @NotNull Set<String> callSiteNames) {
            Intrinsics.checkNotNullParameter(declarationSiteNames, (String)"declarationSiteNames");
            Intrinsics.checkNotNullParameter(callSiteNames, (String)"callSiteNames");
            this.declarationSiteNames = declarationSiteNames;
            this.callSiteNames = callSiteNames;
        }

        @NotNull
        public final Set<String> getDeclarationSiteNames() {
            return this.declarationSiteNames;
        }

        @NotNull
        public final Set<String> getCallSiteNames() {
            return this.callSiteNames;
        }

        public final void plusAssign(@NotNull String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ((Collection)this.declarationSiteNames).add(it);
            ((Collection)this.callSiteNames).add(it);
        }
    }
}

