/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.inline.function;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.impl.GoTypeParametersAwareReference;
import com.goide.refactor.inline.GoInlineActionHandler;
import com.goide.refactor.inline.function.GoInlineFunctionDialog;
import com.goide.refactor.inline.function.GoInlineFunctionProcessor;
import com.goide.refactor.inline.function.GoInlineFunctionProcessorKt;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\f0\u0004\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u001c\u001a\u00020\u00162\b\b\u0001\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001e\u001a\u00020\u0006*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/goide/refactor/inline/function/GoInlineFunctionHandler;", "Lcom/goide/refactor/inline/GoInlineActionHandler;", "()V", "REFACTORING_ID", "", "isDeleteDeclaration", "", "()Z", "setDeleteDeclaration", "(Z)V", "isInlineThisOnly", "setInlineThisOnly", "canInlineElement", "element", "Lcom/intellij/psi/PsiElement;", "getActionName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "hasManyReturns", "declaration", "Lcom/goide/psi/GoFunctionOrMethodDeclaration;", "inlineElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isRecursive", "showErrorHint", "error", "hasNoBody", "intellij.go.impl"})
public final class GoInlineFunctionHandler
extends GoInlineActionHandler {
    @NotNull
    private final String REFACTORING_ID;
    private boolean isInlineThisOnly;
    private boolean isDeleteDeclaration;

    public GoInlineFunctionHandler() {
        this.REFACTORING_ID = "refactoring.inlineMethod";
    }

    public final boolean isInlineThisOnly() {
        return this.isInlineThisOnly;
    }

    public final void setInlineThisOnly(boolean bl) {
        this.isInlineThisOnly = bl;
    }

    public final boolean isDeleteDeclaration() {
        return this.isDeleteDeclaration;
    }

    public final void setDeleteDeclaration(boolean bl) {
        this.isDeleteDeclaration = bl;
    }

    @NotNull
    public String getActionName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = GoBundle.message((String)"go.refactoring.inline.command.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean canInlineElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof GoFunctionOrMethodDeclaration || element instanceof GoCallExpr;
    }

    public void inlineElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        String error;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        GoFunctionOrMethodDeclaration goFunctionOrMethodDeclaration = element instanceof GoFunctionOrMethodDeclaration ? (GoFunctionOrMethodDeclaration)element : null;
        if (goFunctionOrMethodDeclaration == null) {
            return;
        }
        GoFunctionOrMethodDeclaration declaration = goFunctionOrMethodDeclaration;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        GoTypeParametersAwareReference reference = psiReference instanceof GoTypeParametersAwareReference ? (GoTypeParametersAwareReference)psiReference : null;
        Object object = reference;
        PsiElement psiElement = object != null && (object = (GoResolvable)object.getElement()) != null ? object.getParent() : null;
        GoCallExpr callExpr = psiElement instanceof GoCallExpr ? (GoCallExpr)psiElement : null;
        String string = this.hasNoBody(declaration) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.no.body", (Object[])new Object[0]) : (this.isRecursive(declaration) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.recursive.functions", (Object[])new Object[0]) : (this.hasManyReturns(declaration) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.many.returns", (Object[])new Object[0]) : (GoInlineFunctionProcessorKt.isUnableToInsertCodeBlock(callExpr, declaration) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.in.loop.condition", (Object[])new Object[0]) : (GoInlineFunctionProcessorKt.isCallFromDefer(callExpr) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.call.from.defer", (Object[])new Object[0]) : (error = GoInlineFunctionProcessorKt.isCallFromGo(callExpr) ? GoBundle.message((String)"go.refactoring.inline.cannot.inline.call.from.go", (Object[])new Object[0]) : null)))));
        if (error != null) {
            this.showErrorHint(error, project, editor);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            new GoInlineFunctionProcessor(project, declaration, reference, this.isInlineThisOnly, this.isDeleteDeclaration).run();
        } else {
            new GoInlineFunctionDialog(project, declaration, reference).show();
        }
    }

    private final boolean hasNoBody(GoFunctionOrMethodDeclaration $this$hasNoBody) {
        return $this$hasNoBody.getBlock() == null;
    }

    private final boolean hasManyReturns(GoFunctionOrMethodDeclaration declaration) {
        GoSignature goSignature = declaration.getSignature();
        GoResult result = goSignature != null ? goSignature.getResult() : null;
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)declaration)).forceIgnore(arg_0 -> ((KClass)Reflection.getOrCreateKotlinClass(GoFunctionLit.class)).isInstance(arg_0))).filter(GoReturnStatement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        int returnsCount = CollectionsKt.count((Iterable)((Iterable)jBIterable));
        return returnsCount > (result != null ? 1 : 0);
    }

    private final boolean isRecursive(GoFunctionOrMethodDeclaration declaration) {
        return GoReferencesSearch.search(declaration, (SearchScope)new LocalSearchScope((PsiElement)declaration)).findFirst() != null;
    }

    private final void showErrorHint(@Nls(capitalization=Nls.Capitalization.Sentence) String error, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)error), (String)GoBundle.message((String)"go.refactoring.inline.command.name", (Object[])new Object[0]), (String)this.REFACTORING_ID);
    }
}

