/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.go.GoGotoUtil;
import com.goide.go.GoInheritorsSearch;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoImportList;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.changeSignature.GoChangeSignatureHandler;
import com.goide.refactor.changeSignature.GoChangeSignatureUtil;
import com.goide.refactor.changeSignature.GoMethodChangeInfo;
import com.goide.refactor.changeSignature.GoMethodDescriptor;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.refactor.util.GoReferenceConverter;
import com.goide.util.GoZeroValue;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    public UsageInfo @NotNull [] findUsages(@NotNull ChangeInfo changeInfo) {
        GoCompositeElement locationToSkip;
        GoMethodChangeInfo info;
        if (changeInfo == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        if ((info = (GoMethodChangeInfo)ObjectUtils.tryCast((Object)changeInfo, GoMethodChangeInfo.class)) == null) {
            if (UsageInfo.EMPTY_ARRAY == null) {
                GoChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        ArrayList<? extends UsageInfo> usages = new ArrayList<UsageInfo>();
        GoNamedSignatureOwner method = info.getMethod();
        SmartList methods = new SmartList((Object)method);
        if (method instanceof GoMethodSpec && info.isRefactorImplementations()) {
            GoInheritorsSearch.METHOD_INHERITORS_SEARCH.processQuery(GoGotoUtil.param(method), (Processor<? super GoNamedSignatureOwner>)((Processor)arg_0 -> GoChangeSignatureUsageProcessor.lambda$findUsages$0((List)methods, usages, arg_0)));
        }
        if (info.isParameterSetOrOrderChanged() || info.isResultParameterSetOrOrderChanged() || info.isNameChanged()) {
            usages.addAll(GoChangeSignatureUsageProcessor.findMethodUsages(method, (List<GoNamedSignatureOwner>)methods));
        }
        if (info.isParameterNamesChanged()) {
            StreamEx.of((Collection)methods).map(GoSignatureOwner::getSignature).nonNull().map(GoSignature::getParameters).map(parameters -> GoChangeSignatureUsageProcessor.getParameterUsages(parameters, info.getNewParameters())).forEach(usages::addAll);
        }
        if (info.isResultParameterNamesChanged()) {
            StreamEx.of((Collection)methods).map(GoSignatureOwner::getSignature).nonNull().map(GoSignature::getResult).nonNull().map(GoResult::getParameters).nonNull().map(resultParameters -> GoChangeSignatureUsageProcessor.getParameterUsages(resultParameters, info.getNewResultParameters())).forEach(usages::addAll);
        }
        if ((locationToSkip = info.getLocationToSkip()) != null) {
            UsageInfo[] usageInfoArray = (UsageInfo[])((StreamEx)StreamEx.of(usages).remove(usage -> {
                PsiElement element = usage.getElement();
                return element != null && PsiTreeUtil.isAncestor((PsiElement)locationToSkip, (PsiElement)element, (boolean)false);
            })).toArray((Object[])UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                GoChangeSignatureUsageProcessor.$$$reportNull$$$0(2);
            }
            return usageInfoArray;
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    public static Collection<? extends UsageInfo> findMethodUsages(@NotNull GoNamedSignatureOwner method, @NotNull List<GoNamedSignatureOwner> methods) {
        if (method == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(4);
        }
        if (methods == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(5);
        }
        LinkedHashSet usages = new LinkedHashSet();
        TextOccurenceProcessor processor2 = (element, offsetInElement) -> {
            PsiReference reference = element.findReferenceAt(offsetInElement);
            if (reference != null) {
                for (GoNamedSignatureOwner m : methods) {
                    if (!reference.isReferenceTo((PsiElement)m)) continue;
                    usages.add(new GoMethodUsageInfo(reference));
                    break;
                }
            }
            return true;
        };
        Project project = method.getProject();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        SearchScope scope = Objects.requireNonNull(StreamEx.of(methods).map(arg_0 -> ((PsiSearchHelper)searchHelper).getUseScope(arg_0)).reduce(SearchScope::union).orElse(null));
        String name = Objects.requireNonNull(method.getName());
        searchHelper.processElementsWithWord(processor2, scope, name, (short)1, true);
        return usages;
    }

    @NotNull
    private static List<UsageInfo> getParameterUsages(@NotNull GoParameters oldParameters, GoParameterInfo @NotNull [] newParameters) {
        if (oldParameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(6);
        }
        if (newParameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(7);
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (GoParameterInfo parameter : newParameters) {
            GoParamDefinition oldParameter;
            if (!parameter.isNameChanged() || (oldParameter = oldParameters.getDefinitionByIndex(parameter.getOldIndex())) == null) continue;
            GoReferencesSearch.search(oldParameter, oldParameter.getUseScope()).forEach(reference -> usages.add(new GoParameterUsageInfo((PsiReference)reference, parameter)));
        }
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public MultiMap<PsiElement, String> findConflicts(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages) {
        GoMethodChangeInfo info = (GoMethodChangeInfo)ObjectUtils.tryCast((Object)changeInfo, GoMethodChangeInfo.class);
        if (info == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                GoChangeSignatureUsageProcessor.$$$reportNull$$$0(9);
            }
            return multiMap;
        }
        MultiMap conflicts2 = MultiMap.createSet();
        GoNamedSignatureOwner method = info.getMethod();
        GoChangeSignatureUsageProcessor.findMethodNameConflicts((MultiMap<PsiElement, String>)conflicts2, info, method);
        GoChangeSignatureUsageProcessor.findParameterNameConflicts((MultiMap<PsiElement, String>)conflicts2, info, method);
        boolean parameterSetOrOrderChanged = info.isParameterSetOrOrderChanged();
        for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
            GoNamedSignatureOwner inheritor;
            if (usage instanceof GoInheritorUsageInfo && (inheritor = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)usage.getElement(), GoNamedSignatureOwner.class)) != null) {
                GoChangeSignatureUsageProcessor.findMethodNameConflicts((MultiMap<PsiElement, String>)conflicts2, info, inheritor);
                GoChangeSignatureUsageProcessor.findParameterNameConflicts((MultiMap<PsiElement, String>)conflicts2, info, inheritor);
            }
            if (!(usage instanceof GoMethodUsageInfo)) continue;
            GoMethodUsageInfo methodUsageInfo = (GoMethodUsageInfo)usage;
            if (!parameterSetOrOrderChanged) continue;
            GoChangeSignatureUsageProcessor.findParametersListConflict((MultiMap<PsiElement, String>)conflicts2, info, methodUsageInfo);
        }
        MultiMap multiMap = conflicts2;
        if (multiMap == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(10);
        }
        return multiMap;
    }

    private static void findMethodNameConflicts(@NotNull MultiMap<PsiElement, String> conflicts2, @NotNull GoMethodChangeInfo info, @NotNull GoNamedSignatureOwner method) {
        if (conflicts2 == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(11);
        }
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(12);
        }
        if (method == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(13);
        }
        if (info.isNameChanged()) {
            String name = info.getNewName();
            GoRefactoringUtil.findDuplicateConflicts(method, name, conflicts2);
            if (method instanceof GoFunctionDeclaration) {
                String oldName = method.getName();
                if (GoPsiUtil.isMainFunction(method)) {
                    assert (oldName != null);
                    conflicts2.putValue((Object)method, (Object)GoBundle.message((String)"go.refactoring.change.signature.function.will.not.start.application.validation.message", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)oldName)}));
                } else if ("init".equals(oldName)) {
                    conflicts2.putValue((Object)method, (Object)GoBundle.message((String)"go.refactoring.change.signature.function.will.not.perform.initialization.validation.message", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)oldName)}));
                }
            }
        }
    }

    private static void findParameterNameConflicts(@NotNull MultiMap<PsiElement, String> conflicts2, @NotNull GoMethodChangeInfo info, @NotNull GoNamedSignatureOwner method) {
        Map newParameters;
        GoBlock block;
        if (conflicts2 == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(14);
        }
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(15);
        }
        if (method == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(16);
        }
        if ((block = method.getBlockIfExists()) != null && !(newParameters = ((StreamEx)StreamEx.of((Object[])info.getNewParameters()).append((Object[])info.getNewResultParameters()).filter(parameter -> !parameter.getName().isEmpty() && (parameter.getOldIndex() == -1 || parameter.isNameChanged()))).toMap(GoParameterInfo::getName, x -> x)).isEmpty()) {
            new GoDuplicatesSearch.StatementsHolderScopeSearch().processAllElements(block, (PairProcessor<String, GoDuplicatesSearch.Duplicate>)((PairProcessor)(name, holder) -> {
                GoParameterInfo parameter = (GoParameterInfo)newParameters.get(name);
                if (parameter != null) {
                    GoNamedElement duplicate = holder.duplicatedElement;
                    conflicts2.putValue((Object)duplicate, (Object)GoRefactoringUtil.getRedeclareMessage(parameter.isNameChanged() ? GoBundle.message((String)"go.refactoring.change.signature.renamed.parameter.validation.message.part", (Object[])new Object[0]) : GoBundle.message((String)"go.refactoring.change.signature.new.parameter.validation.message.part", (Object[])new Object[0]), Objects.requireNonNull(name), duplicate));
                }
                return true;
            }));
        }
    }

    private static void findParametersListConflict(@NotNull MultiMap<PsiElement, String> conflicts2, @NotNull GoMethodChangeInfo info, @NotNull GoMethodUsageInfo usage) {
        GoArgumentList argumentList;
        PsiElement psiElement;
        GoVarSpec varSpec;
        if (conflicts2 == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(17);
        }
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(18);
        }
        if (usage == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(19);
        }
        if (!info.isParameterSetOrOrderChanged()) {
            return;
        }
        GoReferenceExpression usageRefExpr = (GoReferenceExpression)ObjectUtils.tryCast((Object)usage.getElement(), GoReferenceExpression.class);
        if (usageRefExpr == null || GoRefactoringUtil.isCall(usageRefExpr) || !(usageRefExpr.getGoType(null) instanceof GoFunctionType)) {
            return;
        }
        PsiElement parent = usageRefExpr.getParent();
        if (parent instanceof GoVarSpec && (varSpec = (GoVarSpec)parent).getType() == null) {
            ContainerUtil.zip(varSpec.getDefinitionList(), varSpec.getExpressionList()).forEach(pair -> {
                if (pair.second != usageRefExpr) {
                    return;
                }
                GoVarDefinition varDefinition = (GoVarDefinition)pair.first;
                String name = varDefinition.getName();
                if (name == null) {
                    return;
                }
                String emphasizedName = CommonRefactoringUtil.htmlEmphasize((String)name);
                conflicts2.putValue((Object)varDefinition, (Object)GoBundle.message((String)"go.refactoring.change.signature.remove.parameter.used.as.var.value.message", (Object[])new Object[]{emphasizedName}));
            });
            return;
        }
        if (parent instanceof GoArgumentList && (psiElement = (argumentList = (GoArgumentList)parent).getParent()) instanceof GoExpression) {
            GoExpression callExpr = (GoExpression)psiElement;
            GoReferenceExpression callRefExpr = GoPsiUtil.getCallReference(callExpr);
            if (callRefExpr == null) {
                return;
            }
            int argsCount = ContainerUtil.count(argumentList.getExpressionList(), expr -> expr == usageRefExpr);
            String emphasizedCallExpr = CommonRefactoringUtil.htmlEmphasize((String)callRefExpr.getText());
            conflicts2.putValue((Object)parent, (Object)GoBundle.message((String)"go.refactoring.change.signature.remove.parameter.used.as.call.argument.message", (Object[])new Object[]{emphasizedCallExpr, argsCount}));
            return;
        }
        if (parent instanceof GoAssignmentStatement) {
            GoAssignmentStatement assignmentStatement = (GoAssignmentStatement)parent;
            ContainerUtil.zip(assignmentStatement.getLeftHandExprList().getExpressionList(), assignmentStatement.getExpressionList()).forEach(pair -> {
                if (pair.second != usageRefExpr) {
                    return;
                }
                GoExpression leftHandExpr = (GoExpression)pair.first;
                String emphasizedExpr = CommonRefactoringUtil.htmlEmphasize((String)leftHandExpr.getText());
                conflicts2.putValue((Object)leftHandExpr, (Object)GoBundle.message((String)"go.refactoring.change.signature.remove.parameter.used.in.assignment.message", (Object[])new Object[]{emphasizedExpr}));
            });
            return;
        }
        conflicts2.putValue((Object)usageRefExpr, (Object)GoBundle.message((String)"go.refactoring.change.signature.remove.parameter.generic.message", (Object[])new Object[0]));
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usage, boolean beforeMethodChange, UsageInfo[] usages) {
        GoNamedSignatureOwner inheritor;
        GoMethodChangeInfo info = (GoMethodChangeInfo)ObjectUtils.tryCast((Object)changeInfo, GoMethodChangeInfo.class);
        if (info == null) {
            return false;
        }
        if (!beforeMethodChange) {
            return true;
        }
        PsiElement element = usage.getElement();
        if (element == null) {
            return true;
        }
        if (usage instanceof GoMethodUsageInfo) {
            GoCallExpr call;
            if (info.isNameChanged()) {
                RenameUtil.rename((UsageInfo)usage, (String)info.getNewName());
            }
            if ((call = (GoCallExpr)ObjectUtils.tryCast((Object)GoRefactoringUtil.getCall(element), GoCallExpr.class)) != null) {
                if (info.isParameterSetOrOrderChanged()) {
                    GoChangeSignatureUsageProcessor.updateArguments(info, call);
                }
                if (info.isResultParameterSetOrOrderChanged()) {
                    List<GoExpression> expressions;
                    PsiElement parent = call.getParent();
                    GoVarSpec varSpec = (GoVarSpec)ObjectUtils.tryCast((Object)parent, GoVarSpec.class);
                    GoAssignmentStatement assignment = (GoAssignmentStatement)ObjectUtils.tryCast((Object)parent, GoAssignmentStatement.class);
                    List<GoExpression> list = varSpec != null ? varSpec.getExpressionList() : (expressions = assignment != null ? assignment.getExpressionList() : Collections.emptyList());
                    if (expressions.size() == 1) {
                        GoParameterInfo[] resultParameters = info.getNewResultParameters();
                        if (resultParameters.length == 0) {
                            GoChangeSignatureUsageProcessor.removeAssignment(info, call);
                        } else if (varSpec != null) {
                            GoChangeSignatureUsageProcessor.updateVariables(info, varSpec);
                        } else {
                            GoChangeSignatureUsageProcessor.updateAssignment(info, assignment);
                        }
                    }
                }
            }
        } else if (usage instanceof GoParameterUsageInfo) {
            GoParameterInfo parameter = ((GoParameterUsageInfo)usage).myParameter;
            String name = parameter.getName();
            if (parameter.isNameChanged() && StringUtil.isNotEmpty((String)name)) {
                RenameUtil.rename((UsageInfo)usage, (String)name);
            }
        } else if (usage instanceof GoInheritorUsageInfo && (inheritor = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)usage.getElement(), GoNamedSignatureOwner.class)) != null) {
            GoChangeSignatureUsageProcessor.processPrimaryMethod(info, inheritor);
        }
        return true;
    }

    private static void updateArguments(@NotNull GoMethodChangeInfo info, @NotNull GoCallExpr call) {
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(20);
        }
        if (call == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(21);
        }
        StringBuilder builder = new StringBuilder(info.getNewName());
        builder.append('(');
        GoArgumentList arguments = call.getArgumentList();
        List<GoExpression> expressions = arguments.getExpressionList();
        GoParameterInfo[] parameters = GoChangeSignatureUsageProcessor.handleMethodExpression(info, call);
        if (GoChangeSignatureUsageProcessor.isMultiReturn(expressions) || GoChangeSignatureUsageProcessor.match(parameters, expressions.size(), info.getOldParametersLength())) {
            return;
        }
        boolean preserveTrailingComma = GoMethodDescriptor.hasTrailingComma(arguments.getRparen());
        GoChangeSignatureUsageProcessor.appendParameters(builder, parameters, expressions, new DefaultValueTextProvider(call, false), preserveTrailingComma);
        builder.append(')');
        GoCallExpr newCall = GoElementFactory.createCallExpression(info.getProject(), builder.toString());
        GoFormatterUtil.reformat(arguments.replace(newCall.getArgumentList()));
    }

    private static GoParameterInfo[] handleMethodExpression(@NotNull GoMethodChangeInfo info, @NotNull GoCallExpr call) {
        GoType methodExpressionType;
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(22);
        }
        if (call == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(23);
        }
        if ((methodExpressionType = GoChangeSignatureUtil.getMethodExpressionType(call)) == null) {
            return info.getNewParameters();
        }
        return GoChangeSignatureUsageProcessor.prependWithParameter(info.getNewParameters(), new GoParameterInfo(0, methodExpressionType, false));
    }

    private static GoParameterInfo @NotNull [] prependWithParameter(GoParameterInfo @NotNull [] parameters, @NotNull GoParameterInfo parameter) {
        if (parameter == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(24);
        }
        if (parameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(25);
        }
        parameters = (GoParameterInfo[])ArrayUtil.prepend((Object)parameter, (Object[])parameters);
        for (int i = 1; i < parameters.length; ++i) {
            parameters[i] = GoParameterInfo.incrementOldIndex(parameters[i]);
        }
        if (parameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(26);
        }
        return parameters;
    }

    private static void removeAssignment(@NotNull GoMethodChangeInfo info, @NotNull GoCallExpr call) {
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(27);
        }
        if (call == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(28);
        }
        GoExpression newExpression = GoElementFactory.createExpression(info.getProject(), call.getText());
        GoStatement newStatement = Objects.requireNonNull((GoStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GoStatement.class));
        GoFormatterUtil.reformat(Objects.requireNonNull((GoStatement)PsiTreeUtil.getParentOfType((PsiElement)call, GoStatement.class)).replace(newStatement));
    }

    private static void updateVariables(@NotNull GoMethodChangeInfo info, @NotNull GoVarSpec oldVarSpec) {
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(29);
        }
        if (oldVarSpec == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(30);
        }
        StringBuilder builder = new StringBuilder();
        List<GoVarDefinition> variables = oldVarSpec.getVarDefinitionList();
        GoParameterInfo[] resultParameters = info.getNewResultParameters();
        if (GoChangeSignatureUsageProcessor.match(resultParameters, variables.size(), info.getOldResultParametersLength())) {
            return;
        }
        GoChangeSignatureUsageProcessor.appendParameters(builder, resultParameters, variables, (Function<GoParameterInfo, String>)((Function)__ -> "_"), false);
        GoVarDeclaration newDeclaration = GoElementFactory.createVarDeclaration(info.getProject(), builder.toString());
        GoVarSpec newVarSpec = Objects.requireNonNull((GoVarSpec)ContainerUtil.getFirstItem(newDeclaration.getSpecList()));
        PsiElement oldAssign = oldVarSpec instanceof GoShortVarDeclaration ? ((GoShortVarDeclaration)oldVarSpec).getVarAssign() : Objects.requireNonNull(oldVarSpec.getAssign());
        oldVarSpec.deleteChildRange(oldVarSpec.getFirstChild(), oldAssign.getPrevSibling());
        oldVarSpec.addRangeBefore(newVarSpec.getFirstChild(), newVarSpec.getLastChild(), oldAssign);
    }

    private static void updateAssignment(@NotNull GoMethodChangeInfo info, @NotNull GoAssignmentStatement assignment) {
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(31);
        }
        if (assignment == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(32);
        }
        StringBuilder builder = new StringBuilder();
        List<GoExpression> variables = assignment.getLeftHandExprList().getExpressionList();
        GoParameterInfo[] resultParameters = info.getNewResultParameters();
        if (GoChangeSignatureUsageProcessor.match(resultParameters, variables.size(), info.getOldResultParametersLength())) {
            return;
        }
        GoChangeSignatureUsageProcessor.appendParameters(builder, resultParameters, variables, (Function<GoParameterInfo, String>)((Function)__ -> "_"), false);
        GoAssignmentStatement newAssignment = GoElementFactory.createAssignmentStatement(info.getProject(), builder.toString(), "a()");
        assignment.getLeftHandExprList().replace(newAssignment.getLeftHandExprList());
    }

    private static void appendParameters(@NotNull StringBuilder builder, GoParameterInfo @NotNull [] parameters, @NotNull List<? extends PsiElement> expressions, @NotNull Function<GoParameterInfo, String> defaultValueProvider, boolean preserveTrailingComma) {
        if (builder == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(33);
        }
        if (expressions == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(34);
        }
        if (defaultValueProvider == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(35);
        }
        if (parameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(36);
        }
        for (GoParameterInfo parameter : parameters) {
            int oldIndex = parameter.getOldIndex();
            if (oldIndex == -1) {
                if (parameter.isVariadic()) continue;
                builder.append((String)defaultValueProvider.fun((Object)parameter)).append(", ");
                continue;
            }
            if (expressions.size() <= oldIndex) continue;
            PsiElement expression = expressions.get(oldIndex);
            builder.append(expression.getText()).append(", ");
            if (!parameter.isVariadic()) continue;
            PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)expression);
            if (PsiUtilCore.getElementType((PsiElement)element) == GoTypes.TRIPLE_DOT) {
                GoChangeSignatureUsageProcessor.trimCommaAndSpace(builder, false);
                builder.append("..., ");
                continue;
            }
            for (int i = oldIndex + 1; i < expressions.size(); ++i) {
                builder.append(expressions.get(i).getText()).append(", ");
            }
        }
        if (parameters.length > 0) {
            GoChangeSignatureUsageProcessor.trimCommaAndSpace(builder, preserveTrailingComma);
        }
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        GoMethodChangeInfo info = (GoMethodChangeInfo)ObjectUtils.tryCast((Object)changeInfo, GoMethodChangeInfo.class);
        if (info == null) {
            return false;
        }
        GoChangeSignatureUsageProcessor.processPrimaryMethod(info, info.getMethod());
        return true;
    }

    private static void processPrimaryMethod(@NotNull GoMethodChangeInfo info, @NotNull GoNamedSignatureOwner method) {
        PsiElement rBrace;
        GoBlock block;
        GoResult result;
        if (info == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(37);
        }
        if (method == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(38);
        }
        if (info.isNameChanged()) {
            method.setName(info.getNewName());
        }
        GoSignature signature = Objects.requireNonNull(method.getSignature());
        if (info.isResultParameterSetOrOrderChanged() && ((result = signature.getResult()) == null || GoChangeSignatureUsageProcessor.isEmpty(result)) && (block = method.getBlockIfExists()) != null && (rBrace = block.getRbrace()) != null && !(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)rBrace) instanceof GoReturnStatement)) {
            block.addBefore(GoElementFactory.createReturnStatement(info.getProject(), ""), rBrace);
        }
        if (info.isResultParameterTypesChanged() || info.isResultParameterSetOrOrderChanged()) {
            GoParameterInfo[] resultParameters = info.getNewResultParameters();
            DefaultValueTextProvider defaultValueTextProvider = new DefaultValueTextProvider(method, true);
            ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)method)).forceIgnore(GoFunctionLit.class::isInstance)).filter(GoReturnStatement.class).forEach(oldReturn -> {
                if (!PsiTreeUtil.isAncestor((PsiElement)info.getLocationToSkip(), (PsiElement)oldReturn, (boolean)false)) {
                    List<GoExpression> expressions = oldReturn.getExpressionList();
                    if (GoChangeSignatureUsageProcessor.isNakedReturn(expressions, method) || GoChangeSignatureUsageProcessor.isRecursiveCall(expressions, method) || GoChangeSignatureUsageProcessor.isMultiReturn(expressions) || GoChangeSignatureUsageProcessor.match(resultParameters, expressions.size(), info.getOldResultParametersLength())) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder();
                    GoChangeSignatureUsageProcessor.appendParameters(builder, resultParameters, expressions, defaultValueTextProvider, false);
                    GoFormatterUtil.reformat(oldReturn.replace(GoElementFactory.createReturnStatement(info.getProject(), builder.toString())));
                }
            });
        }
        if (info.isAnyParameterChanged()) {
            boolean inheritor = info.getMethod() != method;
            boolean reuseTypes = info.isReuseTypes();
            HashSet<String> namesToExclude = new HashSet<String>();
            TypeTextProvider typeTextProvider = new TypeTextProvider(method);
            StringBuilder typeParams = new StringBuilder();
            GoTypeParameters typeParameters = signature.getTypeParameters();
            if (typeParameters != null) {
                for (GoTypeParameterDeclaration declaration : typeParameters.getTypeParameterDeclarationList()) {
                    typeParams.append(declaration.getText()).append(", ");
                }
                GoChangeSignatureUsageProcessor.trimCommaAndSpace(typeParams, false);
            }
            StringBuilder params = new StringBuilder();
            NameProvider nameProvider = new NameProvider(inheritor, method, signature.getParameters(), namesToExclude);
            GoChangeSignatureUsageProcessor.appendParameters(params, info.getNewParameters(), nameProvider, typeTextProvider, info.hasParameterTrailingComma(), reuseTypes);
            StringBuilder result2 = new StringBuilder();
            GoParameters resultParams = (GoParameters)ObjectUtils.doIfNotNull((Object)signature.getResult(), GoResult::getParameters);
            NameProvider resultNameProvider = new NameProvider(inheritor, method, resultParams, namesToExclude);
            GoParameterInfo[] resultParameters = info.getNewResultParameters();
            GoParameterInfo onlyResultParameter = (GoParameterInfo)ContainerUtil.getOnlyItem(Arrays.asList(resultParameters));
            if (onlyResultParameter != null && StringUtil.isEmpty((String)((String)resultNameProvider.fun(onlyResultParameter)))) {
                result2.append(typeTextProvider.fun(onlyResultParameter));
            } else {
                GoChangeSignatureUsageProcessor.appendParameters(result2, resultParameters, resultNameProvider, typeTextProvider, info.hasResultParameterTrailingComma(), reuseTypes);
            }
            GoSignature newSignature = GoElementFactory.createFunctionSignatureFromText(info.getProject(), typeParams.toString(), params.toString(), result2.toString());
            GoFormatterUtil.reformat(signature.replace(newSignature));
        }
    }

    private static boolean match(GoParameterInfo @NotNull [] parameters, int argumentsLength, int oldParametersLength) {
        if (parameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(39);
        }
        return parameters.length == argumentsLength && oldParametersLength != argumentsLength && GoChangeSignatureUsageProcessor.isEitherAddOrRemove(parameters);
    }

    private static boolean isEitherAddOrRemove(GoParameterInfo @NotNull [] parameters) {
        if (parameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(40);
        }
        int i = 0;
        boolean add = false;
        boolean remove = false;
        for (GoParameterInfo parameter : parameters) {
            int oldIndex = parameter.getOldIndex();
            if (oldIndex == -1) {
                add = true;
                continue;
            }
            if (oldIndex >= i) {
                if (oldIndex > i) {
                    remove = true;
                }
                i = oldIndex + 1;
                continue;
            }
            return false;
        }
        return add ^ remove;
    }

    private static boolean isEmpty(@NotNull GoResult result) {
        if (result == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(41);
        }
        if (result.getType() == null) {
            GoParameters parameters = result.getParameters();
            return parameters == null || parameters.getParameterDeclarationList().isEmpty();
        }
        return false;
    }

    private static boolean isNakedReturn(@NotNull List<GoExpression> expressions, @NotNull GoNamedSignatureOwner method) {
        if (expressions == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(42);
        }
        if (method == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(43);
        }
        if (expressions.size() != 0) {
            return false;
        }
        GoParameters parameters = (GoParameters)ObjectUtils.doIfNotNull((Object)method.getResult(), GoResult::getParameters);
        return parameters != null && parameters.getDefinitionList().size() > 0;
    }

    private static boolean isRecursiveCall(@NotNull List<GoExpression> expressions, @NotNull GoNamedSignatureOwner method) {
        if (expressions == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(44);
        }
        if (method == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(45);
        }
        return GoChangeSignatureUtil.resolveMethodFromCall((GoExpression)ContainerUtil.getOnlyItem(expressions)) == method;
    }

    private static boolean isMultiReturn(@NotNull List<GoExpression> expressions) {
        GoExpression expression;
        if (expressions == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(46);
        }
        if ((expression = (GoExpression)ContainerUtil.getOnlyItem(expressions)) == null) {
            return false;
        }
        GoType type2 = expression.getGoUnderlyingType(null);
        return GoTypeUtil.getListOfTypesFromTypeList(type2).size() > 1;
    }

    public static void appendParameters(@NotNull StringBuilder builder, GoParameterInfo @NotNull [] parameters, @NotNull Function<? super GoParameterInfo, String> nameProvider, @NotNull Function<? super GoParameterInfo, String> typeProvider, boolean preserveTrailingComma, boolean reuseTypes) {
        if (builder == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(47);
        }
        if (nameProvider == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(48);
        }
        if (typeProvider == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(49);
        }
        if (parameters == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(50);
        }
        List mappedParameters = ContainerUtil.map((Object[])parameters, parameter -> new NameTypeVariadic((String)nameProvider.fun(parameter), (String)typeProvider.fun(parameter), parameter.isVariadic()));
        for (int i = 0; i < mappedParameters.size(); ++i) {
            NameTypeVariadic parameter2 = (NameTypeVariadic)mappedParameters.get(i);
            String name = parameter2.name;
            String typeText = GoChangeSignatureUsageProcessor.tryReusingType(reuseTypes, parameter2, (NameTypeVariadic)ContainerUtil.getOrElse((List)mappedParameters, (int)(i + 1), null));
            if (StringUtil.isNotEmpty((String)name)) {
                builder.append(name);
                if (StringUtil.isNotEmpty((String)typeText)) {
                    builder.append(' ');
                }
            }
            if (StringUtil.isNotEmpty((String)typeText)) {
                builder.append(typeText);
            }
            builder.append(", ");
        }
        if (parameters.length > 0) {
            GoChangeSignatureUsageProcessor.trimCommaAndSpace(builder, preserveTrailingComma);
        }
    }

    @NotNull
    private static String tryReusingType(boolean reuseTypes, @NotNull NameTypeVariadic curr, @Nullable NameTypeVariadic next) {
        if (curr == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(51);
        }
        String string = reuseTypes && GoChangeSignatureUsageProcessor.canReuseType(curr, next) ? "" : curr.type;
        if (string == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(52);
        }
        return string;
    }

    public static boolean canReuseType(@NotNull NameTypeVariadic curr, @Nullable NameTypeVariadic next) {
        if (curr == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(53);
        }
        return StringUtil.isNotEmpty((String)curr.name) && next != null && !next.variadic && !curr.type.isEmpty() && curr.type.equals(next.type);
    }

    static void trimCommaAndSpace(StringBuilder builder, boolean preserveTrailingComma) {
        StringUtil.trimEnd((StringBuilder)builder, (CharSequence)" ");
        if (!preserveTrailingComma) {
            StringUtil.trimEnd((StringBuilder)builder, (CharSequence)",");
        }
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        Project project;
        if (changeInfo instanceof GoMethodChangeInfo) {
            GoMethodChangeInfo methodChangeInfo = (GoMethodChangeInfo)changeInfo;
            project = methodChangeInfo.getProject();
        } else {
            project = null;
        }
        Project project2 = project;
        return project2 != null && UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)project2);
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<? super ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(54);
        }
    }

    @NotNull
    public static String convertToText(@NotNull GoType type2, @NotNull GoFile file) {
        if (type2 == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(55);
        }
        if (file == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(56);
        }
        GoRefactoringUtil.TypeTextWithImports textWithImports = GoRefactoringUtil.getTypeTextWithImports(file, type2);
        GoImportList importList = Objects.requireNonNull(file.getImportList());
        textWithImports.imports.forEach(i -> importList.addImport(i.getImportPath(), i.getAlias()));
        String string = textWithImports.typeText;
        if (string == null) {
            GoChangeSignatureUsageProcessor.$$$reportNull$$$0(57);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$findUsages$0(List methods, List usages, GoNamedSignatureOwner inheritor) {
        ProgressManager.checkCanceled();
        if (GoChangeSignatureHandler.canBeModified(inheritor.getContainingFile())) {
            methods.add(inheritor);
            usages.add(new GoInheritorUsageInfo(inheritor));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 9, 10, 26, 52, 57 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 26: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 38: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: 
            case 36: 
            case 39: 
            case 40: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldVarSpec";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 34: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueProvider";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProvider";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curr";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findConflicts";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "prependWithParameter";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "tryReusingType";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 26: 
            case 52: 
            case 57: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMethodUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParameterUsages";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMethodNameConflicts";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findParameterNameConflicts";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findParametersListConflict";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateArguments";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handleMethodExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "prependWithParameter";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeAssignment";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateVariables";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateAssignment";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "appendParameters";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processPrimaryMethod";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isEitherAddOrRemove";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isNakedReturn";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveCall";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isMultiReturn";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "tryReusingType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "canReuseType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerConflictResolvers";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "convertToText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 9, 10, 26, 52, 57 -> new IllegalStateException(string);
        };
    }

    static final class GoInheritorUsageInfo
    extends UsageInfo {
        private GoInheritorUsageInfo(@NotNull GoNamedSignatureOwner inheritor) {
            if (inheritor == null) {
                GoInheritorUsageInfo.$$$reportNull$$$0(0);
            }
            super((PsiElement)inheritor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$GoInheritorUsageInfo", "<init>"));
        }
    }

    private static final class GoMethodUsageInfo
    extends UsageInfo {
        private GoMethodUsageInfo(@NotNull PsiReference reference) {
            if (reference == null) {
                GoMethodUsageInfo.$$$reportNull$$$0(0);
            }
            super(reference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$GoMethodUsageInfo", "<init>"));
        }
    }

    private static final class GoParameterUsageInfo
    extends UsageInfo {
        private final GoParameterInfo myParameter;

        private GoParameterUsageInfo(@NotNull PsiReference reference, @NotNull GoParameterInfo parameter) {
            if (reference == null) {
                GoParameterUsageInfo.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                GoParameterUsageInfo.$$$reportNull$$$0(1);
            }
            super(reference);
            this.myParameter = parameter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$GoParameterUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultValueTextProvider
    implements Function<GoParameterInfo, String> {
        private final GoFile myContext;
        private final boolean myInResult;

        private DefaultValueTextProvider(@NotNull PsiElement context, boolean inResult) {
            if (context == null) {
                DefaultValueTextProvider.$$$reportNull$$$0(0);
            }
            this.myContext = (GoFile)((Object)ObjectUtils.tryCast((Object)context.getContainingFile(), GoFile.class));
            this.myInResult = inResult;
        }

        @NotNull
        public String fun(@NotNull GoParameterInfo parameter) {
            GoExpression expression;
            if (parameter == null) {
                DefaultValueTextProvider.$$$reportNull$$$0(1);
            }
            if ((expression = parameter.getDefaultValueExpression()) != null) {
                String string = GoReferenceConverter.on(expression, this.myContext).getText();
                if (string == null) {
                    DefaultValueTextProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
            String name = parameter.getName();
            if (this.myInResult && StringUtil.isNotEmpty((String)name)) {
                String string = name;
                if (string == null) {
                    DefaultValueTextProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            GoType type2 = parameter.getType();
            if (GoTypeUtil.isVoid(type2)) {
                return "nil";
            }
            return type2 != null ? StringUtil.notNullize((String)GoZeroValue.of(type2).getText()) : "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$DefaultValueTextProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$DefaultValueTextProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class TypeTextProvider
    implements Function<GoParameterInfo, String> {
        private final GoFile myContext;

        private TypeTextProvider(@NotNull GoNamedSignatureOwner method) {
            if (method == null) {
                TypeTextProvider.$$$reportNull$$$0(0);
            }
            this.myContext = method.getContainingFile();
        }

        @NotNull
        public String fun(@NotNull GoParameterInfo parameter) {
            if (parameter == null) {
                TypeTextProvider.$$$reportNull$$$0(1);
            }
            GoType type2 = parameter.getType();
            String string = (parameter.isVariadic() ? "..." : "") + (type2 != null ? GoChangeSignatureUsageProcessor.convertToText(type2, this.myContext) : "");
            if (string == null) {
                TypeTextProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$TypeTextProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$TypeTextProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class NameProvider
    implements Function<GoParameterInfo, String> {
        private final boolean myInheritor;
        private final GoNamedSignatureOwner myMethod;
        private final GoParameters myParameters;
        private final boolean myNamed;
        private final Set<String> myNamesToExclude;

        private NameProvider(boolean inheritor, @NotNull GoNamedSignatureOwner method, @Nullable GoParameters parameters, @NotNull Set<String> namesToExclude) {
            if (method == null) {
                NameProvider.$$$reportNull$$$0(0);
            }
            if (namesToExclude == null) {
                NameProvider.$$$reportNull$$$0(1);
            }
            this.myInheritor = inheritor;
            this.myMethod = method;
            this.myParameters = parameters;
            this.myNamed = parameters != null && !parameters.getDefinitionList().isEmpty();
            this.myNamesToExclude = namesToExclude;
        }

        @NotNull
        public String fun(@NotNull GoParameterInfo parameter) {
            if (parameter == null) {
                NameProvider.$$$reportNull$$$0(2);
            }
            if (!this.myInheritor) {
                String string = parameter.getName();
                if (string == null) {
                    NameProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (this.myNamed) {
                String name = parameter.getName();
                if (StringUtil.isNotEmpty((String)name)) {
                    String string = name;
                    if (string == null) {
                        NameProvider.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                name = this.getExistingName(parameter.getOldIndex());
                if (StringUtil.isNotEmpty((String)name)) {
                    String string = name;
                    if (string == null) {
                        NameProvider.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                name = this.generateUniqueName(parameter.getType());
                if (StringUtil.isNotEmpty((String)name)) {
                    String string = name;
                    if (string == null) {
                        NameProvider.$$$reportNull$$$0(6);
                    }
                    return string;
                }
            }
            return "";
        }

        @Nullable
        private String getExistingName(int index) {
            return (String)ObjectUtils.doIfNotNull((Object)this.myParameters.getDefinitionByIndex(index), NavigationItem::getName);
        }

        @Nullable
        private String generateUniqueName(@Nullable GoType type2) {
            if (type2 != null) {
                GoFakeTypeOwner typeOwner;
                String name;
                HashSet<String> namesToExclude = new HashSet<String>(this.myNamesToExclude);
                GoBlock block = this.myMethod.getBlockIfExists();
                if (block != null) {
                    namesToExclude.addAll(GoNameSuggestionProvider.getNamesInContext(block.getFirstChild()));
                }
                if (StringUtil.isNotEmpty((String)(name = (String)ContainerUtil.getFirstItem(GoNameSuggestionProvider.getSuggestedNames(typeOwner = new GoFakeTypeOwner(this.myParameters.getManager(), type2, this.myParameters.getContainingFile()), this.myParameters, new GoNameSuggestionProvider.Settings(namesToExclude)))))) {
                    this.myNamesToExclude.add(name);
                    return name;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namesToExclude";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$NameProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$NameProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static final class NameTypeVariadic {
        private final String name;
        private final String type;
        private final boolean variadic;

        public NameTypeVariadic(@Nullable String name, @NotNull String type2, boolean variadic) {
            if (type2 == null) {
                NameTypeVariadic.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type2;
            this.variadic = variadic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/goide/refactor/changeSignature/GoChangeSignatureUsageProcessor$NameTypeVariadic", "<init>"));
        }
    }
}

