/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor;

import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.GoReceiverNamesInspection;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStructType;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNamesValidator;
import com.goide.util.GoStdlibUtil;
import com.google.common.collect.Sets;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoNameSuggestionProvider
implements NameSuggestionProvider {
    @NotNull
    public SuggestedNameInfo getSuggestedNames(@Nullable PsiElement element, @Nullable PsiElement context, @NotNull Set<String> result) {
        if (result == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof GoTypeOwner) {
            result.addAll(GoNameSuggestionProvider.getSuggestedNames((GoTypeOwner)element, context));
        }
        SuggestedNameInfo suggestedNameInfo = SuggestedNameInfo.NULL_INFO;
        if (suggestedNameInfo == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(1);
        }
        return suggestedNameInfo;
    }

    @NotNull
    public static LinkedHashSet<String> getSuggestedNames(@NotNull GoTypeOwner o, @Nullable PsiElement context) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(2);
        }
        return GoNameSuggestionProvider.getSuggestedNames(o, context, Settings.DEFAULT);
    }

    @NotNull
    public static LinkedHashSet<String> getSuggestedNames(@NotNull GoTypeOwner o, @Nullable PsiElement context, @NotNull Settings settings) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(4);
        }
        if (o instanceof GoReceiver) {
            return GoNameSuggestionProvider.getSuggestedNamesForReceiver(o, context, settings);
        }
        if (o instanceof GoImportSpec || o instanceof GoTypeSpec || o instanceof GoLabelDefinition) {
            return GoNameSuggestionProvider.getSuggestedNamesForNamedElementWithoutType((GoNamedElement)o, context, settings);
        }
        if (o instanceof GoNamedSignatureOwner) {
            return GoNameSuggestionProvider.getSuggestedNamesForSignatureOwner((GoNamedElement)o, context, settings);
        }
        if (o instanceof GoVarOrConstDefinition || o instanceof GoFieldDefinition || o instanceof GoParamDefinition) {
            return GoNameSuggestionProvider.getSuggestedNamesForDefinition((GoNamedElement)o, context, settings);
        }
        return GoNameSuggestionProvider.getSuggestedNamesForExpression(o, context, settings);
    }

    @NotNull
    public static LinkedHashSet<String> getSuggestedNamesForReceiver(@NotNull GoTypeOwner o, @Nullable PsiElement context) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(5);
        }
        return GoNameSuggestionProvider.getSuggestedNamesForReceiver(o, context, Settings.DEFAULT);
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestedNamesForReceiver(@NotNull GoTypeOwner o, @Nullable PsiElement context, @NotNull Settings settings) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(7);
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        Set<String> excluded = GoNameSuggestionProvider.applySettings(GoNameSuggestionProvider.getNamesInContext(context), settings);
        Set<String> receiversNames = GoPsiImplUtil.getReceiversNames(GoPsiImplUtil.getTypeSpecFromReceiver(o), false);
        GoType type2 = o.getGoType(null);
        String fromTypeName = (String)ContainerUtil.getFirstItem(GoNameSuggestionProvider.getSuggestionsFromName(GoNameSuggestionProvider.getTypeName(type2), false, false, Settings.DEFAULT_OPTIONS));
        String firstLetter = StringUtil.isNotEmpty((String)fromTypeName) ? fromTypeName.substring(0, 1) : "";
        GoNameSuggestionProvider.addAllValid(suggestions, (Set<String>)Sets.union(excluded, GoReceiverNamesInspection.GENERIC_NAMES_SET), ContainerUtil.concat(receiversNames, Collections.singleton(firstLetter)));
        GoNameSuggestionProvider.addDummyNameIfNeeded(suggestions, null, type2, excluded, false, settings.options);
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> applySettings(@NotNull Set<String> namesInContext, @NotNull Settings settings) {
        if (namesInContext == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(10);
        }
        Sets.SetView setView = Sets.difference((Set)Sets.union(namesInContext, settings.excludedNames), settings.allowedNames);
        if (setView == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(11);
        }
        return setView;
    }

    private static void addAllValid(@NotNull LinkedHashSet<String> result, @NotNull Set<String> excluded, @NotNull Iterable<String> candidates) {
        if (result == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(12);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(13);
        }
        if (candidates == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(14);
        }
        Sets.SetView allExcluded = Sets.union(result, excluded);
        for (String candidate : candidates) {
            if (!GoNameSuggestionProvider.isValidName(candidate, (Set<String>)allExcluded)) continue;
            result.add(candidate);
        }
    }

    private static boolean isValidName(@Nullable String name, @NotNull Set<String> excluded) {
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(15);
        }
        return StringUtil.isNotEmpty((String)name) && !"_".equals(name) && !excluded.contains(name) && GoNamesValidator.INSTANCE.isIdentifier(name, null);
    }

    @NotNull
    private static List<String> getSuggestionsFromName(@Nullable String name, boolean capitalize, boolean pluralize, @NotNull EnumSet<Option> options) {
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)name) || options.contains((Object)Option.DO_NOT_SUGGEST_NAMES_BASED_ON_INITIAL_NAME)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GoNameSuggestionProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        LinkedHashSet suggestions = new LinkedHashSet(NameUtil.getSuggestionsByName((String)name, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)pluralize));
        List list = ContainerUtil.map(suggestions, n -> capitalize ? StringUtil.capitalize((String)n) : n);
        if (list == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static void addDummyNameIfNeeded(@NotNull LinkedHashSet<String> suggestions, @Nullable String name, @Nullable GoType type2, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(19);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(20);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(21);
        }
        if (suggestions.isEmpty() && !options.contains((Object)Option.DO_NOT_SUGGEST_DUMMY_NAMES)) {
            String nameOrType;
            String nameFirstLetter;
            name = StringUtil.notNullize((String)name);
            name = capitalize ? StringUtil.capitalize((String)name) : StringUtil.decapitalize((String)name);
            String string = nameFirstLetter = StringUtil.isNotEmpty((String)name) ? name.substring(0, 1) : "";
            if (GoNameSuggestionProvider.isValidName(nameFirstLetter, excluded)) {
                suggestions.add(nameFirstLetter);
                return;
            }
            String typeFistLetter = GoNameSuggestionProvider.getFirstLetter(type2);
            String string2 = typeFistLetter = capitalize ? StringUtil.capitalize((String)typeFistLetter) : StringUtil.decapitalize((String)typeFistLetter);
            if (GoNameSuggestionProvider.isValidName(typeFistLetter, excluded)) {
                suggestions.add(typeFistLetter);
                return;
            }
            String string3 = !name.isEmpty() ? name : (nameOrType = !typeFistLetter.isEmpty() ? typeFistLetter : "");
            if (GoNameSuggestionProvider.isValidName(nameOrType, Collections.emptySet())) {
                suggestions.add(UniqueNameGenerator.generateUniqueName((String)nameOrType, excluded));
                return;
            }
            suggestions.add(UniqueNameGenerator.generateUniqueName((String)(capitalize ? "I" : "i"), excluded));
        }
    }

    @NotNull
    private static String getFirstLetter(@Nullable GoType type2) {
        GoType unwrapped = GoPsiImplUtil.unwrapPointerIfNeeded(type2);
        String text = unwrapped != null ? unwrapped.getPresentationText() : "";
        return StringUtil.isNotEmpty((String)text) ? text.substring(0, 1) : "";
    }

    private static String getTypeName(@Nullable GoType type2) {
        if ((type2 = GoPsiImplUtil.unwrapPointerIfNeeded(type2)) instanceof GoSpecType) {
            return ((GoSpecType)type2).getIdentifier().getText();
        }
        if (GoTypeUtil.isNamedType(type2)) {
            return type2.getText();
        }
        return "";
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestedNamesForNamedElementWithoutType(@NotNull GoNamedElement o, @Nullable PsiElement context, @NotNull Settings settings) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(22);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(23);
        }
        assert (PsiTreeUtil.instanceOf((Object)o, (Class[])new Class[]{GoImportSpec.class, GoLabelDefinition.class, GoTypeSpec.class}));
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        Set<String> excluded = GoNameSuggestionProvider.applySettings(GoNameSuggestionProvider.getExcludedNamesInContext(o, context), settings);
        boolean capitalize = o.isPublic() && !(o instanceof GoImportSpec);
        String name = o.getName();
        List<String> fromName = GoNameSuggestionProvider.getSuggestionsFromName(name, capitalize, false, Settings.DEFAULT_OPTIONS);
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, fromName);
        if (o instanceof GoImportSpec) {
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)o.getProject());
            TreeSet<String> aliases = new TreeSet<String>(GoImportPathToAliasIndexKt.getAliasesByImportPath(scope, ((GoImportSpec)o).getPath()));
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, aliases);
            GoNameSuggestionProvider.addSameNameWithNumberIfNeeded(suggestions, (String)ObjectUtils.notNull((Object)name, (Object)"alias"), excluded, settings.options);
        } else {
            GoNameSuggestionProvider.addDummyNameIfNeeded(suggestions, (String)ContainerUtil.getFirstItem(fromName), null, excluded, capitalize, settings.options);
        }
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(24);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> getExcludedNamesInContext(@NotNull GoTypeOwner o, @Nullable PsiElement context) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(25);
        }
        if (o instanceof GoLabelDefinition) {
            return GoNameSuggestionProvider.getLabelNames(context);
        }
        Sets.SetView namesInContext = GoNameSuggestionProvider.getNamesInContext(context);
        Sets.SetView setView = o instanceof GoMethodDeclaration ? Sets.union(namesInContext, GoNameSuggestionProvider.getOtherMethodNames((GoMethodDeclaration)o)) : namesInContext;
        if (setView == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(26);
        }
        return setView;
    }

    @NotNull
    private static Set<String> getLabelNames(@Nullable PsiElement context) {
        GoSignatureOwner scope = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)context, GoSignatureOwner.class);
        if (scope == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoNameSuggestionProvider.$$$reportNull$$$0(27);
            }
            return set;
        }
        Set set = ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)scope)).forceIgnore(GoFunctionLit.class::isInstance)).filter(GoLabelDefinition.class).map(NavigationItem::getName).filter(Objects::nonNull).toSet();
        if (set == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    private static Set<String> getOtherMethodNames(@NotNull GoMethodDeclaration methodDeclaration) {
        GoReceiver receiver;
        GoTypeSpec typeSpec;
        if (methodDeclaration == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(29);
        }
        List<Object> methods = (typeSpec = GoPsiImplUtil.getTypeSpecFromReceiver(receiver = methodDeclaration.getReceiver())) != null ? typeSpec.getMethods() : Collections.emptyList();
        Set set = ContainerUtil.map2SetNotNull(methods, NavigationItem::getName);
        if (set == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(30);
        }
        return set;
    }

    private static void addSameNameWithNumberIfNeeded(@NotNull LinkedHashSet<String> suggestions, @NotNull String name, @NotNull Set<String> excluded, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(31);
        }
        if (name == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(32);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(33);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(34);
        }
        if (suggestions.isEmpty() && !options.contains((Object)Option.DO_NOT_SUGGEST_DUMMY_NAMES)) {
            suggestions.add(UniqueNameGenerator.generateUniqueName((String)name, excluded));
        }
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestedNamesForSignatureOwner(@NotNull GoNamedElement o, @Nullable PsiElement context, @NotNull Settings settings) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(35);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(36);
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        Set<String> excluded = GoNameSuggestionProvider.applySettings(GoNameSuggestionProvider.getExcludedNamesInContext(o, context), settings);
        boolean capitalize = o.isPublic();
        List<String> fromName = GoNameSuggestionProvider.getSuggestionsFromName(o.getName(), capitalize, false, settings.options);
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, fromName);
        GoType type2 = (GoType)ContainerUtil.getFirstItem(GoTypeUtil.getListOfTypesFromTypeList(((GoNamedSignatureOwner)o).getResultType()));
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromType(type2, capitalize));
        GoNameSuggestionProvider.addDummyNameIfNeeded(suggestions, (String)ContainerUtil.getFirstItem(fromName), type2, excluded, capitalize, settings.options);
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestedNamesForDefinition(@NotNull GoNamedElement o, @Nullable PsiElement context, @NotNull Settings settings) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(38);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(39);
        }
        assert (PsiTreeUtil.instanceOf((Object)o, (Class[])new Class[]{GoFieldDefinition.class, GoParamDefinition.class, GoVarDefinition.class, GoConstDefinition.class}));
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        Set<String> excluded = GoNameSuggestionProvider.applySettings(GoNameSuggestionProvider.getExcludedNamesInContext(o, context), settings);
        GoNameSuggestionProvider.addSuggestionsForDefinition(suggestions, o, context, excluded, o.isPublic(), settings.options);
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    private static void addSuggestionsForDefinition(@NotNull LinkedHashSet<String> suggestions, @NotNull GoNamedElement o, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(41);
        }
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(42);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(43);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(44);
        }
        GoNameSuggestionProvider.addSuggestionsForDefinition(suggestions, o, Collections.emptySet(), context, excluded, capitalize, options);
    }

    private static void addSuggestionsForDefinition(@NotNull LinkedHashSet<String> suggestions, @NotNull GoNamedElement o, @NotNull Set<String> additionalNames, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        GoType type2;
        String commonName;
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(45);
        }
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(46);
        }
        if (additionalNames == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(47);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(48);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(49);
        }
        if ((commonName = GoNameSuggestionProvider.getCommonName(type2 = GoTypeUtil.getDefaultType(o.getGoType(null)), context, capitalize)) != null) {
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, Collections.singleton(commonName));
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromName(o.getName(), capitalize, false, options));
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, additionalNames);
            GoNameSuggestionProvider.addDummyCommonNameIfNeeded(suggestions, commonName, excluded, capitalize, options);
            return;
        }
        List<String> fromName = GoNameSuggestionProvider.getSuggestionsFromName(o.getName(), capitalize, false, options);
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, fromName);
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, additionalNames);
        PsiElement parent = o.getParent();
        if (o instanceof GoVarDefinition && parent instanceof GoRangeClause) {
            GoRangeClause rangeClause = (GoRangeClause)parent;
            GoExpression container = rangeClause.getRangeExpression();
            if (container instanceof GoReferenceExpression) {
                GoType underlyingType;
                GoType containerType = container.getGoType(null);
                GoType goType = underlyingType = containerType != null ? containerType.getUnderlyingType(context) : null;
                if (underlyingType instanceof GoChannelType || underlyingType instanceof GoArrayOrSliceType && rangeClause.getVarDefinitionList().indexOf(o) == 1) {
                    List fromContainerName = ContainerUtil.map(GoNameSuggestionProvider.getSuggestionsFromReference(container, capitalize, GoNameSuggestionProvider.remove(options, Option.DO_NOT_SUGGEST_NAMES_BASED_ON_INITIAL_NAME)), StringUtil::unpluralize);
                    GoNameSuggestionProvider.addAllValid(suggestions, excluded, fromContainerName);
                }
            }
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromType(type2, capitalize));
        } else if (o instanceof GoVarOrConstDefinition) {
            GoExpression initializer;
            if (GoNameSuggestionProvider.hasExplicitType((GoVarOrConstDefinition)o)) {
                GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromType(type2, capitalize));
            }
            if ((initializer = ((GoVarOrConstDefinition)o).findExpression()) != null) {
                GoNameSuggestionProvider.addSuggestionsForExpression(suggestions, initializer, context, excluded, capitalize, GoNameSuggestionProvider.add(options, Option.DO_NOT_SUGGEST_DUMMY_NAMES));
            }
        } else {
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromType(type2, capitalize));
        }
        GoNameSuggestionProvider.addDummyNameIfNeeded(suggestions, (String)ContainerUtil.getFirstItem(fromName), type2, excluded, capitalize, options);
    }

    @Nullable
    private static String getCommonName(@Nullable GoType type2, @Nullable PsiElement context, boolean capitalize) {
        if (GoTypeUtil.isError(type2, context)) {
            return capitalize ? "Err" : "err";
        }
        if (GoStdlibUtil.isStdLibType(type2, context, "context", "Context")) {
            return capitalize ? "Ctx" : "ctx";
        }
        return null;
    }

    private static void addDummyCommonNameIfNeeded(@NotNull LinkedHashSet<String> suggestions, @NotNull String commonName, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(50);
        }
        if (commonName == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(51);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(52);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(53);
        }
        if (suggestions.isEmpty() && !options.contains((Object)Option.DO_NOT_SUGGEST_DUMMY_NAMES)) {
            commonName = capitalize ? StringUtil.capitalize((String)commonName) : StringUtil.decapitalize((String)commonName);
            suggestions.add(UniqueNameGenerator.generateUniqueName((String)commonName, excluded));
        }
    }

    private static boolean hasExplicitType(@NotNull GoVarOrConstDefinition o) {
        GoVarOrConstSpec spec;
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(54);
        }
        return (spec = (GoVarOrConstSpec)PsiTreeUtil.getParentOfType((PsiElement)o, GoVarOrConstSpec.class)) != null && spec.getType() != null;
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestedNamesForExpression(@NotNull GoTypeOwner o, @Nullable PsiElement context, @NotNull Settings settings) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(55);
        }
        if (settings == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(56);
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        Set<String> excluded = GoNameSuggestionProvider.applySettings(GoNameSuggestionProvider.getExcludedNamesInContext(o, context), settings);
        GoNameSuggestionProvider.addSuggestionsForExpression(suggestions, o, context, excluded, false, settings.options);
        LinkedHashSet<String> linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(57);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<String> getSuggestionsFromType(@Nullable GoType type2, boolean capitalize) {
        PsiFile typeDeclarationFile = GoNameSuggestionProvider.getTypeDeclarationContainingFile(type2);
        if (typeDeclarationFile != null && !GoPsiImplUtil.isBuiltinFile(typeDeclarationFile)) {
            return GoNameSuggestionProvider.getSuggestionsFromName(GoNameSuggestionProvider.getTypeName(type2), capitalize, false, Settings.DEFAULT_OPTIONS);
        }
        if (type2 instanceof GoArrayOrSliceType) {
            GoArrayOrSliceType arrayOrSlice = (GoArrayOrSliceType)type2;
            return GoNameSuggestionProvider.getSuggestionsForCollection(arrayOrSlice.getType(), capitalize);
        }
        if (type2 instanceof GoChannelType) {
            return GoNameSuggestionProvider.getSuggestionsForCollection(((GoChannelType)type2).getType(), capitalize);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(58);
        }
        return list;
    }

    @Nullable
    private static PsiFile getTypeDeclarationContainingFile(@Nullable GoType type2) {
        GoTypeReferenceExpression reference = GoPsiImplUtil.findTypeReference(type2);
        GoType resolve2 = type2 instanceof GoSpecType ? type2 : (reference != null ? reference.resolve() : null);
        return resolve2 != null ? resolve2.getContainingFile() : null;
    }

    @NotNull
    private static List<String> getSuggestionsForCollection(@Nullable GoType elementType, boolean capitalize) {
        return GoNameSuggestionProvider.getSuggestionsFromName(GoNameSuggestionProvider.getTypeName(GoPsiImplUtil.unwrapPointerIfNeeded(elementType)), capitalize, true, Settings.DEFAULT_OPTIONS);
    }

    @NotNull
    private static EnumSet<Option> add(@NotNull EnumSet<Option> options, @NotNull Option option) {
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(59);
        }
        if (option == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(60);
        }
        Object optionsCopy = options.clone();
        ((AbstractCollection)optionsCopy).add(option);
        Object object = optionsCopy;
        if (object == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(61);
        }
        return object;
    }

    @NotNull
    private static EnumSet<Option> remove(@NotNull EnumSet<Option> options, @NotNull Option option) {
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(62);
        }
        if (option == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(63);
        }
        Object optionsCopy = options.clone();
        ((AbstractCollection)optionsCopy).remove((Object)option);
        Object object = optionsCopy;
        if (object == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(64);
        }
        return object;
    }

    private static void addSuggestionsForExpression(@NotNull LinkedHashSet<String> suggestions, @NotNull GoTypeOwner o, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(65);
        }
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(66);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(67);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(68);
        }
        if (o instanceof GoCallExpr) {
            List<LinkedHashSet<String>> forCall = GoNameSuggestionProvider.getSuggestionsForCall((GoCallExpr)o, context, (Set<String>)Sets.union(suggestions, excluded), capitalize, options);
            forCall.forEach(suggestions::addAll);
            return;
        }
        GoNameSuggestionProvider.addSuggestionsForNonCallExpression(suggestions, o, context, excluded, capitalize, options);
    }

    @NotNull
    public static List<LinkedHashSet<String>> getSuggestedNamesForCall(@NotNull GoCallExpr o, @Nullable PsiElement context) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(69);
        }
        return GoNameSuggestionProvider.getSuggestionsForCall(o, context, GoNameSuggestionProvider.getNamesInContext(context), false, Settings.DEFAULT_OPTIONS);
    }

    @NotNull
    private static List<LinkedHashSet<String>> getSuggestionsForCall(@NotNull GoCallExpr o, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(70);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(71);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(72);
        }
        if (GoPsiUtil.isConversionExpression(o)) {
            LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
            GoNameSuggestionProvider.addSuggestionsForNonCallExpression(suggestions, o, context, excluded, capitalize, options);
            List<LinkedHashSet<String>> list = Collections.singletonList(suggestions);
            if (list == null) {
                GoNameSuggestionProvider.$$$reportNull$$$0(73);
            }
            return list;
        }
        int resultCount = GoInspectionUtil.getExpressionResultCount(o);
        if (resultCount < 1) {
            LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
            GoNameSuggestionProvider.addDummyNameIfNeeded(suggestions, null, null, excluded, capitalize, options);
            List<LinkedHashSet<String>> list = Collections.singletonList(suggestions);
            if (list == null) {
                GoNameSuggestionProvider.$$$reportNull$$$0(74);
            }
            return list;
        }
        List<? extends PsiElement> resultParamsOrTypes = GoNameSuggestionProvider.getResultParametersOrTypes(o);
        List<LinkedHashSet<String>> suggestions = GoNameSuggestionProvider.newListOfEmptySets(resultCount);
        Sets.SetView allExcluded = excluded;
        for (int i = 0; i < resultParamsOrTypes.size(); ++i) {
            PsiElement paramOrType = resultParamsOrTypes.get(i);
            GoType type2 = paramOrType instanceof GoParamDefinition ? ((GoParamDefinition)paramOrType).getGoType(null) : (GoType)paramOrType;
            LinkedHashSet<String> namesFromCallReference = new LinkedHashSet<String>();
            if (i == 0 && !GoTypeUtil.isError(type2, context)) {
                GoNameSuggestionProvider.addAllValid(namesFromCallReference, allExcluded, GoNameSuggestionProvider.getSuggestionsFromCallReference(o, capitalize));
            }
            if (paramOrType instanceof GoParamDefinition) {
                GoNameSuggestionProvider.addExistingErrorNamesIfNeeded(suggestions.get(i), type2, context, options);
                GoNameSuggestionProvider.addSuggestionsForDefinition(suggestions.get(i), (GoParamDefinition)paramOrType, namesFromCallReference, context, allExcluded, capitalize, options);
            } else {
                GoNameSuggestionProvider.addAllValid(suggestions.get(0), allExcluded, namesFromCallReference);
                GoFakeTypeOwner typeOwner = new GoFakeTypeOwner(paramOrType.getManager(), type2, paramOrType.getContainingFile());
                GoNameSuggestionProvider.addSuggestionsForNonCallExpression(suggestions.get(i), typeOwner, context, allExcluded, capitalize, options);
            }
            allExcluded = Sets.union((Set)suggestions.get(i), allExcluded);
        }
        List<LinkedHashSet<String>> list = suggestions;
        if (list == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(75);
        }
        return list;
    }

    private static void addSuggestionsForNonCallExpression(@NotNull LinkedHashSet<String> suggestions, @NotNull GoTypeOwner o, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(76);
        }
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(77);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(78);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(79);
        }
        GoType type2 = GoTypeUtil.getDefaultType(o.getGoType(null));
        GoNameSuggestionProvider.addExistingErrorNamesIfNeeded(suggestions, type2, context, options);
        String commonName = GoNameSuggestionProvider.getCommonName(type2, context, capitalize);
        if (commonName != null) {
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, Collections.singleton(commonName));
            GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromReference(o, capitalize, options));
            GoNameSuggestionProvider.addDummyCommonNameIfNeeded(suggestions, commonName, excluded, capitalize, options);
            return;
        }
        List<String> fromName = GoNameSuggestionProvider.getSuggestionsFromReference(o, capitalize, options);
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, fromName);
        GoNameSuggestionProvider.addAllValid(suggestions, excluded, GoNameSuggestionProvider.getSuggestionsFromType(type2, capitalize));
        if (o.getParent() instanceof GoArgumentList) {
            GoNameSuggestionProvider.addSuggestionsForCallArgument(suggestions, (GoArgumentList)o.getParent(), o, context, excluded, capitalize, options);
        }
        if (o.getParent() instanceof GoValue) {
            GoNameSuggestionProvider.addSuggestionsForLiteralValue(suggestions, (GoValue)o.getParent(), context, excluded, capitalize, options);
        }
        GoNameSuggestionProvider.addDummyNameIfNeeded(suggestions, (String)ContainerUtil.getFirstItem(fromName), type2, excluded, capitalize, options);
    }

    private static void addExistingErrorNamesIfNeeded(@NotNull LinkedHashSet<String> suggestions, @Nullable GoType type2, @Nullable PsiElement context, @NotNull EnumSet<Option> options) {
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(80);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(81);
        }
        if (!options.contains((Object)Option.DO_NOT_SUGGEST_EXISTING_ERROR_NAMES) && GoTypeUtil.isError(type2, context)) {
            suggestions.addAll(GoNameSuggestionProvider.getErrorNames(context));
        }
    }

    @NotNull
    private static List<String> getSuggestionsFromReference(@NotNull GoTypeOwner o, boolean capitalize, @NotNull EnumSet<Option> options) {
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(82);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(83);
        }
        List<String> list = o instanceof GoReferenceExpression && !GoNameSuggestionProvider.isReferenceToBuiltin((GoReferenceExpression)o) ? GoNameSuggestionProvider.getSuggestionsFromName(o.getText(), capitalize, false, options) : Collections.emptyList();
        if (list == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(84);
        }
        return list;
    }

    private static boolean isReferenceToBuiltin(@NotNull GoReferenceExpression ref) {
        PsiElement resolve2;
        if (ref == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(85);
        }
        PsiFile file = (resolve2 = ref.resolve()) != null ? resolve2.getContainingFile() : null;
        return GoPsiImplUtil.isBuiltinFile(file);
    }

    private static void addSuggestionsForCallArgument(@NotNull LinkedHashSet<String> suggestions, @NotNull GoArgumentList arguments, @NotNull PsiElement argument, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        GoParamDefinition param;
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(86);
        }
        if (arguments == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(87);
        }
        if (argument == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(88);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(89);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(90);
        }
        if (options.contains((Object)Option.DO_NOT_SUGGEST_NAMES_BASED_ON_FUNC_PARAM_NAME)) {
            return;
        }
        int argIndex = arguments.getExpressionList().indexOf(argument);
        if (argIndex == -1) {
            return;
        }
        GoCallExpr call = (GoCallExpr)ObjectUtils.tryCast((Object)arguments.getParent(), GoCallExpr.class);
        GoSignatureOwner signatureOwner = call != null ? GoPsiImplUtil.resolveCall(call) : null;
        GoSignature signature = signatureOwner != null ? signatureOwner.getSignature() : null;
        GoParameters parameters = signature != null ? signature.getParameters() : null;
        GoParamDefinition goParamDefinition = param = parameters != null ? parameters.getDefinitionByIndex(argIndex) : null;
        if (param != null) {
            GoNameSuggestionProvider.addSuggestionsForDefinition(suggestions, param, context, excluded, capitalize, options);
        }
    }

    private static void addSuggestionsForLiteralValue(@NotNull LinkedHashSet<String> suggestions, @NotNull GoValue value, @Nullable PsiElement context, @NotNull Set<String> excluded, boolean capitalize, @NotNull EnumSet<Option> options) {
        GoElement element;
        GoNamedElement field;
        if (suggestions == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(91);
        }
        if (value == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(92);
        }
        if (excluded == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(93);
        }
        if (options == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(94);
        }
        if ((field = GoNameSuggestionProvider.findFieldDefinition(element = (GoElement)PsiTreeUtil.getParentOfType((PsiElement)value, GoElement.class))) != null) {
            GoNameSuggestionProvider.addSuggestionsForDefinition(suggestions, field, context, excluded, capitalize, options);
        }
    }

    @Nullable
    private static GoNamedElement findFieldDefinition(@Nullable GoElement element) {
        if (element == null) {
            return null;
        }
        GoKey key = element.getKey();
        if (key != null) {
            GoFieldName fieldName = key.getFieldName();
            return fieldName != null ? (GoNamedElement)ObjectUtils.tryCast((Object)fieldName.resolve(), GoFieldDefinition.class) : null;
        }
        GoLiteralValue literalValue = (GoLiteralValue)PsiTreeUtil.getParentOfType((PsiElement)element, GoLiteralValue.class);
        GoStructType type2 = GoInspectionUtil.findStructTypeForLiteralValue(literalValue);
        if (literalValue != null && type2 != null) {
            List<GoNamedElement> definitions = type2.getFieldDefinitions();
            int index = literalValue.getElementList().indexOf(element);
            return 0 <= index && index < definitions.size() ? definitions.get(index) : null;
        }
        return null;
    }

    @NotNull
    private static List<LinkedHashSet<String>> newListOfEmptySets(int size) {
        Object list = size == 1 ? new SmartList() : new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(new LinkedHashSet());
        }
        Object object = list;
        if (object == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(95);
        }
        return object;
    }

    @NotNull
    private static List<? extends PsiElement> getResultParametersOrTypes(@NotNull GoCallExpr o) {
        GoSignatureOwner signatureOwner;
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(96);
        }
        GoResult result = (signatureOwner = GoPsiImplUtil.resolveCall(o)) != null ? signatureOwner.getResult() : null;
        GoParameters parameters = result != null ? result.getParameters() : null;
        List<Object> resultParameters = parameters != null ? parameters.getDefinitionList() : Collections.emptyList();
        List<Object> list = !resultParameters.isEmpty() ? resultParameters : GoTypeUtil.getListOfTypesFromTypeList(o.getGoType(null));
        if (list == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(97);
        }
        return list;
    }

    @NotNull
    private static LinkedHashSet<String> getErrorNames(@Nullable PsiElement context) {
        GoSignatureOwner scope = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)context, GoSignatureOwner.class);
        if (scope == null) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        GoReference.processResolvableVariants(context, scope, (PairProcessor<? super String, ? super PsiElement>)((PairProcessor)(name, element) -> {
            if (element instanceof GoTypeOwner && GoTypeUtil.isError(((GoTypeOwner)element).getGoType(null), element)) {
                result.add((String)name);
            }
            return true;
        }));
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(98);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<String> getSuggestionsFromCallReference(@NotNull GoCallExpr o, boolean capitalize) {
        GoReferenceExpression callReference;
        if (o == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(99);
        }
        String referenceName = (callReference = GoPsiUtil.getCallReference(o)) != null ? callReference.getIdentifier().getText() : "";
        return GoNameSuggestionProvider.getSuggestionsFromName(referenceName, capitalize, false, Settings.DEFAULT_OPTIONS);
    }

    @NotNull
    public static LinkedHashSet<String> getNamesInContext(@Nullable PsiElement context) {
        return GoNameSuggestionProvider.getNamesInContext(context, false);
    }

    @NotNull
    public static LinkedHashSet<String> getNamesInContext(@Nullable PsiElement context, boolean skipStructAndInterfaceScope) {
        GoCompositeType structOrInterface;
        if (context == null) {
            return new LinkedHashSet<String>();
        }
        GoSignatureOwner signatureOwner = GoNameSuggestionProvider.findSignatureOwner(context);
        if (signatureOwner != null) {
            return GoNameSuggestionProvider.getNamesForSignatureScope(context, signatureOwner);
        }
        if (!skipStructAndInterfaceScope && (structOrInterface = (GoCompositeType)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoStructType.class, GoInterfaceType.class})) != null) {
            return GoNameSuggestionProvider.getNamesForStructOrInterfaceTypeScope(structOrInterface);
        }
        GoStatementsHolder statementsHolder = GoNameSuggestionProvider.findStatementsHolder(context);
        if (statementsHolder != null) {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            PsiElement lastChild = statementsHolder.getLastChild();
            if (lastChild == null) {
                LinkedHashSet<String> linkedHashSet = names;
                if (linkedHashSet == null) {
                    GoNameSuggestionProvider.$$$reportNull$$$0(100);
                }
                return linkedHashSet;
            }
            GoNameSuggestionProvider.consumeAllResolvableNames(lastChild, names);
            LinkedHashSet<String> linkedHashSet = names;
            if (linkedHashSet == null) {
                GoNameSuggestionProvider.$$$reportNull$$$0(101);
            }
            return linkedHashSet;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        GoNameSuggestionProvider.consumeAllResolvableNames(context, names);
        LinkedHashSet<String> linkedHashSet = names;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(102);
        }
        return linkedHashSet;
    }

    @NotNull
    private static LinkedHashSet<String> getNamesForSignatureScope(@Nullable PsiElement context, @NotNull GoSignatureOwner signatureOwner) {
        if (signatureOwner == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(103);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoType.class, GoSignatureOwner.class});
        if (!(parent instanceof GoType)) {
            PairProcessor processor2 = (name, duplicate) -> {
                names.add((String)name);
                return true;
            };
            new GoDuplicatesSearch.SignatureScopeSearch().processAllElements(signatureOwner, (PairProcessor<String, GoDuplicatesSearch.Duplicate>)processor2);
        }
        GoNameSuggestionProvider.consumeAllResolvableNames(signatureOwner, names);
        LinkedHashSet<String> linkedHashSet = names;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(104);
        }
        return linkedHashSet;
    }

    private static void consumeAllResolvableNames(@NotNull PsiElement context, @NotNull LinkedHashSet<String> names) {
        if (context == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(105);
        }
        if (names == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(106);
        }
        GoReference.processResolvableVariants(context, null, (PairProcessor<? super String, ? super PsiElement>)((PairProcessor)(name, __) -> {
            names.add((String)name);
            return true;
        }));
    }

    @Nullable
    private static GoSignatureOwner findSignatureOwner(@NotNull PsiElement context) {
        GoCompositeElement parent;
        if (context == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(107);
        }
        return (parent = (GoCompositeElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{GoReceiver.class, GoSignature.class, GoStatement.class, GoStatementsHolder.class})) instanceof GoReceiver || parent instanceof GoSignature ? (GoSignatureOwner)ObjectUtils.tryCast((Object)parent.getParent(), GoSignatureOwner.class) : null;
    }

    @NotNull
    private static LinkedHashSet<String> getNamesForStructOrInterfaceTypeScope(@NotNull GoType structOrInterface) {
        if (structOrInterface == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(108);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (structOrInterface instanceof GoStructType) {
            ((GoStructType)structOrInterface).getFieldDefinitions().stream().map(NavigationItem::getName).filter(Objects::nonNull).forEach(names::add);
        } else if (structOrInterface instanceof GoInterfaceType) {
            ((GoInterfaceType)structOrInterface).getAllMethods().stream().map(NavigationItem::getName).filter(Objects::nonNull).forEach(names::add);
        }
        GoNameSuggestionProvider.consumeAllResolvableNames(structOrInterface, names);
        LinkedHashSet<String> linkedHashSet = names;
        if (linkedHashSet == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(109);
        }
        return linkedHashSet;
    }

    @Nullable
    private static GoStatementsHolder findStatementsHolder(@NotNull PsiElement context) {
        PsiElement parent;
        if (context == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(110);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoStatementsHolder.class, GoIfStatement.class, GoForStatement.class, GoSwitchStatement.class})) instanceof GoIfStatement) {
            return ((GoIfStatement)parent).getBlock();
        }
        if (parent instanceof GoForStatement) {
            return ((GoForStatement)parent).getBlock();
        }
        if (parent instanceof GoSwitchStatement) {
            return ((GoSwitchStatement)parent).getBlock();
        }
        return (GoStatementsHolder)ObjectUtils.tryCast((Object)parent, GoStatementsHolder.class);
    }

    @NotNull
    public static String addNumberSuffixIfNeeded(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(111);
        }
        if (context == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(112);
        }
        return GoNameSuggestionProvider.addNumberSuffixIfNeeded(name, GoNameSuggestionProvider.getNamesInContext(context));
    }

    @NotNull
    public static String addNumberSuffixIfNeeded(@NotNull String name, @NotNull Set<String> existingNames) {
        if (name == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(113);
        }
        if (existingNames == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(114);
        }
        if (!existingNames.contains(name)) {
            String string = name;
            if (string == null) {
                GoNameSuggestionProvider.$$$reportNull$$$0(115);
            }
            return string;
        }
        int i = 2;
        while (existingNames.contains(name + i)) {
            ++i;
        }
        String string = name + i;
        if (string == null) {
            GoNameSuggestionProvider.$$$reportNull$$$0(116);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 11, 17, 18, 24, 26, 27, 28, 30, 37, 40, 57, 58, 61, 64, 73, 74, 75, 84, 95, 97, 98, 100, 101, 102, 104, 109, 115, 116 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 40: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 73: 
            case 74: 
            case 75: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 109: 
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/GoNameSuggestionProvider";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 22: 
            case 25: 
            case 35: 
            case 38: 
            case 42: 
            case 46: 
            case 54: 
            case 55: 
            case 66: 
            case 69: 
            case 70: 
            case 77: 
            case 82: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 23: 
            case 36: 
            case 39: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesInContext";
                break;
            }
            case 13: 
            case 15: 
            case 20: 
            case 33: 
            case 43: 
            case 48: 
            case 52: 
            case 67: 
            case 71: 
            case 78: 
            case 89: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 16: 
            case 21: 
            case 34: 
            case 44: 
            case 49: 
            case 53: 
            case 59: 
            case 62: 
            case 68: 
            case 72: 
            case 79: 
            case 81: 
            case 83: 
            case 90: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 19: 
            case 31: 
            case 41: 
            case 45: 
            case 50: 
            case 65: 
            case 76: 
            case 80: 
            case 86: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDeclaration";
                break;
            }
            case 32: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalNames";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonName";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 105: 
            case 107: 
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structOrInterface";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/GoNameSuggestionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNamesForReceiver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applySettings";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsFromName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNamesForNamedElementWithoutType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedNamesInContext";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelNames";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherMethodNames";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNamesForSignatureOwner";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNamesForDefinition";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNamesForExpression";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsFromType";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsForCall";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsFromReference";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "newListOfEmptySets";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultParametersOrTypes";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorNames";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesInContext";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesForSignatureScope";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesForStructOrInterfaceTypeScope";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "addNumberSuffixIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNames";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 40: 
            case 57: 
            case 58: 
            case 61: 
            case 64: 
            case 73: 
            case 74: 
            case 75: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 109: 
            case 115: 
            case 116: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNamesForReceiver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applySettings";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAllValid";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsFromName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDummyNameIfNeeded";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNamesForNamedElementWithoutType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedNamesInContext";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOtherMethodNames";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addSameNameWithNumberIfNeeded";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNamesForSignatureOwner";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNamesForDefinition";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestionsForDefinition";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addDummyCommonNameIfNeeded";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNamesForExpression";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestionsForExpression";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedNamesForCall";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsForCall";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestionsForNonCallExpression";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addExistingErrorNamesIfNeeded";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsFromReference";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToBuiltin";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestionsForCallArgument";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestionsForLiteralValue";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getResultParametersOrTypes";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsFromCallReference";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getNamesForSignatureScope";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "consumeAllResolvableNames";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "findSignatureOwner";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getNamesForStructOrInterfaceTypeScope";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "findStatementsHolder";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addNumberSuffixIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 11, 17, 18, 24, 26, 27, 28, 30, 37, 40, 57, 58, 61, 64, 73, 74, 75, 84, 95, 97, 98, 100, 101, 102, 104, 109, 115, 116 -> new IllegalStateException(string);
        };
    }

    public static class Settings {
        public final Set<String> excludedNames;
        public final Set<String> allowedNames;
        public final EnumSet<Option> options;
        public static final Settings DEFAULT = new Settings();
        public static final EnumSet<Option> DEFAULT_OPTIONS = EnumSet.noneOf(Option.class);

        private Settings() {
            this(Collections.emptySet(), Collections.emptySet(), new Option[0]);
        }

        public Settings(@NotNull Set<String> excludedNames) {
            if (excludedNames == null) {
                Settings.$$$reportNull$$$0(0);
            }
            this(excludedNames, Collections.emptySet(), new Option[0]);
        }

        public Settings(@NotNull Set<String> excludedNames, @NotNull Set<String> allowedNames, Option ... options) {
            if (excludedNames == null) {
                Settings.$$$reportNull$$$0(1);
            }
            if (allowedNames == null) {
                Settings.$$$reportNull$$$0(2);
            }
            if (options == null) {
                Settings.$$$reportNull$$$0(3);
            }
            this.excludedNames = excludedNames;
            this.allowedNames = allowedNames;
            this.options = EnumSet.noneOf(Option.class);
            this.options.addAll(Arrays.asList(options));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "excludedNames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allowedNames";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/GoNameSuggestionProvider$Settings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Option {
        DO_NOT_SUGGEST_DUMMY_NAMES,
        DO_NOT_SUGGEST_EXISTING_ERROR_NAMES,
        DO_NOT_SUGGEST_NAMES_BASED_ON_INITIAL_NAME,
        DO_NOT_SUGGEST_NAMES_BASED_ON_FUNC_PARAM_NAME;

    }
}

