/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.codeInsight.imports.GoImport;
import com.goide.editor.template.GoErrorVariableDefinitionMacro;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GoUnhandledErrorWrapper {
    @NotNull
    private final GoCallExpr myCall;
    @NotNull
    protected final List<String> myParameters;
    @NotNull
    private final List<String> myParameterNames;
    @NotNull
    protected final List<String> myArguments;
    @Nullable
    protected String myWrappedCall;
    protected int myCallResultsCount;
    protected int myErrorVariableIndex;
    @NotNull
    protected final Set<String> myExistingNames;
    @NotNull
    private final Set<GoImport> myImports;

    protected GoUnhandledErrorWrapper(@NotNull GoCallExpr call) {
        if (call == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(0);
        }
        this.myParameters = new SmartList();
        this.myParameterNames = new SmartList();
        this.myArguments = new SmartList();
        this.myCallResultsCount = -1;
        this.myErrorVariableIndex = -1;
        this.myExistingNames = new HashSet<String>();
        this.myImports = new HashSet<GoImport>();
        this.myCall = call;
    }

    void run(@NotNull Project project, @Nullable Editor editor, @NotNull GoCallExpr call, @NotNull PsiElement parent) {
        if (project == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(1);
        }
        if (call == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(3);
        }
        if (this.setup(project, editor, call, parent instanceof GoDeferStatement)) {
            this.wrap(project, editor);
        }
    }

    private boolean setup(@NotNull Project project, @Nullable Editor editor, @NotNull GoCallExpr call, boolean isDeferred) {
        GoExpression qualifier;
        GoSignature signature;
        IntPair resultsCountAndErrorIndex;
        if (project == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(4);
        }
        if (call == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(5);
        }
        if ((resultsCountAndErrorIndex = GoErrorVariableDefinitionMacro.getResultsCountAndErrorIndex(call)) == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GoBundle.message((String)"go.fix.failed.to.introduce.variables.from.call", (Object[])new Object[0]), (String)GoBundle.message((String)"go.fix.failed.to.handle.error", (Object[])new Object[0]), null);
            return false;
        }
        this.myCallResultsCount = resultsCountAndErrorIndex.first;
        this.myErrorVariableIndex = resultsCountAndErrorIndex.second;
        if (!isDeferred) {
            this.myWrappedCall = call.getText();
            return true;
        }
        GoNamedSignatureOwner signatureOwner = GoInspectionUtil.resolveCall(call);
        GoSignature goSignature = signature = signatureOwner != null ? signatureOwner.getSignature() : null;
        if (signature == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GoBundle.message((String)"go.fix.failed.to.resolve.called.function.signature", (Object[])new Object[0]), (String)GoBundle.message((String)"go.fix.failed.to.handle.error", (Object[])new Object[0]), null);
            return false;
        }
        if (signatureOwner instanceof GoFunctionDeclaration) {
            if (ContainerUtil.all(call.getArgumentList().getExpressionList(), argument -> GoUnhandledErrorWrapper.canInlineArgument(argument))) {
                this.myWrappedCall = call.getText();
                return true;
            }
            this.addParameters(signature.getParameters());
            call.getArgumentList().getExpressionList().forEach(e -> this.myArguments.add(e.getText()));
            this.myWrappedCall = call.getExpression().getText() + "(" + StringUtil.join(this.myParameterNames, (String)", ") + ")";
            return true;
        }
        GoReferenceExpression callReference = GoPsiUtil.getCallReference(call);
        GoExpression goExpression = qualifier = callReference != null ? callReference.getExpressionQualifier() : null;
        if (qualifier == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GoBundle.message((String)"go.fix.call.receiver.is.not.an.expression", (Object[])new Object[0]), (String)GoBundle.message((String)"go.fix.failed.to.handle.error", (Object[])new Object[0]), null);
            return false;
        }
        if (GoUnhandledErrorWrapper.canInlineArgument(qualifier) && ContainerUtil.all(call.getArgumentList().getExpressionList(), argument -> GoUnhandledErrorWrapper.canInlineArgument(argument))) {
            this.myWrappedCall = call.getText();
            return true;
        }
        boolean needPointer = GoUnhandledErrorWrapper.isMethodCallWithImplicitTakeAddress(qualifier, signatureOwner);
        this.addParameters(qualifier, needPointer, signature.getParameters());
        Object receiverArgument = needPointer ? "&" + qualifier.getText() : qualifier.getText();
        this.myArguments.add((String)receiverArgument);
        call.getArgumentList().getExpressionList().forEach(e -> this.myArguments.add(e.getText()));
        String firstParameterName = (String)ContainerUtil.getFirstItem(this.myParameterNames);
        List restParameters = ContainerUtil.subList(this.myParameterNames, (int)1);
        this.myWrappedCall = firstParameterName + "." + signatureOwner.getName() + "(" + StringUtil.join((Collection)restParameters, (String)", ") + ")";
        return true;
    }

    private static boolean canInlineArgument(@NotNull GoExpression argument) {
        if (argument == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(6);
        }
        return ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)argument)).forceIgnore(child -> {
            if (child == argument) {
                return false;
            }
            PsiElement parent = child.getParent();
            if (parent instanceof GoCallExpr && ((GoCallExpr)parent).getExpression() == child) {
                return true;
            }
            return parent instanceof GoBuiltinCallExpr && ((GoBuiltinCallExpr)parent).getExpression() == child;
        })).traverse().skipWhile(element -> {
            GoExpression expression = (GoExpression)ObjectUtils.tryCast((Object)element, GoExpression.class);
            if (expression instanceof GoCallExpr) {
                return GoPsiUtil.isBuiltinFunctionCall((GoCallExpr)expression, "len", "cap", "complex", "real", "imag", "min", "max") || GoPsiUtil.isConversionExpression(expression);
            }
            if (expression instanceof GoBuiltinCallExpr) {
                return ((GoBuiltinCallExpr)expression).isTrulyBuiltin() || GoPsiUtil.isConversionExpression(expression);
            }
            if (expression instanceof GoReferenceExpression) {
                return expression.isConstant() || GoExpressionUtil.isNil(expression);
            }
            if (expression instanceof GoFunctionLit) {
                return false;
            }
            if (expression instanceof GoUnaryExpr) {
                return ((GoUnaryExpr)expression).getArrow() == null;
            }
            return true;
        }).isEmpty();
    }

    private void addParameters(@NotNull GoParameters parameters) {
        if (parameters == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(7);
        }
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            GoType type2 = GoTypeUtil.getInterfaceIfNull(declaration.getType(), this.myCall);
            List<String> names = ContainerUtil.map(declaration.getParamDefinitionList(), this::calculateName);
            if (names.isEmpty()) {
                names = Collections.singletonList(this.suggestName(new GoFakeTypeOwner(this.myCall.getManager(), type2, this.myCall.getContainingFile())));
            }
            String namesText = StringUtil.join((Collection)names, (String)", ");
            String typeText = this.calculateTypeText(type2);
            this.myParameters.add(String.format("%s %s%s", namesText, declaration.isVariadic() ? "..." : "", typeText));
            this.myParameterNames.addAll(names);
        }
    }

    private void addParameters(@NotNull GoExpression receiver, boolean pointerReceiver, @NotNull GoParameters parameters) {
        if (receiver == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(9);
        }
        this.addParameters(parameters);
        String name = receiver instanceof GoReferenceExpression ? GoNameSuggestionProvider.addNumberSuffixIfNeeded(((GoReferenceExpression)receiver).getIdentifier().getText(), this.myExistingNames) : this.calculateName(receiver);
        String typeText = this.calculateTypeText(receiver.getGoType(null));
        this.myParameters.add(0, String.format("%s %s%s", name, pointerReceiver ? "*" : "", typeText));
        this.myParameterNames.add(0, name);
    }

    @NotNull
    private String calculateName(@NotNull GoTypeOwner typeOwner) {
        String name;
        if (typeOwner == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(10);
        }
        String string = name = typeOwner instanceof GoNamedElement ? ((GoNamedElement)typeOwner).getName() : null;
        if (name == null || this.myExistingNames.contains(name)) {
            name = this.suggestName(typeOwner);
        }
        this.myExistingNames.add(name);
        String string2 = name;
        if (string2 == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    private String suggestName(@NotNull GoTypeOwner typeOwner) {
        if (typeOwner == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(12);
        }
        GoNameSuggestionProvider.Settings settings = new GoNameSuggestionProvider.Settings(this.myExistingNames);
        String string = (String)ContainerUtil.getFirstItem(GoNameSuggestionProvider.getSuggestedNames(typeOwner, null, settings));
        if (string == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String calculateTypeText(@Nullable GoType type2) {
        GoRefactoringUtil.TypeTextWithImports typeTextWithImports = GoRefactoringUtil.getTypeTextWithImports((GoFile)this.myCall.getContainingFile(), type2);
        this.myImports.addAll(typeTextWithImports.imports);
        String string = typeTextWithImports.typeText;
        if (string == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(14);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isMethodCallWithImplicitTakeAddress(@NotNull GoExpression qualifier, @NotNull GoNamedSignatureOwner declaration) {
        if (qualifier == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(15);
        }
        if (declaration == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(16);
        }
        if (!Optional.ofNullable((GoMethodDeclaration)ObjectUtils.tryCast((Object)declaration, GoMethodDeclaration.class)).map(GoMethodDeclaration::getReceiverType).map(t -> (GoType)ObjectUtils.notNull((Object)GoTypeUtil.unwrapAlias(t, qualifier), (Object)t)).filter(GoPointerType.class::isInstance).isPresent()) return false;
        if (!Optional.ofNullable(qualifier.getGoType(null)).map(t -> (GoType)ObjectUtils.notNull((Object)GoTypeUtil.unwrapAlias(t, qualifier), (Object)t)).filter(GoPointerType.class::isInstance).isEmpty()) return false;
        return true;
    }

    private void wrap(@NotNull Project project, @Nullable Editor editor) {
        if (project == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(17);
        }
        if (this.myWrappedCall == null || this.myCallResultsCount < 0 || this.myErrorVariableIndex < 0) {
            throw new IllegalStateException("Cannot create wrapper, some required values are missing");
        }
        PsiElement wrappedCall = this.myCall.replace(this.createWrappedCallExpression(project));
        GoRefactoringUtil.addImports((GoFile)wrappedCall.getContainingFile(), this.myImports);
        GoBlock wrapperBlock = Objects.requireNonNull((GoBlock)PsiTreeUtil.findChildOfType((PsiElement)wrappedCall, GoBlock.class));
        GoCallExpr callInsideWrapper = Objects.requireNonNull((GoCallExpr)PsiTreeUtil.findChildOfType((PsiElement)wrapperBlock, GoCallExpr.class));
        GoRefactoringUtil.highlightSearchResults(project, editor, Collections.singletonList(callInsideWrapper));
        this.afterReplace(project, editor, wrappedCall);
    }

    @NotNull
    protected abstract GoExpression createWrappedCallExpression(@NotNull Project var1);

    protected void afterReplace(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement wrappedCallExpression) {
        if (project == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(18);
        }
        if (wrappedCallExpression == null) {
            GoUnhandledErrorWrapper.$$$reportNull$$$0(19);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 4: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoUnhandledErrorWrapper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoUnhandledErrorWrapper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canInlineArgument";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateName";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMethodCallWithImplicitTakeAddress";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "afterReplace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

