/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSimplifyIfStatementUtil {
    public static boolean prepareToExtractToOuterBlock(@NotNull GoStatement statementToExtract) {
        if (statementToExtract == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(0);
        }
        return GoSimplifyIfStatementUtil.prepareToExtractToOuterBlock((List<GoStatement>)new SmartList((Object)statementToExtract));
    }

    public static boolean prepareToExtractToOuterBlock(@NotNull List<GoStatement> statementsToExtract) {
        if (statementsToExtract == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(1);
        }
        List shadowingDefs = statementsToExtract.stream().flatMap(stmt -> GoSimplifyIfStatementUtil.findDefinitions(stmt).stream()).filter(def -> GoExpressionUtil.shadowsOtherVarOrConst(def, true)).collect(Collectors.toList());
        LinkedHashSet<String> newNames = new LinkedHashSet<String>();
        for (GoVarOrConstDefinition def2 : shadowingDefs) {
            String newName = GoSimplifyIfStatementUtil.getNewName(def2, newNames);
            if (newName == null) {
                return false;
            }
            newNames.add(newName);
        }
        ContainerUtil.zip(shadowingDefs, newNames).forEach(pair -> GoRefactoringUtil.renameInPsiTree((GoNamedElement)pair.first, (String)pair.second));
        return true;
    }

    public static boolean prepareToEmbedIntoBlock(@NotNull GoStatement statementToEmbed, @NotNull List<GoStatement> blockStatements) {
        if (statementToEmbed == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(2);
        }
        if (blockStatements == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(3);
        }
        List defs = blockStatements.stream().flatMap(stmt -> GoSimplifyIfStatementUtil.findDefinitions(stmt).stream()).toList();
        List<GoVarOrConstDefinition> possiblyShadowedDefs = GoSimplifyIfStatementUtil.findDefinitions(statementToEmbed);
        LinkedHashSet<String> newNames = new LinkedHashSet<String>();
        SmartList renameData = new SmartList();
        block0: for (GoVarOrConstDefinition possiblyShadowedDef : possiblyShadowedDefs) {
            for (GoVarOrConstDefinition def : defs) {
                if (GoExpressionUtil.getShadowedElement(def) != possiblyShadowedDef) continue;
                String newName = GoSimplifyIfStatementUtil.getNewName(def, newNames);
                if (newName == null) {
                    return false;
                }
                newNames.add(newName);
                renameData.add(Pair.pair((Object)possiblyShadowedDef, (Object)newName));
                continue block0;
            }
        }
        renameData.forEach(pair -> GoRefactoringUtil.renameInPsiTree((GoNamedElement)pair.first, (String)pair.second));
        return true;
    }

    private static List<GoVarOrConstDefinition> findDefinitions(@NotNull GoStatement statement) {
        if (statement == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(4);
        }
        SmartList definitions = new SmartList();
        GoPsiUtil.processDefinitions(statement, (Processor<? super GoNamedElement>)((Processor)arg_0 -> GoSimplifyIfStatementUtil.lambda$findDefinitions$5((List)definitions, arg_0)));
        return definitions;
    }

    @Nullable
    private static String getNewName(@NotNull GoNamedElement namedElement, @NotNull Set<String> usedNames) {
        if (namedElement == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(5);
        }
        if (usedNames == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(6);
        }
        return (String)ContainerUtil.getFirstItem(GoNameSuggestionProvider.getSuggestedNames(namedElement, namedElement, new GoNameSuggestionProvider.Settings(usedNames)));
    }

    public static void processElementsWithComments(@NotNull List<? extends PsiElement> elements, @NotNull Processor<? super PsiElement> processor2) {
        if (elements == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            GoSimplifyIfStatementUtil.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < elements.size(); ++i) {
            boolean notLast = i != elements.size() - 1;
            PsiElement element = elements.get(i);
            GoDocumentationProvider.getUpperComments(element).forEach(comment -> {
                processor2.process(comment);
                processor2.process((Object)GoElementFactory.createNewLine(element.getProject()));
            });
            processor2.process((Object)element);
            GoDocumentationProvider.getAfterComments(element).forEach(arg_0 -> processor2.process(arg_0));
            if (!notLast) continue;
            processor2.process((Object)GoElementFactory.createNewLine(element.getProject()));
        }
    }

    private static /* synthetic */ boolean lambda$findDefinitions$5(List definitions, GoNamedElement namedElement) {
        ContainerUtil.addIfNotNull((Collection)definitions, (Object)((GoVarOrConstDefinition)ObjectUtils.tryCast((Object)namedElement, GoVarOrConstDefinition.class)));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementToExtract";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToExtract";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementToEmbed";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/goide/quickfix/GoSimplifyIfStatementUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareToExtractToOuterBlock";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareToEmbedIntoBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findDefinitions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

