/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoExpression;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoInsertBlankIdentifiersQuickFix
implements LocalQuickFix {
    private final int myCountOfBlankIdentifiersToInsert;

    @Nls
    @NotNull
    static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.insert.blank.identifiers.name", (Object[])new Object[0]);
        if (string == null) {
            GoInsertBlankIdentifiersQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public GoInsertBlankIdentifiersQuickFix(int countOfBlankIdentifiersToInsert) {
        this.myCountOfBlankIdentifiersToInsert = countOfBlankIdentifiersToInsert;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GoInsertBlankIdentifiersQuickFix.getQuickFixName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            GoInsertBlankIdentifiersQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            GoInsertBlankIdentifiersQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = descriptor.getPsiElement()) instanceof GoExpression && element.isValid()) {
            element = element.getParent();
        }
        PsiElement insertAfter = null;
        if (element instanceof GoVarSpec) {
            insertAfter = (PsiElement)ContainerUtil.getLastItem(((GoVarSpec)element).getVarDefinitionList());
        }
        if (element instanceof GoConstSpec) {
            insertAfter = (PsiElement)ContainerUtil.getLastItem(((GoConstSpec)element).getConstDefinitionList());
        }
        if (element instanceof GoAssignmentStatement) {
            element = ((GoAssignmentStatement)element).getLeftHandExprList();
            insertAfter = (PsiElement)ContainerUtil.getLastItem(((GoLeftHandExprList)element).getExpressionList());
        }
        if (insertAfter == null) {
            return;
        }
        for (int i = 0; i < this.myCountOfBlankIdentifiersToInsert; ++i) {
            PsiElement comma = GoElementFactory.createComma(project);
            insertAfter = element.addAfter(comma, insertAfter);
            PsiElement identifier = GoElementFactory.createIdentifierFromText(project, "_");
            insertAfter = element.addAfter(identifier, insertAfter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoInsertBlankIdentifiersQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoInsertBlankIdentifiersQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

