/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDeleteVarDefinitionQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(GoDeleteVarDefinitionQuickFix.class);
    private final String myVariableName;

    public GoDeleteVarDefinitionQuickFix(@Nullable String variableName) {
        this.myVariableName = variableName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myVariableName != null ? GoBundle.message((String)"go.fix.delete.text", (Object[])new Object[]{GoBundle.message((String)"go.terms.variable", (Object[])new Object[0]), this.myVariableName}) : this.getFamilyName();
        if (string == null) {
            GoDeleteVarDefinitionQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.variable", (Object[])new Object[0])});
        if (string == null) {
            GoDeleteVarDefinitionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement varAssign;
        PsiElement element;
        if (project == null) {
            GoDeleteVarDefinitionQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            GoDeleteVarDefinitionQuickFix.$$$reportNull$$$0(3);
        }
        if (!((element = descriptor.getPsiElement()) instanceof GoVarDefinition) || !element.isValid()) {
            return;
        }
        GoReferencesSearch.search(element, element.getUseScope()).forEach(reference -> {
            PsiElement usage = reference.getElement();
            PsiElement parent = usage.getParent();
            if (usage instanceof GoVarDefinition) {
                ((GoVarSpec)parent).deleteDefinition((GoVarDefinition)usage);
                return;
            }
            if (usage instanceof GoReferenceExpression) {
                GoAssignmentStatement assignment;
                if (parent instanceof GoLeftHandExprList && (assignment = (GoAssignmentStatement)ObjectUtils.tryCast((Object)parent.getParent(), GoAssignmentStatement.class)) != null && assignment.deleteExpression((GoReferenceExpression)usage)) {
                    return;
                }
                reference.handleElementRename("_");
            }
        });
        PsiElement parent = element.getParent();
        if (parent instanceof GoVarSpec) {
            ((GoVarSpec)parent).deleteDefinition((GoVarDefinition)element);
            return;
        }
        if (parent instanceof GoTypeSwitchGuard && (varAssign = ((GoTypeSwitchGuard)parent).getVarAssign()) != null) {
            PsiElement next;
            PsiElement lastElement = varAssign;
            while ((next = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                lastElement = next;
            }
            parent.deleteChildRange(element, lastElement);
            return;
        }
        LOG.error("Cannot delete variable " + ((GoVarDefinition)element).getName() + ". Parent: " + parent.getClass().getSimpleName(), new Attachment[]{CoreAttachmentFactory.createAttachment((VirtualFile)parent.getContainingFile().getVirtualFile())});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoDeleteVarDefinitionQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoDeleteVarDefinitionQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

