/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoUniqueIdentifier;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCallLikeExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParType;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoElementWithSubst;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoIdenticalTypesMatcher;
import com.goide.psi.impl.GoLightMethodDeclaration;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReceiverUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeImpl;
import com.goide.psi.impl.expectedTypes.GoAnyComplexExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnyFloatExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnyIntegerExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnyPointerExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnySendChannelExpectedType;
import com.goide.psi.impl.expectedTypes.GoConditionExpectedType;
import com.goide.psi.impl.expectedTypes.GoConversionExpectedType;
import com.goide.psi.impl.expectedTypes.GoCoreIdenticalExpectedType;
import com.goide.psi.impl.expectedTypes.GoCoreStringExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedTypeImpl;
import com.goide.psi.impl.expectedTypes.GoExpectedTypes;
import com.goide.psi.impl.expectedTypes.GoExprCaseClauseExpectedType;
import com.goide.psi.impl.expectedTypes.GoFunctionExpectedType;
import com.goide.psi.impl.expectedTypes.GoIdenticalExpectedType;
import com.goide.psi.impl.expectedTypes.GoIterableExpectedType;
import com.goide.psi.impl.expectedTypes.GoNotNilExpectedType;
import com.goide.psi.impl.expectedTypes.GoNotTypeParameterExpectedType;
import com.goide.psi.impl.expectedTypes.GoTypedSliceExpectedType;
import com.goide.psi.impl.expectedTypes.GoUntypedFloatExpectedType;
import com.goide.psi.impl.generics.GoAbstractConstraintTerm;
import com.goide.psi.impl.generics.GoGenericsUtilKt;
import com.goide.psi.impl.generics.GoPossiblyIdenticalTypesMatcher;
import com.goide.psi.impl.generics.GoTypeArgument;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.psi.impl.generics.GoTypeSet;
import com.goide.psi.impl.generics.GoTypeSetKt;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedType;
import com.goide.psi.impl.typesCompatibility.GoAmbiguousMethods;
import com.goide.psi.impl.typesCompatibility.GoCannotBeNil;
import com.goide.psi.impl.typesCompatibility.GoCannotUsePointerReceiverMethod;
import com.goide.psi.impl.typesCompatibility.GoDoesNotImplementInterface;
import com.goide.psi.impl.typesCompatibility.GoInterfaceWithNonExportedMethodInDifferentPackage;
import com.goide.psi.impl.typesCompatibility.GoMethodsMissing;
import com.goide.psi.impl.typesCompatibility.GoNonStrictComparabilityUnsupported;
import com.goide.psi.impl.typesCompatibility.GoNotInTypeSet;
import com.goide.psi.impl.typesCompatibility.GoNotRepresentable;
import com.goide.psi.impl.typesCompatibility.GoRangeExpressionWithoutCoreType;
import com.goide.psi.impl.typesCompatibility.GoSignatureDiffers;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesCompatible;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.stubs.GoTypeSpecStub;
import com.goide.stubs.GoTypeStub;
import com.goide.stubs.index.GoIdFilter;
import com.goide.stubs.index.GoTypesIndex;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoUtil;
import com.goide.utils.GoStringUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTypeUtil {
    private static final Comparator<GoNamedElement> BY_NAME = (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
    private static final String INT = "int";
    private static final String INT8 = "int8";
    private static final String INT16 = "int16";
    private static final String INT32 = "int32";
    private static final String INT64 = "int64";
    private static final String UINT = "uint";
    public static final String UINT8 = "uint8";
    private static final String UINT16 = "uint16";
    private static final String UINT32 = "uint32";
    private static final String UINT64 = "uint64";
    private static final String FLOAT32 = "float32";
    private static final String FLOAT64 = "float64";
    public static final String COMPLEX64 = "complex64";
    public static final String COMPLEX128 = "complex128";
    private static final String RUNE = "rune";
    public static final String BYTE = "byte";
    private static final String UINTPTR = "uintptr";
    private static final Set<String> NUMERIC_TYPES = Set.of("int", "int8", "int16", "int32", "int64", "uint", "uint8", "uint16", "uint32", "uint64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr");
    private static final Set<String> INTEGER_TYPES = Set.of("int", "int8", "int16", "int32", "int64", "uint", "uint8", "uint16", "uint32", "uint64", "rune", "byte", "uintptr");
    private static final Set<String> UINT_TYPES = Set.of("uint", "uint8", "uint16", "uint32", "uint64", "byte", "uintptr");
    private static final Set<String> FLOAT_TYPES = Set.of("float32", "float64");
    private static final Set<String> COMPLEX_TYPES = Set.of("complex64", "complex128");
    private static final Set<String> INT32_ALIAS = Set.of("int32", "rune");
    private static final Set<String> UINT8_ALIAS = Set.of("uint8", "byte");
    private static final String DOC_ONLY_ANY_TYPE = "Type";
    private static final String DOC_ONLY_ANY_TYPE_1 = "Type1";
    private static final String DOC_ONLY_INTEGER_TYPE = "IntegerType";
    private static final String DOC_ONLY_FLOAT_TYPE = "FloatType";
    private static final String DOC_ONLY_COMPLEX_TYPE = "ComplexType";
    public static final Set<String> DOC_ONLY_TYPES = Set.of("Type", "Type1", "IntegerType", "FloatType", "ComplexType");
    private static final Set<String> DOC_ONLY_ANY_TYPES = Set.of("Type", "Type1");
    private static final Set<String> DOC_ONLY_NUMERIC_TYPES = Set.of("IntegerType", "FloatType", "ComplexType");
    private static final Map<String, Pair<Long, Long>> INTEGER_LIMITS = Map.ofEntries(Map.entry("uint8", Pair.pair((Object)0L, (Object)255L)), Map.entry("uint16", Pair.pair((Object)0L, (Object)65535L)), Map.entry("uint32", Pair.pair((Object)0L, (Object)0xFFFFFFFFL)), Map.entry("byte", Pair.pair((Object)0L, (Object)255L)), Map.entry("int8", Pair.pair((Object)-128L, (Object)127L)), Map.entry("int16", Pair.pair((Object)-32768L, (Object)32767L)), Map.entry("int32", Pair.pair((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE)), Map.entry("int64", Pair.pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE)), Map.entry("rune", Pair.pair((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE)));
    private static final int PROCESS_METHODS_BY_LEVEL_ALLOWED_DEPTH = 100;

    @NotNull
    public static GoTypeCheckResult checkIterable(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            return new GoTypesCompatible();
        }
        GoType coreType = GoTypeUtil.getCoreType(type2, context);
        if (coreType == null) {
            return new GoRangeExpressionWithoutCoreType();
        }
        boolean isIterable = coreType instanceof GoChannelType || GoTypeUtil.isIterableAndIndexed(coreType, context) || GoTypeUtil.isIntegerType(coreType, context) || GoTypeUtil.isIteratorType(coreType, context) || GoTypeUtil.matchTypeConstraints(coreType, context, (GoType t) -> GoTypeUtil.isIterable(t, context));
        GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(isIterable);
        if (goTypeCheckResult == null) {
            GoTypeUtil.$$$reportNull$$$0(0);
        }
        return goTypeCheckResult;
    }

    @Contract(value="null, _ -> false")
    public static boolean isIterable(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.checkIterable(type2, context) instanceof GoTypesCompatible;
    }

    public static boolean isIterableAndIndexed(@Nullable GoType type2, @Nullable PsiElement context) {
        GoType goType = type2 = type2 != null ? type2.getUnderlyingType(context) : null;
        if (type2 instanceof GoArrayOrSliceType || type2 instanceof GoMapType) {
            return true;
        }
        if (type2 instanceof GoPointerType) {
            return GoTypeUtil.isArray(((GoPointerType)type2).getType(), context);
        }
        return GoTypeUtil.isString(type2, context) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isIterableAndIndexed(t, context));
    }

    public static boolean isArray(@Nullable GoType type2, @Nullable PsiElement context) {
        type2 = type2 != null ? type2.getUnderlyingType(context) : null;
        return type2 instanceof GoArrayOrSliceType && ((GoArrayOrSliceType)type2).isArray() || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isArray(t, context));
    }

    public static boolean isSlice(@Nullable GoType type2, @Nullable PsiElement context) {
        GoArrayOrSliceType arrayOrSliceType = (GoArrayOrSliceType)GoTypeUtil.getArrayOrSliceType(type2, context);
        return arrayOrSliceType != null && !arrayOrSliceType.isArray();
    }

    public static boolean isString(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isStringType(type2, context) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isString(t, context));
    }

    private static boolean isStringType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 instanceof GoLightType.LightUntypedStringType || GoTypeUtil.isBuiltinType(type2, context, "string");
    }

    public static boolean isBoolean(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 instanceof GoLightType.LightUntypedBoolType || GoTypeUtil.isBuiltinType(type2, context, "bool") || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isBoolean(t, context));
    }

    public static boolean isError(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && !(type2 instanceof GoCompositeType) && type2.textMatches("error") && GoTypeUtil.isBuiltinType(type2, context);
    }

    public static boolean isVoid(@Nullable GoType type2) {
        return type2 instanceof GoLightType.LightVoidType;
    }

    @Contract(value="null, _ -> false")
    public static boolean isUnresolvedType(@Nullable GoType type2, @Nullable ResolveState resolveState) {
        return GoTypeUtil.isNamedType(type2) && !GoTypeUtil.isBasicType(type2, null) && type2.resolve(resolveState) == null;
    }

    @Contract(value="null, _, _ -> false; _, _, null -> false")
    private static boolean isBuiltinType(@Nullable GoType type2, @Nullable PsiElement context, @Nullable String builtinTypeName) {
        if (builtinTypeName == null) {
            return false;
        }
        type2 = type2 != null ? type2.getUnderlyingType(context) : null;
        return type2 != null && !(type2 instanceof GoCompositeType) && type2.textMatches(builtinTypeName) && GoPsiImplUtil.builtin(type2);
    }

    public static boolean isBuiltinType(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoPsiImplUtil.builtin(type2 != null ? type2.getUnderlyingType(context) : null);
    }

    private static boolean isArbitraryType(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 instanceof GoSpecType || type2 instanceof GoTypeList) {
            return false;
        }
        if (type2 != null && "ArbitraryType".equals(GoTypeUtil.getTypeNameOrText(type2))) {
            PsiElement resolve2 = type2.resolve(context);
            return resolve2 != null && GoPsiImplUtil.isUnsafeFile(resolve2.getContainingFile());
        }
        return false;
    }

    public static boolean isUnsafePointerType(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(1);
        }
        return (type2 = type2.getUnderlyingType(context)) instanceof GoPointerType && GoTypeUtil.isArbitraryType(((GoPointerType)type2).getType(), context);
    }

    public static boolean isCType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && type2.getUnderlyingType(context) instanceof GoCType;
    }

    public static boolean isNumericType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && NUMERIC_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoTypeUtil.isBuiltinType(type2, context) || GoTypeUtil.isUntypedNumericType(type2) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isNumericType(t, context));
    }

    public static boolean isPlusable(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isNumericType(type2, context) || GoTypeUtil.isString(type2, context) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isPlusable(t, context));
    }

    @Contract(value="null, _ -> false")
    public static boolean isBasicType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 instanceof GoLightType.LightUntypedType || GoPsiImplUtil.builtin(type2) || type2 instanceof GoPointerType && GoTypeUtil.isArbitraryType(((GoPointerType)type2).getType(), context);
    }

    public static boolean isDocOnlyAnyType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && DOC_ONLY_ANY_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoPsiImplUtil.builtin(type2);
    }

    private static boolean isDocOnlyNumericType(@Nullable GoType type2) {
        return type2 != null && DOC_ONLY_NUMERIC_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoPsiImplUtil.builtin(type2);
    }

    @Contract(value="null, _ -> false")
    public static boolean isIteratorType(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.getYieldSignatureFromIteratorType(type2, context) != null || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isIteratorType(t, context));
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoSignature getYieldSignatureFromIteratorType(@Nullable GoType iteratorType, @Nullable PsiElement context) {
        if (iteratorType == null) {
            return null;
        }
        GoType goType = iteratorType.getUnderlyingType(context);
        if (goType instanceof GoFunctionType) {
            GoType goType2;
            GoFunctionType iteratorFuncType = (GoFunctionType)goType;
            GoSignature iteratorFuncSignature = iteratorFuncType.getSignature();
            if (iteratorFuncSignature == null) {
                return null;
            }
            GoResult iteratorFuncResult = iteratorFuncSignature.getResult();
            if (iteratorFuncResult != null && !iteratorFuncResult.isVoid()) {
                return null;
            }
            GoParameters iteratorParameters = iteratorFuncSignature.getParameters();
            if (iteratorParameters.getParameterCount() != 1) {
                return null;
            }
            GoType yieldType = iteratorParameters.getParameterDeclarationList().get(0).getType();
            if (yieldType != null && (goType2 = yieldType.getUnderlyingType(context)) instanceof GoFunctionType) {
                GoFunctionType yieldFuncType = (GoFunctionType)goType2;
                GoSignature yieldFuncSignature = yieldFuncType.getSignature();
                if (yieldFuncSignature == null) {
                    return null;
                }
                GoResult yieldFuncResult = yieldFuncSignature.getResult();
                if (yieldFuncResult == null || !GoTypeUtil.isBoolean(yieldFuncResult.getType(), context)) {
                    return null;
                }
                return yieldFuncSignature.getParameters().getParameterCount() <= 2 ? yieldFuncSignature : null;
            }
        }
        return (GoSignature)GoPsiImplUtil.withContextOnElement(context, state -> {
            GoType iteratorCoreType = GoTypeUtil.getCoreType(iteratorType, state);
            GoAbstractConstraintTerm term = (GoAbstractConstraintTerm)ContainerUtil.getOnlyItem(GoTypeUtil.getConstraintTerms(iteratorCoreType, state));
            if (term == null) {
                return null;
            }
            GoType constraintType = term.getType();
            GoType underlying = constraintType != null ? GoPsiImplUtil.getUnderlyingType(constraintType, state) : null;
            return GoTypeUtil.getYieldSignatureFromIteratorType(underlying, context);
        });
    }

    @Contract(value="null, _ -> false")
    public static boolean isIntegerType(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isUntypedIntegerType(type2) || type2 != null && INTEGER_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoTypeUtil.isBuiltinType(type2, context) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isIntegerType(t, context));
    }

    public static boolean isIntType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 instanceof GoLightType.LightUntypedIntType || type2 != null && INT.equals(GoTypeUtil.getTypeNameOrText(type2)) && GoTypeUtil.isBuiltinType(type2, context);
    }

    public static boolean isUntypedIntegerType(@Nullable GoType type2) {
        return type2 instanceof GoLightType.LightUntypedIntType || type2 instanceof GoLightType.LightUntypedRuneType;
    }

    public static boolean isUntypedFloatType(@Nullable GoType type2) {
        return type2 instanceof GoLightType.LightUntypedFloatType;
    }

    private static boolean isUntypedComplexType(@Nullable GoType type2) {
        return type2 instanceof GoLightType.LightUntypedComplexType;
    }

    public static boolean isUintType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && UINT_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoTypeUtil.isBuiltinType(type2, context);
    }

    public static boolean isTypedComplexType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && COMPLEX_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoTypeUtil.isBuiltinType(type2, context);
    }

    public static boolean isComplexType(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(2);
        }
        return GoTypeUtil.isTypedComplexType(type2, context) || GoTypeUtil.isUntypedComplexType(type2);
    }

    @Contract(value="null, _ -> false")
    public static boolean isTypedFloatType(@Nullable GoType type2, @Nullable PsiElement context) {
        return type2 != null && FLOAT_TYPES.contains(GoTypeUtil.getTypeNameOrText(type2)) && GoTypeUtil.isBuiltinType(type2, context) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isTypedFloatType(t, context));
    }

    public static boolean isFloatType(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(3);
        }
        return GoTypeUtil.isTypedFloatType(type2, context) || GoTypeUtil.isUntypedFloatType(type2);
    }

    @Contract(value="null -> false")
    public static boolean isUntypedNumericType(@Nullable GoType type2) {
        return type2 != null && (type2 instanceof GoLightType.LightUntypedNumericType || GoTypeUtil.isDocOnlyNumericType(type2));
    }

    @Contract(value="null, _ -> false")
    public static boolean isUintptr(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, UINTPTR);
    }

    @Contract(value="null, _ -> false")
    public static boolean isFloat32(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, FLOAT32);
    }

    @Contract(value="null, _ -> false")
    public static boolean isFloat64(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, FLOAT64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isComplex64(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, COMPLEX64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInt64(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, INT64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isUint64(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, UINT64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isComplex128(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, COMPLEX128);
    }

    @Contract(value="null, _ -> false")
    public static boolean isByteType(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, BYTE) || GoTypeUtil.isBuiltinType(type2, context, UINT8);
    }

    @Contract(value="null, _ -> false")
    public static boolean isRuneType(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type2, context, RUNE) || GoTypeUtil.isBuiltinType(type2, context, INT32);
    }

    @Nullable
    public static Pair<Long, Long> getIntegerTypeLimits(@NotNull GoType integerType, @Nullable PsiElement context) {
        if (integerType == null) {
            GoTypeUtil.$$$reportNull$$$0(4);
        }
        if (!GoTypeUtil.isIntegerType(integerType, context)) {
            return null;
        }
        return INTEGER_LIMITS.get(GoTypeUtil.getTypeNameOrText(integerType));
    }

    @NotNull
    public static GoExpectedTypes getExpectedTypes(@NotNull GoExpression expression) {
        GoIndexOrSliceExpr indexOrSliceExpr;
        GoConversionExpr conversionExpr;
        GoType type2;
        GoRangeClause rangeClause;
        PsiElement parent;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(5);
        }
        if ((parent = expression.getParent()) == null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(6);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoCodeFragment) {
            GoCodeFragment codeFragment = (GoCodeFragment)parent;
            GoType type3 = codeFragment.getExpectedType();
            GoExpectedTypes goExpectedTypes = type3 != null ? GoExpectedTypes.create(type3) : GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(7);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoParenthesesExpr) {
            GoParenthesesExpr parenthesesExpr = (GoParenthesesExpr)parent;
            return GoTypeUtil.getExpectedTypes(parenthesesExpr);
        }
        if (parent instanceof GoAssignmentStatement) {
            GoAssignmentStatement assignmentStatement = (GoAssignmentStatement)parent;
            return GoTypeUtil.getExpectedTypesFromAssignmentStatement(expression, assignmentStatement);
        }
        if (parent instanceof GoRangeClause && expression.equals((rangeClause = (GoRangeClause)parent).getRangeExpression())) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoIterableExpectedType());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(8);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoRecvStatement) {
            GoRecvStatement recvStatement = (GoRecvStatement)parent;
            return GoTypeUtil.getExpectedTypesFromRecvStatement(recvStatement);
        }
        if (parent instanceof GoVarOrConstSpec) {
            GoVarOrConstSpec varOrConstSpec = (GoVarOrConstSpec)parent;
            return GoTypeUtil.getExpectedTypesFromVarOrConstSpec(expression, varOrConstSpec);
        }
        if (parent instanceof GoArgumentList) {
            GoType type4;
            GoArgumentList argumentList = (GoArgumentList)parent;
            PsiElement grand = parent.getParent();
            GoType goType = type4 = grand != null ? GoPsiUtil.getTypeIfConversion(CompletionUtil.getOriginalOrSelf((PsiElement)grand)) : null;
            if (type4 != null) {
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConversionExpectedType(type4));
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(9);
                }
                return goExpectedTypes;
            }
            if (grand instanceof GoBuiltinCallExpr) {
                GoBuiltinCallExpr newOrMakeCallExpr = (GoBuiltinCallExpr)grand;
                return newOrMakeCallExpr.isTrulyBuiltin() ? GoTypeUtil.getExpectedTypeForNewAndMake(expression, newOrMakeCallExpr) : GoTypeUtil.getExpectedTypesFromArgumentList(expression, argumentList, newOrMakeCallExpr);
            }
            if (grand instanceof GoCallExpr) {
                GoCallExpr callExpr = (GoCallExpr)grand;
                GoExpectedTypes expectedTypesForBuiltin = GoTypeUtil.getExpectedTypesForBuiltinFunctions(expression, callExpr);
                return expectedTypesForBuiltin != null ? expectedTypesForBuiltin : GoTypeUtil.getExpectedTypesFromArgumentList(expression, argumentList, callExpr);
            }
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(10);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoUnaryExpr) {
            GoUnaryExpr unaryExpr = (GoUnaryExpr)parent;
            if (unaryExpr.getArrow() != null) {
                GoType type5 = GoTypeUtil.getExpectedTypes(unaryExpr).getFirstType();
                String text = GoTypeUtil.getTypeNameOrText(GoTypeUtil.getInterfaceIfNull(type5, parent));
                GoType chanType = GoElementFactory.createTypeCheap(parent.getProject(), "chan " + text);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(chanType);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(11);
                }
                return goExpectedTypes;
            }
            if (unaryExpr.getBitAnd() != null) {
                GoType[] types = (GoType[])GoTypeUtil.getExpectedTypes(unaryExpr).getTypes().stream().map(GoTypeUtil::unwrapPointerAndParTypes).filter(Objects::nonNull).toArray(GoType[]::new);
                GoExpectedTypes goExpectedTypes = types.length == 0 ? GoExpectedTypes.createWithContext(GoTypeUtil.getInterfaceType(parent), parent) : GoExpectedTypes.create(types);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(12);
                }
                return goExpectedTypes;
            }
            if (unaryExpr.getMul() != null) {
                GoType[] types = (GoType[])GoTypeUtil.getExpectedTypes(unaryExpr).getTypes().stream().map(GoLightType.LightPointerType::new).toArray(GoType[]::new);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(types);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(13);
                }
                return goExpectedTypes;
            }
            return GoTypeUtil.getExpectedTypes(unaryExpr);
        }
        if (parent instanceof GoBinaryExpr) {
            GoBinaryExpr binaryExpr = (GoBinaryExpr)parent;
            return GoTypeUtil.getExpectedTypesForBinaryExprOperand(expression, binaryExpr);
        }
        if (parent instanceof GoSendStatement) {
            GoSendStatement sendStatement = (GoSendStatement)parent;
            return GoTypeUtil.getExpectedTypesFromGoSendStatement(expression, sendStatement);
        }
        if (parent instanceof GoExprCaseClause) {
            GoExprSwitchStatement switchStatement = (GoExprSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, GoExprSwitchStatement.class);
            assert (switchStatement != null);
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoExprCaseClauseExpectedType(switchStatement));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(14);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoReturnStatement) {
            GoReturnStatement returnStatement = (GoReturnStatement)parent;
            return GoTypeUtil.getExpectedTypesFromReturnStatement(returnStatement, expression);
        }
        if (parent instanceof GoKey) {
            GoKey key = (GoKey)parent;
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoPsiImplUtil.getKeyType(key), expression);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(15);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoValue) {
            GoLiteralValue literalValue;
            GoType literalValueType;
            GoValue value = (GoValue)parent;
            GoElement literalElement = (GoElement)ObjectUtils.tryCast((Object)parent.getParent(), GoElement.class);
            if (literalElement != null && literalElement.getKey() == null && (literalValueType = GoInspectionUtil.getLiteralValueUnderlyingType(literalValue = (GoLiteralValue)ObjectUtils.tryCast((Object)literalElement.getParent(), GoLiteralValue.class))) instanceof GoMapType) {
                GoMapType mapType = (GoMapType)literalValueType;
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(mapType.getKeyType(), expression);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(16);
                }
                return goExpectedTypes;
            }
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoPsiImplUtil.getValueType(value), expression);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(17);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoForStatement || parent instanceof GoForClause || GoPsiUtil.isIfCondition(expression)) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConditionExpectedType((PsiElement)expression.getContainingFile()));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(18);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoDeferStatement) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoFunctionExpectedType());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(19);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoLeftHandExprList) {
            GoLeftHandExprList leftHandExprList = (GoLeftHandExprList)parent;
            return GoTypeUtil.getExpectedTypesFromAssignmentLHS(expression, leftHandExprList);
        }
        if (parent instanceof GoConversionExpr && (type2 = GoPsiUtil.getTypeIfConversion(CompletionUtil.getOriginalOrSelf((PsiElement)(conversionExpr = (GoConversionExpr)parent)))) != null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConversionExpectedType(type2));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(20);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoIndexOrSliceExpr && (indexOrSliceExpr = (GoIndexOrSliceExpr)parent).getExpressionList().contains(expression)) {
            GoReferenceExpression referenceExpression;
            GoType exprType;
            GoExpression indexedExpr = indexOrSliceExpr.getExpression();
            GoType goType = exprType = indexedExpr != null ? indexedExpr.getGoType(ResolveState.initial()) : null;
            if (exprType instanceof GoMapType) {
                GoMapType mapType = (GoMapType)exprType;
                GoType keyType = mapType.getKeyType();
                GoExpectedTypes goExpectedTypes = keyType != null ? GoExpectedTypes.create(keyType) : GoExpectedTypes.EMPTY;
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(21);
                }
                return goExpectedTypes;
            }
            if (exprType instanceof GoArrayOrSliceType) {
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoAnyIntegerExpectedType.inSliceExpression(expression));
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(22);
                }
                return goExpectedTypes;
            }
            if (indexedExpr instanceof GoReferenceExpression && (referenceExpression = (GoReferenceExpression)indexedExpr).resolve() == null) {
                if (indexOrSliceExpr.isIndexExpression()) {
                    GoType type6;
                    GoExpression firstIndex = (GoExpression)indexOrSliceExpr.getIndices().first;
                    if (firstIndex != null && (type6 = firstIndex.getGoType(null)) != null) {
                        if (GoTypeUtil.isIntegerType(type6, indexOrSliceExpr)) {
                            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoElementFactory.createTypeCheap(indexOrSliceExpr.getProject(), "[]any"));
                            if (goExpectedTypes == null) {
                                GoTypeUtil.$$$reportNull$$$0(23);
                            }
                            return goExpectedTypes;
                        }
                        String typeText = "map[" + type6.getPresentationText() + "]any";
                        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoElementFactory.createTypeCheap(indexOrSliceExpr.getProject(), typeText, indexOrSliceExpr));
                        if (goExpectedTypes == null) {
                            GoTypeUtil.$$$reportNull$$$0(24);
                        }
                        return goExpectedTypes;
                    }
                } else {
                    GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoElementFactory.createTypeCheap(indexOrSliceExpr.getProject(), "[]any"));
                    if (goExpectedTypes == null) {
                        GoTypeUtil.$$$reportNull$$$0(25);
                    }
                    return goExpectedTypes;
                }
            }
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(26);
        }
        return goExpectedTypes;
    }

    public static boolean isMapCompositeLiteralElement(@NotNull GoElement literalElement) {
        if (literalElement == null) {
            GoTypeUtil.$$$reportNull$$$0(27);
        }
        GoLiteralValue literalValue = (GoLiteralValue)ObjectUtils.tryCast((Object)literalElement.getParent(), GoLiteralValue.class);
        GoType literalValueType = GoInspectionUtil.getLiteralValueUnderlyingType(literalValue);
        return literalValueType instanceof GoMapType;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromReturnStatement(@NotNull GoReturnStatement returnStatement, @NotNull GoExpression expression) {
        GoSignatureOwner signatureOwner;
        if (returnStatement == null) {
            GoTypeUtil.$$$reportNull$$$0(28);
        }
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(29);
        }
        GoType type2 = (signatureOwner = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GoSignatureOwner.class)) != null ? signatureOwner.getResultType() : null;
        List<GoType> resultTypes = type2 instanceof GoTypeList ? ((GoTypeList)type2).getTypeList() : ContainerUtil.createMaybeSingletonList((Object)type2);
        int resultCount = resultTypes.size();
        List<GoExpression> expressions = returnStatement.getExpressionList();
        int indexOf = expressions.indexOf(expression);
        if (indexOf < 0 || expressions.size() > resultCount) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(30);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = expressions.size() == 1 && resultCount > 1 ? GoExpectedTypes.create(type2, (GoType)ContainerUtil.getFirstItem(resultTypes)) : GoExpectedTypes.create(resultTypes.get(indexOf));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(31);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromGoSendStatement(@NotNull GoExpression expression, @NotNull GoSendStatement statement) {
        GoType chanType;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(32);
        }
        if (statement == null) {
            GoTypeUtil.$$$reportNull$$$0(33);
        }
        GoExpression channel = statement.getChannelExpression();
        GoExpression sendExpr = statement.getSendExpression();
        if (expression.isEquivalentTo(sendExpr) && (chanType = channel.getGoType(null)) instanceof GoChannelType) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(((GoChannelType)chanType).getType(), statement);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(34);
            }
            return goExpectedTypes;
        }
        if (expression.isEquivalentTo(channel)) {
            GoType type2 = sendExpr != null ? sendExpr.getGoType(null) : null;
            String text = GoTypeUtil.getTypeNameOrText(GoTypeUtil.getInterfaceIfNull(type2, statement));
            GoType chanType2 = GoElementFactory.createTypeCheap(statement.getProject(), "chan " + text);
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(chanType2);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(35);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoTypeUtil.getInterfaceType(statement), statement);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(36);
        }
        return goExpectedTypes;
    }

    @Nullable
    public static GoSignature getSignatureFromFunctionType(@NotNull GoCallLikeExpr call) {
        GoExpression calledExpression;
        GoType type2;
        GoType coreType;
        if (call == null) {
            GoTypeUtil.$$$reportNull$$$0(37);
        }
        GoType goType = coreType = (type2 = (calledExpression = call.getExpression()).getGoType(null)) != null ? GoTypeUtil.getCoreType(type2, call) : null;
        if (coreType instanceof GoFunctionType) {
            return ((GoFunctionType)coreType).getSignature();
        }
        return null;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromArgumentList(@NotNull GoExpression expression, @NotNull GoArgumentList argumentList, @NotNull GoCallLikeExpr call) {
        GoSignature resolvedSignature;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(38);
        }
        if (argumentList == null) {
            GoTypeUtil.$$$reportNull$$$0(39);
        }
        if (call == null) {
            GoTypeUtil.$$$reportNull$$$0(40);
        }
        if ((resolvedSignature = call.resolveSignature()) != null) {
            GoParameters parameters = resolvedSignature.getParameters();
            List<GoParameterDeclaration> paramsList = parameters.getParameterDeclarationList();
            if (paramsList.isEmpty()) {
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(41);
                }
                return goExpectedTypes;
            }
            boolean variadic = parameters.isVariadic();
            List<GoExpression> exprList = argumentList.getExpressionList();
            if (exprList.size() == 1) {
                SmartList typeList = new SmartList();
                for (GoParameterDeclaration parameterDecl : paramsList) {
                    for (GoParamDefinition parameter : parameterDecl.getParamDefinitionList()) {
                        GoType type2 = GoTypeUtil.unwrapVariadicArrayOrSliceType(GoTypeUtil.getGoType(parameter, argumentList), parameter);
                        typeList.add(GoTypeUtil.getInterfaceIfNull(type2, argumentList));
                    }
                    if (!parameterDecl.getParamDefinitionList().isEmpty()) continue;
                    typeList.add(GoTypeUtil.getInterfaceIfNull(parameterDecl.getType(), argumentList));
                }
                GoExpectedTypeImpl typeListExpectedType = new GoExpectedTypeImpl(GoTypeUtil.createGoTypeListOrGoType((List<GoType>)typeList, argumentList), variadic);
                if (typeList.size() <= 1) {
                    GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(typeListExpectedType);
                    if (goExpectedTypes == null) {
                        GoTypeUtil.$$$reportNull$$$0(42);
                    }
                    return goExpectedTypes;
                }
                assert (paramsList.get(0) != null);
                GoType firstParameterType = GoTypeUtil.getInterfaceIfNull(paramsList.get(0).getType(), argumentList);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(typeListExpectedType, new GoExpectedTypeImpl(firstParameterType, false));
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(43);
                }
                return goExpectedTypes;
            }
            GoParameterDeclaration lastParameter = (GoParameterDeclaration)ContainerUtil.getLastItem(paramsList);
            int index = exprList.indexOf(expression);
            GoParameterDeclaration decl = parameters.getDeclarationByIndex(index);
            if (decl != null) {
                GoParamDefinition parameter = parameters.getDefinitionByIndex(index);
                GoType parameterType = parameter != null ? parameter.getGoType(null) : parameters.getTypeByIndex(index);
                GoType type3 = GoTypeUtil.unwrapVariadicArrayOrSliceType(parameterType, parameter);
                boolean isLastParameter = decl.isEquivalentTo(lastParameter);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(type3, argumentList, variadic && isLastParameter);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(44);
                }
                return goExpectedTypes;
            }
            if (variadic) {
                GoType type4 = Objects.requireNonNull(lastParameter).getType();
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(type4, argumentList, false);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(45);
                }
                return goExpectedTypes;
            }
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoTypeUtil.getInterfaceType(argumentList), argumentList, true);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(46);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesForBinaryExprOperand(@NotNull GoExpression operand, @NotNull GoBinaryExpr binaryExpression) {
        PsiElement operator;
        if (operand == null) {
            GoTypeUtil.$$$reportNull$$$0(47);
        }
        if (binaryExpression == null) {
            GoTypeUtil.$$$reportNull$$$0(48);
        }
        if ((operator = binaryExpression.getOperator()) == null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.getInterfaceType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(49);
            }
            return goExpectedTypes;
        }
        GoType type2 = GoTypeUtil.getExpectedOperandTypeFromOtherOperands(operand, binaryExpression);
        if (type2 != null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(type2);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(50);
            }
            return goExpectedTypes;
        }
        IElementType operatorType = operator.getNode().getElementType();
        GoExpectedTypes expectedTypes = GoTypeUtil.getExpectedTypes(binaryExpression);
        if (!expectedTypes.areEmpty() && !expectedTypes.areCompatibleWith(GoTypeUtil.getInterfaceType(operand), null, false, false, ResolveState.initial())) {
            GoExpectedTypes goExpectedTypes = expectedTypes;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(51);
            }
            return goExpectedTypes;
        }
        if (GoParserDefinition.Lazy.SHIFT_BINARY_OPERATORS.contains(operatorType)) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(52);
            }
            return goExpectedTypes;
        }
        if (GoParserDefinition.Lazy.CONDITION_BINARY_OPERATORS.contains(operatorType)) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConditionExpectedType((PsiElement)operand.getContainingFile()));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(53);
            }
            return goExpectedTypes;
        }
        if (operatorType == GoTypes.PLUS) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand), GoLightType.getFloatType(operand), GoLightType.getComplexType(operand), GoLightType.getStringType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(54);
            }
            return goExpectedTypes;
        }
        if (operatorType == GoTypes.MINUS || operatorType == GoTypes.MUL || operatorType == GoTypes.QUOTIENT) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand), GoLightType.getFloatType(operand), GoLightType.getComplexType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(55);
            }
            return goExpectedTypes;
        }
        if (operatorType == GoTypes.REMAINDER || operatorType == GoTypes.BIT_AND || operatorType == GoTypes.BIT_OR || operatorType == GoTypes.BIT_XOR || operatorType == GoTypes.BIT_CLEAR) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(56);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.getInterfaceType(operand));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(57);
        }
        return goExpectedTypes;
    }

    @Nullable
    private static GoType getExpectedOperandTypeFromOtherOperands(@NotNull GoExpression operandExpr, @NotNull GoBinaryExpr binaryExpression) {
        PsiElement operator;
        if (operandExpr == null) {
            GoTypeUtil.$$$reportNull$$$0(58);
        }
        if (binaryExpression == null) {
            GoTypeUtil.$$$reportNull$$$0(59);
        }
        if ((operator = binaryExpression.getOperator()) == null) {
            return null;
        }
        boolean isConditionalExpr = GoParserDefinition.Lazy.CONDITION_BINARY_OPERATORS.contains(GoTypeUtil.getBinaryExprOperatorType(binaryExpression));
        GoType result = null;
        PsiElement operand = GoTypeUtil.findNonShiftExpressionOperand(operandExpr);
        while (operand != null) {
            GoExpression otherOperand;
            GoType otherOperandType;
            GoType type2;
            GoBinaryExpr parentExpr = (GoBinaryExpr)operand.getParent();
            if (!isConditionalExpr && GoParserDefinition.Lazy.CONDITION_BINARY_OPERATORS.contains(GoTypeUtil.getBinaryExprOperatorType(parentExpr)) || (type2 = GoTypeUtil.getBinaryExprOperandTypeFromOtherOperand(result, otherOperandType = (otherOperand = parentExpr.getLeft() == operand ? parentExpr.getRight() : parentExpr.getLeft()) != null ? otherOperand.getGoType(null) : null, operandExpr)) == null || !((result = type2) instanceof GoLightType.LightUntypedType)) break;
            operand = GoTypeUtil.findNonShiftExpressionOperand(parentExpr);
        }
        return result;
    }

    @Nullable
    private static PsiElement findNonShiftExpressionOperand(@NotNull PsiElement operand) {
        if (operand == null) {
            GoTypeUtil.$$$reportNull$$$0(60);
        }
        operand = GoPsiUtil.skipParens(operand);
        GoBinaryExpr binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)operand.getParent(), GoBinaryExpr.class);
        while (GoParserDefinition.Lazy.SHIFT_BINARY_OPERATORS.contains(GoTypeUtil.getBinaryExprOperatorType(binaryExpr))) {
            if (binaryExpr.getLeft() == operand) {
                operand = GoPsiUtil.skipParens(binaryExpr);
                binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)operand.getParent(), GoBinaryExpr.class);
                continue;
            }
            return null;
        }
        return binaryExpr != null ? operand : null;
    }

    @Nullable
    private static GoType getBinaryExprOperandTypeFromOtherOperand(@Nullable GoType operandType, @Nullable GoType otherOperandType, @Nullable PsiElement context) {
        int otherOperandTypeRank;
        int operandTypeRank;
        if (otherOperandType == null) {
            return null;
        }
        if (operandType == null) {
            return otherOperandType;
        }
        if (!GoTypeUtil.isAssignable(operandType, null, otherOperandType, context, true)) {
            return GoTypeUtil.isAssignable(otherOperandType, null, operandType, context, true) ? otherOperandType : null;
        }
        if (operandType instanceof GoLightType.LightUntypedNumericType && otherOperandType instanceof GoLightType.LightUntypedNumericType && (operandTypeRank = GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)operandType)) < (otherOperandTypeRank = GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)otherOperandType))) {
            return otherOperandType;
        }
        return operandType;
    }

    @Contract(value="null -> null")
    @Nullable
    private static IElementType getBinaryExprOperatorType(@Nullable PsiElement element) {
        return GoExpressionUtil.getOperatorType((GoBinaryExpr)ObjectUtils.tryCast((Object)element, GoBinaryExpr.class));
    }

    @Contract(value="!null,_ -> !null")
    private static GoType unwrapVariadicArrayOrSliceType(@Nullable GoType type2, @Nullable GoParamDefinition parameter) {
        return GoTypeUtil.unwrapVariadicArrayOrSliceType(type2, parameter != null && parameter.isVariadic());
    }

    @Contract(value="!null,_ -> !null")
    public static GoType unwrapVariadicArrayOrSliceType(@Nullable GoType type2, boolean isVariadic) {
        if (isVariadic && type2 instanceof GoArrayOrSliceType) {
            return ((GoArrayOrSliceType)type2).getType();
        }
        return type2;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypeForNewAndMake(@NotNull GoExpression expression, @NotNull GoBuiltinCallExpr callExpr) {
        boolean textMatches;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(61);
        }
        if (callExpr == null) {
            GoTypeUtil.$$$reportNull$$$0(62);
        }
        GoBuiltinArgumentList list = callExpr.getBuiltinArgumentList();
        GoExpression referenceExpression = callExpr.getExpression().unwrapParentheses();
        boolean bl = textMatches = referenceExpression != null && !referenceExpression.textMatches("make");
        if (textMatches || expression != ContainerUtil.getFirstItem(list.getExpressionList())) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(63);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoAnyIntegerExpectedType.inBuiltinFile(expression));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(64);
        }
        return goExpectedTypes;
    }

    @Nullable
    private static GoExpectedTypes getExpectedTypesForBuiltinFunctions(@NotNull GoExpression expression, @NotNull GoCallExpr callExpr) {
        GoType keyType;
        List<GoExpression> exprList;
        GoExpression first;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(65);
        }
        if (callExpr == null) {
            GoTypeUtil.$$$reportNull$$$0(66);
        }
        GoType firstType = (first = (GoExpression)ContainerUtil.getFirstItem(exprList = callExpr.getArgumentList().getExpressionList())) != null ? first.getGoType(null) : null;
        int index = exprList.indexOf(expression);
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "append")) {
            if (index == 0) {
                return GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile());
            }
            GoType elementType = GoTypeUtil.getArrayOrSliceElementType(GoTypeUtil.getArrayOrSliceType(firstType, expression));
            if (elementType != null) {
                return GoExpectedTypes.create(elementType, exprList.size() == 2);
            }
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "delete") && index == 1 && (keyType = GoTypeUtil.getMapKeyType(firstType, expression)) != null) {
            return GoExpectedTypes.create(keyType, false);
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "complex")) {
            GoType underlying;
            if (index > 0 && firstType != null && !GoTypeUtil.isTypeParameter(firstType, first) && GoTypeUtil.isTypedFloatType(underlying = firstType.getUnderlyingType(first), first)) {
                return GoExpectedTypes.create(new GoIdenticalExpectedType(firstType), new GoUntypedFloatExpectedType());
            }
            return GoExpectedTypes.create(new GoNotTypeParameterExpectedType(new GoAnyFloatExpectedType()));
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "real", "imag")) {
            return GoExpectedTypes.create(new GoNotTypeParameterExpectedType(new GoAnyComplexExpectedType()));
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "copy")) {
            if (exprList.size() != 2 || index < 0 || index > 1) {
                return GoTypeUtil.builtinCopyDefaultExpectedTypes(expression, index);
            }
            GoExpression second = exprList.get(1);
            if (first == null || second == null) {
                return GoTypeUtil.builtinCopyDefaultExpectedTypes(expression, index);
            }
            if (index == 0) {
                GoType srcCoreType;
                if (GoExpressionUtil.isNil(first) && (srcCoreType = GoTypeUtil.getCoreType(second.getGoType(null), expression)) != null) {
                    GoArrayOrSliceType byteSliceType;
                    if (GoTypeUtil.isSlice(srcCoreType, expression)) {
                        return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(srcCoreType)));
                    }
                    if (GoTypeUtil.isString(srcCoreType, expression) && (byteSliceType = GoTypeUtil.getByteSliceType(expression)) != null) {
                        return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(byteSliceType)));
                    }
                }
                return GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile());
            }
            GoType dstCoreType = GoTypeUtil.getCoreType(firstType, expression);
            if (dstCoreType == null || !GoTypeUtil.isSlice(dstCoreType, expression)) {
                return GoTypeUtil.builtinCopyDefaultExpectedTypes(expression, index);
            }
            if (GoTypeUtil.isByteSliceStrict(dstCoreType, expression)) {
                return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(dstCoreType)), new GoCoreStringExpectedType());
            }
            return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(dstCoreType)));
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "close")) {
            return GoExpectedTypes.create(new GoAnySendChannelExpectedType());
        }
        if (GoStdlibUtil.isUnsafeFunctionCall(callExpr, "Slice")) {
            if (index == 0) {
                return GoExpectedTypes.create(new GoNotNilExpectedType(new GoAnyPointerExpectedType()));
            }
            if (index == 1) {
                return GoExpectedTypes.create(GoAnyIntegerExpectedType.inUnsafePackage(expression));
            }
        }
        if (GoStdlibUtil.isUnsafeFunctionCall(callExpr, "SliceData") && index == 0) {
            return GoExpectedTypes.create(GoTypedSliceExpectedType.inUnsafePackage());
        }
        if (GoStdlibUtil.isUnsafeFunctionCall(callExpr, "Add", "String") && index == 1) {
            return GoExpectedTypes.create(GoAnyIntegerExpectedType.inUnsafePackage(expression));
        }
        return null;
    }

    @NotNull
    private static GoExpectedTypes builtinCopyDefaultExpectedTypes(@NotNull PsiElement argument, int argumentIndex) {
        if (argument == null) {
            GoTypeUtil.$$$reportNull$$$0(67);
        }
        if (argumentIndex == 0) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(68);
            }
            return goExpectedTypes;
        }
        if (argumentIndex == 1) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile(), new GoCoreStringExpectedType());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(69);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.getInterfaceType(argument));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(70);
        }
        return goExpectedTypes;
    }

    public static boolean isByteSlice(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isSliceOfType(type2, context, BYTE, UINT8);
    }

    public static boolean isByteSliceStrict(@Nullable GoType type2, @Nullable PsiElement context) {
        GoType instantiatedSlice = GoTypeUtil.getArrayOrSliceType(type2, context);
        GoArrayOrSliceType slice = (GoArrayOrSliceType)instantiatedSlice;
        if (slice == null || slice.isArray()) {
            return false;
        }
        GoType sliceElementType = GoTypeUtil.getArrayOrSliceElementType(instantiatedSlice);
        return sliceElementType != null && (sliceElementType.textMatches(BYTE) || sliceElementType.textMatches(UINT8)) && GoPsiImplUtil.builtin(sliceElementType.resolve(context));
    }

    public static boolean isRuneSlice(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isSliceOfType(type2, context, RUNE, INT32);
    }

    public static boolean isSliceOfType(@Nullable GoType type2, @Nullable PsiElement context, String ... builtinTypes) {
        GoType instantiatedSlice;
        GoArrayOrSliceType slice;
        if (builtinTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(71);
        }
        if ((slice = (GoArrayOrSliceType)(instantiatedSlice = GoTypeUtil.getArrayOrSliceType(type2, context))) == null || slice.isArray()) {
            return false;
        }
        GoType sliceType = GoTypeUtil.getArrayOrSliceElementType(instantiatedSlice);
        for (String builtinType : builtinTypes) {
            if (!GoTypeUtil.isBuiltinType(sliceType, context, builtinType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromRecvStatement(@NotNull GoRecvStatement recvStatement) {
        if (recvStatement == null) {
            GoTypeUtil.$$$reportNull$$$0(72);
        }
        SmartList typeList = new SmartList();
        for (GoExpression expr : recvStatement.getLeftExpressionsList()) {
            typeList.add(GoTypeUtil.getGoType(expr, recvStatement));
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.createGoTypeListOrGoType((List<GoType>)typeList, recvStatement));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(73);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromVarOrConstSpec(@NotNull GoExpression expression, @NotNull GoVarOrConstSpec spec) {
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(74);
        }
        if (spec == null) {
            GoTypeUtil.$$$reportNull$$$0(75);
        }
        GoType type2 = GoTypeUtil.getInterfaceIfNull(spec.getType(), spec);
        if (spec.getRightExpressionsList().size() == 1) {
            int defListSize = spec.getDefinitionList().size();
            return GoTypeUtil.getTypes(expression, type2, defListSize);
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(type2);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(76);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getTypes(@NotNull PsiElement context, @NotNull GoType type2, int defListSize) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(77);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(78);
        }
        SmartList listOfTypes = new SmartList();
        for (int i = 0; i < defListSize; ++i) {
            listOfTypes.add(type2);
        }
        GoType typeList = GoTypeUtil.createGoTypeListOrGoType((List<GoType>)listOfTypes, context);
        GoExpectedTypes goExpectedTypes = defListSize > 1 ? GoExpectedTypes.create(typeList, type2) : GoExpectedTypes.create(typeList);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(79);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromAssignmentStatement(@NotNull GoExpression expression, @NotNull GoAssignmentStatement assignment) {
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(80);
        }
        if (assignment == null) {
            GoTypeUtil.$$$reportNull$$$0(81);
        }
        List<GoExpression> leftExpressions = assignment.getLeftHandExprList().getExpressionList();
        if (assignment.getExpressionList().size() == 1) {
            SmartList typeList = new SmartList();
            for (GoExpression expr : leftExpressions) {
                typeList.add(GoTypeUtil.getInterfaceIfNull(expr.getGoType(null), expression));
            }
            GoType expectedType = GoTypeUtil.createGoTypeListOrGoType((List<GoType>)typeList, expression);
            GoExpectedTypes goExpectedTypes = leftExpressions.size() <= 1 ? GoExpectedTypes.create(expectedType) : GoExpectedTypes.create(expectedType, GoTypeUtil.getGoType(leftExpressions.get(0), assignment));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(82);
            }
            return goExpectedTypes;
        }
        int position = assignment.getExpressionList().indexOf(expression);
        GoType leftExpression = leftExpressions.size() > position ? leftExpressions.get(position).getGoType(null) : null;
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(leftExpression, assignment);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(83);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromAssignmentLHS(@NotNull GoExpression expression, @NotNull GoLeftHandExprList lhsExprList) {
        GoExpression goExpression;
        GoAssignmentStatement assignment;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(84);
        }
        if (lhsExprList == null) {
            GoTypeUtil.$$$reportNull$$$0(85);
        }
        if ((assignment = (GoAssignmentStatement)ObjectUtils.tryCast((Object)lhsExprList.getParent(), GoAssignmentStatement.class)) == null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(86);
            }
            return goExpectedTypes;
        }
        List<GoExpression> lhsExpressions = lhsExprList.getExpressionList();
        int index = lhsExpressions.indexOf(expression);
        if (index < 0) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(87);
            }
            return goExpectedTypes;
        }
        List<GoExpression> rhsExpressions = assignment.getExpressionList();
        if (rhsExpressions.size() == lhsExpressions.size()) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(rhsExpressions.get(index).getGoType(null), expression);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(88);
            }
            return goExpectedTypes;
        }
        if (rhsExpressions.size() == 1 && (goExpression = rhsExpressions.get(0)) instanceof GoCallExpr) {
            GoCallExpr call = (GoCallExpr)goExpression;
            GoFunctionType funcType = (GoFunctionType)ObjectUtils.tryCast((Object)call.getExpression().getGoType(null), GoFunctionType.class);
            GoResult result = funcType != null ? funcType.getResult() : null;
            GoParameters params = result != null ? result.getParameters() : null;
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(params != null ? params.getTypeByIndex(index) : null, expression);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(89);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(90);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoType createGoTypeListOrGoType(@NotNull List<GoType> types, @NotNull PsiElement context) {
        if (types == null) {
            GoTypeUtil.$$$reportNull$$$0(91);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(92);
        }
        return types.size() < 2 ? GoTypeUtil.getInterfaceIfNull((GoType)ContainerUtil.getFirstItem(types), context) : new GoLightType.LightTypeList(context, types);
    }

    @NotNull
    public static GoType getInterfaceIfNull(@Nullable GoType type2, @NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(93);
        }
        GoType goType = type2 == null ? GoTypeUtil.getInterfaceType(context) : type2;
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(94);
        }
        return goType;
    }

    @NotNull
    private static GoType getInterfaceType(@NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(95);
        }
        GoType goType = GoElementFactory.createTypeCheap(context.getProject(), "interface{}");
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(96);
        }
        return goType;
    }

    @NotNull
    private static GoType getGoType(@Nullable GoTypeOwner element, @NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(97);
        }
        return GoTypeUtil.getInterfaceIfNull(element != null ? element.getGoType(null) : null, context);
    }

    @Nullable
    public static GoType getDefaultType(@Nullable GoType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof GoLightType.LightUntypedType) {
            return ((GoLightType.LightUntypedType)type2).getDefaultType();
        }
        if (GoPsiImplUtil.builtin(type2)) {
            String text = GoTypeUtil.getTypeNameOrText(type2);
            if (DOC_ONLY_COMPLEX_TYPE.equals(text)) {
                return GoPsiImplUtil.getBuiltinType(COMPLEX128, type2);
            }
            if (DOC_ONLY_FLOAT_TYPE.equals(text)) {
                return GoPsiImplUtil.getBuiltinType(FLOAT64, type2);
            }
        }
        return type2;
    }

    @NotNull
    static String getTypeNameOrText(@NotNull GoType type2) {
        GoType baseType;
        String name;
        StubElement parent;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(98);
        }
        if ((parent = (StubElement)ObjectUtils.doIfNotNull((Object)((GoTypeStub)type2.getStub()), StubBase::getParentStub)) != null && !(parent instanceof GoTypeSpecStub)) {
            parent = parent.getParentStub();
        }
        if (parent instanceof GoTypeSpecStub && (name = ((GoTypeSpecStub)parent).getSpecTypeName()) != null) {
            String string = name;
            if (string == null) {
                GoTypeUtil.$$$reportNull$$$0(99);
            }
            return string;
        }
        if (type2 instanceof GoPointerType && (baseType = ((GoPointerType)type2).getType()) != null) {
            String string = "*" + GoTypeUtil.getTypeNameOrText(baseType);
            if (string == null) {
                GoTypeUtil.$$$reportNull$$$0(100);
            }
            return string;
        }
        String string = type2.getText();
        if (string == null) {
            GoTypeUtil.$$$reportNull$$$0(101);
        }
        return string;
    }

    public static boolean isAssignable(@Nullable GoType type2, @Nullable GoTypeOwner value, boolean strict) {
        return GoTypeUtil.checkAssignable(type2, value, strict) instanceof GoTypesCompatible;
    }

    public static boolean isAssignable(@Nullable GoType type2, @Nullable GoTypeOwner value, @Nullable GoType valueType, boolean strict) {
        return GoTypeUtil.checkAssignable(type2, value, valueType, strict) instanceof GoTypesCompatible;
    }

    public static boolean isAssignable(@Nullable GoType type2, @Nullable GoTypeOwner value, @Nullable GoType valueType, @Nullable PsiElement context, boolean strict) {
        return GoTypeUtil.checkAssignable(type2, value, valueType, context, strict) instanceof GoTypesCompatible;
    }

    @NotNull
    public static GoTypeCheckResult checkAssignable(@Nullable GoType type2, @Nullable GoTypeOwner value, boolean strict) {
        GoType valueType = value != null ? value.getGoType(null) : null;
        return GoTypeUtil.checkAssignable(type2, value, valueType, strict);
    }

    @NotNull
    public static GoTypeCheckResult checkAssignable(@Nullable GoType type2, @Nullable GoTypeOwner value, @Nullable GoType valueType, boolean strict) {
        PsiElement context = (PsiElement)ObjectUtils.doIfNotNull((Object)value, GoReferenceBase::getSubstitutionContextOrSelf);
        return GoTypeUtil.checkAssignable(type2, value, valueType, context, strict);
    }

    @NotNull
    public static GoTypeCheckResult checkAssignable(@Nullable GoType type2, @Nullable GoTypeOwner value, @Nullable GoType valueType, @Nullable PsiElement context, boolean strict) {
        GoType valueUnderlyingType;
        GoType underlyingType;
        if (type2 == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(102);
            }
            return goTypeCheckResult;
        }
        if (GoExpressionUtil.isNil(value)) {
            if (GoTypeUtil.isTypeParameter(type2, context)) {
                return GoTypeUtil.typeSetIs(type2, context, (GoType t) -> GoTypeUtil.isAssignable(t, value, valueType, context, strict)) ? new GoTypesCompatible() : new GoCannotBeNil();
            }
            return GoTypeUtil.isAllowedComparingToNil(type2, context) ? new GoTypesCompatible() : new GoCannotBeNil();
        }
        if (valueType == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(103);
            }
            return goTypeCheckResult;
        }
        if (valueType instanceof GoLightType.LightUntypedType && GoTypeUtil.isConstant(value)) {
            ThreeState representable = GoInvalidExpressionConversionInspection.isRepresentable(value, valueType, type2, strict);
            if (representable == ThreeState.UNSURE) {
                GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
                if (goTypeCheckResult == null) {
                    GoTypeUtil.$$$reportNull$$$0(104);
                }
                return goTypeCheckResult;
            }
            return representable.toBoolean() ? new GoTypesCompatible() : new GoNotRepresentable();
        }
        if (GoTypeUtil.isTypeParameter(type2, context) && !GoTypeUtil.isNamedType(valueType) && GoTypeUtil.matchTypeConstraints(underlyingType = type2.getUnderlyingType(context), context, (GoType t) -> GoTypeUtil.isAssignable(t, value, valueType, context, strict))) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isTypeParameter(valueType, context) && !GoTypeUtil.isNamedType(type2) && GoTypeUtil.matchTypeConstraints(valueUnderlyingType = valueType.getUnderlyingType(context), context, (GoType t) -> GoTypeUtil.isAssignable(type2, null, t, context, strict))) {
            return new GoTypesCompatible();
        }
        return GoTypeUtil.checkAssignable(type2, valueType, context, strict);
    }

    private static boolean isConstant(@Nullable GoTypeOwner value) {
        return value instanceof GoExpression && ((GoExpression)value).isConstant() || value instanceof GoConstDefinition;
    }

    @NotNull
    private static GoTypeCheckResult checkAssignable(@NotNull GoType left, @Nullable GoType right, @Nullable PsiElement context, boolean strict) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(105);
        }
        if (right == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(106);
            }
            return goTypeCheckResult;
        }
        if (left == right || left.equals(right)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isDocOnlyAnyType(left, context)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isArbitraryType(left, context)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.identical(left, right, strict, context)) {
            return new GoTypesCompatible();
        }
        GoType underlyingLeft = left.getUnderlyingType(context);
        if (right instanceof GoLightType.LightUntypedNumericType && GoTypeUtil.isNumericType(underlyingLeft, context)) {
            return new GoTypesCompatible();
        }
        if (right instanceof GoLightType.LightUntypedStringType && GoTypeUtil.isString(underlyingLeft, context)) {
            return new GoTypesCompatible();
        }
        if (right instanceof GoLightType.LightUntypedBoolType && GoTypeUtil.isBoolean(underlyingLeft, context)) {
            return new GoTypesCompatible();
        }
        GoType underlyingRight = right.getUnderlyingType(context);
        if (!(!GoTypeUtil.identical(underlyingLeft, underlyingRight, strict, context) || GoTypeUtil.isDefinedTypeModuloAlias(left, !strict, context) && GoTypeUtil.isDefinedTypeModuloAlias(right, !strict, context))) {
            return new GoTypesCompatible();
        }
        if (underlyingLeft instanceof GoInterfaceType && !GoTypeUtil.isTypeParameter(left, context)) {
            GoTypeCheckResult result = GoTypeUtil.checkImplementsInterface(underlyingLeft, right, strict, context);
            GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(result, left, right);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(107);
            }
            return goTypeCheckResult;
        }
        GoChannelType leftChannel = (GoChannelType)ObjectUtils.tryCast((Object)underlyingLeft, GoChannelType.class);
        if (leftChannel != null) {
            GoChannelType rightChannel = (GoChannelType)ObjectUtils.tryCast((Object)underlyingRight, GoChannelType.class);
            if (rightChannel == null || GoTypeUtil.isDefinedTypeModuloAlias(left, !strict, context) && GoTypeUtil.isDefinedTypeModuloAlias(right, !strict, context)) {
                return new GoTypesNotCompatible();
            }
            GoPsiImplUtil.ChannelDirection rightChannelDirection = rightChannel.getDirection();
            if (rightChannelDirection != GoPsiImplUtil.ChannelDirection.BIDIRECTIONAL && rightChannelDirection != leftChannel.getDirection()) {
                return new GoTypesNotCompatible();
            }
            GoType leftChannelType = leftChannel.getType();
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(GoTypeUtil.isDocOnlyAnyType(leftChannelType, context) || GoTypeUtil.identical(leftChannelType, rightChannel.getType(), strict, context));
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(108);
            }
            return goTypeCheckResult;
        }
        return new GoTypesNotCompatible();
    }

    private static boolean isDefinedTypeModuloAlias(@Nullable GoType type2, boolean strict, @Nullable PsiElement context) {
        if (!GoTypeUtil.isNamedType(type2)) {
            return false;
        }
        if (GoTypeUtil.isTypeParameter(type2, context)) {
            return true;
        }
        GoType aliasedType = GoTypeUtil.unwrapAliasIfNamed(type2, context);
        return aliasedType != null ? GoTypeUtil.isNamedType(aliasedType) : !strict;
    }

    @Nullable
    public static GoType unwrapAliasIfNamed(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(109);
        }
        return GoPsiUtil.unwrapAlias(GoTypeUtil.findTypeSpec(type2, context));
    }

    @NotNull
    public static GoType unwrapAlias(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(110);
        }
        GoType goType = (GoType)ObjectUtils.notNull((Object)GoTypeUtil.unwrapAliasIfNamed(type2, context), (Object)type2);
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(111);
        }
        return goType;
    }

    @Contract(value="null, _ -> null")
    public static GoTypeSpec findTypeSpec(@Nullable GoType type2, @Nullable PsiElement context) {
        return (GoTypeSpec)ObjectUtils.tryCast((Object)GoTypeUtil.resolveNamedType(type2, context), GoTypeSpec.class);
    }

    @Nullable
    public static GoTypeSpec findTypeSpec(@Nullable GoType type2, @Nullable PsiElement context, boolean unwrapPointer) {
        GoType unwrapped = unwrapPointer ? GoPsiImplUtil.unwrapPointerIfNeeded(type2) : type2;
        return GoTypeUtil.findTypeSpec(unwrapped, context);
    }

    @Contract(value="null, _ -> null")
    public static GoNamedElement resolveNamedType(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)type2;
            return specType.getTypeSpec();
        }
        if (type2 instanceof GoTypeParameter) {
            GoTypeParameter typeParameter = (GoTypeParameter)type2;
            return typeParameter.getTypeParamDefinition();
        }
        GoTypeParamDefinition receiverTypeParam = GoPsiUtil.getReceiverTypeParamDefinition(type2);
        if (receiverTypeParam != null) {
            return receiverTypeParam;
        }
        return (GoNamedElement)ObjectUtils.tryCast((Object)type2.resolve(context), GoNamedElement.class);
    }

    public static boolean identical(@Nullable GoType left, @Nullable GoType right, @Nullable PsiElement context) {
        return GoTypeUtil.identical(left, right, false, false, context);
    }

    public static boolean identical(@Nullable GoType leftType, @Nullable GoType rightType, boolean strict, @Nullable PsiElement context) {
        return GoTypeUtil.identical(leftType, rightType, strict, false, context);
    }

    public static boolean identical(@Nullable GoType leftType, @Nullable GoType rightType, boolean strict, boolean forceIgnoreStructTags, @Nullable PsiElement context) {
        return (Boolean)GoPsiImplUtil.withContextOnElement(context, state -> {
            GoIdenticalTypesMatcher matcher = new GoIdenticalTypesMatcher(strict, forceIgnoreStructTags, false, (ResolveState)state);
            return matcher.match(leftType, rightType);
        });
    }

    public static boolean sameNamedTypes(@NotNull GoType l, @NotNull GoType r, @Nullable GoNamedElement lResolve, @Nullable GoNamedElement rResolve, boolean strict, @Nullable PsiElement context, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (l == null) {
            GoTypeUtil.$$$reportNull$$$0(112);
        }
        if (r == null) {
            GoTypeUtil.$$$reportNull$$$0(113);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(114);
        }
        if (!GoTypeUtil.isNamedType(l) || !GoTypeUtil.isNamedType(r)) {
            return false;
        }
        if (lResolve == null || rResolve == null) {
            return !strict;
        }
        if (!lResolve.isEquivalentTo(rResolve) && !GoTypeUtil.areEquivalentTypeParams(lResolve, rResolve, null, context)) {
            return false;
        }
        Map<GoTypeParamDefinition, GoTypeArgument> leftTypeArguments = GoTypeInstantiationKt.getExplicitParamSubstitutionMap(l, context);
        Map<GoTypeParamDefinition, GoTypeArgument> rightTypeArguments = GoTypeInstantiationKt.getExplicitParamSubstitutionMap(r, context);
        return GoTypeUtil.sameTypeArguments(leftTypeArguments, rightTypeArguments, predicate);
    }

    private static boolean sameTypeArguments(@NotNull Map<GoTypeParamDefinition, GoTypeArgument> leftTypeArguments, @NotNull Map<GoTypeParamDefinition, GoTypeArgument> rightTypeArguments, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (leftTypeArguments == null) {
            GoTypeUtil.$$$reportNull$$$0(115);
        }
        if (rightTypeArguments == null) {
            GoTypeUtil.$$$reportNull$$$0(116);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(117);
        }
        if (leftTypeArguments.size() != rightTypeArguments.size()) {
            return false;
        }
        for (Map.Entry<GoTypeParamDefinition, GoTypeArgument> entry : leftTypeArguments.entrySet()) {
            GoType leftType = entry.getValue().getType();
            GoTypeArgument rightTypeArgument = rightTypeArguments.get(entry.getKey());
            if (rightTypeArgument == null) {
                return false;
            }
            GoType rightType = rightTypeArgument.getType();
            if (predicate.test(leftType, rightType)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalentTypeParams(@NotNull GoNamedElement left, @NotNull GoNamedElement right, @Nullable ResolveState state, @Nullable PsiElement context) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(118);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(119);
        }
        if (!(left instanceof GoTypeParamDefinition) || !(right instanceof GoTypeParamDefinition)) {
            return false;
        }
        GoType lRecvTypeArg = GoPsiUtil.getReceiverTypeArg(left);
        GoTypeParamDefinition leftTypeParam = lRecvTypeArg != null ? GoPsiImplUtil.getReceiverTypeParam(lRecvTypeArg, state, context) : (GoTypeParamDefinition)left;
        GoType rRecvTypeArg = GoPsiUtil.getReceiverTypeArg(right);
        GoTypeParamDefinition rightTypeParam = rRecvTypeArg != null ? GoPsiImplUtil.getReceiverTypeParam(rRecvTypeArg, state, context) : (GoTypeParamDefinition)right;
        return leftTypeParam != null && rightTypeParam != null && leftTypeParam.isEquivalentTo(rightTypeParam);
    }

    public static boolean sameBuiltinIntegerAliases(@NotNull GoType left, @NotNull GoType right, @Nullable PsiElement context) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(120);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(121);
        }
        if (!GoTypeUtil.isBuiltinType(left, context) || !GoTypeUtil.isBuiltinType(right, context)) {
            return false;
        }
        String l = GoTypeUtil.getTypeNameOrText(left);
        String r = GoTypeUtil.getTypeNameOrText(right);
        return INT32_ALIAS.contains(l) && INT32_ALIAS.contains(r) || UINT8_ALIAS.contains(l) && UINT8_ALIAS.contains(r);
    }

    public static boolean sameInterfaces(@NotNull GoInterfaceType left, @NotNull GoInterfaceType right, @Nullable PsiElement context, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(122);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(123);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(124);
        }
        List<GoMethodSpec> leftMethods = left.getAllMethods(context);
        List<GoMethodSpec> rightMethods = right.getAllMethods(context);
        if (leftMethods.size() != rightMethods.size()) {
            return false;
        }
        ContainerUtil.sort(leftMethods, BY_NAME);
        ContainerUtil.sort(rightMethods, BY_NAME);
        NotNullLazyValue<Boolean> samePackages = GoTypeUtil.isSamePackages(left, right);
        for (int i = 0; i < leftMethods.size(); ++i) {
            GoMethodSpec rightMethod;
            GoMethodSpec leftMethod = leftMethods.get(i);
            if (!GoTypeUtil.sameNames(leftMethod, rightMethod = rightMethods.get(i), samePackages)) {
                return false;
            }
            if (GoTypeUtil.sameSignatures(leftMethod.getSignature(), rightMethod.getSignature(), predicate)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static NotNullLazyValue<Boolean> isSamePackages(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(125);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(126);
        }
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.createValue(() -> {
            PsiElement leftContext = GoReferenceBase.getSubstitutionContextOrSelf(left);
            PsiElement rightContext = GoReferenceBase.getSubstitutionContextOrSelf(right);
            return GoUtil.inSamePackage(leftContext.getContainingFile(), rightContext.getContainingFile(), true);
        });
        if (notNullLazyValue == null) {
            GoTypeUtil.$$$reportNull$$$0(127);
        }
        return notNullLazyValue;
    }

    private static boolean sameNames(@NotNull GoNamedElement left, @NotNull GoNamedElement right, @NotNull NotNullLazyValue<Boolean> inSamePackages) {
        String name;
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(128);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(129);
        }
        if (inSamePackages == null) {
            GoTypeUtil.$$$reportNull$$$0(130);
        }
        if (!Objects.equals(name = left.getName(), right.getName())) {
            return false;
        }
        if (name == null) {
            return false;
        }
        return left.isPublic() || (Boolean)inSamePackages.getValue() != false;
    }

    public static boolean sameStructs(@NotNull GoStructType left, @NotNull GoStructType right, boolean checkTags, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(131);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(132);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(133);
        }
        List<GoNamedElement> l = left.getFieldDefinitions();
        List<GoNamedElement> r = right.getFieldDefinitions();
        if (l.size() != r.size()) {
            return false;
        }
        NotNullLazyValue<Boolean> samePackages = GoTypeUtil.isSamePackages(left, right);
        for (int i = 0; i < l.size(); ++i) {
            GoNamedElement s;
            GoNamedElement f = l.get(i);
            if (!GoTypeUtil.sameNames(f, s = r.get(i), samePackages)) {
                return false;
            }
            if (f instanceof GoFieldDefinition && !(s instanceof GoFieldDefinition)) {
                return false;
            }
            if (f instanceof GoAnonymousFieldDefinition && !(s instanceof GoAnonymousFieldDefinition)) {
                return false;
            }
            if (!predicate.test(f.getGoType(null), s.getGoType(null))) {
                return false;
            }
            if (!checkTags || Objects.equals(GoTypeUtil.getTagForFieldDefinition(f), GoTypeUtil.getTagForFieldDefinition(s))) continue;
            return false;
        }
        return true;
    }

    private static String getTagForFieldDefinition(@Nullable GoNamedElement definition) {
        GoFieldDeclaration declaration = (GoFieldDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)definition, GoFieldDeclaration.class);
        return GoStringUtil.unescapeStringLiteralText(declaration == null ? null : declaration.getTagText());
    }

    @Contract(value="null -> false")
    public static boolean isNamedType(@Nullable GoType type2) {
        return type2 != null && !(type2 instanceof GoArrayOrSliceType) && !(type2 instanceof GoStructType) && !(type2 instanceof GoPointerType) && !(type2 instanceof GoFunctionType) && !(type2 instanceof GoInterfaceType) && !(type2 instanceof GoMapType) && !(type2 instanceof GoChannelType) && !(type2 instanceof GoTypeList) && !(type2 instanceof GoCType) && !(type2 instanceof GoLightType.LightVoidType);
    }

    public static boolean isImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type2, boolean strict, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(134);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(135);
        }
        return GoTypeUtil.isImplementsInterface(interfaceType, type2, strict, true, context);
    }

    public static boolean isImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type2, boolean strict, boolean checkPointers, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(136);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(137);
        }
        return GoTypeUtil.isImplementsInterface(interfaceType, type2, strict, checkPointers, false, context);
    }

    public static boolean isImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type2, boolean strict, boolean checkPointers, boolean checkPossibleIdentity, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(138);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(139);
        }
        return GoTypeUtil.checkImplementsInterface(interfaceType, type2, strict, checkPointers, checkPossibleIdentity, context) instanceof GoTypesCompatible;
    }

    @NotNull
    public static GoTypeCheckResult checkImplementsConstraint(@NotNull GoType constraintType, @NotNull GoType valueType, @Nullable PsiElement context, boolean strict) {
        boolean wantComparable;
        GoTypeCheckResult result;
        ResolveState state;
        GoType valueUnderlyingType;
        GoTypeSet valueTypeSet;
        if (constraintType == null) {
            GoTypeUtil.$$$reportNull$$$0(140);
        }
        if (valueType == null) {
            GoTypeUtil.$$$reportNull$$$0(141);
        }
        if ((valueTypeSet = GoTypeSetKt.computeTypeSet(valueUnderlyingType = valueType.getUnderlyingType(state = GoPsiImplUtil.createContextOnElement(context)), state)) == GoTypeSet.Empty.INSTANCE) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(true);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(142);
            }
            return goTypeCheckResult;
        }
        GoType constraintUnderlyingType = GoPsiImplUtil.getUnderlyingType(constraintType, state);
        GoInterfaceType constraintInterface = (GoInterfaceType)ObjectUtils.tryCast((Object)constraintUnderlyingType, GoInterfaceType.class);
        if (constraintInterface != null && (result = GoTypeUtil.checkImplementsInterface(constraintUnderlyingType, valueType, strict, context)) instanceof GoTypesNotCompatible) {
            GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(result, constraintType, valueType);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(143);
            }
            return goTypeCheckResult;
        }
        GoTypeSet constraintTypeSet = GoTypeSetKt.computeTypeSet(constraintUnderlyingType, state);
        boolean bl = wantComparable = constraintTypeSet == GoTypeSet.Comparable.INSTANCE || GoTypeUtil.isBuiltinComparable(constraintUnderlyingType, context);
        if (wantComparable) {
            GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(GoTypeUtil.checkSatisfiesComparable(valueType, context, strict), constraintType, valueType);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(144);
            }
            return goTypeCheckResult;
        }
        if (constraintInterface == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(GoTypeUtil.identical(constraintType, valueType, strict, context));
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(145);
            }
            return goTypeCheckResult;
        }
        GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(GoTypeUtil.checkConstraintIncludesType(state, constraintTypeSet, valueType, valueUnderlyingType, valueTypeSet, strict), constraintType, valueType);
        if (goTypeCheckResult == null) {
            GoTypeUtil.$$$reportNull$$$0(146);
        }
        return goTypeCheckResult;
    }

    @Contract(value="null, _, _ -> null")
    private static GoTypeCheckResult addInterfaceProblemInfo(@Nullable GoTypeCheckResult result, @Nullable GoType interfaceType, @Nullable GoType valueType) {
        if (result instanceof GoDoesNotImplementInterface) {
            ((GoDoesNotImplementInterface)result).setInterfaceType(interfaceType);
            ((GoDoesNotImplementInterface)result).setType(valueType);
        }
        return result;
    }

    @NotNull
    private static GoTypeCheckResult checkImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type2, boolean strict, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(147);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(148);
        }
        return GoTypeUtil.checkImplementsInterface(interfaceType, type2, strict, true, false, context);
    }

    @NotNull
    private static GoTypeCheckResult checkImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type2, boolean strict, boolean checkPointers, boolean checkPossibleIdentity, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(149);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(150);
        }
        BiPredicate<GoSignature, GoSignature> signaturesMatcher = GoTypeUtil.getSignaturesMatcher(checkPossibleIdentity, strict, context);
        return GoTypeUtil.checkImplementsInterface(interfaceType, type2, checkPointers, context, signaturesMatcher);
    }

    @NotNull
    public static GoTypeCheckResult checkImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type2, boolean checkPointers, @Nullable PsiElement context, @NotNull BiPredicate<GoSignature, GoSignature> signaturesMatcher) {
        boolean bl;
        GoInterfaceType unwrappedInterfaceType;
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(151);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(152);
        }
        if (signaturesMatcher == null) {
            GoTypeUtil.$$$reportNull$$$0(153);
        }
        if ((unwrappedInterfaceType = (GoInterfaceType)ObjectUtils.tryCast((Object)interfaceType, GoInterfaceType.class)) == null) {
            return new GoTypesNotCompatible();
        }
        List<GoElementWithSubst<GoMethodSpec>> interfaceMethods = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(unwrappedInterfaceType, interfaceType, context);
        if (interfaceMethods.isEmpty()) {
            return new GoTypesCompatible();
        }
        GoType unwrappedType = GoTypeUtil.unwrapAlias(type2, context);
        if (GoTypeUtil.isPointerToInterface(unwrappedType, context)) {
            return new GoTypesNotCompatible();
        }
        boolean ambiguityPossible = false;
        HashMap<GoUniqueIdentifier, Object> implementedMethodsMap = new HashMap<GoUniqueIdentifier, Object>();
        for (GoElementWithSubst<? extends GoNamedSignatureOwner> implementedMethod : GoTypeUtil.findImplementedMethodsWithSubstitutionSource(type2, context)) {
            GoUniqueIdentifier goUniqueIdentifier;
            if (!implementedMethod.getElement().isValid() || (goUniqueIdentifier = GoUniqueIdentifier.Companion.of((GoNamedElement)implementedMethod.getElement(), context, true)) == null) continue;
            ambiguityPossible |= implementedMethodsMap.putIfAbsent(goUniqueIdentifier, implementedMethod) != null;
        }
        LinkedHashMap<GoElementWithSubst, GoUniqueIdentifier> interfaceMethodsMap = new LinkedHashMap<GoElementWithSubst, GoUniqueIdentifier>();
        for (GoElementWithSubst goElementWithSubst : interfaceMethods) {
            GoUniqueIdentifier identifier3 = GoUniqueIdentifier.Companion.of((GoNamedElement)goElementWithSubst.getElement(), context, true);
            if (identifier3 == null) {
                return new GoTypesNotCompatible();
            }
            interfaceMethodsMap.put(goElementWithSubst, identifier3);
        }
        SmartList missingMethods = new SmartList();
        for (GoElementWithSubst interfaceMethod : interfaceMethodsMap.keySet()) {
            GoUniqueIdentifier identifier4 = (GoUniqueIdentifier)interfaceMethodsMap.get(interfaceMethod);
            if (implementedMethodsMap.containsKey(identifier4)) continue;
            missingMethods.add((GoMethodSpec)interfaceMethod.getElement());
        }
        if (!missingMethods.isEmpty()) {
            Set implementedMethodNames;
            List list = ContainerUtil.filter((Collection)missingMethods, m -> !m.isPublic());
            if (!list.isEmpty() && ContainerUtil.exists((Iterable)list, arg_0 -> GoTypeUtil.lambda$checkImplementsInterface$20(implementedMethodNames = ContainerUtil.map2Set(implementedMethodsMap.keySet(), GoUniqueIdentifier::getName), arg_0))) {
                return new GoInterfaceWithNonExportedMethodInDifferentPackage();
            }
            return new GoMethodsMissing((List<GoMethodSpec>)missingMethods);
        }
        boolean bl2 = bl = !(unwrappedType instanceof GoPointerType);
        if (ambiguityPossible) {
            HashMap<String, GoElementWithSubst<GoMethodSpec>> interfaceMethodNamesMap = new HashMap<String, GoElementWithSubst<GoMethodSpec>>();
            interfaceMethodsMap.forEach((method, identifier) -> interfaceMethodNamesMap.putIfAbsent(identifier.getName(), (GoElementWithSubst<GoMethodSpec>)method));
            return GoTypeUtil.checkAmbiguousMethods(checkPointers, bl, signaturesMatcher, interfaceType, type2, interfaceMethodNamesMap, context);
        }
        for (GoElementWithSubst interfaceMethod : interfaceMethodsMap.keySet()) {
            GoUniqueIdentifier identifier5 = (GoUniqueIdentifier)interfaceMethodsMap.get(interfaceMethod);
            GoElementWithSubst implementedMethod = (GoElementWithSubst)implementedMethodsMap.get(identifier5);
            GoType interfaceSubstitutionSource = (GoType)ObjectUtils.notNull((Object)interfaceMethod.getSubstitutionSource(), (Object)interfaceType);
            GoType implementationSubstitutionSource = (GoType)ObjectUtils.notNull((Object)implementedMethod.getSubstitutionSource(), (Object)type2);
            GoTypeCheckResult result = GoTypeUtil.checkMethod(checkPointers, bl, signaturesMatcher, (GoMethodSpec)interfaceMethod.getElement(), interfaceSubstitutionSource, (GoNamedSignatureOwner)implementedMethod.getElement(), implementationSubstitutionSource);
            if (!(result instanceof GoTypesNotCompatible)) continue;
            GoTypeCheckResult goTypeCheckResult = result;
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(154);
            }
            return goTypeCheckResult;
        }
        return new GoTypesCompatible();
    }

    @NotNull
    private static BiPredicate<GoSignature, GoSignature> getSignaturesMatcher(boolean checkPossibleIdentity, boolean strict, @Nullable PsiElement context) {
        if (checkPossibleIdentity) {
            GoPossiblyIdenticalTypesMatcher matcher = new GoPossiblyIdenticalTypesMatcher(strict, GoPsiImplUtil.createContextOnElement(context));
            BiPredicate<GoSignature, GoSignature> biPredicate = (s1, s2) -> GoTypeUtil.sameSignatures(s1, s2, matcher::match);
            if (biPredicate == null) {
                GoTypeUtil.$$$reportNull$$$0(155);
            }
            return biPredicate;
        }
        BiPredicate<GoSignature, GoSignature> biPredicate = (s1, s2) -> GoTypeUtil.sameSignatures(s1, s2, (l, r) -> GoTypeUtil.identical(l, r, strict, false, context));
        if (biPredicate == null) {
            GoTypeUtil.$$$reportNull$$$0(156);
        }
        return biPredicate;
    }

    @NotNull
    private static GoTypeCheckResult checkMethod(boolean checkPointers, boolean isNotPointer, @NotNull BiPredicate<GoSignature, GoSignature> signaturesMatcher, @NotNull GoMethodSpec interfaceMethod, @NotNull GoType interfaceSubstitutionSource, @NotNull GoNamedSignatureOwner implementedMethod, @NotNull GoType implementationSubstitutionSource) {
        if (signaturesMatcher == null) {
            GoTypeUtil.$$$reportNull$$$0(157);
        }
        if (interfaceMethod == null) {
            GoTypeUtil.$$$reportNull$$$0(158);
        }
        if (interfaceSubstitutionSource == null) {
            GoTypeUtil.$$$reportNull$$$0(159);
        }
        if (implementedMethod == null) {
            GoTypeUtil.$$$reportNull$$$0(160);
        }
        if (implementationSubstitutionSource == null) {
            GoTypeUtil.$$$reportNull$$$0(161);
        }
        GoSignature interfaceMethodSignature = interfaceMethod.getSignature(interfaceSubstitutionSource);
        GoSignature implementedMethodSignature = implementedMethod.getSignature(implementationSubstitutionSource);
        if (checkPointers && isNotPointer && GoTypeUtil.cannotCallOnNonPointer(implementedMethod) || !signaturesMatcher.test(interfaceMethodSignature, implementedMethodSignature)) {
            GoMethodDeclaration implementation = (GoMethodDeclaration)ObjectUtils.tryCast((Object)implementedMethod, GoMethodDeclaration.class);
            if (implementation == null) {
                return new GoMethodsMissing(Collections.singletonList(interfaceMethod));
            }
            if (checkPointers && isNotPointer && GoTypeUtil.cannotCallOnNonPointer(implementation)) {
                return new GoCannotUsePointerReceiverMethod(implementation);
            }
            return new GoSignatureDiffers(interfaceMethod, implementation);
        }
        return new GoTypesCompatible();
    }

    private static boolean isPointerToInterface(@NotNull GoType type2, @Nullable PsiElement context) {
        GoType pointerType;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(162);
        }
        if ((pointerType = (GoType)ObjectUtils.tryCast((Object)type2, GoPointerType.class)) == null) {
            return false;
        }
        GoType basePointerType = GoTypeUtil.getBasePointerType(type2, context);
        GoType underlying = basePointerType != null ? basePointerType.getUnderlyingType(context) : null;
        return underlying instanceof GoInterfaceType;
    }

    private static <T> T processMethodsByLevel(@NotNull GoType initialType, @Nullable PsiElement context, @NotNull ByLevelMethodsProcessor<T> processor2) {
        if (initialType == null) {
            GoTypeUtil.$$$reportNull$$$0(163);
        }
        if (processor2 == null) {
            GoTypeUtil.$$$reportNull$$$0(164);
        }
        T result = null;
        SmartList currentLevelTypes = Collections.singleton(initialType);
        final class GoTypeIdentity {
            final GoType type;
            final /* synthetic */ PsiElement val$context;

            GoTypeIdentity(GoType goType) {
                this.val$context = goType;
                this.type = GoTypeUtil.unwrapPointerAndParTypes(type2);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                GoTypeIdentity identity = (GoTypeIdentity)o;
                return GoTypeUtil.identical(this.type, identity.type, this.val$context);
            }

            public int hashCode() {
                GoType goType = this.type;
                if (goType instanceof GoInstantiatedType) {
                    GoInstantiatedType instantiatedType = (GoInstantiatedType)goType;
                    return ((GoType)instantiatedType.getGeneric()).hashCode();
                }
                if (this.type instanceof GoLightType) {
                    return 0;
                }
                assert (this.type instanceof GoTypeImpl);
                return this.type.hashCode();
            }
        }
        HashSet<GoTypeIdentity> visitedTypes = new HashSet<GoTypeIdentity>();
        for (int currentLevel = 0; result == null && !currentLevelTypes.isEmpty() && currentLevel < 100; ++currentLevel) {
            HashSet<GoElementWithSubst<GoNamedSignatureOwner>> currentLevelMethods = new HashSet<GoElementWithSubst<GoNamedSignatureOwner>>();
            SmartList nextLevelTypes = new SmartList();
            for (GoType type2 : currentLevelTypes) {
                if (!visitedTypes.add(new GoTypeIdentity(type2, context))) continue;
                boolean acquirePointerSomehow = type2 instanceof GoLightType.LightPointerType;
                if (acquirePointerSomehow) {
                    type2 = ((GoLightType.LightPointerType)type2).getType();
                }
                if (type2 instanceof GoSpecType) {
                    GoType underlyingType;
                    GoSpecType specType = (GoSpecType)type2;
                    GoTypeSpec typeSpec = specType.getTypeSpec();
                    if (typeSpec != null) {
                        for (GoMethodDeclaration method : typeSpec.getMethods()) {
                            currentLevelMethods.add(GoElementWithSubst.create(acquirePointerSomehow ? GoLightMethodDeclaration.wrap(method) : method, type2));
                        }
                    }
                    if ((underlyingType = type2.getUnderlyingType(context)) instanceof GoInterfaceType || underlyingType instanceof GoStructType) {
                        type2 = underlyingType;
                    }
                }
                ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
                if (type2 instanceof GoInterfaceType) {
                    for (GoMethodSpec methodSpec : ((GoInterfaceType)type2).getMethodSpecList()) {
                        GoTypeArguments typeArgsElem;
                        List<Object> typeArgs;
                        GoType underSpecType;
                        GoTypeReferenceExpression reference = methodSpec.getTypeReferenceExpression();
                        if (reference == null) {
                            currentLevelMethods.add(GoElementWithSubst.create(methodSpec, type2));
                            continue;
                        }
                        GoSpecType specType = (GoSpecType)ObjectUtils.doIfCast((Object)reference.resolve(resolveState), GoTypeSpec.class, GoTypeSpec::getSpecType);
                        if (specType == null || !((underSpecType = GoTypeInstantiationKt.getInstantiatedSpecType(specType, typeArgs = (typeArgsElem = methodSpec.getTypeArguments()) != null ? typeArgsElem.getTypes() : Collections.emptyList()).getUnderlyingType(context)) instanceof GoInterfaceType)) continue;
                        nextLevelTypes.add(underSpecType);
                    }
                    continue;
                }
                if (!(type2 instanceof GoStructType)) continue;
                for (GoAnonymousFieldDefinition field : GoPsiImplUtil.getAnonymousFieldDefinitions((GoStructType)type2)) {
                    GoTypeReferenceExpression expression = field.getTypeReferenceExpression();
                    if (expression == null) continue;
                    ObjectUtils.doIfCast((Object)expression.resolve(resolveState), GoTypeSpec.class, arg_0 -> GoTypeUtil.lambda$processMethodsByLevel$25(acquirePointerSomehow, field, (Collection)nextLevelTypes, arg_0));
                }
            }
            result = processor2.process(currentLevel, currentLevelMethods);
            currentLevelTypes = nextLevelTypes;
        }
        return result;
    }

    @NotNull
    public static GoTypeCheckResult checkAmbiguousMethods(boolean checkPointers, boolean isNotPointer, BiPredicate<GoSignature, GoSignature> signaturesMatcher, @NotNull GoType interfaceType, @NotNull GoType type2, @NotNull Map<String, GoElementWithSubst<GoMethodSpec>> interfaceMethodsMap, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(165);
        }
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(166);
        }
        if (interfaceMethodsMap == null) {
            GoTypeUtil.$$$reportNull$$$0(167);
        }
        HashSet previousLevelsMethodNames = new HashSet();
        PsiFile file = interfaceType.getContainingFile();
        Module module = GoUtil.module(interfaceType);
        GoTypeCheckResult result = GoTypeUtil.processMethodsByLevel(Objects.requireNonNull(GoTypeUtil.findMethodsHolder(type2, context)), context, (__, currentLevelMethods) -> {
            MultiMap methods = MultiMap.create();
            for (GoElementWithSubst method : currentLevelMethods) {
                methods.putValue((Object)((GoNamedSignatureOwner)method.getElement()).getName(), (Object)method);
            }
            for (Map.Entry entry : methods.entrySet()) {
                String name = (String)entry.getKey();
                if (!interfaceMethodsMap.containsKey(name) || previousLevelsMethodNames.contains(name)) continue;
                ArrayList allowedMethods = new ArrayList();
                for (GoElementWithSubst method : (Collection)entry.getValue()) {
                    if (!GoPsiImplUtil.allowed((PsiFile)((GoNamedSignatureOwner)method.getElement()).getContainingFile(), file, module)) continue;
                    allowedMethods.add(method);
                }
                if (allowedMethods.size() > 1 && !GoPsiUtil.allowedDuplicateMethodsFromOverlappingInterfaces(allowedMethods, context)) {
                    return new GoAmbiguousMethods(ContainerUtil.map(allowedMethods, it -> (GoNamedSignatureOwner)it.getElement()));
                }
                if (allowedMethods.size() != 1) continue;
                GoElementWithSubst interfaceMethod = (GoElementWithSubst)interfaceMethodsMap.get(name);
                GoElementWithSubst implementedMethod = (GoElementWithSubst)ContainerUtil.getFirstItem(allowedMethods);
                GoTypeCheckResult checkResult = GoTypeUtil.checkMethod(checkPointers, isNotPointer, signaturesMatcher, (GoMethodSpec)interfaceMethod.getElement(), (GoType)ObjectUtils.notNull((Object)interfaceMethod.getSubstitutionSource(), (Object)interfaceType), (GoNamedSignatureOwner)implementedMethod.getElement(), (GoType)ObjectUtils.notNull((Object)implementedMethod.getSubstitutionSource(), (Object)type2));
                if (!(checkResult instanceof GoTypesNotCompatible)) continue;
                return checkResult;
            }
            previousLevelsMethodNames.addAll(methods.keySet());
            return null;
        });
        return result != null ? result : new GoTypesCompatible();
    }

    private static boolean cannotCallOnNonPointer(@NotNull GoNamedSignatureOwner method) {
        GoMethodDeclaration declaration;
        if (method == null) {
            GoTypeUtil.$$$reportNull$$$0(168);
        }
        return (declaration = (GoMethodDeclaration)ObjectUtils.tryCast((Object)method, GoMethodDeclaration.class)) != null && declaration.getReceiverType() instanceof GoPointerType && !declaration.isEmbeddedByPointer();
    }

    @NotNull
    public static List<? extends GoNamedSignatureOwner> findImplementedMethods(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(169);
        }
        List list = ContainerUtil.map(GoTypeUtil.findImplementedMethodsWithSubstitutionSource(type2, context), it -> (GoNamedSignatureOwner)it.getElement());
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(170);
        }
        return list;
    }

    @NotNull
    public static List<GoElementWithSubst<? extends GoNamedSignatureOwner>> findImplementedMethodsWithSubstitutionSource(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(171);
            }
            return list;
        }
        GoType methodsHolder = GoTypeUtil.findMethodsHolder(type2, context);
        GoType unwrapped = GoPsiImplUtil.unwrapInstantiation(methodsHolder);
        if (unwrapped instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)unwrapped;
            GoTypeSpec typeSpec = specType.getTypeSpec();
            if (typeSpec != null) {
                List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(typeSpec, type2, context);
                if (list == null) {
                    GoTypeUtil.$$$reportNull$$$0(172);
                }
                return list;
            }
        } else {
            if (unwrapped instanceof GoInterfaceType) {
                GoInterfaceType interfaceType = (GoInterfaceType)unwrapped;
                List<GoElementWithSubst<? extends GoNamedSignatureOwner>> methodsOfTypeSet = GoGenericsUtilKt.calcAllMethodsOfTypeSet(interfaceType, context);
                List methodSpecs = ContainerUtil.map(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(interfaceType, methodsHolder, context), it -> GoElementWithSubst.create((GoMethodSpec)it.getElement(), it.getSubstitutionSource()));
                List list = ContainerUtil.concat(methodsOfTypeSet, (List)methodSpecs);
                if (list == null) {
                    GoTypeUtil.$$$reportNull$$$0(173);
                }
                return list;
            }
            if (unwrapped instanceof GoStructType) {
                List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource((GoStructType)unwrapped, methodsHolder, context);
                if (list == null) {
                    GoTypeUtil.$$$reportNull$$$0(174);
                }
                return list;
            }
        }
        List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(175);
        }
        return list;
    }

    @Nullable
    private static GoType findMethodsHolder(@NotNull GoType type2, @Nullable PsiElement context) {
        GoType withoutAlias;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(176);
        }
        if (GoTypeUtil.isPointerToInterface(type2, context)) {
            return null;
        }
        GoType underlyingType = type2.getUnderlyingType(context);
        if (underlyingType instanceof GoInterfaceType) {
            return underlyingType;
        }
        if ((type2 = GoPsiImplUtil.unwrapPointerIfNeeded(type2)) instanceof GoStructType) {
            return type2;
        }
        GoType goType = withoutAlias = type2 != null ? GoTypeUtil.unwrapAlias(type2, context) : null;
        if (withoutAlias instanceof GoStructType) {
            return withoutAlias;
        }
        if (!GoTypeUtil.isNamedType(type2)) {
            return null;
        }
        if (type2 instanceof GoSpecType) {
            return type2;
        }
        PsiElement resolve2 = type2.resolve(context);
        if (resolve2 instanceof GoTypeSpec) {
            GoSpecType spec = ((GoTypeSpec)resolve2).getSpecType();
            return GoTypeInstantiationKt.getInstantiatedSpecType(spec, type2);
        }
        return null;
    }

    public static List<? extends GoNamedSignatureOwner> getMethodSet(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(177);
        }
        List<? extends GoNamedSignatureOwner> methods = GoTypeUtil.findImplementedMethods(type2, context);
        GoType unwrappedType = GoTypeUtil.unwrapAlias(type2, context);
        if (unwrappedType instanceof GoPointerType) {
            return methods;
        }
        return ContainerUtil.filter(methods, method -> !GoTypeUtil.cannotCallOnNonPointer(method));
    }

    public static boolean areSignaturesIdentical(@NotNull GoSignatureOwner left, @NotNull GoSignatureOwner right, boolean strict) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(178);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(179);
        }
        return GoTypeUtil.areSignaturesIdentical(left.getSignature(), right.getSignature(), false, strict, null);
    }

    public static boolean areSignaturesIdentical(@Nullable GoSignature left, @Nullable GoSignature right, boolean checkPossibleIdentity, boolean strict, @Nullable PsiElement context) {
        return GoTypeUtil.getSignaturesMatcher(checkPossibleIdentity, strict, context).test(left, right);
    }

    public static boolean sameSignatures(@Nullable GoSignature left, @Nullable GoSignature right, @NotNull BiPredicate<GoType, GoType> predicate) {
        List<GoType> rightResultTypeList;
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(180);
        }
        if (right == null || left == null || right == left) {
            return right == left;
        }
        List<GoType> leftResultTypeList = GoTypeUtil.getListOfTypesFromTypeList(left.getResultType());
        if (!GoTypeUtil.sameTypeLists(leftResultTypeList, rightResultTypeList = GoTypeUtil.getListOfTypesFromTypeList(right.getResultType()), predicate)) {
            return false;
        }
        Pair<List<GoType>, Boolean> leftParamsTypeList = GoTypeUtil.getTypesAndIsVariadicFromParameters(left.getParameters());
        Pair<List<GoType>, Boolean> rightParamsTypeList = GoTypeUtil.getTypesAndIsVariadicFromParameters(right.getParameters());
        return ((Boolean)leftParamsTypeList.second).equals(rightParamsTypeList.second) && GoTypeUtil.sameTypeLists((List)leftParamsTypeList.first, (List)rightParamsTypeList.first, predicate);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NotNull Pair<List<@Nullable GoType>, Boolean> getTypesAndIsVariadicFromParameters(@Nullable GoParameters parameters) {
        @Nullable SmartList result = new SmartList();
        if (parameters == null) {
            Pair pair = Pair.create((Object)result, (Object)false);
            if (pair == null) {
                GoTypeUtil.$$$reportNull$$$0(181);
            }
            return pair;
        }
        for (GoParameterDeclaration parameterDecl : parameters.getParameterDeclarationList()) {
            List<GoParamDefinition> list = parameterDecl.getParamDefinitionList();
            for (GoParamDefinition p : list) {
                result.add(p.findSiblingType());
            }
            if (!list.isEmpty()) continue;
            GoType type2 = parameterDecl.getType();
            result.add(type2);
        }
        Pair pair = Pair.create((Object)result, (Object)parameters.isVariadic());
        if (pair == null) {
            GoTypeUtil.$$$reportNull$$$0(182);
        }
        return pair;
    }

    public static boolean sameTypeLists(@NotNull List<GoType> left, @NotNull List<GoType> right, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(183);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(184);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(185);
        }
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (predicate.test(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFunction(@Nullable GoType goType, @Nullable PsiElement context) {
        return goType != null && goType.getUnderlyingType(context) instanceof GoFunctionType;
    }

    @NotNull
    public static @NotNull List<@NotNull GoType> getListOfTypesFromTypeList(@Nullable GoType type2) {
        if (type2 instanceof GoTypeList) {
            List<GoType> list = ((GoTypeList)type2).getTypeList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(186);
            }
            return list;
        }
        if (type2 instanceof GoLightType.LightVoidType) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(187);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)type2);
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(188);
        }
        return list;
    }

    @NotNull
    public static List<GoType> getTypesOfExpressions(@NotNull List<GoExpression> expressions) {
        if (expressions == null) {
            GoTypeUtil.$$$reportNull$$$0(189);
        }
        return GoTypeUtil.getTypesOfExpressions(expressions, null);
    }

    @NotNull
    public static List<GoType> getTypesOfExpressions(@NotNull List<GoExpression> expressions, @Nullable ResolveState state) {
        GoType firstExprType;
        if (expressions == null) {
            GoTypeUtil.$$$reportNull$$$0(190);
        }
        if (expressions.size() == 1 && (firstExprType = expressions.get(0).getGoType(state)) instanceof GoTypeList) {
            List<GoType> list = ((GoTypeList)firstExprType).getTypeList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(191);
            }
            return list;
        }
        List list = ContainerUtil.map(expressions, e -> e.getGoType(state));
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(192);
        }
        return list;
    }

    @Contract(value="null,_,_ -> true")
    public static boolean isComparable(@Nullable GoType type2, @Nullable PsiElement context, boolean strict) {
        return GoTypeUtil.isComparable(type2, context, strict, true);
    }

    @Contract(value="null,_,_,_ -> true")
    public static boolean isComparable(@Nullable GoType type2, @Nullable PsiElement context, boolean strict, boolean dynamic) {
        if (type2 == null) {
            return true;
        }
        GoType underlying = type2.getUnderlyingType(context);
        if (underlying instanceof GoStructType) {
            Boolean areFieldsComparable = (Boolean)RecursionManager.doPreventingRecursion((Object)underlying, (boolean)true, () -> ContainerUtil.and(((GoStructType)underlying).getFieldDefinitions(), e -> GoTypeUtil.isComparable(e.getGoType(null), e, strict, dynamic)));
            return areFieldsComparable != null ? areFieldsComparable : !strict;
        }
        if (underlying instanceof GoArrayOrSliceType) {
            GoArrayOrSliceType arrayOrSliceType = (GoArrayOrSliceType)underlying;
            return arrayOrSliceType.isArray() && GoTypeUtil.isComparable(arrayOrSliceType.getType(), context, strict, dynamic);
        }
        if (underlying instanceof GoInterfaceType) {
            if (dynamic && !GoTypeUtil.isTypeParameter(type2, context)) {
                return true;
            }
            GoTypeSet typeSet = GoTypeSetKt.computeTypeSet(underlying, GoPsiImplUtil.createContextOnElement(context));
            if (typeSet == GoTypeSet.Comparable.INSTANCE) {
                return true;
            }
            return typeSet instanceof GoTypeSet.Terms && ContainerUtil.and(((GoTypeSet.Terms)typeSet).getTerms(), it -> GoTypeUtil.isComparable(it.getType(), context, strict, false));
        }
        return !(underlying instanceof GoFunctionType) && !(underlying instanceof GoMapType);
    }

    @Contract(value="null, _ -> true")
    public static boolean isOrderedComparable(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            return true;
        }
        return GoTypeUtil.isIntegerType(type2 = type2.getUnderlyingType(context), context) || GoTypeUtil.isTypedFloatType(type2, context) || GoTypeUtil.isString(type2, context) || GoTypeUtil.isUntypedFloatType(type2) || GoTypeUtil.matchTypeConstraints(type2, context, (GoType t) -> GoTypeUtil.isOrderedComparable(t, context));
    }

    @Contract(value="null, _ -> true")
    public static boolean isConstantType(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 == null || GoTypeUtil.isNamedType(type2) && type2.resolve(context) == null) {
            return true;
        }
        GoType underlyingType = type2.getUnderlyingType(context);
        return GoTypeUtil.isNumericType(underlyingType, context) || GoTypeUtil.isBoolean(underlyingType, context) || GoTypeUtil.isString(underlyingType, context);
    }

    public static boolean isLenCapAvailableTo(@Nullable GoType type2, boolean isLen, @Nullable PsiElement context) {
        if (type2 == null) {
            return false;
        }
        GoType underlyingType = GoPsiImplUtil.getUnderlyingType(type2, context);
        GoType baseType = GoTypeUtil.arrayPointerDeref(underlyingType, context);
        if (baseType instanceof GoArrayOrSliceType || baseType instanceof GoChannelType || isLen && baseType instanceof GoMapType || isLen && GoTypeUtil.isStringType(baseType, context)) {
            return true;
        }
        return GoTypeUtil.matchTypeConstraints(baseType, context, (GoType t) -> GoTypeUtil.isLenCapAvailableTo(t, isLen, context));
    }

    @NotNull
    private static GoType arrayPointerDeref(@NotNull GoType type2, @Nullable PsiElement context) {
        GoType baseType;
        GoType underlying;
        GoArrayOrSliceType arrayOrSliceType;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(193);
        }
        if ((arrayOrSliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)(underlying = (baseType = GoTypeUtil.getBasePointerType(type2, context)) != null ? GoPsiImplUtil.getUnderlyingType(baseType, context) : null), GoArrayOrSliceType.class)) != null && arrayOrSliceType.isArray()) {
            GoType goType = underlying;
            if (goType == null) {
                GoTypeUtil.$$$reportNull$$$0(194);
            }
            return goType;
        }
        GoType goType = type2;
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(195);
        }
        return goType;
    }

    @Nullable
    public static String getReceiverTypeText(@Nullable GoType type2) {
        GoType inner;
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof GoPointerType && (inner = ((GoPointerType)type2).getType()) != null) {
            return inner.getPresentationText();
        }
        return type2.getPresentationText();
    }

    public static boolean isAllowedComparingToNil(@NotNull GoType type2, @Nullable PsiElement context) {
        GoType underlyingType;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(196);
        }
        return (underlyingType = type2.getUnderlyingType(context)) instanceof GoArrayOrSliceType && !((GoArrayOrSliceType)underlyingType).isArray() || underlyingType instanceof GoMapType || underlyingType instanceof GoFunctionType || underlyingType instanceof GoPointerType || underlyingType instanceof GoChannelType || underlyingType instanceof GoInterfaceType || underlyingType instanceof GoCType;
    }

    @Contract(value="null -> null;!null->!null")
    public static GoType unwrapPointerAndParTypes(@Nullable GoType type2) {
        if (type2 == null) {
            return null;
        }
        GoType o = type2;
        while (o instanceof GoParType || o instanceof GoPointerType) {
            o = o instanceof GoParType ? ((GoParType)o).getType() : ((GoPointerType)o).getType();
        }
        return (GoType)ObjectUtils.notNull((Object)o, (Object)type2);
    }

    public static boolean equalTypes(@Nullable GoType left, @Nullable GoType right, @Nullable PsiElement context, boolean strict) {
        if (left == null || right == null) {
            return !strict;
        }
        if (left instanceof GoLightType.LightVoidType) {
            return right instanceof GoLightType.LightVoidType;
        }
        if (left instanceof GoLightType.LightUntypedType) {
            return right instanceof GoLightType.LightUntypedType && left.getClass().equals(right.getClass());
        }
        if (GoTypeUtil.isCType(left, context) || GoTypeUtil.isCType(right, context)) {
            return true;
        }
        if (GoTypeUtil.isArbitraryType(left, context)) {
            return GoTypeUtil.isArbitraryType(right, context);
        }
        if (left instanceof GoSpecType) {
            return right instanceof GoSpecType && left.isEquivalentTo(right);
        }
        if (left instanceof GoArrayOrSliceType) {
            return right instanceof GoArrayOrSliceType && ((GoArrayOrSliceType)left).getLength() == ((GoArrayOrSliceType)right).getLength() && GoTypeUtil.equalTypes(((GoArrayOrSliceType)left).getType(), ((GoArrayOrSliceType)right).getType(), context, strict);
        }
        if (left instanceof GoStructType) {
            return right instanceof GoStructType && GoTypeUtil.sameStructs((GoStructType)left, (GoStructType)right, true, (l, r) -> GoTypeUtil.equalTypes(l, r, context, strict));
        }
        if (left instanceof GoPointerType) {
            return right instanceof GoPointerType && GoTypeUtil.equalTypes(((GoPointerType)left).getType(), ((GoPointerType)right).getType(), context, strict);
        }
        if (left instanceof GoFunctionType) {
            return right instanceof GoFunctionType && GoTypeUtil.sameSignatures(((GoFunctionType)left).getSignature(), ((GoFunctionType)right).getSignature(), (l, r) -> GoTypeUtil.equalTypes(l, r, context, strict));
        }
        if (left instanceof GoInterfaceType) {
            return right instanceof GoInterfaceType && GoTypeUtil.sameInterfaces((GoInterfaceType)left, (GoInterfaceType)right, context, (l, r) -> GoTypeUtil.equalTypes(l, r, context, strict));
        }
        if (left instanceof GoMapType) {
            return right instanceof GoMapType && GoTypeUtil.equalTypes(((GoMapType)left).getKeyType(), ((GoMapType)right).getKeyType(), context, strict) && GoTypeUtil.equalTypes(((GoMapType)left).getValueType(), ((GoMapType)right).getValueType(), context, strict);
        }
        if (left instanceof GoChannelType) {
            return right instanceof GoChannelType && ((GoChannelType)left).getDirection() == ((GoChannelType)right).getDirection() && GoTypeUtil.equalTypes(((GoChannelType)left).getType(), ((GoChannelType)right).getType(), context, strict);
        }
        if (left instanceof GoTypeList) {
            if (!(right instanceof GoTypeList)) {
                return false;
            }
            List<GoType> leftList = ((GoTypeList)left).getTypeList();
            List<GoType> rightList = ((GoTypeList)right).getTypeList();
            if (leftList.size() != rightList.size()) {
                return false;
            }
            for (int i = 0; i < leftList.size(); ++i) {
                if (GoTypeUtil.equalTypes(leftList.get(i), rightList.get(i), context, strict)) continue;
                return false;
            }
            return true;
        }
        PsiElement leftResolve = left.resolve(context);
        if (leftResolve == null) {
            return !strict;
        }
        PsiElement rightResolve = right.resolve(context);
        if (rightResolve == null) {
            return !strict;
        }
        return leftResolve.isEquivalentTo(rightResolve);
    }

    @Nullable
    public static GoType getExpectedValueType(@NotNull GoCompositeLit o) {
        GoType type2;
        if (o == null) {
            GoTypeUtil.$$$reportNull$$$0(197);
        }
        if ((type2 = o.getType()) instanceof GoArrayOrSliceType) {
            return ((GoArrayOrSliceType)type2).getType();
        }
        if (type2 instanceof GoMapType && ((GoMapType)type2).getValueType() != null) {
            return ((GoMapType)type2).getValueType();
        }
        return null;
    }

    public static boolean isInterface(@NotNull GoTypeSpec spec) {
        if (spec == null) {
            GoTypeUtil.$$$reportNull$$$0(198);
        }
        return GoTypeUtil.isInterface(spec.getSpecType());
    }

    public static boolean isInterface(@NotNull GoSpecType type2) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(199);
        }
        return type2.getContextlessUnderlyingType() instanceof GoInterfaceType;
    }

    @Nullable
    public static GoType findType(@NotNull Project project, @Nullable String importPath, @NotNull String typeName) {
        if (project == null) {
            GoTypeUtil.$$$reportNull$$$0(200);
        }
        if (typeName == null) {
            GoTypeUtil.$$$reportNull$$$0(201);
        }
        if (StringUtil.isEmpty((String)typeName)) {
            return null;
        }
        Object importString = StringUtil.isNotEmpty((String)importPath) ? "import pkg \"" + importPath + "\"; " : "";
        String qualifier = StringUtil.isNotEmpty((String)importPath) ? "pkg." : "";
        String text = "package main; " + (String)importString + "var a " + qualifier + typeName;
        GoVarDeclaration var = GoElementFactory.createElement(project, text, GoVarDeclaration.class, null);
        GoVarSpec spec = (GoVarSpec)ContainerUtil.getFirstItem(var != null ? var.getVarSpecList() : null);
        return (GoType)ObjectUtils.doIfNotNull((Object)spec, GoVarSpec::getType);
    }

    @Contract(value="null, _, _, _, _ -> false")
    public static boolean isKnownType(@Nullable GoType type2, @Nullable PsiElement context, @NotNull @NonNls String importPath, @NotNull @NonNls String typeName, boolean unwrapPointer) {
        GoTypeSpec resolve2;
        if (importPath == null) {
            GoTypeUtil.$$$reportNull$$$0(202);
        }
        if (typeName == null) {
            GoTypeUtil.$$$reportNull$$$0(203);
        }
        return (resolve2 = GoTypeUtil.findTypeSpec(type2, context, unwrapPointer)) != null && typeName.equals(resolve2.getName()) && importPath.equals(GoUtil.getImportPath(resolve2, context));
    }

    @Nullable
    public static GoInterfaceType findInterface(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull String interfaceName) {
        if (project == null) {
            GoTypeUtil.$$$reportNull$$$0(204);
        }
        if (scope == null) {
            GoTypeUtil.$$$reportNull$$$0(205);
        }
        if (interfaceName == null) {
            GoTypeUtil.$$$reportNull$$$0(206);
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        Collection<GoTypeSpec> interfaces = GoTypesIndex.find(interfaceName, project, scope, GoIdFilter.getProductionFilter(project));
        GoTypeSpec interfaceSpec = (GoTypeSpec)ContainerUtil.getFirstItem(interfaces);
        return (GoInterfaceType)ObjectUtils.tryCast((Object)(interfaceSpec != null ? interfaceSpec.getSpecType().getType() : null), GoInterfaceType.class);
    }

    public static boolean isNamedUnresolved(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(207);
        }
        return GoTypeUtil.isNamedType(type2) && GoTypeUtil.resolveNamedType(type2, context) == null;
    }

    public static boolean isEmptyInterface(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(208);
        }
        return interfaceType.getMethodSpecList().isEmpty() && interfaceType.getConstraintElemList().isEmpty();
    }

    public static boolean matchTypeConstraints(@Nullable GoType type2, @Nullable PsiElement context, @NotNull Predicate<GoType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(209);
        }
        return (Boolean)GoPsiImplUtil.withContextOnElement(context, resolveState -> GoTypeUtil.matchTypeConstraints(type2, resolveState, predicate));
    }

    public static boolean matchTypeConstraints(@Nullable GoType type2, @Nullable ResolveState resolveState, @NotNull Predicate<GoType> predicate) {
        List<GoAbstractConstraintTerm> terms;
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(210);
        }
        return !(terms = GoTypeUtil.getConstraintTerms(type2, resolveState)).isEmpty() && ContainerUtil.and(terms, it -> GoTypeUtil.checkTerm(it, resolveState, predicate));
    }

    public static boolean typeSetIs(@Nullable GoType type2, @Nullable PsiElement context, @NotNull Predicate<GoType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(211);
        }
        return (Boolean)GoPsiImplUtil.withContextOnElement(context, resolveState -> GoTypeUtil.typeSetIs(type2, resolveState, predicate));
    }

    public static boolean typeSetIs(@Nullable GoType type2, @Nullable ResolveState resolveState, @NotNull Predicate<GoType> predicate) {
        List<GoAbstractConstraintTerm> terms;
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(212);
        }
        return !(terms = GoTypeUtil.getConstraintTerms(type2, resolveState)).isEmpty() && ContainerUtil.and(terms, term -> {
            GoType termType = term.getType();
            return termType != null && predicate.test(termType);
        });
    }

    @NotNull
    private static List<GoAbstractConstraintTerm> getConstraintTerms(@Nullable GoType type2, @Nullable ResolveState resolveState) {
        type2 = type2 != null ? type2.getUnderlyingType(resolveState) : null;
        GoTypeSet typeSet = GoTypeSetKt.computeTypeSet(type2, resolveState);
        GoTypeSet.Terms termSet = (GoTypeSet.Terms)ObjectUtils.tryCast((Object)typeSet, GoTypeSet.Terms.class);
        List<GoAbstractConstraintTerm> list = termSet != null ? termSet.getTerms() : Collections.emptyList();
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(213);
        }
        return list;
    }

    public static boolean checkTerm(@NotNull GoAbstractConstraintTerm term, @Nullable ResolveState resolveState, @NotNull Predicate<GoType> predicate) {
        GoType constraintType;
        if (term == null) {
            GoTypeUtil.$$$reportNull$$$0(214);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(215);
        }
        GoType underlying = (constraintType = term.getType()) != null ? GoPsiImplUtil.getUnderlyingType(constraintType, resolveState) : null;
        return underlying != null && predicate.test(underlying);
    }

    @NotNull
    private static GoTypeCheckResult checkConstraintIncludesType(@NotNull ResolveState resolveState, @Nullable GoTypeSet constraintTypeSet, @NotNull GoType valueType, @Nullable GoType valueUnderlyingType, @Nullable GoTypeSet valueTypeSet, boolean strict) {
        if (resolveState == null) {
            GoTypeUtil.$$$reportNull$$$0(216);
        }
        if (valueType == null) {
            GoTypeUtil.$$$reportNull$$$0(217);
        }
        if (constraintTypeSet == null) {
            return new GoTypesCompatible();
        }
        if (valueUnderlyingType instanceof GoInterfaceType) {
            return GoTypeUtil.checkTypeSetIncludesAnotherTypeSet(constraintTypeSet, valueTypeSet, resolveState);
        }
        if (constraintTypeSet instanceof GoTypeSet.All) {
            return new GoTypesCompatible();
        }
        if (constraintTypeSet instanceof GoTypeSet.Empty) {
            return new GoNotInTypeSet(constraintTypeSet);
        }
        PsiElement context = GoPsiImplUtil.getContextElement(resolveState);
        if (constraintTypeSet instanceof GoTypeSet.Comparable) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(GoTypeUtil.isComparable(valueType, context, strict, false));
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(218);
            }
            return goTypeCheckResult;
        }
        GoTypeSet.Terms termSet = (GoTypeSet.Terms)ObjectUtils.tryCast((Object)constraintTypeSet, GoTypeSet.Terms.class);
        if (termSet == null) {
            return new GoTypesCompatible();
        }
        List<GoAbstractConstraintTerm> terms = termSet.getTerms();
        boolean exists = ContainerUtil.or(terms, term -> {
            GoType constraintType = term.getType();
            if (constraintType == null) {
                return false;
            }
            GoType checkedValueType = term.hasTilde() ? valueUnderlyingType : valueType;
            return GoTypeUtil.identical(constraintType, checkedValueType, strict, context);
        });
        return exists ? new GoTypesCompatible() : new GoNotInTypeSet(constraintTypeSet);
    }

    @NotNull
    private static GoTypeCheckResult checkTypeSetIncludesAnotherTypeSet(@NotNull GoTypeSet typeSet, @Nullable GoTypeSet anotherTypeSet, @Nullable ResolveState resolveState) {
        if (typeSet == null) {
            GoTypeUtil.$$$reportNull$$$0(219);
        }
        if (anotherTypeSet == null) {
            return new GoTypesCompatible();
        }
        boolean subset = GoTypeSetKt.isSubsetOf(anotherTypeSet, typeSet, resolveState);
        return subset ? new GoTypesCompatible() : new GoNotInTypeSet(typeSet);
    }

    @NotNull
    private static GoTypeCheckResult checkSatisfiesComparable(@NotNull GoType valueType, @Nullable PsiElement context, boolean strict) {
        if (valueType == null) {
            GoTypeUtil.$$$reportNull$$$0(220);
        }
        if (GoTypeUtil.isComparable(valueType, context, strict, false)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isComparable(valueType, context, strict, true)) {
            GoSdkUtil.FeatureSupported supported = GoSdkUtil.featureSupported(valueType, false, GoSdkVersion::supportsBasicInterfacesSatisfyingComparable);
            return supported == GoSdkUtil.FeatureSupported.YES ? new GoTypesCompatible() : new GoNonStrictComparabilityUnsupported(supported == GoSdkUtil.FeatureSupported.NEED_VERSION_UPDATE);
        }
        return new GoNotInTypeSet(GoTypeSet.Comparable.INSTANCE);
    }

    public static boolean isBuiltinComparable(@Nullable GoType type2, @Nullable PsiElement context) {
        GoType underlying;
        GoType goType = underlying = type2 != null ? type2.getUnderlyingType(context) : null;
        if (underlying instanceof GoInterfaceType) {
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)underlying, GoTypeSpec.class);
            return typeSpec != null && "comparable".equals(typeSpec.getName()) && GoPsiImplUtil.builtin(underlying);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isTypeParameter(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.getTypeParameter(type2, context) != null;
    }

    @Nullable
    public static GoTypeParameter getTypeParameter(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 instanceof GoTypeParameter) {
            return (GoTypeParameter)type2;
        }
        GoTypeParamDefinition receiverTypeParamDefinition = GoPsiUtil.getReceiverTypeParamDefinition(type2);
        if (receiverTypeParamDefinition != null) {
            return receiverTypeParamDefinition.getTypeParameter();
        }
        PsiElement resolved = type2 != null ? type2.resolve(context) : null;
        return resolved instanceof GoTypeParamDefinition ? ((GoTypeParamDefinition)resolved).getTypeParameter() : null;
    }

    public static boolean isPointer(@Nullable GoType type2, @Nullable PsiElement context) {
        GoType underlying = type2 != null ? type2.getUnderlyingType(context) : null;
        return underlying instanceof GoPointerType || GoTypeUtil.matchTypeConstraints(underlying, context, (GoType t) -> GoTypeUtil.isPointer(t, context));
    }

    @Nullable
    public static GoType getBasePointerType(@Nullable GoType type2, @Nullable PsiElement context) {
        return (GoType)GoPsiImplUtil.withContextOnElement(context, state -> GoTypeUtil.getBasePointerType(type2, state));
    }

    @Nullable
    public static GoType getBasePointerType(@Nullable GoType type2, @Nullable ResolveState state) {
        GoType basePointerType;
        if (type2 == null) {
            return null;
        }
        GoType underlying = type2.getUnderlyingType(state);
        if (underlying instanceof GoPointerType) {
            return ((GoPointerType)underlying).getType();
        }
        List<GoAbstractConstraintTerm> terms = GoTypeUtil.getConstraintTerms(underlying, state);
        GoAbstractConstraintTerm first = (GoAbstractConstraintTerm)ContainerUtil.getFirstItem(terms);
        GoType firstTermType = first != null ? first.getType() : null;
        GoType goType = basePointerType = firstTermType != null ? (GoType)RecursionManager.doPreventingRecursion((Object)firstTermType, (boolean)false, () -> GoTypeUtil.getBasePointerType(firstTermType, state)) : null;
        if (basePointerType == null) {
            return null;
        }
        for (GoAbstractConstraintTerm term : terms.subList(1, terms.size())) {
            GoType termType = term.getType();
            GoType termBasePointerType = termType != null ? (GoType)RecursionManager.doPreventingRecursion((Object)termType, (boolean)false, () -> GoTypeUtil.getBasePointerType(termType, state)) : null;
            if (GoTypeUtil.identical(basePointerType, termBasePointerType, GoPsiImplUtil.getContextElement(state))) continue;
            return null;
        }
        return basePointerType;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getCoreType(@Nullable GoType type2, @Nullable PsiElement context) {
        return (GoType)GoPsiImplUtil.withContextOnElement(context, state -> GoTypeUtil.getCoreType(type2, state));
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getCoreType(@Nullable GoType type2, @Nullable ResolveState state) {
        if (type2 == null) {
            return null;
        }
        GoType underlyingType = GoPsiImplUtil.getUnderlyingType(type2, state);
        if (!GoTypeUtil.isTypeParameter(type2, GoPsiImplUtil.getContextElement(state))) {
            return underlyingType;
        }
        Ref coreType = Ref.create();
        boolean success = GoTypeUtil.matchTypeConstraints(underlyingType, state, (GoType termUnderlying) -> {
            if (termUnderlying == null) {
                return false;
            }
            if (!coreType.isNull() && (termUnderlying = GoTypeUtil.coreMatch((GoType)coreType.get(), termUnderlying, state)) == null) {
                return false;
            }
            coreType.set(termUnderlying);
            return true;
        });
        return success ? (GoType)coreType.get() : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getCoreStringType(@Nullable GoType type2, @Nullable ResolveState state) {
        if (type2 == null) {
            return null;
        }
        PsiElement context = GoPsiImplUtil.getContextElement(state);
        GoType underlyingType = GoPsiImplUtil.getUnderlyingType(type2, state);
        if (!GoTypeUtil.isTypeParameter(type2, context)) {
            return underlyingType;
        }
        if (context == null) {
            return null;
        }
        GoArrayOrSliceType byteSlice = GoTypeUtil.getByteSliceType(context);
        Ref coreType = Ref.create();
        Ref hasString = Ref.create((Object)false);
        boolean success = GoTypeUtil.matchTypeConstraints(underlyingType, state, (GoType termUnderlying) -> {
            if (termUnderlying == null) {
                return false;
            }
            if (GoTypeUtil.isString(termUnderlying, context)) {
                hasString.set((Object)true);
                GoType goType = termUnderlying = byteSlice != null ? byteSlice : termUnderlying;
            }
            if (!coreType.isNull() && (termUnderlying = GoTypeUtil.coreMatch((GoType)coreType.get(), termUnderlying, state)) == null) {
                return false;
            }
            coreType.set(termUnderlying);
            return true;
        });
        if (!success) {
            return null;
        }
        return (Boolean)hasString.get() != false ? GoPsiImplUtil.getBuiltinType("string", context) : (GoType)coreType.get();
    }

    @Nullable
    private static GoArrayOrSliceType getByteSliceType(@NotNull PsiElement context) {
        GoType byteType;
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(221);
        }
        return (byteType = GoPsiImplUtil.getBuiltinType(BYTE, context)) != null ? new GoLightType.LightSliceType(byteType) : null;
    }

    @Nullable
    private static GoType coreMatch(@NotNull GoType x, @NotNull GoType y, @Nullable ResolveState state) {
        PsiElement context;
        if (x == null) {
            GoTypeUtil.$$$reportNull$$$0(222);
        }
        if (y == null) {
            GoTypeUtil.$$$reportNull$$$0(223);
        }
        if (GoTypeUtil.identical(x, y, context = GoPsiImplUtil.getContextElement(state))) {
            return x;
        }
        GoChannelType xChannel = (GoChannelType)ObjectUtils.tryCast((Object)x, GoChannelType.class);
        GoChannelType yChannel = (GoChannelType)ObjectUtils.tryCast((Object)y, GoChannelType.class);
        if (xChannel != null && yChannel != null && GoTypeUtil.identical(xChannel.getType(), yChannel.getType(), context)) {
            if (xChannel.getDirection() == GoPsiImplUtil.ChannelDirection.BIDIRECTIONAL) {
                return y;
            }
            if (yChannel.getDirection() == GoPsiImplUtil.ChannelDirection.BIDIRECTIONAL) {
                return x;
            }
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getArrayOrSliceType(@Nullable GoType type2, @Nullable PsiElement context) {
        GoType coreType = GoTypeUtil.getCoreType(type2, context);
        return coreType instanceof GoArrayOrSliceType ? coreType : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GoType getArrayOrSliceElementType(@Nullable GoType type2) {
        return (GoType)ObjectUtils.doIfCast((Object)type2, GoArrayOrSliceType.class, it -> it.getType());
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getMapKeyType(@Nullable GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            return null;
        }
        GoType underlying = GoPsiImplUtil.getUnderlyingType(type2, context);
        if (underlying instanceof GoMapType) {
            return ((GoMapType)underlying).getKeyType();
        }
        if (underlying instanceof GoInterfaceType) {
            Ref resultType = Ref.create();
            boolean match = GoTypeUtil.matchTypeConstraints(underlying, context, (GoType term) -> {
                if (!(term instanceof GoMapType)) {
                    return false;
                }
                GoType keyType = ((GoMapType)term).getKeyType();
                if (!resultType.isNull()) {
                    return GoTypeUtil.identical((GoType)resultType.get(), keyType, false, context);
                }
                resultType.set((Object)keyType);
                return true;
            });
            return match ? (GoType)resultType.get() : null;
        }
        return null;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean underlyingTypeIs(@Nullable GoType type2, @Nullable PsiElement context, @NotNull Predicate<@Nullable GoType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(224);
        }
        if (type2 == null) {
            return false;
        }
        if (GoTypeUtil.isTypeParameter(type2, context)) {
            return GoTypeUtil.matchTypeConstraints(type2, context, predicate);
        }
        GoType underlying = GoPsiImplUtil.getUnderlyingType(type2, context);
        return predicate.test(underlying);
    }

    @Nullable
    public static GoInterfaceType findFirstMatchedInterfaceDfs(@Nullable GoType type2, @NotNull Predicate<GoInterfaceType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(225);
        }
        if (!(type2 instanceof GoInterfaceType)) {
            return null;
        }
        HashSet<GoType> seen = new HashSet<GoType>();
        ArrayDeque<GoInterfaceType> stack = new ArrayDeque<GoInterfaceType>();
        seen.add(type2);
        stack.push((GoInterfaceType)type2);
        while (!stack.isEmpty()) {
            GoInterfaceType t = (GoInterfaceType)stack.pop();
            if (predicate.test(t)) {
                return t;
            }
            for (GoTypeReferenceExpression reference : t.getBaseTypesReferences()) {
                GoSpecType specType;
                GoInterfaceType embeddedInterface;
                GoType resolved = reference.resolveType(ResolveState.initial());
                if (!(resolved instanceof GoSpecType) || (embeddedInterface = (GoInterfaceType)ObjectUtils.tryCast((Object)(specType = (GoSpecType)resolved).getContextlessUnderlyingType(), GoInterfaceType.class)) == null || !seen.add(embeddedInterface)) continue;
                stack.push(embeddedInterface);
            }
        }
        return null;
    }

    public static boolean isBasicInterface(@Nullable GoInterfaceType iface, @Nullable PsiElement context) {
        if (iface == null || !iface.getConstraintElemList().isEmpty() || GoTypeUtil.isBuiltinComparable(iface, context)) {
            return false;
        }
        for (GoTypeReferenceExpression reference : iface.getBaseTypesReferences()) {
            GoSpecType specType = (GoSpecType)ObjectUtils.tryCast((Object)reference.resolveType(ResolveState.initial()), GoSpecType.class);
            if (specType == null || GoTypeUtil.isInterface(specType)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static GoReceiverUtil.ReceiverTypeCheckError checkBaseReceiverType(@NotNull GoType receiverType, @NotNull PsiElement context) {
        GoType flattenedReceiverType;
        GoType baseType;
        if (receiverType == null) {
            GoTypeUtil.$$$reportNull$$$0(226);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(227);
        }
        if ((baseType = GoPsiImplUtil.unwrapPointerIfNeeded(flattenedReceiverType = GoTypeUtil.flattenAliasesAndPointers(receiverType, context))) == null) {
            return null;
        }
        if (!(baseType instanceof GoPointerType) && !GoTypeUtil.isNamedType(baseType)) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.UNNAMED_TYPE, flattenedReceiverType, baseType);
        }
        if (GoTypeUtil.isNonLocalType(baseType, context)) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.NONLOCAL_TYPE, flattenedReceiverType, baseType);
        }
        GoType underlyingType = baseType.getUnderlyingType(context);
        if (underlyingType instanceof GoPointerType) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.POINTER_TYPE, flattenedReceiverType, underlyingType);
        }
        if (underlyingType instanceof GoInterfaceType) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.INTERFACE_TYPE, flattenedReceiverType, baseType);
        }
        return null;
    }

    @NotNull
    private static GoType flattenAliasesAndPointers(@NotNull GoType type2, @NotNull PsiElement context) {
        GoPointerType pointerType;
        GoType unwrappedAlias;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(228);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(229);
        }
        if ((unwrappedAlias = GoTypeUtil.unwrapAliasOnly(type2, context)) instanceof GoPointerType && (pointerType = (GoPointerType)unwrappedAlias).getType() != null) {
            return new GoLightType.LightPointerType(GoTypeUtil.flattenAliasesAndPointers(pointerType.getType(), context));
        }
        if (unwrappedAlias == null || unwrappedAlias == type2) {
            GoType goType = type2;
            if (goType == null) {
                GoTypeUtil.$$$reportNull$$$0(230);
            }
            return goType;
        }
        GoType goType = unwrappedAlias;
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(231);
        }
        return goType;
    }

    private static boolean isNonLocalType(@NotNull GoType type2, @NotNull PsiElement context) {
        GoTypeSpec spec;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(232);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(233);
        }
        return (spec = GoTypeUtil.findTypeSpec(type2, context)) != null && !GoUtil.isDirectlyAccessible((PsiFile)spec.getContainingFile(), context.getContainingFile());
    }

    @Nullable
    private static GoType unwrapAliasOnly(@NotNull GoType type2, @NotNull PsiElement context) {
        GoTypeSpec spec;
        if (type2 == null) {
            GoTypeUtil.$$$reportNull$$$0(234);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(235);
        }
        if ((spec = GoTypeUtil.findTypeSpec(type2, context)) == null) {
            return type2;
        }
        if (!spec.isTypeAlias()) {
            return type2;
        }
        return GoPsiUtil.unwrapAlias(spec);
    }

    private static /* synthetic */ Boolean lambda$processMethodsByLevel$25(boolean acquirePointerSomehow, GoAnonymousFieldDefinition field, Collection nextLevelTypes, GoTypeSpec typeSpec) {
        boolean pointer = acquirePointerSomehow || field.getType() instanceof GoPointerType;
        GoType specType = GoTypeInstantiationKt.getInstantiatedSpecType(typeSpec.getSpecType(), field.getType());
        return nextLevelTypes.add(pointer ? new GoLightType.LightPointerType(specType) : specType);
    }

    private static /* synthetic */ boolean lambda$checkImplementsInterface$20(Set implementedMethodNames, GoMethodSpec m) {
        return implementedMethodNames.contains(m.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 27, 28, 29, 32, 33, 37, 38, 39, 40, 47, 48, 58, 59, 60, 61, 62, 65, 66, 67, 71, 72, 74, 75, 77, 78, 80, 81, 84, 85, 91, 92, 93, 95, 97, 98, 105, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 147, 148, 149, 150, 151, 152, 153, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 176, 177, 178, 179, 180, 183, 184, 185, 189, 190, 193, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 214, 215, 216, 217, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 232, 233, 234, 235 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoTypeUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 78: 
            case 98: 
            case 109: 
            case 110: 
            case 135: 
            case 137: 
            case 139: 
            case 148: 
            case 150: 
            case 152: 
            case 162: 
            case 166: 
            case 169: 
            case 176: 
            case 177: 
            case 193: 
            case 196: 
            case 199: 
            case 207: 
            case 228: 
            case 232: 
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "integerType";
                break;
            }
            case 5: 
            case 29: 
            case 32: 
            case 38: 
            case 61: 
            case 65: 
            case 74: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 47: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 48: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandExpr";
                break;
            }
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtinTypes";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recvStatement";
                break;
            }
            case 75: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 77: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 221: 
            case 227: 
            case 229: 
            case 233: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhsExprList";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 105: 
            case 118: 
            case 120: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 178: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 114: 
            case 117: 
            case 124: 
            case 133: 
            case 180: 
            case 185: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 215: 
            case 224: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypeArguments";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypeArguments";
                break;
            }
            case 119: 
            case 121: 
            case 123: 
            case 126: 
            case 129: 
            case 132: 
            case 179: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSamePackages";
                break;
            }
            case 134: 
            case 136: 
            case 138: 
            case 147: 
            case 149: 
            case 151: 
            case 165: 
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceType";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintType";
                break;
            }
            case 141: 
            case 217: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 153: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signaturesMatcher";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceMethod";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceSubstitutionSource";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedMethod";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationSubstitutionSource";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialType";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceMethodsMap";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 189: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 200: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 201: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceName";
                break;
            }
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSet";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "y";
                break;
            }
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIterable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 105: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 183: 
            case 184: 
            case 185: 
            case 189: 
            case 190: 
            case 193: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 232: 
            case 233: 
            case 234: 
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoTypeUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromReturnStatement";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromGoSendStatement";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromArgumentList";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesForBinaryExprOperand";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeForNewAndMake";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "builtinCopyDefaultExpectedTypes";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromRecvStatement";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromVarOrConstSpec";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromAssignmentStatement";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromAssignmentLHS";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceIfNull";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceType";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameOrText";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAssignable";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapAlias";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "isSamePackages";
                break;
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImplementsConstraint";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImplementsInterface";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesMatcher";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "findImplementedMethods";
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "findImplementedMethodsWithSubstitutionSource";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesAndIsVariadicFromParameters";
                break;
            }
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOfTypesFromTypeList";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesOfExpressions";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayPointerDeref";
                break;
            }
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintTerms";
                break;
            }
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConstraintIncludesType";
                break;
            }
            case 230: 
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAliasesAndPointers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafePointerType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isComplexType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFloatType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntegerTypeLimits";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMapCompositeLiteralElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromReturnStatement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromGoSendStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureFromFunctionType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromArgumentList";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesForBinaryExprOperand";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedOperandTypeFromOtherOperands";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findNonShiftExpressionOperand";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeForNewAndMake";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesForBuiltinFunctions";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "builtinCopyDefaultExpectedTypes";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isSliceOfType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromRecvStatement";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromVarOrConstSpec";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTypes";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromAssignmentStatement";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromAssignmentLHS";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createGoTypeListOrGoType";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceIfNull";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getGoType";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNameOrText";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignable";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAliasIfNamed";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAlias";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "sameNamedTypes";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "sameTypeArguments";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalentTypeParams";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "sameBuiltinIntegerAliases";
                break;
            }
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "sameInterfaces";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isSamePackages";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "sameNames";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sameStructs";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isImplementsInterface";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementsConstraint";
                break;
            }
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementsInterface";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToInterface";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsByLevel";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethods";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "cannotCallOnNonPointer";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "findImplementedMethods";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsHolder";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSet";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesIdentical";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "sameSignatures";
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "sameTypeLists";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "getTypesOfExpressions";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "arrayPointerDeref";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedComparingToNil";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedValueType";
                break;
            }
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "isInterface";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "findType";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "isKnownType";
                break;
            }
            case 204: 
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "findInterface";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "isNamedUnresolved";
                break;
            }
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyInterface";
                break;
            }
            case 209: 
            case 210: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeConstraints";
                break;
            }
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "typeSetIs";
                break;
            }
            case 214: 
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "checkTerm";
                break;
            }
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "checkConstraintIncludesType";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeSetIncludesAnotherTypeSet";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "checkSatisfiesComparable";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "getByteSliceType";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "coreMatch";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "underlyingTypeIs";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "findFirstMatchedInterfaceDfs";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "checkBaseReceiverType";
                break;
            }
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "flattenAliasesAndPointers";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "isNonLocalType";
                break;
            }
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAliasOnly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 27, 28, 29, 32, 33, 37, 38, 39, 40, 47, 48, 58, 59, 60, 61, 62, 65, 66, 67, 71, 72, 74, 75, 77, 78, 80, 81, 84, 85, 91, 92, 93, 95, 97, 98, 105, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 147, 148, 149, 150, 151, 152, 153, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 176, 177, 178, 179, 180, 183, 184, 185, 189, 190, 193, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 214, 215, 216, 217, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 232, 233, 234, 235 -> new IllegalArgumentException(string);
        };
    }

    public static interface ByLevelMethodsProcessor<T> {
        @Nullable(value="null to process next level")
        public @Nullable(value="null to process next level") T process(int var1, @NotNull Collection<GoElementWithSubst<GoNamedSignatureOwner>> var2);
    }
}

