/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoFileType;
import com.goide.GoLanguage;
import com.goide.execution.testing.GoTestFinder;
import com.goide.project.GoBuildTargetSettings;
import com.goide.project.GoModuleSettings;
import com.goide.project.GoPackageFactory;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoPsiTreeChangeProcessor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.presentation.GoPackagePresentationProvider;
import com.goide.psi.properties.GoFileProperties;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoPathUseScope;
import com.goide.util.GoUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=GoPackagePresentationProvider.class)
public class GoPackage
implements PomRenameableTarget<GoPackage> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myDirectories;
    @NotNull
    private final String myName;
    private boolean valid;

    @Nullable
    public static GoPackage of(@NotNull GoFile file) {
        PsiElement context;
        if (file == null) {
            GoPackage.$$$reportNull$$$0(0);
        }
        GoFile contextFile = (GoFile)((Object)ObjectUtils.notNull((Object)((Object)((GoFile)((Object)ObjectUtils.tryCast((Object)((context = (PsiElement)file.getUserData(GoReference.SUBSTITUTION_CONTEXT)) != null ? context.getContainingFile() : null), GoFile.class)))), (Object)((Object)file)));
        for (GoPackageFactory factory : GoPackageFactory.EP_NAME.getExtensionList()) {
            GoPackage aPackage = factory.createPackage(contextFile);
            if (aPackage == null) continue;
            return aPackage;
        }
        String packageName = contextFile.getCanonicalPackageName();
        PsiDirectory parent = contextFile.getParent();
        if (parent != null && !StringUtil.isEmpty((String)packageName)) {
            return new GoPackage(parent.getProject(), packageName, parent.getVirtualFile());
        }
        return null;
    }

    @NotNull
    public static Collection<GoPackage> in(@Nullable PsiDirectory directory) {
        return GoPackage.in(directory, (Module)null);
    }

    @NotNull
    public static Collection<GoPackage> in(@Nullable PsiDirectory directory, @Nullable Module contextModule) {
        if (directory == null) {
            Set<GoPackage> set = Collections.emptySet();
            if (set == null) {
                GoPackage.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<String> packageNamesInDirectory = GoPackageUtil.getAllPackagesInDirectory(directory, contextModule, true);
        Collection collection = !packageNamesInDirectory.isEmpty() ? ContainerUtil.map(packageNamesInDirectory, packageName -> GoPackage.in(directory, packageName)) : ContainerUtil.createMaybeSingletonSet((Object)GoPackage.in(directory, GoPsiImplUtil.sanitizePackageName(directory.getName())));
        if (collection == null) {
            GoPackage.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static GoPackage in(@NotNull PsiDirectory directory, @NotNull String packageName) {
        if (directory == null) {
            GoPackage.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            GoPackage.$$$reportNull$$$0(4);
        }
        for (GoPackageFactory factory : GoPackageFactory.EP_NAME.getExtensionList()) {
            GoPackage aPackage = factory.createPackage(packageName, directory);
            if (aPackage == null) continue;
            GoPackage goPackage = aPackage;
            if (goPackage == null) {
                GoPackage.$$$reportNull$$$0(5);
            }
            return goPackage;
        }
        return new GoPackage(directory.getProject(), packageName, directory.getVirtualFile());
    }

    protected GoPackage(@NotNull Project project, @NotNull String name, VirtualFile ... directories) {
        if (project == null) {
            GoPackage.$$$reportNull$$$0(6);
        }
        if (name == null) {
            GoPackage.$$$reportNull$$$0(7);
        }
        if (directories == null) {
            GoPackage.$$$reportNull$$$0(8);
        }
        this.valid = true;
        this.myProject = project;
        this.myDirectories = new SmartHashSet(Arrays.asList(directories));
        this.myName = name;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GoPackage.$$$reportNull$$$0(9);
        }
        return project;
    }

    @NotNull
    public Set<VirtualFile> getDirectories() {
        Set<VirtualFile> set = this.myDirectories;
        if (set == null) {
            GoPackage.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public StreamEx<PsiDirectory> getPsiDirectories() {
        if (!this.isValid()) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                GoPackage.$$$reportNull$$$0(11);
            }
            return streamEx;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        StreamEx streamEx = (StreamEx)((StreamEx)StreamEx.of(this.myDirectories).map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).filter(Objects::nonNull)).filter(PsiElement::isValid);
        if (streamEx == null) {
            GoPackage.$$$reportNull$$$0(12);
        }
        return streamEx;
    }

    public boolean processBuildableFiles(@Nullable PsiFile referenceContext, @Nullable Module contextModule, @NotNull Processor<? super PsiFile> processor2) {
        if (processor2 == null) {
            GoPackage.$$$reportNull$$$0(13);
        }
        return this.processFiles((Processor<? super PsiFile>)new FilteringProcessor(file -> GoPsiImplUtil.allowed(file, referenceContext, contextModule), processor2));
    }

    public boolean processBuildableFiles(@Nullable PsiFile referenceContext, @Nullable Module contextModule, @NotNull Processor<? super PsiFile> processor2, @NotNull Predicate<VirtualFile> virtualFilePredicate) {
        if (processor2 == null) {
            GoPackage.$$$reportNull$$$0(14);
        }
        if (virtualFilePredicate == null) {
            GoPackage.$$$reportNull$$$0(15);
        }
        return this.processFiles((Processor<? super PsiFile>)new FilteringProcessor(file -> GoPsiImplUtil.allowed(file, referenceContext, contextModule), processor2), virtualFilePredicate);
    }

    public Collection<PsiFile> files() {
        CommonProcessors.CollectUniquesProcessor processor2 = new CommonProcessors.CollectUniquesProcessor();
        this.processFiles((Processor<? super PsiFile>)processor2);
        return processor2.getResults();
    }

    @Nullable
    public PsiFile find(final @NotNull Predicate<PsiFile> predicate) {
        if (predicate == null) {
            GoPackage.$$$reportNull$$$0(16);
        }
        CommonProcessors.FindProcessor<PsiFile> processor2 = new CommonProcessors.FindProcessor<PsiFile>(){

            protected boolean accept(PsiFile o) {
                return predicate.test(o);
            }
        };
        this.processFiles((Processor<? super PsiFile>)processor2);
        return (PsiFile)processor2.getFoundValue();
    }

    public boolean processFiles(@NotNull Processor<? super PsiFile> processor2) {
        if (processor2 == null) {
            GoPackage.$$$reportNull$$$0(17);
        }
        return this.processFiles(processor2, it -> true);
    }

    public boolean processFiles(@NotNull Processor<? super PsiFile> processor2, @NotNull Predicate<VirtualFile> virtualFileFilter) {
        if (processor2 == null) {
            GoPackage.$$$reportNull$$$0(18);
        }
        if (virtualFileFilter == null) {
            GoPackage.$$$reportNull$$$0(19);
        }
        if (!this.isValid()) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this.myProject);
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        for (VirtualFile directory : this.getDirectories()) {
            for (VirtualFile virtualFile : directory.getChildren()) {
                PsiFile file;
                GoFileProperties fileProperties;
                ProgressIndicatorProvider.checkCanceled();
                if (virtualFile.isDirectory() || !virtualFile.isValid() || !virtualFileFilter.test(virtualFile) || !fileTypeRegistry.isFileOfType(virtualFile, (FileType)GoFileType.INSTANCE) || fileIndexFacade.isExcludedFile(virtualFile) || (fileProperties = GoFileProperties.of(file = psiManager.findFile(virtualFile))) == null || !this.myName.equals(fileProperties.getCanonicalPackageName(virtualFile)) || processor2.process((Object)file)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isWritable() {
        CommonProcessors.FindFirstProcessor<PsiFile> processor2 = new CommonProcessors.FindFirstProcessor<PsiFile>(){

            protected boolean accept(PsiFile file) {
                return !NonProjectFileWritingAccessProvider.isWriteAccessAllowed((VirtualFile)file.getVirtualFile(), (Project)file.getProject());
            }
        };
        this.processFiles((Processor<? super PsiFile>)processor2);
        return !processor2.isFound();
    }

    public GoPackage setName(@NotNull String newName) {
        if (newName == null) {
            GoPackage.$$$reportNull$$$0(20);
        }
        if (this.isValid() && !newName.equals(this.myName)) {
            this.processFiles((Processor<? super PsiFile>)((Processor)file -> {
                GoPackageClause packageClause;
                GoPackageClause goPackageClause = packageClause = file instanceof GoFile ? ((GoFile)((Object)file)).getPackage() : null;
                if (packageClause != null) {
                    packageClause.setName((String)(GoTestFinder.isTestFileWithTestPackage(file) ? newName + "_test" : newName));
                }
                return true;
            }));
            this.valid = false;
        }
        return this;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GoPackage.$$$reportNull$$$0(21);
        }
        return string;
    }

    public boolean isValid() {
        if (!this.valid || this.myProject.isDisposed()) {
            return false;
        }
        for (VirtualFile directory : this.myDirectories) {
            ProgressIndicatorProvider.checkCanceled();
            if (directory.isValid()) continue;
            return false;
        }
        return true;
    }

    public void navigate(boolean requestFocus) {
        for (PsiDirectory directory : this.getPsiDirectories()) {
            ProgressIndicatorProvider.checkCanceled();
            PsiNavigationSupport.getInstance().navigateToDirectory(directory, requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.getPsiDirectories().anyMatch(directory -> {
            ProgressIndicatorProvider.checkCanceled();
            return PsiNavigationSupport.getInstance().canNavigate((PsiElement)directory);
        });
    }

    public boolean isBuiltin() {
        if (!"builtin".equals(this.myName)) {
            return false;
        }
        for (String importPath : this.getAllImportPaths(false)) {
            if (!"builtin".equals(importPath)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoPackage)) {
            return false;
        }
        GoPackage aPackage = (GoPackage)o;
        if (!this.myDirectories.equals(aPackage.myDirectories)) {
            return false;
        }
        return this.myName.equals(aPackage.myName);
    }

    public int hashCode() {
        int result = this.myDirectories.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    public String toString() {
        return "Package: " + this.myName + " (" + ContainerUtil.map(this.myDirectories, VirtualFile::getPath) + ")";
    }

    @Nullable
    public PsiElement getNavigableElement() {
        return this.getPsiDirectories().findFirst().orElse(null);
    }

    @NotNull
    public GlobalSearchScope getScope() {
        HashSet files = new HashSet();
        this.processFiles((Processor<? super PsiFile>)((Processor)f -> files.add(f.getViewProvider().getVirtualFile())));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)this.myProject, files);
        if (globalSearchScope == null) {
            GoPackage.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getScope(@Nullable PsiFile referenceContext) {
        Module module = GoUtil.module((PsiElement)referenceContext);
        HashSet files = new HashSet();
        this.processFiles((Processor<? super PsiFile>)((Processor)f -> {
            if (GoPsiImplUtil.allowed(f, referenceContext, module)) {
                files.add(f.getViewProvider().getVirtualFile());
            }
            return true;
        }));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)this.myProject, files);
        if (globalSearchScope == null) {
            GoPackage.$$$reportNull$$$0(23);
        }
        return globalSearchScope;
    }

    public PomTargetPsiElement toPsi(@NotNull Project project) {
        if (project == null) {
            GoPackage.$$$reportNull$$$0(24);
        }
        return new GoPomTargetPsiElement(project, this);
    }

    @Nullable
    public String getCanonicalImport(@Nullable Module contextModule) {
        if (contextModule != null) {
            return this.getCanonicalImportInner(contextModule);
        }
        for (PsiDirectory directory : this.getPsiDirectories()) {
            ProgressIndicatorProvider.checkCanceled();
            String result = (String)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
                Module module = GoUtil.module((PsiElement)directory);
                GoBuildTargetSettings buildTargetSettings = module != null ? GoModuleSettings.getInstance(module).getBuildTargetSettings() : null;
                ModificationTracker packageModificationTracker = GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)directory);
                return buildTargetSettings != null ? CachedValueProvider.Result.create((Object)this.getCanonicalImportInner(module), (Object[])new Object[]{packageModificationTracker, buildTargetSettings}) : CachedValueProvider.Result.create((Object)this.getCanonicalImportInner(null), (Object[])new Object[]{packageModificationTracker});
            });
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    @NlsSafe
    public String getImportPath(boolean withVendoring) {
        for (PsiDirectory directory : this.getPsiDirectories()) {
            ProgressIndicatorProvider.checkCanceled();
            String importPath = GoSdkUtil.getImportPath(directory, withVendoring);
            if (importPath == null) continue;
            return importPath;
        }
        return null;
    }

    @NotNull
    public Collection<String> getAllImportPaths(boolean withVendoring) {
        Set set = this.getPsiDirectories().flatCollection(directory -> {
            ProgressIndicatorProvider.checkCanceled();
            return GoSdkUtil.getAllImportPaths(directory, withVendoring);
        }).toSet();
        if (set == null) {
            GoPackage.$$$reportNull$$$0(25);
        }
        return set;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        List trackers = this.getPsiDirectories().map(GoPsiTreeChangeProcessor::packageModificationTracker).toList();
        ModificationTracker modificationTracker = () -> trackers.stream().map(ModificationTracker::getModificationCount).reduce(0L, Long::sum);
        if (modificationTracker == null) {
            GoPackage.$$$reportNull$$$0(26);
        }
        return modificationTracker;
    }

    @Nullable
    private String getCanonicalImportInner(@Nullable Module contextModule) {
        Ref result = Ref.create();
        this.processBuildableFiles(null, contextModule, (Processor<? super PsiFile>)((Processor)file -> {
            String path;
            GoPackageClause packageClause = file instanceof GoFile ? ((GoFile)((Object)file)).getPackage() : null;
            String string = path = packageClause != null ? packageClause.getCanonicalPath() : null;
            if (path != null) {
                result.set((Object)path);
                return false;
            }
            return true;
        }));
        return (String)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 9, 10, 11, 12, 21, 22, 23, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePredicate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileFilter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoPackage";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "in";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiDirectories";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportPaths";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "in";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processBuildableFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toPsi";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 9, 10, 11, 12, 21, 22, 23, 25, 26 -> new IllegalStateException(string);
        };
    }

    public static class GoPomTargetPsiElement
    extends PomTargetPsiElementImpl
    implements PsiNameIdentifierOwner {
        public GoPomTargetPsiElement(@NotNull Project project, @NotNull GoPackage target) {
            if (project == null) {
                GoPomTargetPsiElement.$$$reportNull$$$0(0);
            }
            if (target == null) {
                GoPomTargetPsiElement.$$$reportNull$$$0(1);
            }
            super(project, (PomTarget)target);
        }

        @NotNull
        public Language getLanguage() {
            Language language = GoLanguage.INSTANCE;
            if (language == null) {
                GoPomTargetPsiElement.$$$reportNull$$$0(2);
            }
            return language;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        @NotNull
        public GoPackage getTarget() {
            GoPackage goPackage = (GoPackage)super.getTarget();
            if (goPackage == null) {
                GoPomTargetPsiElement.$$$reportNull$$$0(3);
            }
            return goPackage;
        }

        @NotNull
        public SearchScope getUseScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])this.getTarget().getPsiDirectories().map(GoPathUseScope::create).toArray((Object[])GlobalSearchScope.EMPTY_ARRAY)));
            if (globalSearchScope == null) {
                GoPomTargetPsiElement.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }

        public String toString() {
            return "Psi Wrapper[" + this.getTarget() + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/psi/impl/GoPackage$GoPomTargetPsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/psi/impl/GoPackage$GoPomTargetPsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUseScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

