/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoCommentsConverter;
import com.goide.GoIcons;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.execution.testing.GoTestFinder;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoCaching;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoItemPresentation;
import com.goide.psi.impl.GoParserPsiTreeUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoStubbedElementImpl;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.GoNamedStub;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoNamedElementImpl<T extends GoNamedStub<?>>
extends GoStubbedElementImpl<T>
implements GoCompositeElement,
GoNamedElement {
    public GoNamedElementImpl(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            GoNamedElementImpl.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            GoNamedElementImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public GoNamedElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GoNamedElementImpl.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @Override
    public boolean isPublic() {
        GoNamedStub stub = (GoNamedStub)this.getGreenStub();
        if (stub != null ? stub.isPublic() : StringUtil.isCapitalized((String)this.getName())) {
            return true;
        }
        return GoPsiImplUtil.builtin(this);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getIdentifier();
    }

    @Nullable
    public String getName() {
        GoNamedStub stub = (GoNamedStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        if (this instanceof GoMethodDeclaration) {
            String typeText = GoTypeUtil.getReceiverTypeText(((GoMethodDeclaration)((Object)this)).getReceiverType());
            if (typeText != null) {
                return typeText + "." + name;
            }
        } else if (this instanceof GoMethodSpec) {
            String typeText;
            GoSpecType type2 = (GoSpecType)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, GoSpecType.class);
            String string = typeText = type2 != null ? type2.getPresentationText() : null;
            if (typeText != null) {
                return typeText + "." + name;
            }
        }
        String packageName = this.getContainingFile().getPackageName();
        return GoPsiImplUtil.getFqn(packageName, name);
    }

    public int getTextOffset() {
        PsiElement identifier = this.getIdentifier();
        return identifier != null ? identifier.getTextOffset() : super.getTextOffset();
    }

    @NotNull
    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            GoNamedElementImpl.$$$reportNull$$$0(3);
        }
        if (this instanceof GoImportSpec) {
            GoNamedElementImpl.setName((GoImportSpec)((Object)this), newName);
        } else {
            PsiElement identifier = this.getIdentifier();
            if (identifier != null) {
                identifier.replace(GoElementFactory.createIdentifierFromText(this.getProject(), newName));
            }
        }
        GoNamedElementImpl goNamedElementImpl = this;
        if (goNamedElementImpl == null) {
            GoNamedElementImpl.$$$reportNull$$$0(4);
        }
        return goNamedElementImpl;
    }

    private static void setName(@NotNull GoImportSpec importSpec, @NotNull String newName) {
        PsiElement existing;
        if (importSpec == null) {
            GoNamedElementImpl.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            GoNamedElementImpl.$$$reportNull$$$0(6);
        }
        if ((existing = GoNamedElementImpl.getImportSpecIdentifierOrDot(importSpec)) != null) {
            GoImportSpec spec = GoElementFactory.createImportSpec((PsiFile)importSpec.getContainingFile(), importSpec.getStringLiteral().getText(), newName);
            PsiElement replacement = Objects.requireNonNull(GoNamedElementImpl.getImportSpecIdentifierOrDot(spec));
            existing.replace(replacement);
        } else {
            GoStringLiteral literal = importSpec.getStringLiteral();
            importSpec.addBefore(GoElementFactory.createImportSpecIdentifierOrDot(importSpec.getContainingFile(), newName), literal);
            PsiElement whitespace = PsiParserFacade.getInstance((Project)importSpec.getProject()).createWhiteSpaceFromText(" ");
            importSpec.addBefore(whitespace, literal);
        }
    }

    @Nullable
    private static PsiElement getImportSpecIdentifierOrDot(@NotNull GoImportSpec importSpec) {
        PsiElement identifier;
        if (importSpec == null) {
            GoNamedElementImpl.$$$reportNull$$$0(7);
        }
        return (identifier = importSpec.getIdentifier()) != null ? identifier : importSpec.getDot();
    }

    @Override
    @Nullable
    public GoType getGoType(@Nullable ResolveState context) {
        if (context != null) {
            return this.getGoTypeInner(context);
        }
        if (!GoCaching.isEnabled()) {
            return this.getGoTypeInner(GoPsiImplUtil.createContextOnElement(this));
        }
        return (GoType)CachedValuesManager.getCachedValue((PsiElement)this, () -> GoCacheUtilKt.createResolveDependentResult(this.getGoTypeInner(GoPsiImplUtil.createContextOnElement(this)), this.getProject(), new Object[0]));
    }

    @Override
    @Nullable
    public GoType getGoUnderlyingType(@Nullable ResolveState context) {
        return GoNamedElementImpl.getGoUnderlyingType(this, context);
    }

    @Nullable
    public static GoType getGoUnderlyingType(@NotNull GoNamedElement o, @Nullable ResolveState context) {
        GoType type2;
        if (o == null) {
            GoNamedElementImpl.$$$reportNull$$$0(8);
        }
        if ((type2 = o.getGoType(context)) == null) {
            return null;
        }
        return context != null ? type2.getUnderlyingType(context) : type2.getUnderlyingType(o);
    }

    @Nullable
    protected GoType getGoTypeInner(@Nullable ResolveState context) {
        if (this instanceof GoImportSpec) {
            return null;
        }
        return this.findSiblingType();
    }

    @Override
    @Nullable
    public GoType findSiblingType() {
        GoTypeReferenceExpression tre;
        GoType inner = this.findSiblingTypeInner();
        GoType type2 = inner instanceof GoPointerType ? ((GoPointerType)inner).getType() : inner;
        GoTypeReferenceExpression goTypeReferenceExpression = tre = type2 == null ? null : type2.getTypeReferenceExpression();
        if (tre != null && tre == type2.contextlessResolve()) {
            return new GoCType(type2);
        }
        return inner;
    }

    @Nullable
    private GoType findSiblingTypeInner() {
        GoNamedStub stub = (GoNamedStub)this.getStub();
        if (stub != null) {
            return GoParserPsiTreeUtil.getStubChildOfType(this.getParentByStub(), GoType.class);
        }
        return GoParserPsiTreeUtil.getNextSiblingOfType(this, GoType.class);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            GoNamedElementImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            GoNamedElementImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            GoNamedElementImpl.$$$reportNull$$$0(11);
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    public ItemPresentation getPresentation() {
        return new GoItemPresentation<GoNamedElement>((GoNamedElement)this){

            @Nullable
            public String getPresentableText() {
                return ((GoNamedElement)this.myElement).getName();
            }
        };
    }

    @Nullable
    public Icon getIcon(int flags) {
        Icon icon = (Icon)ReadAction.compute(() -> this.isValid() ? this.computeIcon(flags) : null);
        if (icon != null) {
            return icon;
        }
        return super.getIcon(flags);
    }

    @Nullable
    private Icon computeIcon(int flags) {
        if (this instanceof GoImportSpec) {
            return GoIcons.IMPORT_ALIAS;
        }
        Icon icon = null;
        if (this instanceof GoMethodDeclaration) {
            icon = GoIcons.METHOD;
        } else if (this instanceof GoFunctionDeclaration) {
            icon = GoIcons.FUNCTION;
        } else if (this instanceof GoTypeSpec) {
            icon = GoPsiImplUtil.getTypeSpecIcon((GoTypeSpec)((Object)this));
        } else if (this instanceof GoVarDefinition) {
            icon = GoIcons.VARIABLE;
        } else if (this instanceof GoConstDefinition) {
            icon = GoIcons.CONSTANT;
        } else if (this instanceof GoMethodSpec) {
            icon = GoIcons.METHOD;
        } else if (GoPsiImplUtil.isFieldDefinition(this)) {
            icon = GoIcons.FIELD;
        } else if (this instanceof GoParamDefinition) {
            icon = GoIcons.PARAMETER;
        } else if (this instanceof GoLabelDefinition) {
            icon = GoIcons.LABEL;
        }
        if (icon != null) {
            if ((flags & 1) != 0) {
                RowIcon rowIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, icon, flags);
                if (rowIcon.getIconCount() > 1) {
                    rowIcon.setIcon(this.isPublic() ? com.intellij.util.PlatformIcons.PUBLIC_ICON : IconManager.getInstance().getPlatformIcon(PlatformIcons.Private), 1);
                }
                return rowIcon;
            }
            return icon;
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.isPublic() ? GoUtil.goPathResolveScope(this) : GoPackageUtil.packageScope(this.getContainingFile());
        if (globalSearchScope == null) {
            GoNamedElementImpl.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GoSignatureOwner f;
        GoBlock block;
        if (!this.isValid()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GoNamedElementImpl.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        GoFile file = this.getContainingFile();
        if (this instanceof GoImportSpec) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)file);
            if (globalSearchScope == null) {
                GoNamedElementImpl.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        if ((this instanceof GoVarDefinition || this instanceof GoConstDefinition || this instanceof GoLabelDefinition) && (block = (GoBlock)PsiTreeUtil.getParentOfType((PsiElement)this, GoBlock.class)) != null) {
            return new LocalSearchScope((PsiElement)block);
        }
        if ((this instanceof GoParamDefinition || this instanceof GoReceiver) && (f = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GoSignatureOwner.class)) != null) {
            return new LocalSearchScope((PsiElement)ObjectUtils.notNull((Object)f.getBlockIfExists(), (Object)f));
        }
        if (this instanceof GoTypeParamDefinition && (f = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GoSignatureOwner.class)) != null) {
            return new LocalSearchScope((PsiElement)f);
        }
        if (!this.isPublic() || GoTestFinder.isTestFile((PsiFile)file)) {
            GlobalSearchScope globalSearchScope = GoPackageUtil.packageScope(file);
            if (globalSearchScope == null) {
                GoNamedElementImpl.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GoUtil.goPathUseScope(this);
        if (globalSearchScope == null) {
            GoNamedElementImpl.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    @Override
    public boolean isBlank() {
        return StringUtil.equals((CharSequence)this.getName(), (CharSequence)"_");
    }

    @Override
    public boolean isDeprecated() {
        if (this instanceof GoImportSpec || this instanceof GoParamDefinition || this instanceof GoReceiver || this instanceof GoLabelDefinition) {
            return false;
        }
        GoNamedStub stub = (GoNamedStub)this.getGreenStub();
        return stub != null ? stub.isDeprecated() : ((Boolean)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcIsDeprecated(), (Object[])new Object[]{this.getContainingFile()}))).booleanValue();
    }

    private boolean calcIsDeprecated() {
        GoVarOrConstDeclaration declaration;
        List<PsiComment> comments = GoDocumentationProvider.getCommentsForElement(this);
        if (GoNamedElementImpl.hasDeprecationLine(GoCommentsConverter.toStringList(comments))) {
            return true;
        }
        if (this instanceof GoVarOrConstDefinition && (declaration = (GoVarOrConstDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, GoVarOrConstDeclaration.class)) != null) {
            comments = GoDocumentationProvider.getCommentsForElement(declaration);
            return GoNamedElementImpl.hasDeprecationLine(GoCommentsConverter.toStringList(comments));
        }
        return false;
    }

    public static boolean hasDeprecationLine(@NotNull List<String> commentLines) {
        if (commentLines == null) {
            GoNamedElementImpl.$$$reportNull$$$0(17);
        }
        for (int i = 0; i < commentLines.size(); ++i) {
            boolean isSeparateParagraph;
            boolean bl = isSeparateParagraph = i == 0 || StringUtil.isEmptyOrSpaces((String)commentLines.get(i - 1));
            if (!GoNamedElementImpl.startsWithDeprecated(commentLines.get(i), isSeparateParagraph)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWithDeprecated(@NotNull String firstLine, boolean isSeparateParagraph) {
        boolean startsWithDeprecated;
        if (firstLine == null) {
            GoNamedElementImpl.$$$reportNull$$$0(18);
        }
        firstLine = firstLine.trim();
        boolean bl = isSeparateParagraph ? StringUtil.startsWithIgnoreCase((String)firstLine, (String)"deprecated") : (startsWithDeprecated = firstLine.startsWith(StringUtil.capitalize((String)"deprecated")) || firstLine.startsWith(StringUtil.toUpperCase((String)"deprecated")));
        if (!startsWithDeprecated) {
            return false;
        }
        String suffix = StringUtil.trimLeading((String)firstLine.substring("deprecated".length()));
        if (suffix.isEmpty()) {
            return true;
        }
        char ch = suffix.charAt(0);
        return ch == ':' || ch == ',' || ch == ';' || ch == '.';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoNamedElementImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentLines";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoNamedElementImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportSpecIdentifierOrDot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGoUnderlyingType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasDeprecationLine";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startsWithDeprecated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

