/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoTypes;
import com.goide.psi.GoAddExpr;
import com.goide.psi.GoAndExpr;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMulExpr;
import com.goide.psi.GoOrExpr;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.util.GoStdlibUtil;
import com.goide.util.Value;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoExpressionUtil {
    private static final TokenSet UNARY_NOT_CONSTANT_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.BIT_AND, GoTypes.MUL, GoTypes.ARROW});
    private static final Set<String> CONSTANT_ALLOWED_FUNCTIONS = Set.of("complex", "real", "imag", "min", "max");

    @Contract(value="null, null -> true; null, !null -> false; !null, null -> false")
    public static boolean identical(@Nullable GoExpression left, @Nullable GoExpression right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        GoExpression l = GoExpressionUtil.unwrapParensAndUnaryPlus(left);
        GoExpression r = GoExpressionUtil.unwrapParensAndUnaryPlus(right);
        if (l == null || r == null) {
            return false;
        }
        if (!l.getClass().equals(r.getClass())) {
            return false;
        }
        if (l instanceof GoBinaryExpr) {
            return GoExpressionUtil.identicalOperators(l, r) && GoExpressionUtil.equalBinaryExpressions((GoBinaryExpr)l, (GoBinaryExpr)r);
        }
        if (l instanceof GoUnaryExpr) {
            return GoExpressionUtil.identicalOperators(l, r) && GoExpressionUtil.identical(((GoUnaryExpr)l).getExpression(), ((GoUnaryExpr)r).getExpression());
        }
        if (l instanceof GoReferenceExpression) {
            return GoExpressionUtil.identicalRefExpressions((GoReferenceExpression)l, (GoReferenceExpression)r);
        }
        if (l instanceof GoIndexOrSliceExpr) {
            return GoExpressionUtil.identical(((GoIndexOrSliceExpr)l).getExpression(), ((GoIndexOrSliceExpr)r).getExpression()) && GoExpressionUtil.identicalIndices(((GoIndexOrSliceExpr)l).getIndices(), ((GoIndexOrSliceExpr)r).getIndices());
        }
        if (l instanceof GoLiteral || l instanceof GoStringLiteral) {
            Value lValue = l.getValue();
            return lValue != null && lValue.equals(r.getValue());
        }
        if (l instanceof GoCallExpr || l instanceof GoBuiltinCallExpr) {
            return false;
        }
        if (l instanceof GoCompositeLit) {
            boolean valuesIdentical = GoExpressionUtil.identical(((GoCompositeLit)l).getLiteralValue(), ((GoCompositeLit)r).getLiteralValue());
            return valuesIdentical && GoTypeUtil.identical(l.getGoType(null), r.getGoType(null), true, l);
        }
        if (l instanceof GoTypeAssertionExpr) {
            GoTypeAssertionExpr leftTypeAssertionExpr = (GoTypeAssertionExpr)l;
            GoTypeAssertionExpr rightTypeAssertionExpr = (GoTypeAssertionExpr)r;
            return GoExpressionUtil.identical(leftTypeAssertionExpr.getExpression(), rightTypeAssertionExpr.getExpression()) && GoTypeUtil.identical(leftTypeAssertionExpr.getType(), rightTypeAssertionExpr.getType(), true, l);
        }
        String text = l.getText();
        return text != null && r.textMatches(text);
    }

    private static boolean identicalRefExpressions(@Nullable GoReferenceExpression l, @Nullable GoReferenceExpression r) {
        if (l == null || r == null) {
            return l == r;
        }
        PsiElement resolve2 = l.resolve();
        return resolve2 != null && resolve2.isEquivalentTo(r.resolve()) && GoExpressionUtil.identicalQualifiers(l.getQualifier(), r.getQualifier());
    }

    private static boolean identicalQualifiers(@Nullable GoQualifier left, @Nullable GoQualifier right) {
        if (left == null || right == null) {
            return left == right;
        }
        if (left instanceof GoExpression && right instanceof GoExpression) {
            return GoExpressionUtil.identical((GoExpression)left, (GoExpression)right);
        }
        return false;
    }

    private static boolean identicalIndices(@NotNull Trinity<GoExpression, GoExpression, GoExpression> l, @NotNull Trinity<GoExpression, GoExpression, GoExpression> r) {
        if (l == null) {
            GoExpressionUtil.$$$reportNull$$$0(0);
        }
        if (r == null) {
            GoExpressionUtil.$$$reportNull$$$0(1);
        }
        return GoExpressionUtil.identical((GoExpression)l.first, (GoExpression)r.first) && GoExpressionUtil.identical((GoExpression)l.second, (GoExpression)r.second) && GoExpressionUtil.identical((GoExpression)l.third, (GoExpression)r.third);
    }

    private static boolean identical(@Nullable GoLiteralValue l, @Nullable GoLiteralValue r) {
        if (l == null || r == null) {
            return false;
        }
        return l.textMatches(r);
    }

    public static boolean identicalOperators(@Nullable GoExpression l, @Nullable GoExpression r) {
        if (l instanceof GoBinaryExpr && r instanceof GoBinaryExpr) {
            return GoExpressionUtil.identicalOperators(((GoBinaryExpr)l).getOperator(), ((GoBinaryExpr)r).getOperator());
        }
        if (l instanceof GoUnaryExpr && r instanceof GoUnaryExpr && ((GoUnaryExpr)l).getArrow() == null) {
            return GoExpressionUtil.identicalOperators(((GoUnaryExpr)l).getOperator(), ((GoUnaryExpr)r).getOperator());
        }
        return false;
    }

    private static boolean identicalOperators(@Nullable PsiElement leftOperator, @Nullable PsiElement rightOperator) {
        if (leftOperator == null || rightOperator == null) {
            return false;
        }
        ASTNode lNode = leftOperator.getNode();
        ASTNode rNode = rightOperator.getNode();
        return lNode instanceof LeafElement && lNode.getElementType().equals(rNode.getElementType());
    }

    private static boolean isOrderImportant(@NotNull GoBinaryExpr o) {
        if (o == null) {
            GoExpressionUtil.$$$reportNull$$$0(2);
        }
        if (o instanceof GoMulExpr) {
            GoMulExpr m = (GoMulExpr)o;
            return m.getRemainder() != null || m.getQuotient() != null || m.getShiftLeft() != null || m.getShiftRight() != null;
        }
        if (o instanceof GoConditionalExpr) {
            GoConditionalExpr c = (GoConditionalExpr)o;
            return c.getEq() == null && c.getNotEq() == null;
        }
        if (o instanceof GoAddExpr) {
            if (((GoAddExpr)o).getMinus() != null) {
                return true;
            }
            for (GoExpression expression : o.getExpressionList()) {
                if (!GoTypeUtil.isString(expression.getGoType(null), expression)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean equalBinaryExpressions(@NotNull GoBinaryExpr left, @NotNull GoBinaryExpr right) {
        if (left == null) {
            GoExpressionUtil.$$$reportNull$$$0(3);
        }
        if (right == null) {
            GoExpressionUtil.$$$reportNull$$$0(4);
        }
        GoExpression l1 = left.getLeft();
        GoExpression l2 = left.getRight();
        GoExpression r1 = right.getLeft();
        GoExpression r2 = right.getRight();
        return GoExpressionUtil.identical(l1, r1) && GoExpressionUtil.identical(l2, r2) || !GoExpressionUtil.isOrderImportant(left) && GoExpressionUtil.identical(l1, r2) && GoExpressionUtil.identical(l2, r1);
    }

    @Nullable
    private static GoExpression unwrapParensAndUnaryPlus(@Nullable GoExpression o) {
        return (o = GoPsiImplUtil.unwrapParentheses(o)) instanceof GoUnaryExpr && ((GoUnaryExpr)o).getPlus() != null ? GoExpressionUtil.unwrapParensAndUnaryPlus(((GoUnaryExpr)o).getExpression()) : o;
    }

    @Nullable
    public static GoExpression unwrapUnaryNot(@Nullable GoExpression expr) {
        GoUnaryExpr unaryExpr;
        if (expr instanceof GoUnaryExpr && (unaryExpr = (GoUnaryExpr)expr).getNot() != null) {
            return GoExpressionUtil.unwrapUnaryNot(unaryExpr.getExpression());
        }
        return expr;
    }

    public static boolean isBoolExpression(@Nullable PsiElement element) {
        return element instanceof GoAndExpr || element instanceof GoOrExpr;
    }

    @Nullable
    @Contract(value="null -> null", pure=true)
    public static Boolean getBoolConst(@Nullable PsiElement o) {
        if (!(o instanceof GoReferenceExpression)) {
            return null;
        }
        if (((GoReferenceExpression)o).getQualifier() != null) {
            return null;
        }
        boolean isTrue = o.textMatches((CharSequence)"true");
        boolean iFalse = o.textMatches((CharSequence)"false");
        if (!isTrue && !iFalse || !GoPsiImplUtil.builtin(((GoReferenceExpression)o).resolve())) {
            return null;
        }
        return isTrue ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isBooleanLiteral(@Nullable PsiElement o) {
        return GoExpressionUtil.getBoolConst(o) != null;
    }

    public static boolean isNil(@Nullable PsiElement o) {
        if (o instanceof GoVarDefinition) {
            return "nil".equals(((GoVarDefinition)o).getName()) && GoPsiImplUtil.builtin(o);
        }
        return o instanceof GoReferenceExpression && o.textMatches((CharSequence)"nil") && GoPsiImplUtil.builtin(((GoReferenceExpression)o).resolve());
    }

    public static boolean processNonConstantExpressions(@Nullable GoExpression expression, @Nullable PsiElement context, @NotNull Processor<? super GoExpression> processor2) {
        if (processor2 == null) {
            GoExpressionUtil.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            return true;
        }
        ArrayDeque<GoExpression> stack = new ArrayDeque<GoExpression>();
        stack.push(expression);
        while (!stack.isEmpty()) {
            expression = (GoExpression)stack.pop();
            List<GoExpression> children = GoExpressionUtil.processNonConstantExpressionsNoRecursion(expression, context, processor2);
            if (children == null) {
                return false;
            }
            children.forEach(it -> stack.push((GoExpression)it));
        }
        return true;
    }

    @Nullable
    private static List<GoExpression> processNonConstantExpressionsNoRecursion(@Nullable GoExpression expression, @Nullable PsiElement context, @NotNull Processor<? super GoExpression> processor2) {
        if (processor2 == null) {
            GoExpressionUtil.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            return Collections.emptyList();
        }
        GoType type2 = expression.getGoType(GoPsiImplUtil.createContextOnElement(context));
        if (GoTypeUtil.isCType(type2, expression)) {
            return Collections.emptyList();
        }
        if (!GoTypeUtil.isConstantType(type2, expression)) {
            return processor2.process((Object)expression) ? Collections.emptyList() : null;
        }
        if (expression instanceof GoCallExpr) {
            if (GoExpressionUtil.isConstantFunctionCall((GoCallExpr)expression)) {
                return Collections.emptyList();
            }
            return processor2.process((Object)expression) ? Collections.emptyList() : null;
        }
        if (expression instanceof GoBinaryExpr) {
            return ((GoBinaryExpr)expression).getExpressionList();
        }
        if (expression instanceof GoLiteral || expression instanceof GoStringLiteral) {
            return Collections.emptyList();
        }
        if (expression instanceof GoParenthesesExpr) {
            return ContainerUtil.createMaybeSingletonList((Object)((GoParenthesesExpr)expression).getExpression());
        }
        if (expression instanceof GoUnaryExpr) {
            boolean constantOperation;
            PsiElement operator = ((GoUnaryExpr)expression).getOperator();
            boolean bl = constantOperation = operator != null && !UNARY_NOT_CONSTANT_OPERATORS.contains(operator.getNode().getElementType());
            return constantOperation ? ContainerUtil.createMaybeSingletonList((Object)((GoUnaryExpr)expression).getExpression()) : (processor2.process((Object)expression) ? Collections.emptyList() : null);
        }
        if (expression instanceof GoReferenceExpression) {
            PsiElement resolve2 = ((GoReferenceExpression)expression).resolve();
            if (resolve2 != null && !(resolve2 instanceof GoConstDefinition)) {
                return processor2.process((Object)expression) ? Collections.emptyList() : null;
            }
            return Collections.emptyList();
        }
        return processor2.process((Object)expression) ? Collections.emptyList() : null;
    }

    private static boolean isConstantFunctionCall(@NotNull GoCallExpr callExpr) {
        GoExpression argument;
        List<GoExpression> arguments;
        GoExpression expression;
        if (callExpr == null) {
            GoExpressionUtil.$$$reportNull$$$0(7);
        }
        if (!((expression = GoPsiImplUtil.unwrapParentheses(callExpr.getExpression())) instanceof GoReferenceExpression)) {
            return GoExpressionUtil.isConstantGenericTypeConversion(callExpr);
        }
        String text = expression.getText();
        if (CONSTANT_ALLOWED_FUNCTIONS.contains(text) && GoPsiImplUtil.builtin(((GoReferenceExpression)expression).resolve()) || expression.getGoType(null) instanceof GoSpecType) {
            return GoExpressionUtil.hasAllArgumentsConstant(callExpr);
        }
        if (("len".equals(text) || "cap".equals(text)) && GoPsiImplUtil.builtin(((GoReferenceExpression)expression).resolve()) && (arguments = callExpr.getArgumentList().getExpressionList()).size() == 1 && (argument = (GoExpression)ContainerUtil.getFirstItem(arguments)) != null) {
            if (argument.isConstant()) {
                return true;
            }
            GoType type2 = argument.getGoType(null);
            boolean isArrayOrArrayPointerType = GoTypeUtil.isArray(type2, argument) || type2 instanceof GoPointerType && GoTypeUtil.isArray(((GoPointerType)type2).getType(), argument);
            return isArrayOrArrayPointerType && GoExpressionUtil.isConstantLenOrCapArgument(argument);
        }
        return GoStdlibUtil.isUnsafeFunctionCall(callExpr);
    }

    private static boolean hasAllArgumentsConstant(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoExpressionUtil.$$$reportNull$$$0(8);
        }
        for (GoExpression argument : callExpr.getArgumentList().getExpressionList()) {
            ProgressIndicatorProvider.checkCanceled();
            if (argument.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static boolean isConstantGenericTypeConversion(@NotNull GoCallExpr callExpr) {
        GoType conversionType;
        if (callExpr == null) {
            GoExpressionUtil.$$$reportNull$$$0(9);
        }
        return (conversionType = GoPsiUtil.getTypeIfConversion(callExpr)) != null && conversionType.resolve(callExpr) instanceof GoTypeSpec && GoExpressionUtil.hasAllArgumentsConstant(callExpr);
    }

    private static boolean isConstantLenOrCapArgument(@NotNull GoExpression expr) {
        if (expr == null) {
            GoExpressionUtil.$$$reportNull$$$0(10);
        }
        return !((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)expr)).filter(e -> e instanceof GoCallExpr && !GoPsiUtil.isConversionExpression((GoExpression)e) && !GoExpressionUtil.isConstantFunctionCall((GoCallExpr)e) || e instanceof GoUnaryExpr && ((GoUnaryExpr)e).getArrow() != null)).iterator().hasNext();
    }

    @Contract(value="null -> false")
    public static boolean isConstant(@Nullable GoExpression o) {
        return GoExpressionUtil.isConstant(o, null);
    }

    @Contract(value="null, _ -> false")
    public static boolean isConstant(@Nullable GoExpression o, @Nullable PsiElement context) {
        return o != null && GoExpressionUtil.processNonConstantExpressions(o, context, (Processor<? super GoExpression>)((Processor)e -> false));
    }

    public static boolean isPointer(@Nullable GoExpression o) {
        return o != null && o.getGoType(null) instanceof GoPointerType;
    }

    public static boolean canTakeAddressOf(@NotNull GoExpression expression) {
        if (expression == null) {
            GoExpressionUtil.$$$reportNull$$$0(11);
        }
        return GoExpressionUtil.isAddressable(expression) || expression instanceof GoCompositeLit;
    }

    public static boolean isAddressable(@NotNull GoExpression expr) {
        if (expr == null) {
            GoExpressionUtil.$$$reportNull$$$0(12);
        }
        if (GoExpressionUtil.isNil(expr = GoPsiImplUtil.unwrapParentheses(expr))) {
            return false;
        }
        if (expr instanceof GoReferenceExpression) {
            GoReferenceExpression ref = (GoReferenceExpression)expr;
            GoQualifier qualifier = ref.getQualifier();
            if (qualifier == null || GoExpressionUtil.isPackageReference(qualifier)) {
                PsiElement resolve2 = ref.resolve();
                return resolve2 == null || resolve2 instanceof GoVarDefinition || resolve2 instanceof GoParamDefinition || resolve2 instanceof GoReceiver || GoPsiImplUtil.isFieldDefinition(resolve2) || GoExpressionUtil.isCReference(ref, resolve2);
            }
            if (qualifier instanceof GoExpression) {
                GoExpression target = (GoExpression)qualifier;
                if (!GoExpressionUtil.isAddressable(target) && !GoExpressionUtil.isAddressableSelectorTarget(target)) {
                    return false;
                }
                PsiElement resolve3 = ref.resolve();
                return resolve3 == null || GoPsiImplUtil.isFieldDefinition(resolve3) || GoExpressionUtil.isCReference(ref, resolve3);
            }
            return true;
        }
        if (expr instanceof GoUnaryExpr) {
            return ((GoUnaryExpr)expr).getMul() != null;
        }
        if (expr instanceof GoIndexOrSliceExpr && ((GoIndexOrSliceExpr)expr).isIndexExpression()) {
            GoType type2;
            GoExpression indexedExpr = ((GoIndexOrSliceExpr)expr).getExpression();
            GoType goType = type2 = indexedExpr != null ? indexedExpr.getGoUnderlyingType(null) : null;
            if (type2 == null || type2 instanceof GoPointerType || type2 instanceof GoCType) {
                return true;
            }
            if (type2 instanceof GoInterfaceType) {
                return GoTypeUtil.matchTypeConstraints(type2, expr, termType -> termType instanceof GoPointerType || termType instanceof GoCType || termType instanceof GoArrayOrSliceType);
            }
            GoArrayOrSliceType arrOrSliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)type2, GoArrayOrSliceType.class);
            return arrOrSliceType != null && (!arrOrSliceType.isArray() || GoExpressionUtil.isAddressable(indexedExpr));
        }
        return false;
    }

    private static boolean isPackageReference(@NotNull GoQualifier qualifier) {
        GoReferenceExpression ref;
        if (qualifier == null) {
            GoExpressionUtil.$$$reportNull$$$0(13);
        }
        PsiElement resolve2 = (ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)qualifier, GoReferenceExpression.class)) != null ? ref.resolve() : null;
        return resolve2 instanceof GoImportSpec || GoPackageUtil.isGoPackage(resolve2);
    }

    private static boolean isAddressableSelectorTarget(@NotNull GoExpression selectorTarget) {
        ResolveState resolveState;
        GoType targetExprType;
        if (selectorTarget == null) {
            GoExpressionUtil.$$$reportNull$$$0(14);
        }
        GoType underlyingType = (targetExprType = selectorTarget.getGoType(resolveState = GoPsiImplUtil.createContextOnElement(selectorTarget))) != null ? targetExprType.getUnderlyingType(resolveState) : null;
        return underlyingType == null || GoTypeUtil.isPointer(underlyingType, selectorTarget);
    }

    private static boolean isCReference(@NotNull GoReferenceExpression ref, @NotNull PsiElement refResolve) {
        if (ref == null) {
            GoExpressionUtil.$$$reportNull$$$0(15);
        }
        if (refResolve == null) {
            GoExpressionUtil.$$$reportNull$$$0(16);
        }
        if (ref != refResolve) {
            return false;
        }
        GoType type2 = ref.getGoType(null);
        return type2 == null || GoTypeUtil.isCType(type2, ref);
    }

    public static boolean shadowsOtherVarOrConst(@NotNull GoVarOrConstDefinition def, boolean strict) {
        if (def == null) {
            GoExpressionUtil.$$$reportNull$$$0(17);
        }
        Pair<PsiElement, ThreeState> result = GoExpressionUtil.checkIfShadowsOtherVar(def);
        return result.second == ThreeState.YES || !strict && result.second == ThreeState.UNSURE;
    }

    @Nullable
    public static PsiElement getShadowedElement(@NotNull GoVarOrConstDefinition def) {
        if (def == null) {
            GoExpressionUtil.$$$reportNull$$$0(18);
        }
        return (PsiElement)GoExpressionUtil.checkIfShadowsOtherVar((GoVarOrConstDefinition)def).first;
    }

    @NotNull
    private static Pair<PsiElement, ThreeState> checkIfShadowsOtherVar(@NotNull GoVarOrConstDefinition def) {
        if (def == null) {
            GoExpressionUtil.$$$reportNull$$$0(19);
        }
        if (!(def instanceof GoResolvable)) {
            Pair pair = Pair.pair(null, (Object)ThreeState.UNSURE);
            if (pair == null) {
                GoExpressionUtil.$$$reportNull$$$0(20);
            }
            return pair;
        }
        if (GoPsiUtil.isTopLevelDeclaration(def)) {
            Pair pair = Pair.pair(null, (Object)ThreeState.NO);
            if (pair == null) {
                GoExpressionUtil.$$$reportNull$$$0(21);
            }
            return pair;
        }
        String name = def.getName();
        if (name == null) {
            Pair pair = Pair.pair(null, (Object)ThreeState.UNSURE);
            if (pair == null) {
                GoExpressionUtil.$$$reportNull$$$0(22);
            }
            return pair;
        }
        if ("_".equals(name)) {
            Pair pair = Pair.pair(null, (Object)ThreeState.NO);
            if (pair == null) {
                GoExpressionUtil.$$$reportNull$$$0(23);
            }
            return pair;
        }
        PsiElement resolve2 = GoReference.create((GoResolvable)((Object)def)).resolve();
        boolean shadowsOtherVar = resolve2 != null && !GoPsiUtil.isImportSpecOrPackage(resolve2);
        Pair pair = Pair.pair((Object)(shadowsOtherVar ? resolve2 : null), (Object)ThreeState.fromBoolean((boolean)shadowsOtherVar));
        if (pair == null) {
            GoExpressionUtil.$$$reportNull$$$0(24);
        }
        return pair;
    }

    public static boolean hasSideEffects(@NotNull GoExpression expression) {
        if (expression == null) {
            GoExpressionUtil.$$$reportNull$$$0(25);
        }
        final Ref hasSideEffects = Ref.create();
        expression.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof GoCallExpr || element instanceof GoUnaryExpr && ((GoUnaryExpr)element).getArrow() != null) {
                    hasSideEffects.set((Object)Boolean.TRUE);
                    this.stopWalking();
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/psi/impl/GoExpressionUtil$1", "visitElement"));
            }
        });
        return !hasSideEffects.isNull() && (Boolean)hasSideEffects.get() != false;
    }

    public static boolean hasSecondBoolValueWhichCanBeOmitted(@Nullable GoExpression expr) {
        return GoPsiImplUtil.isMapIndexExpr(expr = GoPsiImplUtil.unwrapParentheses(expr)) || expr instanceof GoTypeAssertionExpr || expr instanceof GoUnaryExpr && ((GoUnaryExpr)expr).getArrow() != null;
    }

    public static boolean isBlankGoReferenceExpression(@Nullable GoExpression o) {
        return o instanceof GoReferenceExpression && o.textMatches("_");
    }

    public static boolean needParentheses(@NotNull PsiElement host, @NotNull GoExpression expression) {
        int expressionPrecedence;
        if (host == null) {
            GoExpressionUtil.$$$reportNull$$$0(26);
        }
        if (expression == null) {
            GoExpressionUtil.$$$reportNull$$$0(27);
        }
        PsiElement hostExpression = host.getParent();
        if (expression instanceof GoCompositeLit && GoExpressionUtil.isConditionOfIfForSwitchStatements(host)) {
            return true;
        }
        int hostPrecedence = GoExpressionUtil.getPrecedence(hostExpression);
        if (hostPrecedence != (expressionPrecedence = GoExpressionUtil.getPrecedence(expression))) {
            return hostPrecedence > expressionPrecedence;
        }
        if (!(hostExpression instanceof GoBinaryExpr) || !(expression instanceof GoBinaryExpr)) {
            return false;
        }
        if (((GoBinaryExpr)hostExpression).getLeft() == host) {
            return false;
        }
        IElementType hostOperation = PsiUtilCore.getElementType((PsiElement)((GoBinaryExpr)hostExpression).getOperator());
        IElementType expressionOperation = PsiUtilCore.getElementType((PsiElement)((GoBinaryExpr)expression).getOperator());
        if (hostOperation == null || expressionOperation == null) {
            return false;
        }
        return hostOperation != expressionOperation || hostOperation != GoTypes.PLUS && hostOperation != GoTypes.MUL;
    }

    private static boolean isConditionOfIfForSwitchStatements(@NotNull PsiElement element) {
        if (element == null) {
            GoExpressionUtil.$$$reportNull$$$0(28);
        }
        return GoExpressionUtil.getParentIfForSwitchStatement(element) != null;
    }

    @Nullable
    public static GoStatement getParentIfForSwitchStatement(@NotNull PsiElement element) {
        GoIfStatement ifStatement;
        if (element == null) {
            GoExpressionUtil.$$$reportNull$$$0(29);
        }
        if ((ifStatement = GoPsiUtil.getParentIfStatement(element)) != null) {
            return ifStatement;
        }
        GoForClause forClause = (GoForClause)PsiTreeUtil.getParentOfType((PsiElement)element, GoForClause.class, (boolean)true);
        if (forClause != null) {
            return (GoStatement)ObjectUtils.tryCast((Object)forClause.getParent(), GoForStatement.class);
        }
        GoForStatement forStatement = (GoForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GoForStatement.class, (boolean)true, (Class[])new Class[]{GoStatementsHolder.class});
        if (forStatement != null) {
            return forStatement;
        }
        GoStatement parent = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GoStatement.class);
        if (parent instanceof GoExprSwitchStatement) {
            return parent;
        }
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        return grandParent instanceof GoExprSwitchStatement ? (GoStatement)grandParent : null;
    }

    private static int getPrecedence(@Nullable PsiElement element) {
        if (element instanceof GoOrExpr) {
            return 0;
        }
        if (element instanceof GoAndExpr) {
            return 1;
        }
        if (element instanceof GoConditionalExpr) {
            return 2;
        }
        if (element instanceof GoAddExpr) {
            return 3;
        }
        if (element instanceof GoMulExpr) {
            return 4;
        }
        if (element instanceof GoUnaryExpr) {
            return 5;
        }
        if (element instanceof GoConversionExpr) {
            return 6;
        }
        if (element instanceof GoLiteral || element instanceof GoCompositeLit || element instanceof GoReferenceExpression || element instanceof GoBuiltinCallExpr || element instanceof GoCallExpr || element instanceof GoTypeAssertionExpr || element instanceof GoIndexOrSliceExpr || element instanceof GoFunctionLit) {
            return 7;
        }
        if (element instanceof GoParenthesesExpr) {
            return 8;
        }
        return -1;
    }

    @Nullable
    @Contract(value="null -> null")
    public static IElementType getOperatorType(@Nullable GoBinaryExpr binaryExpr) {
        if (binaryExpr == null) {
            return null;
        }
        PsiElement operator = binaryExpr.getOperator();
        return operator != null ? operator.getNode().getElementType() : null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static IElementType getOperatorType(@Nullable GoUnaryExpr unaryExpr) {
        if (unaryExpr == null) {
            return null;
        }
        PsiElement operator = unaryExpr.getOperator();
        return operator != null ? operator.getNode().getElementType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 21, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 11: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorTarget";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refResolve";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoExpressionUtil";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoExpressionUtil";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIfShadowsOtherVar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "identicalIndices";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOrderImportant";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "equalBinaryExpressions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNonConstantExpressions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processNonConstantExpressionsNoRecursion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConstantFunctionCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAllArgumentsConstant";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConstantGenericTypeConversion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConstantLenOrCapArgument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canTakeAddressOf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAddressable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPackageReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAddressableSelectorTarget";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shadowsOtherVarOrConst";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShadowedElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkIfShadowsOtherVar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasSideEffects";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "needParentheses";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isConditionOfIfForSwitchStatements";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParentIfForSwitchStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 21, 22, 23, 24 -> new IllegalStateException(string);
        };
    }
}

