/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.ui;

import com.goide.playground.GoPlaygroundRunOption;
import com.goide.playground.managers.GoPlaygroundEditorManager;
import com.goide.playground.ui.GoPlaygroundTopPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/goide/playground/ui/GoPlaygroundFileEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "editor", "preview", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/fileEditor/TextEditor;)V", "GO_PLAYGROUND_URL", "", "PREFIX_LENGTH", "", "manager", "Lcom/goide/playground/managers/GoPlaygroundEditorManager;", "topPanel", "Lcom/goide/playground/ui/GoPlaygroundTopPanel;", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createViewActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getRunLocation", "Lcom/goide/playground/GoPlaygroundRunOption;", "getSelectedVersion", "getVersionList", "", "scrapVersionListFromPage", "", "pageContent", "Companion", "intellij.go.impl"})
public final class GoPlaygroundFileEditorWithPreview
extends TextEditorWithPreview
implements TextEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoPlaygroundEditorManager manager;
    @NotNull
    private final GoPlaygroundTopPanel topPanel;
    @NotNull
    private final String GO_PLAYGROUND_URL;
    private final int PREFIX_LENGTH;

    public GoPlaygroundFileEditorWithPreview(@NotNull TextEditor editor, @NotNull TextEditor preview) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
        super(editor, (FileEditor)preview);
        this.manager = new GoPlaygroundEditorManager(editor, preview);
        this.topPanel = new GoPlaygroundTopPanel(this.manager);
        this.GO_PLAYGROUND_URL = "https://go.dev/play/";
        this.PREFIX_LENGTH = 3;
        this.getVersionList();
    }

    private final void getVersionList() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> GoPlaygroundFileEditorWithPreview.getVersionList$lambda$1(this));
    }

    private final List<String> scrapVersionListFromPage(String pageContent) {
        int index = 0;
        int start = 0;
        int end = 0;
        List list = new ArrayList();
        index = StringsKt.indexOf$default((CharSequence)pageContent, (String)"Go version", (int)index, (boolean)false, (int)4, null);
        for (int i = 1; i < 4; ++i) {
            index = StringsKt.indexOf$default((CharSequence)pageContent, (String)"<option", (int)index, (boolean)false, (int)4, null);
            start = StringsKt.indexOf$default((CharSequence)pageContent, (String)">", (int)index, (boolean)false, (int)4, null) + 1;
            end = StringsKt.indexOf$default((CharSequence)pageContent, (String)"<", (int)start, (boolean)false, (int)4, null);
            String string = pageContent.substring(start + this.PREFIX_LENGTH, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            list.add(string);
            index = end;
        }
        return CollectionsKt.toList((Iterable)list);
    }

    @NotNull
    protected ActionToolbar createToolbar() {
        return this.topPanel.getToolbar();
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        AnAction[] anActionArray = new AnAction[]{this.getShowEditorAction(), this.getShowEditorAndPreviewAction()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @Nullable
    public final String getSelectedVersion() {
        return this.manager.getSelectedVersion();
    }

    @NotNull
    public final GoPlaygroundRunOption getRunLocation() {
        GoPlaygroundRunOption goPlaygroundRunOption = this.manager.getRunLocation();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goPlaygroundRunOption), (String)"getRunLocation(...)");
        return goPlaygroundRunOption;
    }

    private static final String getVersionList$lambda$1$lambda$0(HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.write("");
        return request.readString();
    }

    private static final void getVersionList$lambda$1(GoPlaygroundFileEditorWithPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        RequestBuilder get = HttpRequests.post((String)this$0.GO_PLAYGROUND_URL, (String)"text/plain");
        try {
            Object object = get.connect(GoPlaygroundFileEditorWithPreview::getVersionList$lambda$1$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
            String content2 = (String)object;
            this$0.manager.setVersions(this$0.scrapVersionListFromPage(content2));
        }
        catch (IOException e) {
            this$0.manager.setVersions(CollectionsKt.listOf((Object)"Not Available"));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/goide/playground/ui/GoPlaygroundFileEditorWithPreview$Companion;", "", "()V", "create", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileEditor create(@NotNull Project project, @NotNull VirtualFile file) {
            FileEditor fileEditor;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            TextEditorProvider textEditorProvider = TextEditorProvider.Companion.getInstance();
            EditorFactory editorFactory = EditorFactory.getInstance();
            FileEditor editor = textEditorProvider.createEditor(project, file);
            TextEditor textEditor = editor instanceof TextEditor ? (TextEditor)editor : null;
            if (textEditor != null) {
                TextEditor it = textEditor;
                boolean bl = false;
                Editor viewer = editorFactory.createViewer(editorFactory.createDocument((CharSequence)""), project, EditorKind.PREVIEW);
                Intrinsics.checkNotNull((Object)viewer);
                TextEditor previewEditor = textEditorProvider.getTextEditor(viewer);
                Disposer.register((Disposable)((Disposable)editor), () -> Companion.create$lambda$1$lambda$0(viewer));
                fileEditor = (FileEditor)new GoPlaygroundFileEditorWithPreview(it, previewEditor);
            } else {
                fileEditor = editor;
            }
            return fileEditor;
        }

        private static final void create$lambda$1$lambda$0(Editor $viewer) {
            EditorFactory.getInstance().releaseEditor($viewer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

