/*
 * Decompiled with CFR 0.152.
 */
package com.goide.playground.ui;

import com.goide.i18n.GoBundle;
import com.goide.playground.actions.GoLoadToPlaygroundAction;
import com.goide.playground.ui.GoLoadFileDialog;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\r\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0015\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/goide/playground/ui/GoLoadFileDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/goide/playground/actions/GoLoadToPlaygroundAction$GoLoadModel;", "(Lcom/intellij/openapi/project/Project;Lcom/goide/playground/actions/GoLoadToPlaygroundAction$GoLoadModel;)V", "LOAD_FILE_DIALOG_MINIMAL_DIMENSION", "Ljava/awt/Dimension;", "TEXT_FIELD_MINIMAL_DIMENSION", "filepathError", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "invalidFilepathPredicate", "com/goide/playground/ui/GoLoadFileDialog$createPredicate$1", "Lcom/goide/playground/ui/GoLoadFileDialog$createPredicate$1;", "invalidUrlPredicate", "getProject", "()Lcom/intellij/openapi/project/Project;", "url", "", "urlError", "createCenterPanel", "Ljavax/swing/JComponent;", "createPredicate", "property", "(Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;)Lcom/goide/playground/ui/GoLoadFileDialog$createPredicate$1;", "doOKAction", "", "isValidFile", "", "filepath", "Companion", "intellij.go.impl"})
public final class GoLoadFileDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final GoLoadToPlaygroundAction.GoLoadModel model;
    @NotNull
    private final Dimension TEXT_FIELD_MINIMAL_DIMENSION;
    @NotNull
    private final Dimension LOAD_FILE_DIALOG_MINIMAL_DIMENSION;
    @NotNull
    private final AtomicBooleanProperty filepathError;
    @NotNull
    private final AtomicBooleanProperty urlError;
    @NotNull
    private final createPredicate.1 invalidFilepathPredicate;
    @NotNull
    private final createPredicate.1 invalidUrlPredicate;
    @NotNull
    private String url;
    @NotNull
    private static final Regex UNRESERVED_CHARACTER = new Regex("[\\w-.~]");
    @NotNull
    private static final Regex URL_REGEX = new Regex("((https?://)?go\\.dev/play/p/" + UNRESERVED_CHARACTER + "+).*?");

    public GoLoadFileDialog(@Nullable Project project, @NotNull GoLoadToPlaygroundAction.GoLoadModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(project, null, true, DialogWrapper.IdeModalityType.IDE, true);
        this.project = project;
        this.model = model;
        this.TEXT_FIELD_MINIMAL_DIMENSION = new Dimension(375, 0);
        this.LOAD_FILE_DIALOG_MINIMAL_DIMENSION = new Dimension(475, 140);
        this.filepathError = new AtomicBooleanProperty(false);
        this.urlError = new AtomicBooleanProperty(false);
        this.invalidFilepathPredicate = this.createPredicate(this.filepathError);
        this.invalidUrlPredicate = this.createPredicate(this.urlError);
        this.url = "";
        this.init();
        this.setTitle(GoBundle.message((String)"go.load.to.playground.dialog.title", (Object[])new Object[0]));
        this.setCrossClosesWindow(false);
        this.setResizable(false);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    private final createPredicate.1 createPredicate(AtomicBooleanProperty property) {
        return new ComponentPredicate(property){
            final /* synthetic */ AtomicBooleanProperty $property;
            {
                this.$property = $property;
            }

            public void addListener(@NotNull Function1<? super Boolean, Unit> listener2) {
                Intrinsics.checkNotNullParameter(listener2, (String)"listener");
                this.$property.afterChange((Function1)new Function1<Boolean, Unit>(listener2, this.$property){
                    final /* synthetic */ Function1<Boolean, Unit> $listener;
                    final /* synthetic */ AtomicBooleanProperty $property;
                    {
                        this.$listener = $listener;
                        this.$property = $property;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        this.$listener.invoke((Object)this.$property.get());
                    }
                });
            }

            @NotNull
            public Boolean invoke() {
                return this.$property.get();
            }
        };
    }

    protected void doOKAction() {
        this.applyFields();
        if (this.model.option == GoLoadToPlaygroundAction.GoLoadOption.FILE) {
            String string = this.model.filepath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filepath");
            if (this.isValidFile(string)) {
                super.doOKAction();
            } else {
                this.filepathError.set(true);
                this.urlError.set(false);
            }
        } else if (this.model.option == GoLoadToPlaygroundAction.GoLoadOption.URL) {
            String string = this.model.url = Companion.retrieveUrl(this.url);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            if (!(((CharSequence)string).length() == 0)) {
                super.doOKAction();
            } else {
                this.filepathError.set(false);
                this.urlError.set(true);
            }
        }
    }

    private final boolean isValidFile(String filepath) {
        return new File(filepath).exists();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel content2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GoLoadFileDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Panel $this$panel) {
                void $this$bind$iv;
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, (String)GoBundle.message((String)"go.load.file.dialog.title", (Object[])new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ GoLoadFileDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$buttonsGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GoLoadFileDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = GoBundle.message((String)"go.load.file.dialog.radio.file", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell button = $this$row.radioButton(string, (Object)((Object)GoLoadToPlaygroundAction.GoLoadOption.FILE));
                                Cell cell = Row.textFieldWithBrowseButton$default((Row)$this$row, null, null, null, null, (int)15, null).enabledIf(ButtonKt.getSelected((Cell)button)).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
                                GoLoadFileDialog goLoadFileDialog = this.this$0;
                                Cell $this$invoke_u24lambda_u240 = cell;
                                boolean bl = false;
                                ((TextFieldWithBrowseButton)$this$invoke_u24lambda_u240.getComponent()).setMinimumSize(GoLoadFileDialog.access$getTEXT_FIELD_MINIMAL_DIMENSION$p(goLoadFileDialog));
                                TextFieldWithBrowseButtonKt.bindText((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(GoLoadFileDialog.access$getModel$p(this.this$0)){

                                    @Nullable
                                    public Object get() {
                                        return ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).filepath;
                                    }

                                    public void set(@Nullable Object value) {
                                        ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).filepath = (String)value;
                                    }
                                }));
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GoLoadFileDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = GoBundle.message((String)"go.load.file.dialog.radio.url", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell button = $this$row.radioButton(string, (Object)((Object)GoLoadToPlaygroundAction.GoLoadOption.URL));
                                Cell cell = $this$row.textField().enabledIf(ButtonKt.getSelected((Cell)button)).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
                                GoLoadFileDialog goLoadFileDialog = this.this$0;
                                Cell $this$invoke_u24lambda_u240 = cell;
                                boolean bl = false;
                                ((JBTextField)$this$invoke_u24lambda_u240.getComponent()).setMinimumSize(GoLoadFileDialog.access$getTEXT_FIELD_MINIMAL_DIMENSION$p(goLoadFileDialog));
                                Cell.comment$default((Cell)TextFieldKt.bindText((Cell)cell, (Function0)((Function0)new Function0<String>(this.this$0){
                                    final /* synthetic */ GoLoadFileDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return GoLoadFileDialog.access$getUrl$p(this.this$0);
                                    }
                                }), (Function1)((Function1)new Function1<String, Unit>(this.this$0){
                                    final /* synthetic */ GoLoadFileDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull String s) {
                                        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                                        GoLoadFileDialog.access$setUrl$p(this.this$0, s);
                                    }
                                })), (String)GoBundle.message((String)"go.load.file.dialog.url.comment", (Object[])new Object[0]), (int)0, null, (int)6, null);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GoLoadFileDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = GoBundle.message((String)"go.load.file.dialog.invalid.file", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell $this$invoke_u24lambda_u240 = cell = Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).visibleIf((ComponentPredicate)GoLoadFileDialog.access$getInvalidFilepathPredicate$p(this.this$0));
                                boolean bl = false;
                                ((JEditorPane)$this$invoke_u24lambda_u240.getComponent()).setForeground(UIUtil.getErrorForeground());
                                cell.align(Align.CENTER);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ GoLoadFileDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = GoBundle.message((String)"go.load.file.dialog.invalid.url", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell $this$invoke_u24lambda_u240 = cell = Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).visibleIf((ComponentPredicate)GoLoadFileDialog.access$getInvalidUrlPredicate$p(this.this$0));
                                boolean bl = false;
                                ((JEditorPane)$this$invoke_u24lambda_u240.getComponent()).setForeground(UIUtil.getErrorForeground());
                                cell.align(Align.CENTER);
                            }
                        }), (int)1, null);
                    }
                }), (int)2, null);
                KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl(GoLoadFileDialog.access$getModel$p(this.this$0)){

                    @Nullable
                    public Object get() {
                        return ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).option;
                    }

                    public void set(@Nullable Object value) {
                        ((GoLoadToPlaygroundAction.GoLoadModel)this.receiver).option = (GoLoadToPlaygroundAction.GoLoadOption)((Object)value);
                    }
                };
                boolean $i$f$bind = false;
                $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), GoLoadToPlaygroundAction.GoLoadOption.class);
            }
        }));
        content2.setMinimumSize(this.LOAD_FILE_DIALOG_MINIMAL_DIMENSION);
        return (JComponent)content2;
    }

    public static final /* synthetic */ GoLoadToPlaygroundAction.GoLoadModel access$getModel$p(GoLoadFileDialog $this) {
        return $this.model;
    }

    public static final /* synthetic */ Dimension access$getTEXT_FIELD_MINIMAL_DIMENSION$p(GoLoadFileDialog $this) {
        return $this.TEXT_FIELD_MINIMAL_DIMENSION;
    }

    public static final /* synthetic */ String access$getUrl$p(GoLoadFileDialog $this) {
        return $this.url;
    }

    public static final /* synthetic */ void access$setUrl$p(GoLoadFileDialog $this, String string) {
        $this.url = string;
    }

    public static final /* synthetic */ createPredicate.1 access$getInvalidFilepathPredicate$p(GoLoadFileDialog $this) {
        return $this.invalidFilepathPredicate;
    }

    public static final /* synthetic */ createPredicate.1 access$getInvalidUrlPredicate$p(GoLoadFileDialog $this) {
        return $this.invalidUrlPredicate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/goide/playground/ui/GoLoadFileDialog$Companion;", "", "()V", "UNRESERVED_CHARACTER", "Lkotlin/text/Regex;", "URL_REGEX", "retrieveUrl", "", "url", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String retrieveUrl(@NotNull String url) {
            String value;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            MatchResult matchResult = Regex.find$default((Regex)URL_REGEX, (CharSequence)url, (int)0, (int)2, null);
            String string = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = (MatchGroup)CollectionsKt.first((Iterable)((Iterable)matchResult))) != null ? matchResult.getValue() : (value = null);
            if (value == null) {
                return "";
            }
            if (StringsKt.startsWith$default((String)value, (String)"http://", (boolean)false, (int)2, null)) {
                return StringsKt.replace$default((String)value, (String)"http://", (String)"https://", (boolean)false, (int)4, null);
            }
            if (!StringsKt.startsWith$default((String)value, (String)"https://", (boolean)false, (int)2, null)) {
                return "https://" + value;
            }
            return value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

