/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.negate;

import com.goide.GoTypes;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBooleanExpressionUtil {
    private static final TokenSet BINARY_BOOLEAN_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.COND_AND, GoTypes.COND_OR, GoTypes.EQ, GoTypes.NOT_EQ, GoTypes.LESS, GoTypes.LESS_OR_EQUAL, GoTypes.GREATER, GoTypes.GREATER_OR_EQUAL});

    @Contract(value="null -> false")
    public static boolean isBooleanBinaryExpr(@Nullable PsiElement element) {
        return BINARY_BOOLEAN_OPERATORS.contains(GoExpressionUtil.getOperatorType((GoBinaryExpr)ObjectUtils.tryCast((Object)element, GoBinaryExpr.class)));
    }

    @Contract(value="null -> false")
    public static boolean isLogicalBinaryExpr(@Nullable PsiElement element) {
        IElementType operatorType = GoExpressionUtil.getOperatorType((GoBinaryExpr)ObjectUtils.tryCast((Object)element, GoBinaryExpr.class));
        return GoTypes.COND_AND.equals(operatorType) || GoTypes.COND_OR.equals(operatorType);
    }

    @Contract(value="null -> false")
    public static boolean isLogicalAndExpression(@Nullable PsiElement element) {
        return GoTypes.COND_AND.equals(GoExpressionUtil.getOperatorType((GoBinaryExpr)ObjectUtils.tryCast((Object)element, GoBinaryExpr.class)));
    }

    @Contract(value="null -> false")
    public static boolean isLogicalOrExpression(@Nullable PsiElement element) {
        return GoTypes.COND_OR.equals(GoExpressionUtil.getOperatorType((GoBinaryExpr)ObjectUtils.tryCast((Object)element, GoBinaryExpr.class)));
    }

    @Contract(value="null -> false")
    public static boolean isLogicalNotExpression(@Nullable PsiElement element) {
        return GoTypes.NOT.equals(GoExpressionUtil.getOperatorType((GoUnaryExpr)ObjectUtils.tryCast((Object)element, GoUnaryExpr.class)));
    }

    @Nullable
    @Contract(pure=true)
    public static String negateOperator(@Nullable IElementType operatorType) {
        if (GoTypes.COND_AND.equals(operatorType)) {
            return "||";
        }
        if (GoTypes.COND_OR.equals(operatorType)) {
            return "&&";
        }
        if (GoTypes.EQ.equals(operatorType)) {
            return "!=";
        }
        if (GoTypes.NOT_EQ.equals(operatorType)) {
            return "==";
        }
        if (GoTypes.LESS.equals(operatorType)) {
            return ">=";
        }
        if (GoTypes.LESS_OR_EQUAL.equals(operatorType)) {
            return ">";
        }
        if (GoTypes.GREATER.equals(operatorType)) {
            return "<=";
        }
        if (GoTypes.GREATER_OR_EQUAL.equals(operatorType)) {
            return "<";
        }
        return null;
    }

    @NotNull
    public static GoExpression negate(@NotNull GoExpression expression, boolean recursive) {
        if (expression == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(0);
        }
        GoExpression goExpression = GoElementFactory.createExpression(expression.getProject(), GoBooleanExpressionUtil.negatedExpressionText(expression, recursive));
        if (goExpression == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(1);
        }
        return goExpression;
    }

    @NotNull
    public static GoExpression trivialNegate(@NotNull GoExpression expression) {
        if (expression == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(2);
        }
        GoExpression goExpression = GoElementFactory.createExpression(expression.getProject(), GoBooleanExpressionUtil.triviallyNegatedExpressionText(expression));
        if (goExpression == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(3);
        }
        return goExpression;
    }

    @NotNull
    public static GoExpression wrapLogicalExpressionInParens(@NotNull GoExpression expression, @Nullable PsiElement parent) {
        if (expression == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(4);
        }
        if (GoBooleanExpressionUtil.isLogicalOrExpression(expression) && GoBooleanExpressionUtil.isLogicalAndExpression(parent)) {
            GoExpression goExpression = GoElementFactory.createExpression(expression.getProject(), "(" + expression.getText() + ")");
            if (goExpression == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(5);
            }
            return goExpression;
        }
        GoExpression goExpression = expression;
        if (goExpression == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(6);
        }
        return goExpression;
    }

    @NotNull
    private static String negatedExpressionText(@Nullable GoExpression expression, boolean recursive) {
        if (expression instanceof GoBinaryExpr) {
            GoBinaryExpr binaryExpression = (GoBinaryExpr)expression;
            if (GoBooleanExpressionUtil.isLogicalBinaryExpr(expression)) {
                String negatedOperator = GoBooleanExpressionUtil.negateOperator(GoExpressionUtil.getOperatorType(binaryExpression));
                if (negatedOperator == null) {
                    return GoBooleanExpressionUtil.oneStepNegatedExpressionText(expression);
                }
                GoExpression left = binaryExpression.getLeft();
                String rawNegatedLeft = recursive ? GoBooleanExpressionUtil.negatedExpressionText(left, true) : GoBooleanExpressionUtil.oneStepNegatedExpressionText(left);
                String negatedLeft = GoBooleanExpressionUtil.fixParensOfArgument(negatedOperator, rawNegatedLeft, binaryExpression.getProject());
                GoExpression right = binaryExpression.getRight();
                String rawNegatedRight = recursive ? GoBooleanExpressionUtil.negatedExpressionText(right, true) : GoBooleanExpressionUtil.oneStepNegatedExpressionText(right);
                String negatedRight = GoBooleanExpressionUtil.fixParensOfArgument(negatedOperator, rawNegatedRight, binaryExpression.getProject());
                String string = negatedLeft + negatedOperator + negatedRight;
                if (string == null) {
                    GoBooleanExpressionUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        if (recursive && expression instanceof GoParenthesesExpr) {
            GoExpression unwrapped = expression.unwrapParentheses();
            Object object = unwrapped != null ? GoBooleanExpressionUtil.negatedExpressionText(unwrapped, true) : "!" + expression.getText();
            if (object == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(8);
            }
            return object;
        }
        return GoBooleanExpressionUtil.oneStepNegatedExpressionText(expression);
    }

    @NotNull
    private static String fixParensOfArgument(@NotNull String operatorText, @NotNull String argText, @NotNull Project project) {
        GoExpression arg;
        if (operatorText == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(9);
        }
        if (argText == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(11);
        }
        if ((arg = GoElementFactory.createExpression(project, argText)) instanceof GoParenthesesExpr) {
            GoExpression unwrapped = arg.unwrapParentheses();
            if ("||".equals(operatorText) || "&&".equals(operatorText) && !GoBooleanExpressionUtil.isLogicalOrExpression(unwrapped)) {
                String string = unwrapped != null ? unwrapped.getText() : argText;
                if (string == null) {
                    GoBooleanExpressionUtil.$$$reportNull$$$0(12);
                }
                return string;
            }
        }
        if ("&&".equals(operatorText) && GoBooleanExpressionUtil.isLogicalOrExpression(arg)) {
            String string = "(" + argText + ")";
            if (string == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = argText;
        if (string == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String oneStepNegatedExpressionText(@Nullable GoExpression expression) {
        if (expression instanceof GoConditionalExpr) {
            GoConditionalExpr conditionalExpression = (GoConditionalExpr)expression;
            String negatedOperator = GoBooleanExpressionUtil.negateOperator(GoExpressionUtil.getOperatorType(conditionalExpression));
            if (negatedOperator == null) {
                return GoBooleanExpressionUtil.triviallyNegatedExpressionText(expression);
            }
            String leftText = conditionalExpression.getLeft().getText();
            GoExpression right = conditionalExpression.getRight();
            String rightText = right != null ? right.getText() : "";
            String string = leftText + negatedOperator + rightText;
            if (string == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        return GoBooleanExpressionUtil.triviallyNegatedExpressionText(expression);
    }

    @NotNull
    private static String triviallyNegatedExpressionText(@Nullable GoExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof GoReferenceExpression) {
            Boolean boolConst = GoExpressionUtil.getBoolConst(expression);
            Object object = boolConst != null ? String.valueOf(boolConst == false) : "!" + expression.getText();
            if (object == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(16);
            }
            return object;
        }
        if (expression instanceof GoCallExpr) {
            String string = "!" + expression.getText();
            if (string == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (expression instanceof GoParenthesesExpr) {
            GoExpression unwrapped = expression.unwrapParentheses();
            Object object = unwrapped != null ? GoBooleanExpressionUtil.triviallyNegatedExpressionText(unwrapped) : "!" + expression.getText();
            if (object == null) {
                GoBooleanExpressionUtil.$$$reportNull$$$0(18);
            }
            return object;
        }
        if (expression instanceof GoUnaryExpr && ((GoUnaryExpr)expression).getNot() != null) {
            GoExpression inner = ((GoUnaryExpr)expression).getExpression();
            GoExpression unwrapped = GoPsiImplUtil.unwrapParentheses(inner);
            if (unwrapped != null) {
                String string = unwrapped.getText();
                if (string == null) {
                    GoBooleanExpressionUtil.$$$reportNull$$$0(19);
                }
                return string;
            }
            if (inner != null) {
                String string = inner.getText();
                if (string == null) {
                    GoBooleanExpressionUtil.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        String string = "!(" + expression.getText() + ")";
        if (string == null) {
            GoBooleanExpressionUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 7, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/negate/GoBooleanExpressionUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operatorText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/negate/GoBooleanExpressionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "negate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "trivialNegate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapLogicalExpressionInParens";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "negatedExpressionText";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fixParensOfArgument";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "oneStepNegatedExpressionText";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "triviallyNegatedExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trivialNegate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapLogicalExpressionInParens";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixParensOfArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 7, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

