/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.declarations;

import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.declarations.GoRefactorDeclarationsUtil;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoVarOrConstDeclaration;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoMergeAllDeclarationsIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.merge.all.declarations.name", (Object[])new Object[0]);
        if (string == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        return GoMergeAllDeclarationsIntention.findDeclarations(element, true).size() > 2;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Collection<PsiElement> declarations;
        if (project == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(8);
        }
        if ((declarations = GoMergeAllDeclarationsIntention.findDeclarations(element, false)).size() <= 2) {
            return;
        }
        GoRefactorDeclarationsUtil.mergeDeclarations(project, editor, declarations);
    }

    @NotNull
    private static Collection<PsiElement> findDeclarations(@NotNull PsiElement context, boolean fast) {
        List<PsiElement> whiteSpaces;
        PsiElement rawDeclaration;
        if (context == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(9);
        }
        if (!((rawDeclaration = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoTypeDeclaration.class, GoVarOrConstDeclaration.class, GoStatement.class, GoFunctionLit.class})) instanceof GoTypeDeclaration) && !(rawDeclaration instanceof GoVarOrConstDeclaration)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoMergeAllDeclarationsIntention.$$$reportNull$$$0(10);
            }
            return list;
        }
        Class<?> declarationClass = rawDeclaration.getClass();
        PsiElement parent = rawDeclaration.getParent();
        boolean isTopLevel = !(parent instanceof GoStatement);
        PsiElement declaration = isTopLevel ? rawDeclaration : parent;
        ArrayDeque<PsiElement> declarations = new ArrayDeque<PsiElement>();
        for (PsiElement prev = declaration.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
            if (prev instanceof PsiWhiteSpace) {
                whiteSpaces = GoMergeAllDeclarationsIntention.collectWhiteSpacesBackward((PsiWhiteSpace)prev);
                if (GoMergeAllDeclarationsIntention.containMoreThenOneNewline(whiteSpaces)) break;
                prev = Objects.requireNonNull((PsiElement)ContainerUtil.getFirstItem(whiteSpaces));
                continue;
            }
            if (!GoRefactorDeclarationsUtil.isWhiteSpaceOrCommentOrSemicolon(prev) && (!GoMergeAllDeclarationsIntention.addIfDeclarationOfTheSameType(prev, declarationClass, isTopLevel, (Consumer<PsiElement>)((Consumer)declarations::addFirst)) || fast && declarations.size() > 1)) break;
        }
        declarations.addLast(declaration);
        if (fast && declarations.size() > 2) {
            ArrayDeque<PsiElement> arrayDeque = declarations;
            if (arrayDeque == null) {
                GoMergeAllDeclarationsIntention.$$$reportNull$$$0(11);
            }
            return arrayDeque;
        }
        for (PsiElement next = declaration.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next instanceof PsiWhiteSpace) {
                whiteSpaces = GoMergeAllDeclarationsIntention.collectWhiteSpacesForward((PsiWhiteSpace)next);
                if (GoMergeAllDeclarationsIntention.containMoreThenOneNewline(whiteSpaces)) break;
                next = Objects.requireNonNull((PsiElement)ContainerUtil.getLastItem(whiteSpaces));
                continue;
            }
            if (!GoRefactorDeclarationsUtil.isWhiteSpaceOrCommentOrSemicolon(next) && (!GoMergeAllDeclarationsIntention.addIfDeclarationOfTheSameType(next, declarationClass, isTopLevel, (Consumer<PsiElement>)((Consumer)declarations::addLast)) || fast && declarations.size() > 2)) break;
        }
        ArrayDeque<PsiElement> arrayDeque = declarations;
        if (arrayDeque == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(12);
        }
        return arrayDeque;
    }

    @NotNull
    private static List<PsiElement> collectWhiteSpacesBackward(@NotNull PsiWhiteSpace whiteSpace) {
        PsiElement prev;
        if (whiteSpace == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(13);
        }
        List list = (prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)whiteSpace)) == null ? Collections.singletonList(whiteSpace) : PsiTreeUtil.getElementsOfRange((PsiElement)prev.getNextSibling(), (PsiElement)whiteSpace);
        if (list == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> collectWhiteSpacesForward(@NotNull PsiWhiteSpace whiteSpace) {
        PsiElement next;
        if (whiteSpace == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(15);
        }
        List list = (next = PsiTreeUtil.skipWhitespacesForward((PsiElement)whiteSpace)) == null ? Collections.singletonList(whiteSpace) : PsiTreeUtil.getElementsOfRange((PsiElement)whiteSpace, (PsiElement)next.getPrevSibling());
        if (list == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static boolean containMoreThenOneNewline(@NotNull List<PsiElement> whiteSpaces) {
        if (whiteSpaces == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(17);
        }
        int newLinesCount = 0;
        for (PsiElement whiteSpace : whiteSpaces) {
            if ((newLinesCount += StringUtil.countChars((CharSequence)whiteSpace.getText(), (char)'\n')) <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean addIfDeclarationOfTheSameType(@NotNull PsiElement current, @NotNull Class<? extends PsiElement> declarationClass, boolean isTopLevel, @NotNull Consumer<PsiElement> declarations) {
        PsiElement declaration;
        if (current == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(18);
        }
        if (declarationClass == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(19);
        }
        if (declarations == null) {
            GoMergeAllDeclarationsIntention.$$$reportNull$$$0(20);
        }
        PsiElement psiElement = declaration = isTopLevel ? current : GoRefactorDeclarationsUtil.findDeclarationIfStatement(current);
        if (declarationClass.isInstance(declaration)) {
            declarations.consume((Object)current);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 13, 15, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/declarations/GoMergeAllDeclarationsIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpace";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaces";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/declarations/GoMergeAllDeclarationsIntention";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclarations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWhiteSpacesBackward";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWhiteSpacesForward";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectWhiteSpacesBackward";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectWhiteSpacesForward";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containMoreThenOneNewline";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addIfDeclarationOfTheSameType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 13, 15, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

