/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.i18n.GoBundle;
import com.goide.intentions.GoAddImportAliasIntention;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.find.FindBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRemoveDotImportAliasIntention
extends GoBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.remove.dot.import.alias.name", (Object[])new Object[0]);
        if (string == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        GoImportSpec spec;
        if (project == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(4);
        }
        return (spec = (GoImportSpec)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoImportSpec.class})) != null && spec.isDot();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoImportSpec spec;
        PsiElement dot;
        if (project == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(7);
        }
        PsiElement psiElement = dot = (spec = (GoImportSpec)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoImportSpec.class})) != null ? spec.getDot() : null;
        if (spec == null || dot == null) {
            return;
        }
        Pair<String, String> qualifierAndAlias = GoRemoveDotImportAliasIntention.getQualifierAndAlias(spec);
        if (qualifierAndAlias == null) {
            return;
        }
        String qualifier = (String)qualifierAndAlias.first;
        Collection<PsiElement> usages = GoRemoveDotImportAliasIntention.findUsages(spec);
        if (usages == null) {
            return;
        }
        for (PsiElement usage : usages) {
            GoReferenceExpressionBase expression = GoAddImportAliasIntention.asReferenceExpression(usage);
            if (expression == null) continue;
            String qualifiedName = qualifier + "." + expression.getIdentifier().getText();
            expression.replace(expression instanceof GoReferenceExpression ? GoElementFactory.createReferenceExpression(element.getProject(), qualifiedName) : GoElementFactory.createTypeReferenceExpression(element.getProject(), qualifiedName));
        }
        String alias = (String)qualifierAndAlias.second;
        if (alias != null) {
            dot.delete();
            PsiElement updated = spec.setName(alias);
            editor.getCaretModel().moveToOffset(updated.getTextOffset());
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            GoRefactoringUtil.runRenameRefactoring(project, updated, EditorUtil.getEditorDataContext((Editor)editor));
        } else {
            spec.replace(GoElementFactory.createImportSpec(element.getContainingFile(), spec.getStringLiteral().getText(), null));
        }
    }

    @Nullable
    private static Pair<String, String> getQualifierAndAlias(@NotNull GoImportSpec spec) {
        String qualifier;
        String localName;
        if (spec == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(8);
        }
        if ((localName = (String)ContainerUtil.getFirstItem(GoPsiImplUtil.getImportQualifiersToUseInFile(spec.resolve(ResolveState.initial()), spec.getPath()))) == null) {
            return null;
        }
        return Pair.create((Object)qualifier, (Object)((qualifier = UniqueNameGenerator.generateUniqueName((String)localName, (Collection)spec.getContainingFile().getImportMap().keySet())).equals(localName) ? null : qualifier));
    }

    @Nullable
    private static Collection<PsiElement> findUsages(@NotNull GoImportSpec spec) {
        Set usages;
        if (spec == null) {
            GoRemoveDotImportAliasIntention.$$$reportNull$$$0(9);
        }
        if ((usages = (Set)spec.getUserData(GoReferenceBase.IMPORT_USERS)) == null) {
            return Collections.emptyList();
        }
        return (Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (List)ApplicationManager.getApplication().runReadAction(() -> {
            HashSet<PsiElement> resolves = new HashSet<PsiElement>();
            for (PsiElement usage : usages) {
                ProgressManager.checkCanceled();
                GoReferenceExpressionBase expression = GoAddImportAliasIntention.asReferenceExpression(usage);
                if (expression == null) continue;
                resolves.add(expression.getReference().resolve());
            }
            return SyntaxTraverser.psiTraverser((PsiElement)spec.getContainingFile()).traverse().filter(it -> {
                ProgressManager.checkCanceled();
                GoReferenceExpressionBase expression = GoAddImportAliasIntention.asReferenceExpression(it);
                return expression != null && resolves.contains(expression.getReference().resolve());
            }).toList();
        }), FindBundle.message((String)"find.usages.progress.title", (Object[])new Object[0]), true, spec.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoRemoveDotImportAliasIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoRemoveDotImportAliasIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAndAlias";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

